-- 
-- Base de donnes: `phpcompet`
-- 


CREATE TABLE `bet` (
  `id` int(11) NOT NULL auto_increment,
  `id_match` int(11) NOT NULL default '0',
  `id_betlist` int(11) NOT NULL default '0',
  `pronostic` enum('1','N','2') NOT NULL default 'N',
  `buts_dom` tinyint(3) NOT NULL default '0',
  `buts_ext` tinyint(3) NOT NULL default '0',
  `id_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Structure de la table `betlist`
-- 

CREATE TABLE `betlist` (
  `id` int(11) NOT NULL auto_increment,
  `id_bettable` int(11) NOT NULL default '0',
  `id_match` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Structure de la table `bettable`
-- 

CREATE TABLE `bettable` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `nbr_prono` tinyint(3) NOT NULL default '0',
  `cost` int(11) NOT NULL default '0',
  `winprize` int(11) NOT NULL default '0',
  `winrank` tinyint(2) NOT NULL default '0',
  `rankpercent` int(3) NOT NULL default '0',
  `date_deb` date NOT NULL default '0000-00-00',
  `date_fin` date NOT NULL default '0000-00-00',
  `date_fin_bet` datetime NOT NULL default '0000-00-00 00:00:00',
  `paybet` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Structure de la table `betwinner`
-- 

CREATE TABLE `betwinner` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `id_bettable` int(11) NOT NULL default '0',
  `goodprono` tinyint(5) NOT NULL default '0',
  `prize` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Structure de la table `candidates`
-- 

CREATE TABLE `candidates` (
  `id` int(11) NOT NULL auto_increment,
  `id_compet` int(11) NOT NULL default '0',
  `id_club` int(11) NOT NULL default '0',
  `id_season` int(11) NOT NULL default '0',
  `penality` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `carac`
-- 

CREATE TABLE `caracs` (
`id` INT( 11 ) NOT NULL auto_increment PRIMARY KEY ,
`shortname` VARCHAR( 255 ) NOT NULL ,
`lib_key` CHAR( 10 ) NOT NULL ,
`type` SMALLINT( 3 ) NOT NULL ,
`genre` SMALLINT( 3 ) NOT NULL ,
`rank` SMALLINT( 3 ) NOT NULL,
`perm` SMALLINT( 5 ) NOT NULL
) ENGINE = MYISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `cards`
-- 

CREATE TABLE `cards` (
  `id` int(11) NOT NULL auto_increment,
  `id_match` int(11) NOT NULL default '0',
  `id_person` int(11) NOT NULL default '0',
  `id_club` int(11) NOT NULL default '0',
  `card_min` tinyint(3) NOT NULL default '0',
  `card_yellow` tinyint(1) NOT NULL default '0',
  `card_red` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------
-- 
-- Structure de la table `categories`
-- 

CREATE TABLE `categories` (
  `id` int(11) NOT NULL auto_increment,
  `longname` varchar(255) NOT NULL default '',
  `shortname` varchar(255) NOT NULL default '',
  `country` varchar(11) NOT NULL default '',
  `plot` text NOT NULL,
  `pos` int(11) NOT NULL default '0',
  `parent` int(11) NOT NULL default '0',
  `active` tinyint(1) NOT NULL default '0',
  `visible` tinyint(1) NOT NULL default '0',
  `imgurl` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------
-- 
-- Structure de la table `classification`
-- 

CREATE TABLE `classification` (
  `id_compet` int(11) NOT NULL default '0',
  `id_season` int(11) NOT NULL default '0',
  `id_day` int(11) NOT NULL default '0',
  `id_team` int(11) NOT NULL default '0',
  `pts` int(3) NOT NULL default '0',
  `played` int(3) NOT NULL default '0',
  `win` int(3) NOT NULL default '0',
  `nul` int(3) NOT NULL default '0',
  `lost` int(3) NOT NULL default '0',
  `sb` int(5) NOT NULL default '0',
  `sa` int(5) NOT NULL default '0',
  `dompts` int(3) NOT NULL default '0',
  `domplayed` int(3) NOT NULL default '0',
  `domwin` int(3) NOT NULL default '0',
  `domnul` int(3) NOT NULL default '0',
  `domlost` int(3) NOT NULL default '0',
  `domsb` int(5) NOT NULL default '0',
  `domsa` int(5) NOT NULL default '0',
  `extpts` int(3) NOT NULL default '0',
  `extplayed` int(3) NOT NULL default '0',
  `extwin` int(3) NOT NULL default '0',
  `extnul` int(3) NOT NULL default '0',
  `extlost` int(3) NOT NULL default '0',
  `extsb` int(5) NOT NULL default '0',
  `extsa` int(5) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

-- 
-- Structure de la table `clubs`
-- 

CREATE TABLE `clubs` (
  `id` int(11) NOT NULL auto_increment,
  `shortname` varchar(255) NOT NULL default '',
  `longname` varchar(255) NOT NULL default '',
  `city` varchar(255) NOT NULL default '',
  `aka` varchar(255) NOT NULL default '',
  `country` varchar(11) NOT NULL default '0',
  `nationalteam` tinyint(1) NOT NULL default '0',
  `imgurl` varchar(255) NOT NULL default '',
  `creation` varchar(11) NOT NULL default '',
  `complete` varchar(11) NOT NULL default '',
  `website` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `adresse` text NOT NULL,
  `tel` varchar(25) NOT NULL default '',
  `fax` varchar(25) NOT NULL default '',
  `newspaper` varchar(255) NOT NULL default '',
  `id_stadium` int(11) NOT NULL default '0',
  `id_president` varchar(11) NOT NULL default '',
  `owner_id` varchar(255) NOT NULL default '',
  `plot` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

-- 
-- Structure de la table `codes`
-- 

CREATE TABLE `codes` (
  `id` tinyint(4) NOT NULL auto_increment,
  `session` text NOT NULL,
  `code` text NOT NULL,
  `now` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `comments`
-- 

CREATE TABLE `comments` (
  `id` int(11) NOT NULL auto_increment,
  `cat_id` int(11) NOT NULL default '0',
  `subcat_id` int(11) NOT NULL default '0',
  `comment_id` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `plot` text NOT NULL,
  `owner_id` int(11) NOT NULL default '0',
  `lastupdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

-- --------------------------------------------------------

-- 
-- Structure de la table `competitions`
-- 

CREATE TABLE `competitions` (
  `id` int(11) NOT NULL auto_increment,
  `longname` varchar(255) NOT NULL default '',
  `shortname` varchar(255) NOT NULL default '',
  `aka` varchar(255) NOT NULL default '',
  `type` tinyint(2) default NULL,
  `category` int(11) NOT NULL default '0',
  `pos` int(11) NOT NULL default '0',
  `subcompet` int(11) NOT NULL default '0',
  `subpos` int(11) NOT NULL default '0',
  `range` tinyint(2) default NULL,
  `oneyear` tinyint(1) default '0',
  `country` varchar(11) NOT NULL default '',
  `creation` int(4) NOT NULL default '0',
  `complete` int(4) NOT NULL default '0',
  `active` tinyint(1) NOT NULL default '0',
  `visible` tinyint(1) NOT NULL default '0',
  `website` varchar(255) NOT NULL default '',
  `imgurl` varchar(255) NOT NULL default '',
  `owner_id` varchar(255) NOT NULL default '',
  `plot` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

-- 
-- Structure de la table `config`
-- 

CREATE TABLE `config` (
  `opt` varchar(50) NOT NULL default '',
  `value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`opt`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




-- --------------------------------------------------------

-- 
-- Structure de la table `days`
-- 

CREATE TABLE `days` (
  `id` int(11) NOT NULL auto_increment,
  `day` smallint(4) NOT NULL default '0',
  `date_day` date NOT NULL default '0000-00-00',
  `id_compet` int(11) NOT NULL default '0',
  `id_season` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `gallery`
-- 

CREATE TABLE `gallery` (
  `id` int(11) NOT NULL auto_increment,
  `cat_id` int(11) NOT NULL default '0',
  `subcat_id` int(11) NOT NULL default '0',
  `imgurl` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;


-- --------------------------------------------------------

-- 
-- Structure de la table `goals`
-- 

CREATE TABLE `goals` (
  `id` int(11) NOT NULL auto_increment,
  `id_match` int(11) NOT NULL default '0',
  `id_person` int(11) NOT NULL default '0',
  `id_club` int(11) NOT NULL default '0',
  `goal_min` tinyint(3) NOT NULL default '0',
  `goal_csc` tinyint(1) NOT NULL default '0',
  `goal_pen` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

--
-- Structure de la table 'lineup'
--

CREATE TABLE `lineup` (
`id` INT( 11 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`id_match` INT( 11 ) NOT NULL ,
`id_club` INT( 11 ) NOT NULL ,
`id_person` INT( 11 ) NOT NULL ,
`type` SMALLINT( 2 ) NOT NULL ,
`captain` SMALLINT( 2 ) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `matchs`
-- 

CREATE TABLE `matchs` (
  `id` int(11) NOT NULL auto_increment,
  `id_candidate_dom` int(11) NOT NULL default '0',
  `id_candidate_ext` int(11) NOT NULL default '0',
  `id_day` int(11) NOT NULL default '0',
  `date_day` datetime NOT NULL default '0000-00-00 00:00:00',
  `buts_dom` smallint(5) NOT NULL default '0',
  `buts_ext` smallint(5) NOT NULL default '0',
  `extendtime` tinyint(1) NOT NULL default '0',
  `pen_dom` tinyint(2) NOT NULL default '0',
  `pen_ext` tinyint(2) NOT NULL default '0',
  `id_referee` int(11) NOT NULL default '0',
  `id_stadium` int(11) NOT NULL default '0',
  `spectators` int(11) NOT NULL default '0',
  `id_weather` smallint(2) NOT NULL default '0',
  `temperature` smallint(3) NOT NULL default '0',
  `validation` tinyint(1) NOT NULL default '0',
  `plot` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

-- 
-- Structure de la table `news`
-- 

CREATE TABLE `news` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) character set latin1 collate latin1_general_ci NOT NULL default '',
  `category` varchar(255) character set latin1 collate latin1_general_ci NOT NULL default '',
  `language` varchar(15) character set latin1 collate latin1_general_ci NOT NULL default '',
  `imgurl` varchar(255) character set latin1 collate latin1_general_ci NOT NULL default '',
  `summary` mediumtext character set latin1 collate latin1_general_ci NOT NULL,
  `plot` longtext character set latin1 collate latin1_general_ci NOT NULL,
  `link` varchar(255) character set latin1 collate latin1_general_ci NOT NULL default '',
  `newsfrom` varchar(255) character set latin1 collate latin1_general_ci NOT NULL default '',
  `owner_id` int(11) NOT NULL default '0',
  `pubdate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `paramcompetitions`
-- 

CREATE TABLE `paramcompetitions` (
  `id` int(11) NOT NULL auto_increment,
  `id_compet` int(11) NOT NULL default '0',
  `id_season` int(11) NOT NULL default '0',
  `dom_vic` int(11) NOT NULL default '0',
  `dom_nul` int(11) NOT NULL default '0',
  `dom_def` int(11) NOT NULL default '0',
  `ext_vic` int(11) NOT NULL default '0',
  `ext_nul` int(11) NOT NULL default '0',
  `ext_def` int(11) NOT NULL default '0',
  `dom_vic_ext` int(11) NOT NULL default '0',
  `dom_nul_ext` int(11) NOT NULL default '0',
  `dom_def_ext` int(11) NOT NULL default '0',
  `ext_vic_ext` int(11) NOT NULL default '0',
  `ext_nul_ext` int(11) NOT NULL default '0',
  `ext_def_ext` int(11) NOT NULL default '0',
  `period` int(11) NOT NULL default '0',
  `period_time` smallint(5) NOT NULL default '0',
  `extension` int(11) NOT NULL default '0',
  `extension_time` smallint(5) NOT NULL default '0',
  `accession` int(11) NOT NULL default '0',
  `barrage` int(11) NOT NULL default '0',
  `relegation` int(11) NOT NULL default '0',
  `ar` tinyint(1) NOT NULL default '0',
  `taborder` char(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

-- 
-- Structure de la table `persons`
-- 

CREATE TABLE `persons` (
  `id` int(11) NOT NULL auto_increment,
  `lastname` varchar(255) NOT NULL default '',
  `firstname` varchar(255) NOT NULL default '',
  `aka` varchar(255) NOT NULL default '',
  `birthday` date NOT NULL default '0000-00-00',
  `birthcity` varchar(255) NOT NULL default '',
  `deathday` date NOT NULL default '0000-00-00',
  `position` varchar(255) NOT NULL default '',
  `height` int(11) NOT NULL default '0',
  `weight` int(11) NOT NULL default '0',
  `country` varchar(5) NOT NULL default '',
  `type` int(11) NOT NULL default '0',
  `international` tinyint(1) NOT NULL default '0',
  `imgurl` varchar(255) NOT NULL default '',
  `license` VARCHAR( 255 ) NOT NULL default '',
  `contribution` BOOL NULL,
  `stop_mail` BOOL NULL,
  `email` varchar(255) NOT NULL default '',
  `website` varchar(255) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `tel1` varchar(255) NOT NULL default '',
  `tel2` varchar(255) NOT NULL default '', 
  `plot` text NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `prizelist`
-- 

CREATE TABLE `prizelist` (
  `id_club` int(11) NOT NULL default '0',
  `id_season` int(11) NOT NULL default '0',
  `id_compet` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_club`,`id_season`,`id_compet`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

-- 
-- Structure de la table `subs`
-- 

CREATE TABLE `subs` (
`id` INT( 11 ) NOT NULL auto_increment,
`id_match` INT( 11 ) NOT NULL ,
`id_club` INT( 11 ) NOT NULL ,
`id_person_in` INT( 11 ) NOT NULL ,
`id_person_out` INT( 11 ) NOT NULL ,
`subs_min` INT( 5 ) NOT NULL,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

-- 
-- Structure de la table `seasons`
-- 


CREATE TABLE `seasons` (
  `id` int(11) NOT NULL auto_increment,
  `season` char(4) NOT NULL default '0000',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Contenu de la table `seasons`
-- 

INSERT INTO `seasons` (`id`, `season`) VALUES 
(1, 1990),
(2, 1991),
(3, 1992),
(4, 1993),
(5, 1994),
(6, 1995),
(7, 1996),
(8, 1997),
(9, 1998),
(10, 1999),
(11, 2000),
(12, 2001),
(13, 2002),
(14, 2003),
(15, 2004),
(16, 2005),
(17, 2006),
(18, 2007),
(19, 2008),
(20, 2009),
(21, 2010);

-- --------------------------------------------------------

-- 
-- Structure de la table `stadiums`
-- 

CREATE TABLE `stadiums` (
  `id` int(11) NOT NULL auto_increment,
  `longname` varchar(255) NOT NULL default '',
  `aka` varchar(255) NOT NULL default '',
  `country` varchar(11) NOT NULL default '',
  `creation` int(11) NOT NULL default '0',
  `renovation` int(11) NOT NULL default '0',
  `places` int(11) NOT NULL default '0',
  `adresse` text NOT NULL,
  `imgurl` varchar(255) NOT NULL default '',
  `plot` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

-- 
-- Structure de la table `teams`
-- 

CREATE TABLE `teams` (
  `id` int(11) NOT NULL auto_increment,
  `id_club` int(11) NOT NULL default '0',
  `id_season` int(11) NOT NULL default '0',
  `id_person` int(11) NOT NULL default '0',
  `start` date NOT NULL default '0000-00-00',
  `end` date NOT NULL default '0000-00-00',
  `games` int(11) NOT NULL default '0',
  `minutes` int(11) NOT NULL default '0',
  `goals` int(11) NOT NULL default '0',
  `ycards` int(11) NOT NULL default '0',
  `rcards` int(11) NOT NULL default '0',  
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

-- 
-- Structure de la table `userconfig`
-- 

CREATE TABLE `userconfig` (
  `user_id` int(11) NOT NULL default '0',
  `opt` varchar(50) NOT NULL default '',
  `value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`user_id`,`opt`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

-- 
-- Structure de la table `users`
-- 


CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `passwd` varchar(100) NOT NULL default '',
  `cookiecode` varchar(100) NOT NULL default '',
  `permissions` int(11) NOT NULL default '0',
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `email` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

-- 
-- Structure de la table `value`
-- 

CREATE TABLE `values` (
`id_carac` INT( 11 ) NOT NULL ,
`id_item` INT( 11 ) NOT NULL ,
`value` VARCHAR( 255 ) NOT NULL
) ENGINE = MYISAM DEFAULT CHARSET=latin1;


-- 
-- Contenu de la table `users`
-- 

INSERT INTO `users` (`id`, `name`, `passwd`, `cookiecode`, `permissions`, `timestamp`, `email`) VALUES (1, 'admin', '21232f297a57a5a743894a0e4a801fc3', '456423950', 255, '2006-12-19 10:35:27', ''),
(10000, 'GUEST', '', '', 0, '2007-01-01 00:00:00', '');


-- 
-- Contenu de la table `config`
-- 
INSERT INTO `config` (`opt`, `value`) VALUES ('language', 'fr'),
('template', 'classic::compact'),
('guestid', '10000'),
('dbversion', '80'),
('debug', '0'),
('filterdefault', 'all'),
('countryfilterdefault', ''),
('shownew', '20'),
('pageno', '20'),
('clubslistcolumns', '4'),
('thumbnail', '1'),
('showimg', '1'),
('multiuser', '1'),
('stadiumslistcolumns', '4'),
('competitionslistcolumns', '3'),
('personslistcolumns', '4'),
('proxy_host', ''),
('proxy_port', ''),
('localnet', ''),
('recompile', ''),
('seasonfilterdefault', '18'),
('advlines', '6'),
('denyguest', '0'),
('site_name', 'PHP Compet'),
('site_description', 'Le portail des rsultats de football'),
('admin_email', 'admin@phpcompet.com'),
('permdefault', '30'),
('time_zone', '1'),
('newslistcolumns', '2'),
('activegallery', '1'),
('activecomments', '1'),
('gallerylistcolumns', '3'),
('displaylistmembers', '1'),
('prizelistsize', '10'),
('prizelistcolumns', '5'),
('site_keywords', 'football, france, brsil, angleterre'),
('displaypronostics', '1'),
('credits', '10000'),
('activecompetcategorys', ''),
('displaystylelist', ''),
('activeclubs', '1'),
('activestadiums', '1'),
('activecompetitions', '1'),
('activeplayers', '1'),
('activereferees', '1'),
('automatchvalidation', '1'),
('activecalendar', '1')
;


#
# IMPORTANT
#
# Always increase this number in createtables.sql, updatedb.sql and
# config.inc.php when changing the database structure!
#
REPLACE INTO config (opt,value) VALUES ('dbversion', 84);