<?php
/**
 * Browse View
 *
 * 
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: index.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';



//IF NOT A SEARCH ACTION
//DEFINE FILTERS
// SET DEFAULTS
if (!$q) {
	if (!isset($catfilter)) 
	{
		$catfilter       = $_SESSION['pcs']['newscatfilter'];
		if (!isset($catfilter)) 
		{
			$catfilter = $config['newscatfilter'];
		}
	}
	if (!isset($langfilter)) 
	{
		$langfilter   = $_SESSION['pcs']['newslangfilter'];
		if (!isset($langfilter)) 
		{
			$langfilter = $config['langfilterdefault'];
		}
	}
	$_SESSION['pcs']['newscatfilter']   = $catfilter;
	$_SESSION['pcs']['newslangfilter']  = $langfilter;
	
	
	
	if ($langfilter) {
		if ($WHERES) {$WHERES .= ' AND ';}
		else {$WHERES .= ' WHERE ';}
		$WHERES .= TBL_NEWS.'.language=\''.$langfilter.'\'';
	}
	if ($catfilter) {
		if ($WHERES) {$WHERES .= ' AND ';}
		else {$WHERES .= ' WHERE ';}
		$WHERES .= TBL_NEWS.'.category=\''.$catfilter.'\'';
	}
	
	// default order
	if (!$ORDER)  {
		$ORDER   = TBL_NEWS.'.pubdate DESC, ' . TBL_NEWS.'.id DESC';
	}
}

//IF SEARCH ACTION
//DEFINE QUERY
// prepare search query
else {
require_once './core/queryparser.php';
$fields = array('title', 'language', 'summary', 'plot');
$QUERY = '';

	if (!empty($q))
	{
		$error  = '';
		$tokens = queryparser($q, $error);
		$wild_char = (empty($nowild)) ? '%' : '';

		foreach ($tokens as $token)
		{
            // escape search token
			$token['token'] = addslashes($token['token']);
            // concatenate tokens with token operator
			$QUERY .= $token['ops'].' (';
            // concatenate all searchable fields with OR
			foreach ($fields as $field) {
				$QUERY .= " ($field LIKE '$wild_char".$token['token']."$wild_char') OR ";
			}
			$QUERY .= ' 1=2)';
		}
	$WHERES = "WHERE 1=1 ".$QUERY;
	
	}
$smarty->assign('q', $q); 
$ORDER   = TBL_NEWS.'.pubdate DESC, ' . TBL_NEWS.'.id DESC';
}


// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
                              FROM '.TBL_NEWS.' '.$WHERES);

// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned

// do hard work
$select = 'SELECT '.TBL_NEWS.'.id, '.TBL_NEWS.'.title, '.TBL_NEWS.'.category, '.TBL_NEWS.'.language, '.TBL_NEWS.'.imgurl, '.TBL_NEWS.'.summary,
				  '.TBL_NEWS.'.plot, '.TBL_NEWS.'.link, '.TBL_NEWS.'.newsfrom, '.TBL_NEWS.'.pubdate FROM '.TBL_NEWS.' '.$WHERES.' ORDER BY '.$ORDER.' '.$LIMIT;
$result = runSQL($select);
$smarty->assign('number', count($result));


// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);


// is it editable/ copyable?
    $editable = localnet();
    // multi-user permissions
    if ($config['multiuser'])
    {
        $editable = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
    }
	$smarty->assign('editable',$editable);


//DISPLAY PAGE

// prepare
tpl_page('news');
tpl_list($result);
tpl_filters_news($filter, $langfilter, $catfilter);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');
smarty_display('filters_news.tpl');
if (!$config['http_caching']) flush();

smarty_display('list.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('index', httpCacheCaptureEnd());
} 
?>