<?
/**
 * Edit Page
 *
 * The edit form for adding and editing person data
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_persons.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';
require_once './core/security.php';
// check for localnet
localnet_or_die();
// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;

// XML import
if ($config['xml'] && ($import == 'xml'))
{
    require_once './core/xml.php';

    // xml file upload
    if (isset($_FILES['xmlfile']) && is_uploaded_file($_FILES['xmlfile']['tmp_name']))
    {
        $file    = $_FILES['xmlfile']['tmp_name'];
        $xmldata = file_get_contents($file);
        unlink($file);
    }

    // uploading XML data directly or loaded from file
    if (!empty($xmldata))
    {
        $error      = '';
        $item_id    = 0;

        if (($xmlitems = xmlimport($xmldata, $error)) !== false)
        {
            // multiple items imported
            if ($xmlitems === true)
            {
                redirect('persons.php?filter=new');
            }
            // exactly one person imported?
            else
            {
                redirect('show_persons.php?id='.$xmlitems);
            }
        }
        $smarty->assign('xmlerror', $error);
    }

    // prepare templates
    tpl_page();

    // display templates
    tpl_display('xmlimport.tpl');
    exit;
}




// explicit setting of owner
if ($config['multiuser'] && empty($owner_id) && empty($id))
{
    if (check_permission(PERM_WRITE, $_COOKIE['PCSuserid']))
    {
        $owner_id = $_COOKIE['PCSuserid'];
    }
    else
    {
        
        $CLIENTERROR = $lang['warn_noOwner'];
        $noError = false;
    }
}

// save data
if ($save)
{
   
    if ($noError && $id)
    {
        $SELECT = 'SELECT id FROM '.TBL_TEAMS.' WHERE id_person = '.$id;
		$seasons = runSQL($SELECT);

		for ($x=0; $x<count($seasons); $x++) {
		if (${'id_season_'.$seasons[$x]['id']}) {
			${'start_'.$seasons[$x]['id']} = getusdate(${'start_'.$seasons[$x]['id']});
			${'end_'.$seasons[$x]['id']} = getusdate(${'end_'.$seasons[$x]['id']});
			if ($IN) {$IN .= ', ';}
			else {$IN = '(';}
			$IN .= $seasons[$x]['id'];		
			if ($VALUES) {$VALUES .= ",";}
			$VALUES .= "(".${'id_club_'.$seasons[$x]['id']}.",".${'id_season_'.$seasons[$x]['id']}.",".$id.",'".${'start_'.$seasons[$x]['id']}."','".${'end_'.$seasons[$x]['id']}."'";
			$VALUES .= ",'".${'games_'.$seasons[$x]['id']}."','".${'minutes_'.$seasons[$x]['id']}."','".${'goals_'.$seasons[$x]['id']}."','".${'ycards_'.$seasons[$x]['id']}."','".${'rcards_'.$seasons[$x]['id']}."')";
		}
	}
	$IN .= ')';
	$DELETE = 'DELETE FROM '.TBL_TEAMS.' WHERE id_person='.$id.' AND id IN '.$IN;
	runSQL($DELETE);
	
	$INSERT = 'REPLACE INTO '.TBL_TEAMS.' (id_club, id_season, id_person, start, end, games, minutes, goals, ycards, rcards) VALUES '.$VALUES;
	$id = runSQL($INSERT); 
  
	}

	// show the saved person
	redirect('show_persons.php?id='.$id);

}

// load existing data
if ($id)
{

    $SELECT = 'SELECT id, lastname, firstname, country, birthday, birthcity, position, height, weight, type, international, imgurl, plot FROM '.TBL_PERSONS.' WHERE id = '.$id;
	$person = runSQL($SELECT);

	if ($config['activecomments']) {
	$person[0]['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
	}
	if ($config['activegallery']) {
    $person[0]['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
	}


	
    $SELECT = 'SELECT '.TBL_TEAMS.'.id, '.TBL_TEAMS.'.id_club, '.TBL_CLUBS.'.shortname, '.TBL_SEASONS.'.season, '.TBL_TEAMS.'.id_season,
			  '.TBL_TEAMS.'.start, '.TBL_TEAMS.'.end, '.TBL_TEAMS.'.games, '.TBL_TEAMS.'.minutes, '.TBL_TEAMS.'.goals, '.TBL_TEAMS.'.ycards, '.TBL_TEAMS.'.rcards
                 FROM '.TBL_TEAMS.'
				 JOIN '.TBL_CLUBS.' ON '.TBL_TEAMS.'.id_club = '.TBL_CLUBS.'.id
                 JOIN '.TBL_SEASONS.' ON '.TBL_TEAMS.'.id_season = '.TBL_SEASONS.'.id
                 WHERE id_person = '.$id.'
				 ORDER BY '.TBL_SEASONS.'.season DESC, '.TBL_TEAMS.'.end ASC';
	$stats = runSQL($SELECT);
	
	
	
	if (!$LIMIT && ($config['prizelistsize'] > 0)) {
		// check Page Number
		if (!isset($pageno))
		{
			$pageno = 1;
		}
	// define Max Results Per Page
	$maxresults = $config['prizelistsize'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num FROM '.TBL_SEASONS);
 
	// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
	}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned
	
} 



// prepare templates
tpl_page();
tpl_edit_statsperson($stats, $person);
$smarty->assign('lookup_id', $lookup);
$smarty->assign('http_error', $CLIENTERROR);
// allow XML import
if ($config['xml'] && empty($id)) $smarty->assign('xmlimport', true);
// display templates
tpl_display('edit_statspersons.tpl');	

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_statspersons'.$id, httpCacheCaptureEnd());
}

?>
