<?php
/**
 * Competition Detail View
 *
 * Shows all prizelist for a competition
 *
 * @package Setup
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: prizelist.php,v 1.00 2006/12/24 13:15:00
 */

require_once './core/functions.php';

// check for localnet
localnet_or_die();
// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;

if ($save) {

	// define Max Results Per Page
	$maxresults = $config['prizelistsize'];
	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
	
	$SELECT = 'SELECT id, season FROM '.TBL_SEASONS.' ORDER BY season DESC'.$LIMIT;
	$seasons = runSQL($SELECT);
	
	
	
	
	for ($x=0; $x<count($seasons); $x++) {
		if (${'season'.$seasons[$x]['id']}) {
			if ($IN) {$IN .= ', ';}
			else {$IN = '(';}
			$IN .= $seasons[$x]['id'];		
			if ($VALUES) {$VALUES .= ",";}
			$VALUES .= "(".${'season'.$seasons[$x]['id']}.",".$seasons[$x]['id'].",".$competition.")";
		}
	}
	$IN .= ')';
	
	$DELETE = 'DELETE FROM '.TBL_PRIZELIST.' WHERE id_compet='.$competition.' AND id_season IN '.$IN;
	runSQL($DELETE);
	
	$INSERT = 'REPLACE INTO '.TBL_PRIZELIST.' (id_club, id_season, id_compet) VALUES '.$VALUES;
	$id = runSQL($INSERT); 
	
redirect('prizelist.php?competition='.$competition);
}

// get data (id may be empty on a empty database)
if (!empty($competition))
{

	$SELECT = 'SELECT id, shortname, longname, aka, active, type, range, oneyear, country, creation, website, imgurl, owner_id, plot FROM '.TBL_COMPETITIONS.' WHERE id = '.$competition;				 
	$competdata = runSQL($SELECT);

	if ($competdata[0]['range'] == 1) {
	$WHERES = 'WHERE country =\''.$competdata[0]['country'].'\''; 
	}
	else if ($competdata[0]['range'] == 3) {
	$WHERES = 'WHERE nationalteam = 1'; 
	}
	else {
	$WHERES = 'WHERE nationalteam != 1'; 
	}
	$SELECT = 'SELECT id, shortname, country FROM '.TBL_CLUBS.' '.$WHERES.' ORDER BY shortname';
	$clubs = runSQL($SELECT);

	
	if (!$LIMIT && ($config['prizelistsize'] > 0)) {
		// check Page Number
		if (!isset($pageno))
		{
			$pageno = 1;
		}
	// define Max Results Per Page
	$maxresults = $config['prizelistsize'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num FROM '.TBL_SEASONS);
 
	// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
	}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned
	
	$SELECT = 'SELECT id, season FROM '.TBL_SEASONS.' ORDER BY season DESC'.$LIMIT;
	$seasons = runSQL($SELECT);
	
	$IN = '(';
	for ($x=0;$x<count($seasons);$x++) {
	if ($x) {$IN .= ', ';}
	$IN .= $seasons[$x]['id'];
	}
	$IN .= ')';
	
	$SELECT = 'SELECT id_club, id_season, id_compet 
	FROM '.TBL_PRIZELIST.'
	LEFT JOIN '.TBL_SEASONS.' ON '.TBL_SEASONS.'.id = '.TBL_PRIZELIST.'.id_season 
	WHERE id_compet = '.$competition.' AND id_season IN '.$IN.' ORDER BY season';
	$list = runSQL($SELECT);

    // is it editable/ copyable?
    //$editable = localnet();
    //$copyable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
		$administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$smarty->assign('administrable', $administrable);
		$owners = split(',', $competdata[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
				$smarty->assign('editable', $editable);
			}
		}
		if (!$administrable && !$editable) {
			errorpage("Access denied",$lang[accessdenied]);
		}
		if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }

    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($competition, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}
if ($config['competitionstats'] && $competdata[0]['active']) {
$smarty->assign('statsactive', 1);
}
if (!$season) {$season = $config['seasonfilterdefault'];}
$smarty->assign('season', $season);
$smarty->assign('competition', $competdata[0]);
$smarty->assign('clubs', $clubs);
$smarty->assign('seasons', $seasons);

// prepare templates
tpl_page('detailview', $matchs['name']);
tpl_edit_prizelist($list);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('edit_prizelist.tpl', $competition);
smarty_display('footer.tpl');
// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_prizelist'.$competition, httpCacheCaptureEnd());
}

?>
