<?
/**
 * Edit Page
 *
 * The edit form for adding and editing candidate data
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_penalitys.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';
require_once './core/security.php';
// check for localnet
localnet_or_die();
// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;

// list of fields to be read/written from/to html form
$candidate_set_fields    = array('id_compet','id_season','id_club','penality');

// list of fields to be overwritten by refetchAllInfos-Script
$candidate_overwrite_fields    = array('penality');

// get default lookup mode (0=ignore, 1=lookup, 2=overwrite) if not set
if (!isset($lookup)) $lookup = (empty($id)) ? $lookup = 2 : $config['lookupdefault'];

// save data
if ($save)
{
	$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname as clubname, '.TBL_CLUBS.'.country as country
                 FROM '.TBL_CANDIDATES.', '.TBL_CLUBS.'
                 WHERE id_compet = '.$mycompet.' AND id_season='.$season.' AND '.TBL_CLUBS.'.id = '.TBL_CANDIDATES.'.id_club ORDER BY clubname';				 
	$candidate = runSQL($SELECT);
	
	
    if ($noError)
    {

			foreach ($candidate as $name)
    		{
			$INSERT = 'UPDATE '.TBL_CANDIDATES.' SET penality='.${'pen'.$name['id']}.' WHERE id_compet = '.$mycompet.' AND id_season='.$season.' AND id_club='.$name['id'];
            $id = runSQL($INSERT);
    		}

	   // show the saved competition
	   redirect('show_competitions.php?id='.$mycompet.'&season='.$season);
	   
	}
}

// load existing data
if ($competition)
{
	if (!$season) {$season       = $config['seasonfilterdefault'];}
	
	// select all fields according to list, plus id
	foreach ($candidate_set_fields as $name)
    {
		if ($SELECT) $SELECT .= ', ';
		$SELECT .= $name;
	}

    $SELECT = 'SELECT '.TBL_CLUBS.'.id, '.$SELECT.', '.TBL_CLUBS.'.shortname as clubname, '.TBL_CLUBS.'.country as country
                 FROM '.TBL_CANDIDATES.', '.TBL_CLUBS.'
                 WHERE id_compet = '.$competition.' AND id_season='.$season.' AND '.TBL_CLUBS.'.id = '.TBL_CANDIDATES.'.id_club ORDER BY clubname';				 
	$candidate = runSQL($SELECT);	
	$numcandidate = count($candidate);
	
	
	
	$SELECT = 'SELECT id, shortname, longname, aka, active, type, range, oneyear, country, creation, website, imgurl, owner_id, plot
                 FROM '.TBL_COMPETITIONS.'
                 WHERE id = '.$competition;				 
	$competdata = runSQL($SELECT);
	
	$SELECT = 'SELECT '.TBL_SEASONS.'.season
                 FROM '.TBL_SEASONS.'
                 WHERE id = '.$season;				 
	$nameseason = runSQL($SELECT);
	
    if ($config['multiuser'])
    {
		//$smarty->assign('editable', check_permission(PERM_WRITE, $_COOKIE['PCSuserid']));
		$administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);

		$owners = split(',', $competdata[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
				$smarty->assign('editable', $editable);
			}
		}
		if (!$administrable && !$editable) {
			errorpage("Access denied",$lang[accessdenied]);
		}	
		
	    if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }
	
	// previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($competition, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
			$smarty->assign('prev_id', $prev_id);
			$smarty->assign('next_id', $next_id);
        }
    }
	if ($config['competitionstats'] && $competdata[0]['active']) {
	$smarty->assign('statsactive', 1);
	}
	$smarty->assign('administrable', $administrable);
	$smarty->assign('numcandidate', $numcandidate);
	$smarty->assign('mycompetition', $competition);
	$smarty->assign('nameseason', $nameseason[0]);
	$smarty->assign('myseason', $season);
	$smarty->assign('competdata', $competdata[0]);

} 


// prepare templates
tpl_page();
tpl_edit_penality($candidate);
$smarty->assign('http_error', $CLIENTERROR);
// allow XML import
if ($config['xml'] && empty($id)) $smarty->assign('xmlimport', true);
// display templates
tpl_display('edit_penalitys.tpl');	

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_penalitys'.$competition, httpCacheCaptureEnd());
}

?>
