<?php
/**
 * Edit all data for matchs
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_days.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';
require_once './core/tables.php';

// check for localnet
localnet_or_die();
// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;


if ($save) {

	if ($mirror) {
		$SELECT = 'SELECT '.TBL_MATCHS.'.id
				FROM '.TBL_MATCHS.'
				JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id 
				WHERE '.TBL_DAYS.'.day = '.$day.' AND '.TBL_DAYS.'.id_compet='.$mycompet.' AND '.TBL_DAYS.'.id_season='.$myseason; 
		$res   = runSQL($SELECT);

		$SELECT = 'SELECT '.TBL_MATCHS.'.id
				FROM '.TBL_MATCHS.'
				JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id 
				WHERE '.TBL_DAYS.'.day = '.$mirror.' AND '.TBL_DAYS.'.id_compet='.$mycompet.' AND '.TBL_DAYS.'.id_season='.$myseason; 
		$mir   = runSQL($SELECT);

		//foreach ($res as $match) {
		for ($x=0; $x<count($mir); $x++) {
		$INSERT = 'UPDATE '.TBL_MATCHS.' SET 
		id_candidate_dom=\''.${'ext'.$res[$x]['id']}.'\', 
		buts_dom=\'0\', 
		id_candidate_ext=\''.${'dom'.$res[$x]['id']}.'\', 
		buts_ext=\'0\'
		WHERE id = '.$mir[$x]['id'];
		$id = runSQL($INSERT); 
		//echo $INSERT . '<br>';
		
		}
		//echo $mirror;
		//exit;
	}
	else {

		$SELECT = 'SELECT '.TBL_MATCHS.'.id
				FROM '.TBL_MATCHS.'
				JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id 
				WHERE '.TBL_DAYS.'.day = '.$day.' AND '.TBL_DAYS.'.id_compet='.$mycompet.' AND '.TBL_DAYS.'.id_season='.$myseason; 
		$res   = runSQL($SELECT);

		foreach ($res as $match) {
		$mymatchdate = getusdate(${'date'.$match['id']}) . ' ' . ${'hour'.$match['id']} . ':00';
		if(${'valid'.$match['id']}) {
			$INSERT = 'UPDATE '.TBL_MATCHS.' SET 
			id_candidate_dom=\''.${'dom'.$match['id']}.'\', 
			buts_dom=\''.${'butsdom'.$match['id']}.'\', 
			id_candidate_ext=\''.${'ext'.$match['id']}.'\', 
			buts_ext=\''.${'butsext'.$match['id']}.'\', 
			date_day=\''.$mymatchdate.'\',
			extendtime=\''.${'extendtime'.$match['id']}.'\',
			pen_dom=\''.${'pendom'.$match['id']}.'\',
			pen_ext=\''.${'penext'.$match['id']}.'\',	 
			id_referee=\''.${'ref'.$match['id']}.'\',
			id_weather=\''.${'weather'.$match['id']}.'\',
			id_stadium=\''.${'stadium'.$match['id']}.'\',
			spectators=\''.${'spect'.$match['id']}.'\',
			temperature=\''.${'temp'.$match['id']}.'\',
			validation=\''.${'valid'.$match['id']}.'\',
			plot=\''.addslashes(${'plot'.$match['id']}).'\'
			WHERE id = '.$match['id'];
		}
		else {
			$INSERT = 'UPDATE '.TBL_MATCHS.' SET 
			id_candidate_dom=\''.${'dom'.$match['id']}.'\',
			id_candidate_ext=\''.${'ext'.$match['id']}.'\',
			id_referee=\''.${'ref'.$match['id']}.'\',
			id_stadium=\''.${'stadium'.$match['id']}.'\',
			date_day=\''.$mymatchdate.'\',
			validation=\''.${'valid'.$match['id']}.'\'
			WHERE id = '.$match['id'];
		}
		$id = runSQL($INSERT); 
		//echo $INSERT . '<br>';
		}
	}

	maketable($mycompet, $day, $myseason);
	$next = $day+1;	
	redirect('edit_matchs.php?competition='.$mycompet.'&season='.$myseason.'&day='.$next);
}

// get data (id may be empty on a empty database)
if (!empty($competition) && !empty($season))
{
	$SELECT = 'SELECT '.TBL_DAYS.'.id FROM '.TBL_DAYS.' WHERE id_compet = '.$competition.' AND id_season='.$season;				 
	$days = runSQL($SELECT);
	$numdays=count($days);

	$SELECT = 'SELECT '.TBL_COMPETITIONS.'.id, '.TBL_COMPETITIONS.'.shortname, '.TBL_COMPETITIONS.'.longname, '.TBL_COMPETITIONS.'.aka, '.TBL_COMPETITIONS.'.active, '.TBL_COMPETITIONS.'.type, '.TBL_COMPETITIONS.'.range, '.TBL_COMPETITIONS.'.oneyear, '.TBL_COMPETITIONS.'.country, '.TBL_COMPETITIONS.'.creation, '.TBL_COMPETITIONS.'.website, '.TBL_COMPETITIONS.'.imgurl, '.TBL_COMPETITIONS.'.owner_id, '.TBL_COMPETITIONS.'.plot, '.TBL_PARAMS.'.ar 
			   FROM '.TBL_COMPETITIONS.' 
			   JOIN '.TBL_PARAMS.' ON '.TBL_COMPETITIONS.'.id = '.TBL_PARAMS.'.id_compet
			   WHERE '.TBL_COMPETITIONS.'.id = '.$competition;				 
	$competdata = runSQL($SELECT);

	if (!$day) {
		$lastday = runSQL('SELECT '.TBL_DAYS.'.day FROM '.TBL_DAYS.' WHERE id_compet = '.$competition.' AND id_season='.$season . ' AND '.TBL_DAYS.'.date_day < NOW() ORDER BY '.TBL_DAYS.'.date_day DESC LIMIT 1');
		$day = $lastday[0]['day'];
	}
	if (!$day) {
		$day=1;
	}

	if ($day) {
		$SELECT = 'SELECT '.TBL_MATCHS.'.id, '.TBL_MATCHS.'.id_candidate_dom, Dom.owner_id AS dom_owner_id, '.TBL_MATCHS.'.id_candidate_ext, Ext.owner_id AS ext_owner_id, '.TBL_MATCHS.'.id_day, '.TBL_MATCHS.'.date_day, TIMEDIFF('.TBL_MATCHS.'.date_day, NOW()) AS timediff, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext, '.TBL_MATCHS.'.extendtime, '.TBL_MATCHS.'.pen_dom, '.TBL_MATCHS.'.pen_ext, '.TBL_MATCHS.'.id_referee, '.TBL_MATCHS.'.id_stadium, Dom.id_stadium as domstadium, '.TBL_MATCHS.'.spectators, '.TBL_MATCHS.'.id_weather, '.TBL_MATCHS.'.temperature, '.TBL_MATCHS.'.validation, '.TBL_MATCHS.'.plot
				FROM '.TBL_MATCHS.' 
				JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id
				LEFT JOIN '.TBL_CLUBS.' AS Dom ON '.TBL_MATCHS.'.id_candidate_dom = Dom.id 
				LEFT JOIN '.TBL_CLUBS.' AS Ext ON '.TBL_MATCHS.'.id_candidate_ext = Ext.id 
				WHERE '.TBL_DAYS.'.id_compet = '.$competition.' AND '.TBL_DAYS.'.id_season = '.$season.' AND '.TBL_DAYS.'.day = '.$day.' ORDER BY '.TBL_MATCHS.'.date_day;'; 
		$res   = runSQL($SELECT);
		// existing id?
		if (!count($res)) redirect('show_tables.php?competition='.$competition.'&season='.$season);
		// get the item
		$matchs = $res;
		$nummatchs = count($res);
		
		
		$allcandidates = runSQL('SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.owner_id
						 FROM '.TBL_CANDIDATES.'
						 JOIN '.TBL_CLUBS.' ON '.TBL_CANDIDATES.'.id_club = '.TBL_CLUBS.'.id 			
						 WHERE id_compet ='.$competition.' AND id_season='.$season.' ORDER BY '.TBL_CLUBS.'.shortname');
		for ($x=0;$x<count($allcandidates);$x++) {
			if ($allcandidates[$x]['owner_id']) {
			$owners = split(',', $allcandidates[$x]['owner_id']);
				foreach($owners as $owner) {
					if($owner == $_COOKIE['PCSuserid']) {
						$allcandidates[$x]['validable'] = 1;
						$validable=1;
					}
				}
			}	
		}
	}
	
	$SELECT = 'SELECT '.TBL_SEASONS.'.season FROM '.TBL_SEASONS.' WHERE id = '.$season;				 
	$nameseason = runSQL($SELECT);
	
    // is it editable/ copyable?
    //$editable = localnet();
    //$copyable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$smarty->assign('administrable', $administrable);
		$owners2 = split(',', $competdata[0]['owner_id']);
		foreach($owners2 as $owneradm) {
			if($owneradm == $_COOKIE['PCSuserid']) {
				$editable = 1;
			}
		}
		if (!$administrable && !$editable && !$validable) {
			errorpage("Access denied",$lang[accessdenied]);
		}
		if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }

    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($competition, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if (!$season) {$season = $config['seasonfilterdefault'];}
if ($config['competitionstats'] && $competition['active']) {
$smarty->assign('statsactive', 1);
}
$smarty->assign('competition', $competition);
$smarty->assign('matchvalidation', $config['matchvalidation']);
$smarty->assign('day', $day);
$smarty->assign('allcandidates', $allcandidates);
$smarty->assign('season', $season);
$smarty->assign('haveseason', $season);
$smarty->assign('editable', $editable);
$smarty->assign('administrable', $administrable);
$smarty->assign('commentable', $commentable);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('nummatchs', $nummatchs);
$smarty->assign('numdays', $numdays);
$smarty->assign('nameseason', $nameseason[0]);
$smarty->assign('competdata', $competdata[0]);

// prepare templates
tpl_page('detailview', $matchs['name']);
tpl_edit_matchs($matchs,$competition);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('edit_matchs.tpl', $competition);
smarty_display('footer.tpl');
// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_matchs'.$competition.$season, httpCacheCaptureEnd());
}

?>
