<?php
/**
 * Edit all data for matchs
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_days.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// check for localnet
localnet_or_die();
// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;


if ($save) {

	$SELECT = 'SELECT '.TBL_MATCHS.'.id, '.TBL_MATCHS.'.id_candidate_dom, '.TBL_MATCHS.'.id_candidate_ext, '.TBL_DAYS.'.id_season
				FROM '.TBL_MATCHS.'
				JOIN '.TBL_DAYS.' ON '.TBL_DAYS.'.id = '.TBL_MATCHS.'.id_day
				WHERE '.TBL_MATCHS.'.id = '.$match; 
	$res   = runSQL($SELECT);

	$SELECT = 'SELECT '.TBL_TEAMS.'.id, '.TBL_TEAMS.'.id_club, '.TBL_TEAMS.'.id_person
				FROM '.TBL_TEAMS.'
				WHERE '.TBL_TEAMS.'.id_season = '.$res[0]['id_season'].' AND ('.TBL_TEAMS.'.id_club = '.$res[0]['id_candidate_dom'].' OR '.TBL_TEAMS.'.id_club = '.$res[0]['id_candidate_ext'].')';
	$rooster   = runSQL($SELECT);

	
	$DELETE = 'DELETE FROM '.TBL_LINEUP.' WHERE id_match='.$match;
	$result = runSQL($DELETE);

	//Insertion in Line UP Table
	$VALUES="";
	// update all fields according to list
	foreach ($rooster as $player)	{
		if (${'type_'.$player['id']}) {
			if (${'captain_'.$player['id_club']} == $player['id_person']) {$captain = 1;}
			else {$captain = 0;}
			if ($VALUES) {$VALUES .= ",";}
			$VALUES .= "(".$match.",".$player['id_club'].",".$player['id_person'].",".${'type_'.$player['id']}.",".$captain.")";		
		}
	}
	$INSERT = 'INSERT INTO '.TBL_LINEUP.' (id_match, id_club, id_person, type, captain) VALUES '.$VALUES;
	// insert new record
    $id = runSQL($INSERT);

	redirect('show_match.php?id='.$match);
}


		$SELECT = 'SELECT '.TBL_MATCHS.'.id, '.TBL_MATCHS.'.id_candidate_dom, Dom.longname AS clubdom, '.TBL_MATCHS.'.id_candidate_ext, Ext.longname AS clubext, '.TBL_DAYS.'.id_season, '.TBL_DAYS.'.id_compet, '.TBL_SEASONS.'.season, '.TBL_COMPETITIONS.'.longname, '.TBL_COMPETITIONS.'.active, '.TBL_COMPETITIONS.'.oneyear, '.TBL_COMPETITIONS.'.owner_id
				FROM '.TBL_MATCHS.'
				JOIN '.TBL_DAYS.' ON '.TBL_DAYS.'.id = '.TBL_MATCHS.'.id_day
				JOIN '.TBL_SEASONS.' ON '.TBL_SEASONS.'.id = '.TBL_DAYS.'.id_season
				JOIN '.TBL_COMPETITIONS.' ON '.TBL_COMPETITIONS.'.id = '.TBL_DAYS.'.id_compet
				LEFT JOIN '.TBL_CLUBS.' AS Dom ON '.TBL_MATCHS.'.id_candidate_dom = Dom.id 
				LEFT JOIN '.TBL_CLUBS.' AS Ext ON '.TBL_MATCHS.'.id_candidate_ext = Ext.id 
				WHERE '.TBL_MATCHS.'.id = '.$match; 
		$res   = runSQL($SELECT);

		$SELECT = 'SELECT '.TBL_TEAMS.'.id, '.TBL_TEAMS.'.id_club, '.TBL_TEAMS.'.id_season, '.TBL_PERSONS.'.id AS id_person, CONCAT('.TBL_PERSONS.'.lastname, " ", '.TBL_PERSONS.'.firstname) AS name, '.TBL_LINEUP.'.type, '.TBL_LINEUP.'.captain
				FROM '.TBL_TEAMS.'
				JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_TEAMS.'.id_person
				LEFT JOIN '.TBL_LINEUP.' ON '.TBL_LINEUP.'.id_person = '.TBL_TEAMS.'.id_person AND '.TBL_LINEUP.'.id_match = '.$match.'
				WHERE '.TBL_TEAMS.'.id_season = '.$res[0]['id_season'].' AND '.TBL_TEAMS.'.id_club IN ('.$res[0]['id_candidate_dom'].', '.$res[0]['id_candidate_ext'].')
				ORDER BY '.TBL_PERSONS.'.position, '.TBL_PERSONS.'.lastname'; 
		$rooster   = runSQL($SELECT);


	$smarty->assign('rooster', $rooster);
	$smarty->assign('competition', $res[0]['id_compet']);
	if ($config['competitionstats'] && $res[0]['active']) {
	$smarty->assign('statsactive', 1);
	}
	$smarty->assign('oneyear', $res[0]['oneyear']);	
	$smarty->assign('season', $res[0]['id_season']);	
	$smarty->assign('match', $match);	
	
    // is it editable/ copyable?
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$smarty->assign('administrable', $administrable);
		$owners = split(',', $res[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
				$smarty->assign('editable', $editable);
			}
		}
		if (!$administrable && !$editable) {
			errorpage("Access denied",$lang[accessdenied]);
		}	
		if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }
if (!$season) {$season = $config['seasonfilterdefault'];}


// prepare templates
tpl_page('detailview', $matchs['name']);
tpl_edit_lineup($res);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('edit_lineup.tpl');
smarty_display('footer.tpl');
// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_lineup'.$match, httpCacheCaptureEnd());
}

?>