<?
/**
 * Edit Page
 *
 * The edit form for adding and editing competition data
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_competitions.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';
require_once './core/security.php';

// check for localnet
localnet_or_die();

// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;

// XML import
if ($config['xml'] && ($import == 'xml'))
{
    require_once './core/xml.php';

    // xml file upload
    if (isset($_FILES['xmlfile']) && is_uploaded_file($_FILES['xmlfile']['tmp_name']))
    {
        $file    = $_FILES['xmlfile']['tmp_name'];
        $xmldata = file_get_contents($file);
        unlink($file);
    }

    // uploading XML data directly or loaded from file
    if (!empty($xmldata))
    {
        $error      = '';
        $item_id    = 0;

        if (($xmlitems = xmlimport($xmldata, $error)) !== false)
        {
            // multiple items imported
            if ($xmlitems === true)
            {
                redirect('categories.php');
            }
            // exactly one competition imported?
            else
            {
                redirect('show_categories.php?id='.$xmlitems);
            }
        }
        $smarty->assign('xmlerror', $error);
    }

    // prepare templates
    tpl_page();

    // display templates
    tpl_display('xmlimport.tpl');
    exit;
}

// list of fields to be read/written from/to html form
$categorie_set_fields    = array('longname','shortname','country','pos','parent','imgurl','active','visible','plot');
// list of fields to be overwritten by refetchAllInfos-Script
$categorie_overwrite_fields    = array('plot');

// get default lookup mode (0=ignore, 1=lookup, 2=overwrite) if not set
if (!isset($lookup)) $lookup = (empty($id)) ? $lookup = 2 : $config['lookupdefault'];

// preload old data for refresh all mechanism
if ($lookup == 3)
{
    // get a list of competitions in DB
    $categorie = runSQL('SELECT * FROM '.TBL_CATEGORIES.' WHERE id = '.$id);

    // get fields (according to list) from db to be saved later
    foreach ($categorie[0] as $name => $val)
    {
       if (in_array($name, $categorie_set_fields)) $$name = $val;
    }

    // Build a list of all fields which are allowed to be overwritten
    $overwrites = array();
    foreach ($categorie_set_fields as $field)
    {
        $tempFieldName = 'update_'.$field;
        if (isset($$tempFieldName) && $$tempFieldName == 1) $overwrites[] = $field;
    }
    $categorie_set_fields = $overwrites;

    $lookup = 2;
}

// save data
if ($save)
{
    // update all fields according to list
    foreach ($categorie_set_fields as $name)
    {
	
		$$name = removeEvilTags($$name);
        // make sure no formatting contained in basic data
        if ($SETS) $SETS .= ', ';
        $SETS .= "$name = '".addslashes($$name)."'";

    }

  if ($noError)
    {
        if ($id)
        {
            $INSERT = 'UPDATE '.TBL_CATEGORIES.' SET '.$SETS.' WHERE id = '.$id;
            runSQL($INSERT);
        }
        else
        {
            // insert new record
            $INSERT = 'INSERT INTO '.TBL_CATEGORIES.' SET '.$SETS;
            $id = runSQL($INSERT);

			$SELECT = 'SELECT count(*) as count FROM '.TBL_CATEGORIES.' WHERE parent = '.$parent;
			runSQL($SELECT);
			if (!$id[0]['count']) {$mypos = '0';}
			else {$mypos = $id[0]['count'];} 	
			$INSERT = 'UPDATE '.TBL_CATEGORIES.' SET pos = '.$mypos.' WHERE id = '.$id;
            runSQL($INSERT);
        }
	
        // uploaded cover?
        if (isset($_FILES['coverupload']) && is_uploaded_file($_FILES['coverupload']['tmp_name']))
        {
            $file = $_FILES['coverupload']['tmp_name'];
            $mime = $_FILES['coverupload']['type'];

            // determine file extension
            if (preg_match('=image/jpe?g=i', $mime))
            {
                $ext = 'jpg';
            }
            elseif (preg_match('=image/(gif|png)=i', $mime, $m))
            {
                $ext = $m[1];
            }
            elseif (preg_match('=application/octet-stream=i', $mime))
            {
                if (preg_match("/\.(jpe?g|gif|png)$/i", $_FILES['coverupload']['name'], $matches))
                {
                    $ext = $matches[1];
                }
            }

            // move to cache and update db
            if (!empty($ext))
            {
                $coverfile = 'cache/img/categories/'.$id.'.'.$ext;
                if (move_uploaded_file($file, $coverfile))
                {
                    $sql = "UPDATE ".TBL_CATEGORIES." SET imgurl='".$coverfile."' WHERE id=".$id;
                    runSQL($sql);
                }
            }
			
	    }

		if (preg_match('/http/i', $imgurl))
    	{
			if (preg_match('/\.(jpe?g|gif|png)$/i', $imgurl, $matches)) {
					// determine mime type
					switch (strtolower($matches[1]))
					{
						case 'gif':	$mime = 'image/gif';
									break;
						case 'png':	$mime = 'image/png';
									break;
						default:	$mime = 'image/jpeg';
					}
			$coverfile = 'cache/img/categories/'.$id.'.'.$matches[1];
			download($imgurl, $coverfile);
			$imgurl = $coverfile;
			$sql = "UPDATE ".TBL_CATEGORIES." SET imgurl='".$coverfile."' WHERE id=".$id;
            runSQL($sql);			
			}        
    	}
        // clear smarty cache for this item
        $smarty->clear_cache($id);

	    // add another?
	    if ($add_flag)
	    {
	        // remove id to prevent edit mode instead of new
	        $id = '';
	        $smarty->assign('add_flag', $add_flag);
	    }
	    else
	    {
	        // show the saved competition
	        redirect('show_categories.php?id='.$id);
	    }
	}
}


// load existing data
if ($id)
{
	// select all fields according to list, plus id
	foreach ($categorie_set_fields as $name)
    {
		if ($SELECT) $SELECT .= ', ';
		$SELECT .= $name;
	}

    $SELECT = 'SELECT id, '.$SELECT.'
                 FROM '.TBL_CATEGORIES.'
                 WHERE id = '.$id;
	$categorie = runSQL($SELECT);


	// multi-user permissions
    if ($config['multiuser'])
    {
		$smarty->assign('editable', check_permission(PERM_WRITE, $_COOKIE['PCSuserid']));
		if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }
	// previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
			$smarty->assign('prev_id', $prev_id);
			$smarty->assign('next_id', $next_id);
        }
    }

	if (!$season) {$season       = $config['seasonfilterdefault'];}
	$smarty->assign('season', $season);
} 


// prepare templates
tpl_page();
tpl_edit_categories($categorie);
$smarty->assign('lookup_id', $lookup);
$smarty->assign('http_error', $CLIENTERROR);
// allow XML import
if ($config['xml'] && empty($id)) $smarty->assign('xmlimport', true);
// display templates
tpl_display('edit_categories.tpl');	

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_categories'.$id, httpCacheCaptureEnd());
}

?>
