<?
/**
 * Edit Page
 *
 * The edit form for adding and editing caracs data
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_caracs.php,v 1.00 2007/10/14 19:47:13
 */

require_once './core/functions.php';
require_once './core/security.php';

// check for localnet
localnet_or_die();

// multiuser permission check
permission_or_die(PERM_WRITE);

$noError = true;

// list of fields to be read/written from/to html form
$caracs_set_fields    = array('shortname','lib_key','type','genre','rank','perm');



// explicit setting of owner
if ($config['multiuser'] && empty($owner_id) && empty($id))
{
    if (check_permission(PERM_WRITE, $_COOKIE['PCSuserid']))
    {
        $owner_id = $_COOKIE['PCSuserid'];
    }
    else
    {
        // error no owner specified
        $caracs = array();
		    		
        // select all fields according to list, plus id
        foreach ($caracs_set_fields as $name)
        {
            $caracs[0][$name] = $$name;
        }
        $CLIENTERROR = $lang['warn_noOwner'];
        $noError = false;
    }
}


// save data
if ($save)
{
    // update all fields according to list
    foreach ($caracs_set_fields as $name)
    {
	
		$$name = removeEvilTags($$name);
        // make sure no formatting contained in basic data
        if ($SETS) $SETS .= ', ';
        $SETS .= "$name = '".addslashes($$name)."'";

    }

    if ($noError)
    {
        if ($id)
        {
            $INSERT = 'UPDATE '.TBL_CARACS.' SET '.$SETS.' WHERE id = '.$id;
            runSQL($INSERT);
        }
        else
        {
            // insert new record
            $INSERT = 'INSERT INTO '.TBL_CARACS.' SET '.$SETS;
            $id = runSQL($INSERT);
        }
	

        // clear smarty cache for this item
        $smarty->clear_cache($id);

	    // add another?
	    if ($add_flag)
	    {
	        // remove id to prevent edit mode instead of new
	        $id = '';
	        $smarty->assign('add_flag', $add_flag);
	    }
	    else
	    {
	        // show the saved caracs
	        redirect('edit_caracs.php?type='.$type);
	    }
	}
}


// load existing data
if ($id)
{
	// select all fields according to list, plus id
	foreach ($caracs_set_fields as $name)
    {
		if ($SELECT) $SELECT .= ', ';
		$SELECT .= $name;
	}

    $SELECT = 'SELECT id, '.$SELECT.'
                 FROM '.TBL_CARACS.'
                 WHERE id = '.$id;
	$caracs = runSQL($SELECT);
	
}

$smarty->assign('type', $type);

if ($type) {
$SELECT = 'SELECT id, shortname FROM '.TBL_CARACS.' WHERE type = '.$type;
$allcaracs = runSQL($SELECT);
$smarty->assign('allcaracs', $allcaracs);
}
// prepare templates
tpl_page();
tpl_edit_caracs($caracs,$type);
$smarty->assign('lookup_id', $lookup);
$smarty->assign('http_error', $CLIENTERROR);
// allow XML import
if ($config['xml'] && empty($id)) $smarty->assign('xmlimport', true);
// display templates
tpl_display('edit_caracs.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_caracs'.$id, httpCacheCaptureEnd());
}	

?>
