<?php
/**
 * Edit bet tables
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: edit_bettable.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';
require_once './core/tables.php';

// check for localnet
localnet_or_die();
// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;

if ($save) {

$date_deb = getusdate($date_deb);
$date_fin = getusdate($date_fin);
$date_fin_bet = getusdate($date_fin_bet) . ' ' . $hour_fin_bet . ':00';

$SETS = "title='".addslashes($title)."', nbr_prono='".$nbr_prono."', cost='".$cost."', date_deb='".$date_deb."', date_fin='".$date_fin."', date_fin_bet='".$date_fin_bet."',
		winprize='".$winprize."', winrank='".$winrank."', rankpercent='".$rankpercent."',  paybet='".$paybet."'";

	if ($id) {	
		$INSERT = 'UPDATE '.TBL_BETTABLE.' SET '.$SETS.' WHERE id='.$id; 
		$bet = runSQL($INSERT); 
	}
	else {
		$INSERT = 'INSERT INTO '.TBL_BETTABLE.' SET '.$SETS; 
		$bet = runSQL($INSERT); 
	}

	if (!$asbepayed && $paybet && $id) {

	$SELECT = 'SELECT DISTINCT('.TBL_BET.'.id_user) FROM '.TBL_BET.'
			   JOIN '.TBL_BETLIST.' ON '.TBL_BET.'.id_betlist = '.TBL_BETLIST.'.id
			   JOIN '.TBL_BETTABLE.' ON '.TBL_BETTABLE.'.id = '.TBL_BETLIST.'.id_bettable
			   WHERE '.TBL_BETTABLE.'.id = '.$id.' GROUP BY '.TBL_BET.'.id_user';

	$players = runSQL($SELECT);

		foreach ($players as $player) {

		$SELECT = 'SELECT '.TBL_BET.'.pronostic, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext
					FROM '.TBL_BETLIST.'
					LEFT JOIN  '.TBL_BET.' ON '.TBL_BET.'.id_betlist = '.TBL_BETLIST.'.id AND '.TBL_BET.'.id_user = '.$player['id_user'].'
					JOIN '.TBL_MATCHS.' ON '.TBL_MATCHS.'.id = '.TBL_BETLIST.'.id_match
					WHERE '.TBL_BETLIST.'.id_bettable ='.$id; 
		$res   = runSQL($SELECT);
	
		$goodbet = 0;
		foreach ($res as $prono) {
			if ($prono['buts_dom'] > $prono['buts_ext'] && $prono['pronostic'] == '1') {$goodbet = $goodbet+1;}
			else if ($prono['buts_dom'] < $prono['buts_ext'] && $prono['pronostic'] == '2') {$goodbet = $goodbet+1;}
			else if ($prono['buts_dom'] == $prono['buts_ext'] && $prono['pronostic'] == 'N') {$goodbet = $goodbet+1;}
		}
	
		$prize = $winprize;
		for ($x=0; $x<$winrank; $x++) {
			if (($nbr_prono - $x) == $goodbet) {$betprize = $prize;}
			$prize = ceil(($prize * $rankpercent)/100);
		}
		
		$DELETE ='DELETE FROM '.TBL_BETWINNER.' WHERE id_bettable = '.$id.' AND user_id = '.$player['id_user'].';';
		runSQL($DELETE);
		
		$INSERT = 'REPLACE INTO '.TBL_BETWINNER.' (user_id, id_bettable, goodprono, prize) VALUES (\''.$player['id_user'].'\',\''.$id.'\',\''.$goodbet.'\',\''.$betprize.'\')';
		$bet = runSQL($INSERT);
		if ($betprize) {
		 count_points($player['id_user'], $betprize);
		}
		}

	}
	redirect('pronostics.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

	$SELECT = 'SELECT '.TBL_BETTABLE.'.title, '.TBL_BETTABLE.'.cost, '.TBL_BETTABLE.'.nbr_prono,  '.TBL_BETTABLE.'.date_deb,
    '.TBL_BETTABLE.'.date_fin,  '.TBL_BETTABLE.'.date_fin_bet,  '.TBL_BETTABLE.'.winprize,  '.TBL_BETTABLE.'.winrank,  '.TBL_BETTABLE.'.rankpercent,  '.TBL_BETTABLE.'.paybet
	FROM '.TBL_BETTABLE.'
	WHERE '.TBL_BETTABLE.'.id = '.$id;				 
	$res = runSQL($SELECT);
	
	// is it editable/ copyable?
    $editable = localnet();
    $copyable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $smarty->assign('editable', check_permission(PERM_WRITE, $_COOKIE['PCSuserid']));
		if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }

$smarty->assign('today', date('Y-m-d HH:MM'));
}

$smarty->assign('id', $id);

// prepare templates
tpl_page('detailview', $res[0]['title']);
tpl_edit_bettable($res[0]);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
smarty_display('filters_pronostics.tpl');
if (!$config['http_caching']) flush();
smarty_display('edit_bettable.tpl', $id);
smarty_display('footer.tpl');
// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_bettable'.$id, httpCacheCaptureEnd());
}

?>
