<?php
/**
 * Delete PCS data in base
 *
 * Handles the deletion of PHP competition system Data
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: delete.php,v 1.00 2006/12/22 20:30:00
 *
 * CAT parameter
 *  1 - Clubs table
 *  2 - Comments table
 *  3 - Competition table
 *  4 - days table
 *  5 - gallery table
 *  6 - matchs table
 *  7 - news table
 *  8 - persons table
 *  9 - seasons table
 * 10 - stadiums table
 * 11 - users table
 * 12 - bet table
 * 13 - categories table
 *
 */

require_once './core/functions.php';


/*
 * Remove image from cache
 */
function removeCacheFile($url)
{
    // get extension
    if (preg_match("/\.(jpe?g|gif|png)$/i", $url, $matches)) 
    {
        // check if file exists
        if (checkCacheFile($url, $matches[1], $file))
        {
            @unlink($file);
        }
    }
}


// check for localnet
localnet_or_die();
permission_or_die(PERM_WRITE, $_COOKIE['PCSuserid']);
// multiuser permission check



if (empty($id) || empty($cat)) {
	redirect('index.php');
}

$msg = '';   
switch ($cat) {
	case '1':
		if (!$confirmdelete) {
			$msg .= '1 ' . $lang['dataclubs'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Candidates table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_CANDIDATES.' WHERE id_club='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['datacandidates'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Cards table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_CARDS.' WHERE id_club='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['datacards'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Goals table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_GOALS.' WHERE id_club='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['datagoals'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Prizelist table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_PRIZELIST.' WHERE id_club='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['dataprizelist'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//teams table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_TEAMS.' WHERE id_club='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['datateams'] . ' ' . $lang['shouldbedeleted'] . '<br>';
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_CLUBS.' WHERE id = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_CANDIDATES.' WHERE id_club = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_CARDS.' WHERE id_club = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_GOALS.' WHERE id_club = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_PRIZELIST.' WHERE id_club = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_TEAMS.' WHERE id_club = '.$id;
		runSQL($DELETE);
		$redirection = "clubs.php";
		}
	break; 
	
	case '2':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datacomments'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_COMMENTS.' WHERE id = '.$id;
		runSQL($DELETE);
		$redirection = "index.php";
		}
	break; 
	
	case '3':
		if (!$confirmdelete) {
			$msg .= '1 ' . $lang['datacompetitions'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Candidates table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_CANDIDATES.' WHERE id_compet='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['datacandidates'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Classification table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_CLMNT.' WHERE id_compet='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['dataclmnt'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
			//Prizelist table count		
			$count= runSQL('SELECT count(*) AS count FROM '.TBL_PRIZELIST.' WHERE id_compet='.$id);
			$msg .= $count[0]['count'] . ' ' . $lang['dataprizelist'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_COMPETITIONS.' WHERE id = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_CANDIDATES.' WHERE id_compet = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_CLMNT.' WHERE id_compet = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_PRIZELIST.' WHERE id_compet = '.$id;
		runSQL($DELETE);
		$redirection = "competitions.php";
		}
	break; 
	
	case 4:
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datadays'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		//Candidates table count		
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_MATCHS.' WHERE id_day='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['datamatchs'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_DAYS.' WHERE id = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_MATCHS.' WHERE id_day = '.$id;
		runSQL($DELETE);
		$redirection = "competitions.php";
		}
	break; 
	
	case '5':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datagallery'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_GALLERY.' WHERE id = '.$id;
		$redirection = "index.php";
		}
	break; 
	
	case '6':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datamatchs'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_MATCHS.' WHERE id = '.$id;
		runSQL($DELETE);
		$redirection = "competitions.php";
		}
	break; 
	
	case '7':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datanews'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_NEWS.' WHERE id = '.$id;
		runSQL($DELETE);
		$redirection = "news.php";
		}
	break; 
	
	case '8':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datapersons'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_PERSONS.' WHERE id = '.$id;
		runSQL($DELETE);
		$redirection = "persons.php";
		}
	break; 
	
	case '9':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['dataseasons'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_CARDS.' WHERE id_season='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['datacards'] . ' ' . $lang['shouldbedeleted'] . '<br>';
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_GOALS.' WHERE id_season='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['datagoals'] . ' ' . $lang['shouldbedeleted'] . '<br>';
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_SEASONS.' WHERE id = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_CARDS.' WHERE id_season = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_GOALS.' WHERE id_season = '.$id;
		runSQL($DELETE);
		$redirection = "competitions.php";
		}
	break; 
	
	case '10':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datastadiums'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_STADIUMS.' WHERE id = '.$id;
		runSQL($DELETE);
		$redirection = "stadiums.php";
		}
	break; 
	
	case '11':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datausers'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_USERCONFIG.' WHERE user_id='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['datauserconfig'] . ' ' . $lang['shouldbedeleted'] . '<br>';
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_USERS.' WHERE id = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_USERCONFIG.' WHERE user_id = '.$id;
		runSQL($DELETE);
		$redirection = "members.php";
		}
	break; 
	
	case '12':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['databettable'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_BETLIST.' WHERE id_bettable='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['databetlist'] . ' ' . $lang['shouldbedeleted'] . '<br>';
		}
		else {
		$betmatch = runSQL('SELECT id FROM '.TBL_BETLIST.' WHERE id_bettable='.$id);
		foreach ($betmatch as $match) {
		$DELETE = 'DELETE FROM '.TBL_BET.' WHERE id_betlist = '.$match['id'];
		runSQL($DELETE);
		}
		$DELETE = 'DELETE FROM '.TBL_BETLIST.' WHERE id_bettable = '.$id;
		runSQL($DELETE);
		$DELETE = 'DELETE FROM '.TBL_BETTABLE.' WHERE id = '.$id;
		runSQL($DELETE);
		$redirection = "members.php";
		}
	break; 

	case '13':
		if (!$confirmdelete) {
		$msg .= '1 ' . $lang['datacategories'] . ' ' . $lang['shouldbedeleted'] . '<br>'; 
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_CATEGORIES.' WHERE parent='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['datacategories'] . ' ' . $lang['shouldbemodified'] . '<br>';
		$count= runSQL('SELECT count(*) AS count FROM '.TBL_COMPETITIONS.' WHERE category='.$id);
		$msg .= $count[0]['count'] . ' ' . $lang['datacompetitions'] . ' ' . $lang['shouldbemodified'] . '<br>';
		}
		else {
		$DELETE = 'DELETE FROM '.TBL_CATEGORIES.' WHERE id = '.$id;
		runSQL($DELETE);
		$INSERT = 'UPDATE '.TBL_CATEGORIES.' SET parent = 0 WHERE parent = '.$id;
        runSQL($INSERT);
		$INSERT = 'UPDATE '.TBL_COMPETITIONS.' SET category = 0 WHERE category = '.$id;
        runSQL($INSERT);
		$redirection = "categories.php";
		}
	break;
	
	default:
	redirect('index.php');
}


//$smarty->assign
if ($confirmdelete) {
	if (!$redirection) {$redirection = 'index.php';}
	$smarty->assign('refresh', $refresh);
	$smarty->assign('redirection', $redirection);
	$smarty->assign('SQL', $DELETE);
}

$smarty->assign('msg', $msg);
$smarty->assign('confirmdelete', $confirmdelete);
$smarty->assign('cat', $cat);
$smarty->assign('id', $id);	


// clear smarty cache for this item
$smarty->clear_cache($id);

// prepare templates
tpl_page();

// display templates
tpl_display('delete.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('delete', httpCacheCaptureEnd());
}

?>
