<?php
/**
 * Template functions
 *
 * These functions prepare the data for assignment to the template engine
 *
 * @package Core
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: template.php,v 1.00 2006/10/23 18:25:48
 */

require_once './core/session.php';
require_once './core/output.php';
//require_once './core/genres.php';

/**
 * Display template with standard header and footer
 */
function tpl_display_show($template, $flush = true)
{
    smarty_display('header.tpl');

    if ($flush) flush();
    smarty_display($template);
    smarty_display('footer.tpl');
}

/**
 * Display page using templates
 * If page content is unmodified, return HTTP 304 Not modified
 *
 * @param   string  $template Template name for main content
 */
function tpl_display($template)
{
    global $config;

    // caching enabled?
    if ($config['http_caching'])
    {
        require_once('./core/httpcache.php');

        httpCacheCaptureStart();
    }

    tpl_display_show($template, !$config['http_caching']);

    if ($config['http_caching'])
    {
        httpCacheOutput($template, httpCacheCaptureEnd());
    }

}

/**
 * Prepare standard page templates
 */
function tpl_page($help = '', $title = '')
{
    tpl_language();
    tpl_header($help, $title);
    tpl_footer();
}

/**
 * Assigns language strings and config options to the smarty engine
 */
function tpl_language()
{
    global $smarty, $lang, $config;

    $smarty->assign('lang', $lang);
    $smarty->assign('config', $config);
}

/**
 * Assigns the headerurls to the smarty engine
 *
 * @param string $help    The helpfile to display (optional, without extension)
 * @param string $title   The text to add to html <title> tag (optional, will be html-encoded)
 */
function tpl_header($help = '', $title = '')
{
    global $smarty, $lang, $config, $id;
	
	$header['browse']          = 'index.php';

	// viewing is only availble if autorized or public access
    if (authcheck(false))
    {
		//Enable clubs
		if ($config['activeclubs']) {
		$header['clubs']           = 'clubs.php';
		}
		//Enable stadiums	
		if ($config['activestadiums']) {
		$header['stadiums']        = 'stadiums.php';
		}
		//Enable competitions
		if ($config['activecompetitions']) {
			if ($config['activecompetcategorys']) {$header['competitions']    = 'categories.php';}
			else {$header['competitions']    = 'competitions.php';}
		}
		//Enable players
		if ($config['activeplayers']) {
		$header['players']         = 'persons.php?type=1';
		}
		//Enable referees
		if ($config['activereferees']) {
		$header['referees']        = 'persons.php?type=3';
		}
		//Enable coachs
		if ($config['activecoachs']) {
		$header['coachs']        = 'persons.php?type=2';
		}
		//Enable search
		if ($config['activesearch']) {
		$header['search']        = 'search.php';
		}
		//Enable calendar
		if ($config['activecalendar']) {
		$header['calendar']        = 'calendar.php';
		}

		//Enable contactus link
		if ($config['contactus'] && $config['admin_email']) {
		$header['contactus']        = $config['admin_email'];
		}
		
		//Admin config
		if (check_permission(PERM_ADMIN)) {
			$header['setup']  = 'setup.php';
		}
	
		//Central Galery
		if ($config['activegallery'] && $config['activecentralgallery'] && check_permission(PERM_GALLERY)) {
			$header['centralgallery']  = 'gallery.php';
		}
		
		//Display pronostics
		if ($config['displaypronostics'] && !empty($_COOKIE['PCSusername']) && $_COOKIE['PCSuserid'] != $config['guestid']) {
			$header['pronostic']   = 'pronostics.php';
		}
		
		//Display list members
		if ($config['displaylistmembers']) {
			$header['members']   = 'members.php';
		}
		
		//Display list members
		if ($config['clubmenutype'] == 1 && $config['clubpreference']) {
			$header['showclubs_preference']    = 'show_clubs.php?id='.$config['clubpreference'];
			$header['showteams_preference']    = 'show_teams.php?id='.$config['clubpreference'];
			if ($config['clubstats']) $header['statsclubs_preference']   = 'stats_clubs.php?id='.$config['clubpreference'];
			$header['showcalendar_preference'] = 'show_calendarteams.php?id='.$config['clubpreference'];
		}
		
	}//end if authcheck
			
	// multiuser settings
    if ($config['multiuser'])
    {
        $header['login'] = 'login.php';

        // logged in?
        if (!empty($_COOKIE['PCSusername']) && $_COOKIE['PCSuserid'] != $config['guestid'])
        {
            $header['profile'] = 'profile.php';
            $smarty->assign('loggedin', $_COOKIE['PCSusername']);
			
			//Display list members
			if ($config['clubmenutype'] == 2 && $config['clubpreferenceuser']) {
			$header['showclubs_preference']    = 'show_clubs.php?id='.$config['clubpreferenceuser'];
			$header['showteams_preference']    = 'show_teams.php?id='.$config['clubpreferenceuser'];
			$header['showcalendar_preference'] = 'show_calendarteams.php?id='.$config['clubpreferenceuser'];
			if ($config['clubstats']) $header['statsclubs_preference']   = 'stats_clubs.php?id='.$config['clubpreferenceuser'];
			}
        }
        else
        {
            // make sure anonymous users don't get access to trace for security reasons
            unset($header['trace']);
			if($config['multiuser'] && !$config['denyguest']) {
			$header['newuser'] = 'register.php';
			}
        }
    }


    $smarty->assign('title',	htmlspecialchars($title));
    $smarty->assign('description',	htmlspecialchars($config['site_description']));
    $smarty->assign('keywords',	htmlspecialchars($config['site_keywords']));
    $smarty->assign('header',	$header);
	if ($config['displaystylelist'] && !empty($_COOKIE['PCSusername']) && $_COOKIE['PCSuserid'] != $config['guestid']) {
    	$smarty->assign('stylelist',	getTemplates());
		$smarty->assign('template',	$config['template']);
	}
    $smarty->assign('style',	$config['style']);
    $smarty->assign('sitename',	$config['sitename']);
    $smarty->assign('langcode', $config['language']);
}


/**
 * Assigns the searchresults/browselist to the smarty engine
 *
 * @param   array   indexed array containing the item data
 */
function tpl_list($list)
{
    global $smarty, $config, $showimg, $lang, $countrylng;
	
	for ($i=0; $i < count($list); $i++)
   {
		$list[$i]['imgurl'] = ($config['thumbnail']) ? getThumbnail($list[$i]['imgurl']) : '';
		$list[$i]['country'] = $countrylng[$list[$i]['country']];
		$list[$i]['country_abr'] = $list[$i]['country'];
	}

	
	// enable dynamic columns in list view
    if ($clubslistcolumns) $_SESSION['pcs']['clubslistcolumns'] = $clubslistcolumns;
    $smarty->assign('clubslistcolumns', $_SESSION['pcs']['clubslistcolumns']);
	
	if ($stadiumslistcolumns) $_SESSION['pcs']['stadiumslistcolumns'] = $stadiumslistcolumns;
    $smarty->assign('stadiumslistcolumns', $_SESSION['pcs']['stadiumslistcolumns']);
	
	if ($competitionslistcolumns) $_SESSION['pcs']['competitionslistcolumns'] = $competitionslistcolumns;
    $smarty->assign('competitionslistcolumns', $_SESSION['pcs']['competitionslistcolumns']);
	
	if ($personslistcolumns) $_SESSION['pcs']['personslistcolumns'] = $personslistcolumns;
    $smarty->assign('personslistcolumns', $_SESSION['pcs']['personslistcolumns']);
	
	if ($newslistcolumns) $_SESSION['pcs']['newslistcolumns'] = $newslistcolumns;
    $smarty->assign('newslistcolumns', $_SESSION['pcs']['newslistcolumns']);
	
	if ($gallerylistcolumns) $_SESSION['pcs']['gallerylistcolumns'] = $gallerylistcolumns;
    $smarty->assign('gallerylistcolumns', $_SESSION['pcs']['gallerylistcolumns']);
	
	if ($prizelistcolumns) $_SESSION['pcs']['prizelistcolumns'] = $gallerylistcolumns;
    $smarty->assign('prizelistcolumns', $_SESSION['pcs']['prizelistcolumns']);
	
	$smarty->assign('showimg', $config['showimg']);

	$smarty->assign('list', $list);
	$smarty->assign('countrylng', $countrylng);
}

/**
 * Edit the penalitys for competition to the smarty engine
 */
function tpl_mkbet($betlist)
{
	global $smarty, $config, $lang, $countrylng, $alert;

	$smarty->assign('betlist', $betlist);

}


/**
 * Assigns the clubsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_clubs($club)
{
global $smarty, $config, $lang, $countrylng;

 // imageurl
    $club['imgurl'] = getThumbnail($club['imgurl']);

    // make soft linebreaks:
    $club['name'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $club['name']);
	$club['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $club['longname']);
	
	if ($club['id_stadium']) {
	$mystade   = runSQL('SELECT longname FROM '.TBL_STADIUMS.' WHERE id='.$club['id_stadium']);
	$club['stadium']   = $mystade[0];
	}
	
	
	// break plot
    $club['plot']       = nl2br($club['plot']);
	$club['plot']	    = bbdecode($club['plot']);
	$club['country_abr']	= $club['country'];
	$club['country']	= $countrylng[$club['country']];
	$club['adresse']    = nl2br($club['adresse']);
	
	if ($prizelistcolumns) $_SESSION['pcs']['prizelistcolumns'] = $prizelistcolumns;
    $smarty->assign('prizelistcolumns', $_SESSION['pcs']['prizelistcolumns']);
	$smarty->assign('club', $club);

}


/**
 * Assigns the clubs stats to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_stats_clubs($club)
{
global $smarty, $config, $lang, $countrylng;

 // imageurl
    $club['imgurl'] = getThumbnail($club['imgurl']);

    // make soft linebreaks:
    $club['name'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $club['name']);
	$club['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $club['longname']);
	
	if ($club['id_stadium']) {
	$mystade   = runSQL('SELECT longname FROM '.TBL_STADIUMS.' WHERE id='.$club['id_stadium']);
	$club['stadium']   = $mystade[0];
	}
	
	
	// break plot
	$club['country_abr']	= $club['country'];
	$club['country']	= $countrylng[$club['country']];
	$club['adresse']    = nl2br($club['adresse']);
	
	$smarty->assign('club', $club);

}


/**
 * Assigns the newsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_news($news)
{
global $smarty, $config, $lang, $countrylng;

 // imageurl
    $news['imgurl'] = getThumbnail($news['imgurl']);

    // make soft linebreaks:
    $news['title'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $news['title']);
	
	// break plot
    $news['plot']       = nl2br($news['plot']);
	$news['plot']	    = bbdecode($news['plot']);
	// break plot
    $news['summary']    = nl2br($news['summary']);
	$news['summary']    = bbdecode($news['summary']);
	
	list($mydate, $myhour) = split(' ',$news['pubdate']);
	list($annee, $mois, $jour) = split('/|-',$mydate);
	$news['pubdate']    = $lang['day'.date("w", mktime(0, 0, 0, $mois, $jour, $annee))] . ' ' . $jour . ' ' . $lang['month'.$mois] . ' ' . $annee;
	

	$smarty->assign('news', $news);

}


/**
 * Assigns the clubsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_teams($club)
{
global $smarty, $config, $lang, $countrylng, $postype, $countrylng, $personstype;

 // imageurl
    $club['imgurl'] = getThumbnail($club['imgurl']);

    // make soft linebreaks:
	$club['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $club['longname']);
	
	//$seasonselect = getseasonsbyclub($club['id']);	
    //$smarty->assign('seasonselect', $seasonselect);
	
	$positions = getlngoptions($postype);	
	$smarty->assign('positions', $positions);
	$smarty->assign('postype', $postype);
	$smarty->assign('personstype', $personstype);
	$smarty->assign('club', $club);
	$smarty->assign('countrylng', $countrylng);

}

/**
 * Assigns the clubsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_calendarteams($club, $calendar)
{
global $smarty, $config, $lang, $countrylng, $postype;

	for ($i=0; $i<count($calendar); $i++) {
	
	list($mydate, $myhour) = split(' ',$calendar[$i]['date_day']);
	list($annee, $mois, $jour) = split('/|-',$mydate);
	$calendar[$i]['date_day'] = $jour . ' ' . $lang['month'.$mois] . ' ' . $annee;
	$calendar[$i]['dateday'] = mktime(0,0,0,$mois,$jour,$annee,0);
	$calendar[$i]['date_hour'] = $myhour;
	
	$calendar[$i]['plot']     = nl2br($calendar[$i]['plot']);
	$calendar[$i]['plot']	  = bbdecode($calendar[$i]['plot']);
	}

 	// imageurl
    $club['imgurl'] = getThumbnail($club['imgurl']);
    // make soft linebreaks:
	$club['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $club['longname']);
	
	$seasonselect = getseasonsbyclub($club['id']);	
    $smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('calendar', $calendar);
	$smarty->assign('club', $club);

}

/**
 * Assigns the clubsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_stadiums($stadium)
{
global $smarty, $config, $lang, $countrylng;

 // imageurl
    $stadium['imgurl'] = getThumbnail($stadium['imgurl']);

    // make soft linebreaks:
	$stadium['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $stadium['longname']);
	
	// break plot
    $stadium['plot']       = nl2br($stadium['plot']);
	$stadium['plot']	   = bbdecode($stadium['plot']);
	$stadium['country'] 	= $countrylng[$stadium['country']];
	$stadium['country_abr'] 	= $stadium['country'];
	$stadium['adresse']    = nl2br($stadium['adresse']);
	

	$smarty->assign('stadium', $stadium);

}


/**
 * Assigns the clubsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_categories($categorie, $list)
{
global $smarty, $config, $lang, $countrylng, $compettype, $competrange;

    // imageurl
    $categorie['imgurl'] = getThumbnail($categorie['imgurl']);

    // make soft linebreaks:
	$categorie['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $categorie['longname']);
	
	// break plot
    $categorie['plot']        = nl2br($categorie['plot']);
	$categorie['plot']	    = bbdecode($categorie['plot']);
	$categorie['country'] 	= $countrylng[$categorie['country']];
	$categorie['country_abr'] 	= $categorie['country'];
	

	$smarty->assign('categorie', $categorie);
	$smarty->assign('haveseason', $seasonselect[0]);
	if ($prizelistcolumns) $_SESSION['pcs']['prizelistcolumns'] = $prizelistcolumns;
    $smarty->assign('prizelistcolumns', $_SESSION['pcs']['prizelistcolumns']);

	
}


/**
 * Assigns the competitionsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_competitions($competition, $subcompet,$season)
{
global $smarty, $config, $lang, $countrylng, $compettype, $competrange;

    // imageurl
    $competition['imgurl'] = getThumbnail($competition['imgurl']);

    // make soft linebreaks:
	$competition['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $competition['longname']);
	
	// break plot
    $competition['plot']        = nl2br($competition['plot']);
	$competition['plot']	    = bbdecode($competition['plot']);
	$competition['country'] 	= $countrylng[$competition['country']];
	$competition['country_abr'] 	= $competition['country'];
	
	if ($competition['range'] == 3) {
	$smarty->assign('nonextyear', $nonextyear);
	}
	
	$seasonselect = getseasonsbycompet($competition['id']);
	$smarty->assign('seasonselect', $seasonselect);
	
	$interselect =  array(0 => $lang['no'], 1 => $lang['yes']);	
	$smarty->assign('compettype', $compettype);
	$smarty->assign('competrange', $competrange);
	
	$smarty->assign('competition', $competition);
	$smarty->assign('haveseason', $seasonselect[0]);

	if ($subcompet) {	
		for ($i=0; $i<count($subcompet); $i++) {
		$table = gettablebycompet($subcompet[$i]['id'], $season, 0);
			if ($table) {
			$sublist[$i]['id'] = $subcompet[$i]['id'];
			$sublist[$i]['shortname'] = $subcompet[$i]['shortname'];
			$sublist[$i]['longname'] = $subcompet[$i]['longname'];
			$sublist[$i]['table'] = $table;
			}
		}
		$smarty->assign('sublist', $sublist);
		if ($prizelistcolumns) $_SESSION['pcs']['prizelistcolumns'] = $prizelistcolumns;
    	$smarty->assign('prizelistcolumns', $_SESSION['pcs']['prizelistcolumns']);
	}

}

/**
 * Assigns the clubsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_stats_competitions($competition,$season)
{
global $smarty, $config, $lang, $countrylng, $compettype, $competrange;

    // imageurl
    $competition['imgurl'] = getThumbnail($competition['imgurl']);

    // make soft linebreaks:
	$competition['longname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $competition['longname']);
	
	// break plot
    $competition['plot']        = nl2br($competition['plot']);
	$competition['plot']	    = bbdecode($competition['plot']);
	$competition['country'] 	= $countrylng[$competition['country']];
	$competition['country_abr'] 	= $competition['country'];
	
	if ($competition['range'] == 3) {
	$smarty->assign('nonextyear', $nonextyear);
	}
	
	$seasonselect = getseasonsbycompet($competition['id']);
	$smarty->assign('seasonselect', $seasonselect);
	
	$interselect =  array(0 => $lang['no'], 1 => $lang['yes']);	
	$smarty->assign('compettype', $compettype);
	$smarty->assign('competrange', $competrange);
	
	$smarty->assign('competition', $competition);
	$smarty->assign('haveseason', $seasonselect[0]);

}



/**
 * Assigns the classementsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_tables($competition)
{
global $smarty, $config, $lang, $countrylng;

	$seasonselect = getseasonsbycompet($competition['id']);
	
    $smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('haveseason', $seasonselect[0]);
	$smarty->assign('competition', $competition);

}

/**
 * Assigns the calendarinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_matchs($matchs,$competition)
{
global $smarty, $config, $lang, $countrylng;

	for ($i=0; $i<count($matchs); $i++) {
		// break plot
    	$matchs[$i]['plot']     = nl2br($matchs[$i]['plot']);
		$matchs[$i]['plot']	    = bbdecode($matchs[$i]['plot']);

		$domclub = runSQL('SELECT shortname FROM '.TBL_CLUBS.' WHERE id='.$matchs[$i]['id_candidate_dom']);
		$matchs[$i]['domclubname']  = $domclub[0]['shortname'];
		$extclub = runSQL('SELECT shortname FROM '.TBL_CLUBS.' WHERE id='.$matchs[$i]['id_candidate_ext']);
		$matchs[$i]['extclubname']  = $extclub[0]['shortname'];
	}
	
	list($mydate, $myhour) = split(' ',$matchs[0]['date_day']);
	list($annee, $mois, $jour) = split('/|-',$mydate);
	$seasonselect = getseasonsbycompet($competition['id']);
	$smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('matchs', $matchs);
	$smarty->assign('dateday', $lang['day'.date("w", mktime(0, 0, 0, $mois, $jour, $annee))] . ' ' . $jour . ' ' . $lang['month'.$mois] . ' ' . $annee);
	$smarty->assign('haveseason', $seasonselect[0]);
}


/**
 * Assigns the calendarinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_match($matchs,$competition,$type)
{
global $smarty, $config, $lang, $countrylng, $competday, $postype;

		// break plot
    	$matchs['plot']     = nl2br($matchs['plot']);
		$matchs['plot']	    = bbdecode($matchs['plot']);


	if ($type == 1) {
	$matchs['day'] = $competday[$matchs['day']];
	}
	
	list($mydate, $myhour) = split(' ',$matchs['date_day']);
	list($annee, $mois, $jour) = split('/|-',$mydate);
	$seasonselect = getseasonsbycompet($competition);
	$smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('matchs', $matchs);
	$smarty->assign('postype', $postype);
	$smarty->assign('dateday', $lang['day'.date("w", mktime(0, 0, 0, $mois, $jour, $annee))] . ' ' . $jour . ' ' . $lang['month'.$mois] . ' ' . $annee);
	$smarty->assign('haveseason', $seasonselect[0]);
}


/**
 * Assigns the calendarinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_stats($matchs,$competition)
{
global $smarty, $config, $lang, $countrylng;

		// break plot
    	$matchs['plot']     = nl2br($matchs['plot']);
		$matchs['plot']	    = bbdecode($matchs['plot']);

	
	list($mydate, $myhour) = split(' ',$matchs['date_day']);
	list($annee, $mois, $jour) = split('/|-',$mydate);
	$seasonselect = getseasonsbycompet($matchs['id_compet']);
	$smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('matchs', $matchs);
	$smarty->assign('dateday', $lang['day'.date("w", mktime(0, 0, 0, $mois, $jour, $annee))] . ' ' . $jour . ' ' . $lang['month'.$mois] . ' ' . $annee);
	$smarty->assign('haveseason', $seasonselect[0]);
}





/**
 * Assigns the personsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_persons($person)
{
global $smarty, $config, $lang, $countrylng, $personstype, $postype;

 	// imageurl
    $person['imgurl'] = getThumbnail($person['imgurl']);

    // make soft linebreaks:
	$person['lastname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $person['lastname']);
	$person['firstname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $person['firstname']);
	
	if ($person['international']) {$person['international'] = $lang[yes];}
	else {$person['international'] = $lang[no];}
	
	// break plot
    $person['plot']       = nl2br($person['plot']);
	$person['plot']	      = bbdecode($person['plot']);
	$person['country']    = $countrylng[$person['country']];
	$person['country_abr']    = $person['country'];
	$person['adresse']    = nl2br($person['adresse']);
	//Define astro sign
	$person['astrosign'] = $lang[out_astro($person['birthday'])];
	//Define bithday date
	$person['birthday'] = out_date($person['birthday'], 2);
	$person['deathday'] = out_date($person['deathday'], 2);

	$smarty->assign('postype', $postype);
	$smarty->assign('person', $person);
	
	
	$smarty->assign('playerstats', $config['playerstats']);
	if ($person['type'] = 1 ) {
		
	
		if ($config['playerstats']) {
			$carrier = runSQL('SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.imgurl, '.TBL_CLUBS.'.country, '.TBL_TEAMS.'.id_club, '.TBL_CLUBS.'.shortname, '.TBL_SEASONS.'.season, '.TBL_TEAMS.'.id_season,
			'.TBL_TEAMS.'.start, '.TBL_TEAMS.'.end, '.TBL_TEAMS.'.games, '.TBL_TEAMS.'.minutes, '.TBL_TEAMS.'.goals, '.TBL_TEAMS.'.ycards, '.TBL_TEAMS.'.rcards
            FROM '.TBL_TEAMS.'
			JOIN '.TBL_CLUBS.' ON '.TBL_TEAMS.'.id_club = '.TBL_CLUBS.'.id
            JOIN '.TBL_SEASONS.' ON '.TBL_TEAMS.'.id_season = '.TBL_SEASONS.'.id
            WHERE '.TBL_TEAMS.'.id_person = '.$person['id'].' AND '.TBL_TEAMS.'.id_season != '.$config['seasonfilterdefault'].'
			ORDER BY '.TBL_SEASONS.'.season DESC');
		}
		else  {
			$carrier = runSQL('SELECT '.TBL_SEASONS.'.season, '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.imgurl 
			FROM '.TBL_TEAMS.'
			JOIN '.TBL_SEASONS.' ON '.TBL_SEASONS.'.id = '.TBL_TEAMS.'.id_season
			JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_TEAMS.'.id_club
			WHERE '.TBL_TEAMS.'.id_person='.$person['id'].' ORDER BY '.TBL_SEASONS.'.season DESC');
		}
		$smarty->assign('carrier', $carrier);
		if ($clubslistcolumns) $_SESSION['pcs']['clubslistcolumns'] = $clubslistcolumns;
    	$smarty->assign('clubslistcolumns', $_SESSION['pcs']['clubslistcolumns']);
	
	}
	

}

/**
 * Assigns the personsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_show_members($member)
{
global $smarty, $config, $lang, $countrylng, $personstype, $postype;

 // imageurl
    $member['avatar'] = getThumbnail($member['avatar']);

    // make soft linebreaks:
	$member['name'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $member['name']);
	
	// break plot
    $member['plot']       = nl2br($member['plot']);
	$member['plot']	      = bbdecode($member['plot']);
	$member['country']    = $countrylng[$member['country']];
	$member['country_abr']    = $member['country'];
	$member['adresse']    = nl2br($member['adresse']);
	//Define astro sign
	$member['astrosign'] = $lang[out_astro($member['birthday'])];
	//Define bithday date
	$member['birthday'] = out_date($member['birthday'], 2);
	

	$smarty->assign('memberdata', $member);

}

/**
 * Assigns the personsinfos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_perm_members($member)
{
global $smarty, $config, $lang, $countrylng, $personstype, $postype;

 // imageurl
    $member['avatar'] = getThumbnail($member['avatar']);

    // make soft linebreaks:
	$member['name'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $member['name']);
	
	// break plot
    $member['plot']       = nl2br($member['plot']);
	$member['plot']	      = bbdecode($member['plot']);
	$member['country']    = $countrylng[$member['country']];
	$member['country_abr']    = $member['country'];
	$member['adresse']    = nl2br($member['adresse']);
	//Define astro sign
	$member['astrosign'] = $lang[out_astro($member['birthday'])];
	//Define bithday date
	$member['birthday'] = out_date($member['birthday'], 2);
	

	$smarty->assign('member', $member);

}

/**
 * Edit the clubsinfos to the smarty engine
 */
function tpl_edit_caracs($caracs)
{
	global $smarty, $config, $lang, $caractype, $caracgenre;

	

	// create a form ready quoted version for each value
	foreach (array_keys($caracs[0]) as $key)
    {
		$caracs[0]['q_'.$key] = formvar($caracs[0][$key]);
	}

	$smarty->assign('caractype', $caractype);
	$smarty->assign('caracgenre', $caracgenre);
	$smarty->assign('caracs', $caracs[0]);

}


/**
 * Edit the clubsinfos to the smarty engine
 */
function tpl_edit_club($club)
{
	global $smarty, $config, $lang, $countrylng;

	// create a form ready quoted version for each value
	foreach (array_keys($club[0]) as $key)
    {
		$club[0]['q_'.$key] = formvar($club[0][$key]);
	}
	
	$stadiumselect   = getstadium();
	$presidentselect = getpresident();

	// get drilldown url for visit link
	//$club[0]['imdbID'];

	$smarty->assign('lookup', array('0' => $lang['radio_look_ignore'],
							        '1' => $lang['radio_look_lookup'],
							        '2' => $lang['radio_look_overwrite']));
	$countryselect = getlngoptions($countrylng);
	$smarty->assign('countryselect', $countryselect);
	$smarty->assign('stadiumselect', $stadiumselect);
	$smarty->assign('presidentselect', $presidentselect);
	$smarty->assign('club', $club[0]);

}

/**
 * Edit the clubsinfos to the smarty engine
 */
function tpl_edit_news($news)
{
	global $smarty, $config, $lang, $countrylng;

	// create a form ready quoted version for each value
	foreach (array_keys($news[0]) as $key)
    {
		$news[0]['q_'.$key] = formvar($news[0][$key]);
	}
	$news[0]['q_pubdate'] = getfrdate($news[0]['q_pubdate']);

	
	$categoryselect = getcategorynews();
	$languageselect = getlanguages();
	$smarty->assign('languageselect', $languageselect);
	$smarty->assign('categoryselect', $categoryselect);
	$smarty->assign('news', $news[0]);

}

/**
 * Edit the stadiumsinfos to the smarty engine
 */
function tpl_edit_stadium($stadium)
{
	global $smarty, $config, $lang, $countrylng;

	// create a form ready quoted version for each value
	foreach (array_keys($stadium[0]) as $key)
    {
		$stadium[0]['q_'.$key] = formvar($stadium[0][$key]);
	}

	$smarty->assign('lookup', array('0' => $lang['radio_look_ignore'],
							        '1' => $lang['radio_look_lookup'],
							        '2' => $lang['radio_look_overwrite']));
	$countryselect = getlngoptions($countrylng);
	$smarty->assign('countryselect', $countryselect);
	$smarty->assign('stadium', $stadium[0]);

}

/**
 * Edit the categoriesinfos to the smarty engine
 */
function tpl_edit_categories($categorie)
{
	global $smarty, $config, $lang, $countrylng;

	// create a form ready quoted version for each value
	foreach (array_keys($categorie[0]) as $key)
    {
		$categorie[0]['q_'.$key] = formvar($categorie[0][$key]);
	}

	$countryselect = getlngoptions($countrylng);
	$smarty->assign('countryselect', $countryselect);
	//$categoryselect = getcategories();
	$categoryselect = get_subcat_data(0,'',0,0);
	$smarty->assign('categoryselect', $categoryselect);
	$smarty->assign('categorie', $categorie[0]);
}

/**
 * Manage the categories to the smarty engine
 */
function tpl_manage_categories($categories)
{
	global $smarty, $config, $lang;

	if (is_file('images/'.$config[template].'/movedown.gif')) {$url_movedown = 'images/'.$config[template].'/movedown.gif';}
	else {$url_movedown = 'images/movedown.gif';}

	if (is_file('images/'.$config[template].'/moveup.gif')) {$url_moveup = 'images/'.$config[template].'/moveup.gif';}
	else {$url_moveup = 'images/moveup.gif';}

	if (is_file('images/'.$config[template].'/delete.gif')) {$url_delete = 'images/'.$config[template].'/delete.gif';}
	else {$url_delete = 'images/delete.gif';}

	if (is_file('images/'.$config[template].'/edit.gif')) {$url_edit = 'images/'.$config[template].'/edit.gif';}
	else {$url_edit = 'images/edit.gif';}



	$smarty->assign('url_movedown', $url_movedown);
	$smarty->assign('url_moveup', $url_moveup);
	$smarty->assign('url_edit', $url_edit);
	$smarty->assign('url_delete', $url_delete);
	

	$categoryselect = getcategories();
	$smarty->assign('categoryselect', $categoryselect);
	$smarty->assign('categories', $categories);
}

/**
 * Manage the categories to the smarty engine
 */
function tpl_manage_competitions($competitions)
{
	global $smarty, $config, $lang;

	if (is_file('images/'.$config[template].'/movedown.gif')) {$url_movedown = 'images/'.$config[template].'/movedown.gif';}
	else {$url_movedown = 'images/movedown.gif';}

	if (is_file('images/'.$config[template].'/moveup.gif')) {$url_moveup = 'images/'.$config[template].'/moveup.gif';}
	else {$url_moveup = 'images/moveup.gif';}

	if (is_file('images/'.$config[template].'/delete.gif')) {$url_delete = 'images/'.$config[template].'/delete.gif';}
	else {$url_delete = 'images/delete.gif';}

	if (is_file('images/'.$config[template].'/edit.gif')) {$url_edit = 'images/'.$config[template].'/edit.gif';}
	else {$url_edit = 'images/edit.gif';}



	$smarty->assign('url_movedown', $url_movedown);
	$smarty->assign('url_moveup', $url_moveup);
	$smarty->assign('url_edit', $url_edit);
	$smarty->assign('url_delete', $url_delete);
	

	//$categoryselect = getcategories();
	//$smarty->assign('categoryselect', $categoryselect);
	$smarty->assign('competitions', $competitions);
}


/**
 * Edit the competitionsinfos to the smarty engine
 */
function tpl_edit_competition($competition)
{
	global $smarty, $config, $lang, $countrylng, $compettype, $competrange;

	// create a form ready quoted version for each value
	foreach (array_keys($competition[0]) as $key)
    {
		$competition[0]['q_'.$key] = formvar($competition[0][$key]);
	}

	$countryselect = getlngoptions($countrylng);
	//$categoryselect = getcategories();
	$categoryselect = get_subcat_data(0, '',0,0);
	$subcompetselect = get_subcompet_data(0, '',0,0);

	$smarty->assign('countryselect', $countryselect);
	$smarty->assign('categoryselect', $categoryselect);
	$smarty->assign('subcompetselect', $subcompetselect);
	$smarty->assign('competition', $competition[0]);
	$smarty->assign('compettype', $compettype);
	$smarty->assign('competrange', $competrange);

}


/**
 * Edit the personsinfos to the smarty engine
 */
function tpl_edit_person($person)
{
	global $smarty, $config, $lang, $countrylng, $personstype, $postype;

	// create a form ready quoted version for each value
	foreach (array_keys($person[0]) as $key)
    {
		$person[0]['q_'.$key] = formvar($person[0][$key]);
	}
	$person[0]['q_birthday'] = getfrdate($person[0]['q_birthday']);
	$person[0]['q_deathday'] = getfrdate($person[0]['q_deathday']);

	$countryselect = getlngoptions($countrylng);
	$smarty->assign('countryselect', $countryselect);



	// imageurl
    $person[0]['imgurl'] = getThumbnail($person[0]['imgurl']);

    // make soft linebreaks:
	$person[0]['lastname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $person[0]['lastname']);
	$person[0]['firstname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $person[0]['firstname']);
	
	if ($person[0]['international']) {$person['international'] = $lang[yes];}
	else {$person[0]['international'] = $lang[no];}
	
	// break plot
    $person[0]['plot']       = nl2br($person[0]['plot']);
	$person[0]['plot']	      = bbdecode($person[0]['plot']);
	$person[0]['country']    = $countrylng[$person[0]['country']];
	$person[0]['adresse']    = nl2br($person[0]['adresse']);
	//Define astro sign
	$person[0]['astrosign'] = $lang[out_astro($person[0]['birthday'])];
	//Define bithday date
	$person[0]['birthday'] = out_date($person[0]['birthday'], 2);
	

	
	$smarty->assign('postype', $postype);

	$smarty->assign('person', $person[0]);
	
	$types = getlngoptions($personstype);
	
	$smarty->assign('personstype', $types);
	
	$positions = getlngoptions($postype);	
	$smarty->assign('positions', $positions);

	$smarty->assign('playerstats', $config['playerstats']);
	
	if ($person[0]['id']) {	
	$allclubs= runSQL('SELECT id, shortname FROM '.TBL_CLUBS.' WHERE nationalteam != 1 ORDER BY shortname ASC');
	$smarty->assign('allclubs', $allclubs);
	
	$mycarrier = runSQL('SELECT id_season, id_club FROM '.TBL_TEAMS.' WHERE id_person='.$person[0]['id']);
		foreach ($mycarrier as $data)
		{
		  $carrier[$data['id_season']]  = $data['id_club'];
		}
	$smarty->assign('carrier', $carrier);
	}
}


/**
 * Edit the personsinfos to the smarty engine
 */
function tpl_edit_statsperson($stats, $person)
{
	global $smarty, $config, $lang,  $countrylng, $postype;

	// create a form ready quoted version for each value
	for ($i=0; $i<count($stats); $i++) {
		$stats[$i]['start'] = getfrdate($stats[$i]['start']);
		$stats[$i]['end']   = getfrdate($stats[$i]['end']);
	}


	$smarty->assign('stats', $stats);


	// imageurl
    $person[0]['imgurl'] = getThumbnail($person[0]['imgurl']);

    // make soft linebreaks:
	$person[0]['lastname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $person[0]['lastname']);
	$person[0]['firstname'] = preg_replace('/(_|\.|-)/', '$1<wbr />', $person[0]['firstname']);
	
	if ($person[0]['international']) {$person['international'] = $lang[yes];}
	else {$person[0]['international'] = $lang[no];}
	
	// break plot
    $person[0]['plot']       = nl2br($person[0]['plot']);
	$person[0]['plot']	      = bbdecode($person[0]['plot']);
	$person[0]['country']    = $countrylng[$person[0]['country']];
	$person[0]['adresse']    = nl2br($person[0]['adresse']);
	//Define astro sign
	$person[0]['astrosign'] = $lang[out_astro($person[0]['birthday'])];
	//Define bithday date
	$person[0]['birthday'] = out_date($person[0]['birthday'], 2);
	
	$smarty->assign('person', $person[0]);
	
	$smarty->assign('postype', $postype);
	
}


/**
 * Edit the candidatesinfos to the smarty engine
 */
function tpl_edit_candidate($candidate, $competdata)
{
	global $smarty, $config, $lang, $countrylng, $alert, $compettaborder;



	if ($competdata['range'] == 1) {$WHERES = 'WHERE '.TBL_CLUBS.'.country = \''.$competdata['country'].'\'';}
	else if ($competdata['range'] == 3) {$WHERES = 'WHERE '.TBL_CLUBS.'.nationalteam = 1';}
	else {$WHERES = 'WHERE '.TBL_CLUBS.'.nationalteam != 1';}
	
	$not_in="";
	foreach($candidate as $club) {
	if ($not_in) {$not_in.=",";}
	if ($club['id']) {$not_in.=$club['id'];}
	}
	if ($not_in) {$not_in = ' AND '.TBL_CLUBS.'.id NOT IN ('.$not_in.')';}
	
	
	$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.country FROM '.TBL_CLUBS.' '.$WHERES.' '.$not_in.' ORDER BY '.TBL_CLUBS.'.shortname';
	$clubs = runSQL($SELECT);
	
	$SELECT = 'SELECT '.TBL_SEASONS.'.id, '.TBL_SEASONS.'.season FROM '.TBL_SEASONS.' ORDER BY '.TBL_SEASONS.'.season ASC';
	$seasons = runSQL($SELECT);
	
	

	$smarty->assign('candidates', $candidate);
	$smarty->assign('clubs', $clubs);
	$smarty->assign('seasons', $seasons);
	$smarty->assign('compettaborder', $compettaborder);
}


/**
 * Edit the penalitys for competition to the smarty engine
 */
function tpl_edit_penality($candidate)
{
	global $smarty, $config, $lang, $countrylng, $alert;

	$smarty->assign('candidates', $candidate);

}


/**
 * Edit the penalitys for competition to the smarty engine
 */
function tpl_edit_betlist($betlist)
{
	global $smarty, $config, $lang;

	$smarty->assign('betlist', $betlist);

}

/**
 * Edit the penalitys for competition to the smarty engine
 */
function tpl_edit_bettable($bettable)
{
	global $smarty, $config, $lang;

	$bettable['date_deb'] = getfrdate($bettable['date_deb']);
	$bettable['date_fin'] = getfrdate($bettable['date_fin']);
	$bettable['date_paybet'] = $bettable['date_fin_bet'];

	$mydate  = getfrdatehour($bettable['date_fin_bet']);
	$bettable['date_fin_bet'] = $mydate['myday'];
	$bettable['myhour_fin_bet']  = $mydate['myhour'];
	$smarty->assign('bettable', $bettable);

}

/**
 * Edit the prizelist for competition to the smarty engine
 */
function tpl_edit_prizelist($list)
{
	global $smarty, $config, $lang, $countrylng, $alert;

	for ($a=0; $a<count($list); $a++) {
	$plist[$list[$a]['id_season']]['id'] = $list[$a]['id_club'];
	}
	$smarty->assign('list', $plist);
	$smarty->assign('competitionslistcolumns', $_SESSION['pcs']['competitionslistcolumns']);

}

/**
 * Edit the penalitys for competition to the smarty engine
 */
function tpl_edit_team($players, $myclub)
{
	global $smarty, $config, $lang, $countrylng;


	//$seasonselect = getseasonsbyclub($myclub);	
    //$smarty->assign('seasonselect', $seasonselect);

	$smarty->assign('players', $players);

}

/**
 * Edit the penalitys for competition to the smarty engine
 */
function tpl_edit_day($days)
{
	global $smarty, $config, $lang, $countrylng;
	
	for ($i=0; $i<count($days); $i++) {
		$days[$i]['date_day'] = getfrdate($days[$i]['date_day']);
	}

	$smarty->assign('lookup', array('0' => $lang['radio_look_ignore'],
							        '1' => $lang['radio_look_lookup'],
							        '2' => $lang['radio_look_overwrite']));
	$smarty->assign('days', $days);
	
	//$smarty->assign('seasons', $seasons);
}

/**
 * EDIT the lineup infos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_edit_lineup($res)
{
global $smarty;
	
	$smarty->assign('clubs', array($res[0]['id_candidate_dom'],$res[0]['id_candidate_ext']));
	$smarty->assign('clubs', array(0 => array ('id' => $res[0]['id_candidate_dom'], 'name' => $res[0]['clubdom']),  1 => array ('id' => $res[0]['id_candidate_ext'], 'name' => $res[0]['clubext'])));
	$seasonselect = getseasonsbycompet($res[0]['id_compet']);
	$smarty->assign('seasons', $seasonselect);
	$smarty->assign('res', $res[0]);
		
}


/**
 * EDIT the matchs infos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_edit_matchs($matchs,$competition)
{
global $smarty, $config, $lang, $countrylng, $weatherlng;

	for ($i=0; $i<count($matchs); $i++) {
		$mydate  = getfrdatehour($matchs[$i]['date_day']);
		$matchs[$i]['matchdate'] = $mydate['myday'];
		$matchs[$i]['matchhour']  = $mydate['myhour'];
		if (!$matchs[$i]['id_stadium']) {
			$matchs[$i]['id_stadium'] = $matchs[$i]['domstadium'];
		}
		if ($matchs[$i]['dom_owner_id']) {
			$owners = split(',', $matchs[$i]['dom_owner_id']);
				foreach($owners as $owner) {
					if($owner == $_COOKIE['PCSuserid']) {
						$matchs[$i]['dom_validable'] = 1;
					}
				}
		}
		if ($matchs[$i]['ext_owner_id']) {
			$owners = split(',', $matchs[$i]['ext_owner_id']);
				foreach($owners as $owner) {
					if($owner == $_COOKIE['PCSuserid']) {
						$matchs[$i]['ext_validable'] = 1;
					}
				}
		}
	}

	$seasonselect = getseasonsbycompet($competition);
	$refereeselect = getreferee();
	$stadiumselect = getstadium();
	$weatherselect = getlngoptions($weatherlng);
	
	list($mydate, $myhour) = split(' ',$matchs[0]['date_day']);
	list($annee, $mois, $jour) = split('/|-',$mydate);
	$smarty->assign('dateday', $lang['day'.date("w", mktime(0, 0, 0, $mois, $jour, $annee))] . ' ' . $jour . ' ' . $lang['month'.$mois] . ' ' . $annee);
	
	$smarty->assign('seasons', $seasonselect);
	$smarty->assign('editable', $editable);
	$smarty->assign('refereeselect', $refereeselect);
	$smarty->assign('weatherselect', $weatherselect);	
	$smarty->assign('stadiumselect', $stadiumselect);	
	$smarty->assign('matchs', $matchs);
	$smarty->assign('haveseason', $seasonselect[0]);
}


/**
 * EDIT the goals infos to the smarty engine
 *
 * @param   array   associative array containing the item data
 */
function tpl_edit_goals($matchs,$competition,$season,$match)
{
global $smarty, $config, $lang, $countrylng, $weatherlng;

	if ($match) {
		$matchs[0]['teamdom'] = getteambyclub($matchs[0]['id_candidate_dom'], $season);
		$matchs[0]['teamext'] = getteambyclub($matchs[0]['id_candidate_ext'], $season);

		if (!$matchs[0]['id_stadium']) {
		$mystadium = runSQL('SELECT id_stadium FROM '.TBL_CLUBS.' WHERE id='.$matchs[0]['id_candidate_dom']);
		$matchs[0]['id_stadium'] = $mystadium[0]['id_stadium'];
		}
				
		$mydate  = getfrdatehour($matchs[0]['date_day']);
		$matchs[0]['matchdate'] = $mydate['myday'];
		$matchs[0]['matchhour']  = $mydate['myhour'];
		
		$refereeselect = getreferee();
		$stadiumselect = getstadium();
		$weatherselect = getlngoptions($weatherlng);

		
		
		$smarty->assign('refereeselect', $refereeselect);
		$smarty->assign('weatherselect', $weatherselect);	
		$smarty->assign('stadiumselect', $stadiumselect);
	
		$smarty->assign('match', $match);
		
	}

	for ($i=0; $i<count($matchs); $i++) {
		$matchs[$i]['goalsdom'] = runSQL('SELECT '.TBL_GOALS.'.id, '.TBL_GOALS.'.id_person, '.TBL_PERSONS.'.lastname as lastname, '.TBL_PERSONS.'.firstname as firstname, '.TBL_GOALS.'.goal_min, '.TBL_GOALS.'.goal_csc, '.TBL_GOALS.'.goal_pen FROM '.TBL_GOALS.' JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_GOALS.'.id_person WHERE id_match ='.$matchs[$i]['id'].' AND id_club='.$matchs[$i]['id_candidate_dom'].' ORDER BY goal_min'); 
		$matchs[$i]['goalsext'] = runSQL('SELECT '.TBL_GOALS.'.id, '.TBL_GOALS.'.id_person, '.TBL_PERSONS.'.lastname as lastname, '.TBL_PERSONS.'.firstname as firstname, '.TBL_GOALS.'.goal_min, '.TBL_GOALS.'.goal_csc, '.TBL_GOALS.'.goal_pen FROM '.TBL_GOALS.' JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_GOALS.'.id_person WHERE id_match ='.$matchs[$i]['id'].' AND id_club='.$matchs[$i]['id_candidate_ext'].' ORDER BY goal_min'); 
	
		$matchs[$i]['cardsdom'] = runSQL('SELECT '.TBL_CARDS.'.id, '.TBL_CARDS.'.id_person, '.TBL_PERSONS.'.lastname as lastname, '.TBL_PERSONS.'.firstname as firstname, '.TBL_CARDS.'.card_min, '.TBL_CARDS.'.card_yellow, '.TBL_CARDS.'.card_red FROM '.TBL_CARDS.' JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_CARDS.'.id_person WHERE id_match ='.$matchs[$i]['id'].' AND id_club='.$matchs[$i]['id_candidate_dom'].' ORDER BY card_min'); 
		$matchs[$i]['cardsext'] = runSQL('SELECT '.TBL_CARDS.'.id, '.TBL_CARDS.'.id_person, '.TBL_PERSONS.'.lastname as lastname, '.TBL_PERSONS.'.firstname as firstname, '.TBL_CARDS.'.card_min, '.TBL_CARDS.'.card_yellow, '.TBL_CARDS.'.card_red FROM '.TBL_CARDS.' JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_CARDS.'.id_person WHERE id_match ='.$matchs[$i]['id'].' AND id_club='.$matchs[$i]['id_candidate_ext'].' ORDER BY card_min'); 
	
		$matchs[$i]['subsdom'] = runSQL('SELECT '.TBL_SUBS.'.id, '.TBL_SUBS.'.id_person_in, '.TBL_SUBS.'.id_person_out, '.TBL_SUBS.'.subs_min FROM '.TBL_SUBS.' WHERE id_match ='.$matchs[$i]['id'].' AND id_club='.$matchs[$i]['id_candidate_dom'].' ORDER BY subs_min'); 
		$matchs[$i]['subsext'] = runSQL('SELECT '.TBL_SUBS.'.id, '.TBL_SUBS.'.id_person_in, '.TBL_SUBS.'.id_person_out, '.TBL_SUBS.'.subs_min FROM '.TBL_SUBS.' WHERE id_match ='.$matchs[$i]['id'].' AND id_club='.$matchs[$i]['id_candidate_ext'].' ORDER BY subs_min'); 
	}


	$seasonselect = getseasonsbycompet($competition);	
	$smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('matchs', $matchs);
	$smarty->assign('haveseason', $seasonselect[0]);
}


function tpl_filters_persons($filter, $type, $countryfilter)
{
    global $smarty, $lang, $personstype, $countrylng;
    global $filter_expr;

    // build filter array
    foreach ($filter_expr as $flt => $regex)
    {
        $filters[$flt] = ($flt == "NUM") ? "#" : $flt;
    }
    $filters['all']	    = $lang['radio_all'];
    $smarty->assign('filters',  $filters);
    $smarty->assign('filter',   $filter);
	$smarty->assign('type',   $type);
	
	$allcountryfilter = getcountryfrompersons($type);
	$smarty->assign('countryfilter', out_selectcountry('countryfilter', $countryfilter, $allcountryfilter));
    
	// enable dynamic columns in list view
    $smarty->assign('personslistcolumns',$_SESSION['pcs']['personslistcolumns']);
}

function tpl_filters_clubs($filter, $countryfilter, $nationalteamfilter)
{
    global $smarty, $lang, $countrylng;
    global $filter_expr;

    // build filter array
    foreach ($filter_expr as $flt => $regex)
    {
        $filters[$flt] = ($flt == "NUM") ? "#" : $flt;
    }
    $filters['all']	    = $lang['radio_all'];
	
	$countrys = getcountryfromclubs($nationalteamfilter);
	
	
	$smarty->assign('countryfilter', out_selectcountry('countryfilter', $countryfilter, $countrys));
    $smarty->assign('nationalteamfilter',  $nationalteamfilter);
    $smarty->assign('filters',  $filters);
    $smarty->assign('filter',   $filter);
	$smarty->assign('type',   $type);
	
	// enable dynamic columns in list view
    $smarty->assign('clubslistcolumns',$_SESSION['pcs']['clubslistcolumns']);
}

function tpl_filters_categories($filter, $countryfilter, $range, $type)
{
    global $smarty, $lang, $countrylng, $compettype, $competrange;
    global $filter_expr;

    // build filter array
    foreach ($filter_expr as $flt => $regex)
    {
        $filters[$flt] = ($flt == "NUM") ? "#" : $flt;
    }
    $filters['all']	    = $lang['radio_all'];
	
	$countrys = getcountryfromcategories();
	
	$smarty->assign('countryfilter', out_selectcountry('countryfilter', $countryfilter, $countrys));
	$smarty->assign('filters',  $filters);
    $smarty->assign('filter',   $filter);
	
	
	// enable dynamic columns in list view
    $smarty->assign('competitionslistcolumns',$_SESSION['pcs']['competitionslistcolumns']);
}

function tpl_filters_competitions($filter, $countryfilter, $range, $type)
{
    global $smarty, $lang, $countrylng, $compettype, $competrange;
    global $filter_expr;

    // build filter array
    foreach ($filter_expr as $flt => $regex)
    {
        $filters[$flt] = ($flt == "NUM") ? "#" : $flt;
    }
    $filters['all']	    = $lang['radio_all'];
	
	$countrys = getcountryfromcompetitions();
	
	$smarty->assign('countryfilter', out_selectcountry('countryfilter', $countryfilter, $countrys));
	$smarty->assign('type',  $type);
    
	$compettype = array_merge($lang['all'], $compettype);
	$smarty->assign('compettype', $compettype);
	$smarty->assign('type', $type);
	
    $compettype = array_merge($lang['all'], $competrange);
	$smarty->assign('competrange', $competrange);
    $smarty->assign('range', $range);
	
	$smarty->assign('filters',  $filters);
    $smarty->assign('filter',   $filter);
	
	
	// enable dynamic columns in list view
    $smarty->assign('competitionslistcolumns',$_SESSION['pcs']['competitionslistcolumns']);
}

function tpl_filters_stadiums($filter, $countryfilter)
{
    global $smarty, $lang, $countrylng;
    global $filter_expr;

    // build filter array
    foreach ($filter_expr as $flt => $regex)
    {
        $filters[$flt] = ($flt == "NUM") ? "#" : $flt;
    }
    $filters['all']	    = $lang['radio_all'];
	
	$countrys = getcountryfromstadiums();
	
	$smarty->assign('countryfilter', out_selectcountry('countryfilter', $countryfilter, $countrys));
    $smarty->assign('filters',  $filters);
    $smarty->assign('filter',   $filter);
	$smarty->assign('type',   $type);
	
	// enable dynamic columns in list view
    $smarty->assign('stadiumslistcolumns',$_SESSION['pcs']['stadiumslistcolumns']);
}

function tpl_filters_news($filter, $langfilter, $catfilter)
{
    global $smarty, $lang, $countrylng;

	$languageselect = getlanguages();
	$smarty->assign('languageselect', $languageselect);
	$smarty->assign('langfilter',   $langfilter);
	
	$categoryselect = getcategorynews();
	$smarty->assign('categoryselect', $categoryselect);
    $smarty->assign('catfilter',   $catfilter);
	
    $smarty->assign('filters',  $filters);
    $smarty->assign('filter',   $filter);
	
	$smarty->assign('type',   $type);

}


/**
 * Assigns debug infos and version to the smarty engine
 */
function tpl_footer()
{
    global $smarty, $config;

    if ($config['debug'])
    {
        $out = $config;
        $out['db_password'] = '***';
        ob_start();
        print '<pre>';
        print_r($out);
        print '</pre>';
        phpinfo();
        $debug .= ob_get_contents();
        ob_end_clean();
        $smarty->assign('DEBUG', $debug);
    }
    $smarty->assign('version', VERSION);
}


/******************************************************************************************************/

function bbdecode($text)
{
	global $bbtag;
	$text = " " . $text;

	// colours
	$text = preg_replace("/\[color=(\#[0-9A-F]{6}|[a-z]+)\]/si", $bbtag['color_open'], $text);
	$text = str_replace("[/color]", $bbtag['color_close'], $text);

	// size
	$text = preg_replace("/\[size=([1-2]?[0-9])\]/si", $bbtag['size_open'], $text);
	$text = str_replace("[/size]", $bbtag['size_close'], $text);

	// [b] and [/b] for bolding text.
	$text = str_replace("[b]", $bbtag['b_open'], $text);
	$text = str_replace("[/b]", $bbtag['b_close'], $text);

	// [u] and [/u] for underlining text.
	$text = str_replace("[u]", $bbtag['u_open'], $text);
	$text = str_replace("[/u]", $bbtag['u_close'], $text);

	// [i] and [/i] for italicizing text.
	$text = str_replace("[i]", $bbtag['i_open'], $text);
	$text = str_replace("[/i]", $bbtag['i_close'], $text);

	// Patterns and replacements for URL and email tags..
	$patterns = array();
	$replacements = array();

	// [img]image_url_here[/img] code..
	// This one gets first-passed..
	$patterns[] = "#\[img\]([^?].*?)\[/img\]#i";
	$replacements[] = $bbtag['img'];

	// matches a [url]xxxx://www.phpbb.com[/url] code..
	$patterns[] = "#\[url\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
	$replacements[] = $bbcode_tpl['url1'];

	// [url]www.phpbb.com[/url] code.. (no xxxx:// prefix).
	$patterns[] = "#\[url\]((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
	$replacements[] = $bbcode_tpl['url2'];

	// [url=xxxx://www.phpbb.com]phpBB[/url] code..
	$patterns[] = "#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
	$replacements[] = $bbcode_tpl['url3'];

	// [url=www.phpbb.com]phpBB[/url] code.. (no xxxx:// prefix).
	$patterns[] = "#\[url=((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
	$replacements[] = $bbcode_tpl['url4'];
	
	// [email]user@domain.tld[/email] code..
	$patterns[] = "#\[email\]([a-z0-9&\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
	$replacements[] = $bbtag['email'];

	$text = preg_replace($patterns, $replacements, $text);

	// Remove our padding from the string..
	$text = substr($text, 1);

	return $text;

} // bbencode_first_pass()



?>