<?php
/**
 * Functions for config options
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: setupfunctions.php,v 1.00 2006/12/06
 */

require_once './core/functions.php';


$SETUP_GLOBAL = array('activegallery', 'activecentralgallery', 'activecomments', 'activecompetcategorys', 'activestadiums', 'activecompetitions', 'activeplayers', 'activereferees', 'activecoachs', 'activeclubs', 'activecalendar', 'activesearch', 'admin_email', 'advlines', 'credits', 'clubslistcolumns', 'clubmenutype', 'clubpreference', 'clubstats', 'competitionslistcolumns', 'competitionstats', 'contactus', 'countryfilterdefault', 'denyguest', 'desactiveturing', 'displaylistmembers', 'displaypronostics', 'filterdefault', 'gallerylistcolumns', 'displaystylelist','language', 'localnet', 'matchvalidation', 'multiuser', 'nationalclubbydefault', 'newslistcolumns', 'pageno', 'personslistcolumns', 'playerstats', 'prizelistcolumns', 'prizelistsize', 'proxy_host', 'proxy_port', 'recompile', 'seasonfilterdefault', 'showimg', 'shownew', 'site_keywords', 'site_description', 'stadiumslistcolumns', 'subslines', 'template', 'thumbnail');

$SETUP_USER   = array('avatar', 'birthday', 'clubslistcolumns', 'competitionslistcolumns', 'clubpreferenceuser', 'country', 'countryfilterdefault', 'filterdefault', 'language', 'pageno', 'personslistcolumns', 'prizelistcolumns', 'prizelistsize', 'residence', 'seasonfilterdefault', 'showimg', 'shownew', 'stadiumslistcolumns', 'template', 'time_zone');

/**
 * build config options array
 *
 * returns associative array of config options
 *
 * @param boolean   $isprofile  Determines if user-specific options are to be displayed
 */
function setup_mkOptions($isprofile = false)
{
	global $config, $lang, $lngtimezone, $countrylng;

    // built list of setup options
	$setup = array();
    
    // isprofile, name, type (text|boolean|dropdown|special|link|image|date), data, set, helphl, helptxt
	
	if ($isprofile) setup_addSection($setup, 'opt_profile');
	if ($isprofile) setup_addOption($setup, $isprofile, 'avatar', 'image');
	if ($isprofile) setup_addOption($setup, $isprofile, 'birthday', 'date');    	
    if ($isprofile) setup_addOption($setup, $isprofile, 'residence', 'text');
	if ($isprofile && $config['clubmenutype'] == 2) setup_addOption($setup, $isprofile, 'clubpreferenceuser', 'dropdown', setup_listClubs());    	
    
	setup_addSection($setup, 'opt_general');
	setup_addOption($setup, $isprofile, 'language', 'dropdown', setup_getLanguages(), null, $lang['help_langn'], $lang['help_lang']);
	setup_addOption($setup, $isprofile, 'template', 'dropdown', getTemplates());
	setup_addOption($setup, $isprofile, 'time_zone', 'dropdown', $lngtimezone);
	setup_addOption($setup, $isprofile, 'country', 'dropdown', $countrylng);
	setup_addOption($setup, $isprofile, 'site_description', 'textarea');
	setup_addOption($setup, $isprofile, 'site_keywords', 'textarea');
	setup_addOption($setup, $isprofile, 'admin_email', 'text');
 	setup_addOption($setup, $isprofile, 'credits', 'text');
	setup_addOption($setup, $isprofile, 'desactiveturing', 'boolean');
	setup_addOption($setup, $isprofile, 'matchvalidation', 'dropdown', array('0'=>$lang['matchvalidation0'],'1'=>$lang['matchvalidation1'],'2'=>$lang['matchvalidation2']));
	if ($config['clubmenutype'] == 1) setup_addOption($setup, $isprofile, 'clubpreference', 'dropdown', setup_listClubs());
    
 
	setup_addSection($setup, 'opt_display');
	setup_addOption($setup, $isprofile, 'newslistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
    if ($config['activeclubs'])        setup_addOption($setup, $isprofile, 'clubslistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
    if ($config['activeplayers'] || $config['activereferees']) setup_addOption($setup, $isprofile, 'personslistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
    if ($config['activegallery'])      setup_addOption($setup, $isprofile, 'gallerylistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
	if ($config['activestadiums'])     setup_addOption($setup, $isprofile, 'stadiumslistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
	if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'competitionslistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
    if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'prizelistcolumns', 'dropdown', array('1'=>'1 '.$lang['columnsperlines'],'2'=>'2 '.$lang['columnsperlines'],'3'=>'3 '.$lang['columnsperlines'],'4'=>'4 '.$lang['columnsperlines'],'5'=>'5 '.$lang['columnsperlines'],'6'=>'6 '.$lang['columnsperlines'],'7'=>'7 '.$lang['columnsperlines'],'8'=>'8 '.$lang['columnsperlines'],'9'=>'9 '.$lang['columnsperlines'],'10'=>'10 '.$lang['columnsperlines']));
	if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'prizelistsize', 'dropdown', array('4'=>'4','5'=>'5','6'=>'6','7'=>'7','8'=>'8','9'=>'9','10'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25'));
	if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'activecompetcategorys', 'boolean');
    if ($config['activeplayers']) setup_addOption($setup, $isprofile, 'playerstats', 'boolean');
	if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'competitionstats', 'boolean');
	if ($config['activeclubs']) setup_addOption($setup, $isprofile, 'clubstats', 'boolean');
    if ($config['activeclubs']) setup_addOption($setup, $isprofile, 'nationalclubbydefault', 'boolean');
    if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'advlines', 'dropdown', array('1'=>'1 '.$lang['linespercolumns'],'2'=>'2 '.$lang['linespercolumns'],'3'=>'3 '.$lang['linespercolumns'],'4'=>'4 '.$lang['linespercolumns'],'5'=>'5 '.$lang['linespercolumns'],'6'=>'6 '.$lang['linespercolumns'],'7'=>'7 '.$lang['linespercolumns'],'8'=>'8 '.$lang['linespercolumns'],'9'=>'9 '.$lang['linespercolumns'],'10'=>'10 '.$lang['linespercolumns']));
	if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'subslines', 'dropdown', array('1'=>'1 '.$lang['linespercolumns'],'2'=>'2 '.$lang['linespercolumns'],'3'=>'3 '.$lang['linespercolumns'],'4'=>'4 '.$lang['linespercolumns'],'5'=>'5 '.$lang['linespercolumns'],'6'=>'6 '.$lang['linespercolumns'],'7'=>'7 '.$lang['linespercolumns'],'8'=>'8 '.$lang['linespercolumns'],'9'=>'9 '.$lang['linespercolumns'],'10'=>'10 '.$lang['linespercolumns']));
	setup_addOption($setup, $isprofile, 'seasonfilterdefault', 'dropdown', setup_getSeasons());
	setup_addOption($setup, $isprofile, 'displaystylelist', 'boolean');
    setup_addOption($setup, $isprofile, 'showimg', 'boolean');
    setup_addOption($setup, $isprofile, 'filterdefault', 'dropdown', array('all'=>$lang['radio_all'], 'unseen'=>$lang['radio_unseen'], 'new'=>$lang['radio_new'], 'wanted'=>$lang['radio_wanted']));
    setup_addOption($setup, $isprofile, 'shownew', 'text');
    setup_addOption($setup, $isprofile, 'pageno', 'text');
    setup_addOption($setup, $isprofile, 'recompile', 'boolean');
   
	if (!$isprofile) setup_addSection($setup, 'opt_menudisplay');
	
	setup_addOption($setup, $isprofile, 'clubmenutype', 'dropdown', array('0'=>$lang['menutype0'],'1'=>$lang['menutype1'],'2'=>$lang['menutype2']));
	if ($config['clubmenutype'] == 1) setup_addOption($setup, $isprofile, 'clubpreference', 'dropdown', setup_listClubs());
	
	if ($config['activegallery']) setup_addOption($setup, $isprofile, 'activecentralgallery', 'boolean');
    setup_addOption($setup, $isprofile, 'activestadiums', 'boolean');
    setup_addOption($setup, $isprofile, 'activecompetitions', 'boolean');
    setup_addOption($setup, $isprofile, 'activeplayers', 'boolean');
    setup_addOption($setup, $isprofile, 'activereferees', 'boolean');
    setup_addOption($setup, $isprofile, 'activecoachs', 'boolean');
    setup_addOption($setup, $isprofile, 'activeclubs', 'boolean');
    setup_addOption($setup, $isprofile, 'activecalendar', 'boolean');
	setup_addOption($setup, $isprofile, 'activegallery', 'boolean');
    setup_addOption($setup, $isprofile, 'activecomments', 'boolean');
    setup_addOption($setup, $isprofile, 'activesearch', 'boolean');
    setup_addOption($setup, $isprofile, 'displaylistmembers', 'boolean');
    if ($config['activecompetitions']) setup_addOption($setup, $isprofile, 'displaypronostics', 'boolean');
	setup_addOption($setup, $isprofile, 'contactus', 'boolean');


    if (!$isprofile) setup_addSection($setup, 'opt_security');
	setup_addOption($setup, $isprofile, 'localnet', 'text');
	setup_addOption($setup, $isprofile, 'multiuser', 'boolean');
	setup_addOption($setup, $isprofile, 'denyguest', 'boolean');
    setup_addOption($setup, $isprofile, 'usermanager', 'link', 'members.php');
	setup_addOption($setup, $isprofile, 'proxy_host', 'text');
	setup_addOption($setup, $isprofile, 'proxy_port', 'text');

    if (!$isprofile) setup_addSection($setup, 'opt_caching');
    setup_addOption($setup, $isprofile, 'thumbnail', 'boolean');
    
	return $setup;
}

/**
 * Add a new section to the config options array
 *
 * @param array   $setup      The config array
 * @param string  $section    Name of the new section
 */
function setup_addSection(&$setup, $section)
{
    $option['group']    = $section;
    $setup[]            = $option;
}

/**
 * Adds an entry for the config option array
 *
 * returns NULL on global options if $isprofile is true 
 * so global options will not be added to user profile settings
 *
 * @param array   $setup      The config array
 * @param boolean $isprofile  Do we prepare a profile array?
 * @param string  $name       Name of the config option
 * @param string  $type       Type of option (text|boolean|dropdown|special|link)
 * @param string  $data       Current value of this option
 * @param string  $set        Default value of this option
 * @param string  $hl         Help text headline
 * @param string  $help       Help text
 */
function setup_addOption(&$setup, $isprofile, $name, $type, 
                         $data='', $set=NULL, $hl=NULL, $help=NULL)
{
	global $config, $lang;
    global $SETUP_USER;

    // user-specific setting?
    $isuser = in_array($name, $SETUP_USER);
    
	if ($isprofile and !$isuser) return;

	$option['isuser']   = $isuser;
	$option['name']     = $name;
	$option['type']     = $type;
	$option['set']  = ($set)  ? $set  : $config[$name];
	
    
	if ($type == 'date') {
	$option['data']  = getfrdate($data);
	}
	else {
    $option['data']     = $data;
	}
	
    $option['hl']   = ($hl)   ? $hl   : $lang['help_'.$name.'n'];
    $option['help'] = ($help) ? $help : $lang['help_'.$name];

	$setup[] = $option;
}

/**
 * Find available languages
 */
function setup_getLanguages()
{
    if ($dh = opendir('language')) 
    {
        while (($file = readdir($dh)) !== false) 
        {
            if (preg_match("/(.*)\.php$/", $file, $matches))
            {
                $languages[$matches[1]] = $matches[1];
            }
        }
        closedir($dh);
    }
    return $languages;
}


/**
 *  Find avalaible Seasons
**/
function setup_getSeasons () {

$SELECT = 'SELECT id, season FROM '.TBL_SEASONS.' ORDER BY season';
$result = runSQL($SELECT);

foreach ($result as $res) {
$myresults[$res['id']] = $res['season'];
}

return($myresults);

}

/**
 *  Find avalaible Seasons
**/
function setup_listClubs () {
global $countrylng;

$SELECT = 'SELECT id, shortname, country FROM '.TBL_CLUBS.' ORDER BY country, shortname';
$result = runSQL($SELECT);

foreach ($result as $res) {
$myresults[$res['id']] = $countrylng[$res['country']].' - '.$res['shortname'];
}

return($myresults);

}


// uploaded cover?
function setup_upload($opt, $target, $id)
{

        if (isset($_FILES[$opt]) && is_uploaded_file($_FILES[$opt]['tmp_name']))
        {
			
            $file = $_FILES[$opt]['tmp_name'];
            $mime = $_FILES[$opt]['type'];

            // determine file extension
            if (preg_match('=image/jpe?g=i', $mime))
            {
                $ext = 'jpg';
            }
            elseif (preg_match('=image/(gif|png)=i', $mime, $m))
            {
                $ext = $m[1];
            }
            elseif (preg_match('=application/octet-stream=i', $mime))
            {
                if (preg_match("/\.(jpe?g|gif|png)$/i", $_FILES['coverupload']['name'], $matches))
                {
                    $ext = $matches[1];
                }
            }

            // move to cache and update db
            if (!empty($ext))
            {
                //$coverfile = 'cache/img/users/logo_'.$id.'.'.$ext;
                $coverfile = $target.$id.'.'.$ext;
                if (move_uploaded_file($file, $coverfile))
                {
                   $myfile = $coverfile; 
                }
            }
			
	    }
		
return($myfile);
}

/**
 * Check cache folder for expired entries
 *
 * @param   string  $dir  cache folder
 * @param   boolean $all  return list of all files (or outdated files)
 * @return  array   $total, $expired, $files    sum and list of total and expired files
 */
function analyzeCacheFolder($dir, $all = false)
{
    global $config;

    $files = array();
    
    if ($handle = opendir($dir))
    {
        // read cache directory (note syntax, according to docs!)
        while (false !== ($file = readdir($handle)))
        {
            // prevent deletion of hidden files (*nix) or directory references (Windows)
            if (preg_match("/^\./", $file)) continue;
            $cfile = "$dir/$file";

            // file found?
            if (!is_dir($cfile)) 
            {
                $total += filesize($cfile);
                if ($all || !(time()-filemtime($cfile) < $config['IMDBage']))
                {
                    $expired += filesize($cfile);
                    $files[] = $cfile;
                }
            }
            
            // or hierarchical cache directories?
            elseif ($config['hierarchical']) 
            {
                // one-char directory name?
                if (preg_match("/^\w$/", $file)) 
                {
                    list($atotal, $aexpired, $afiles) = analyzeCacheFolder($cfile, $all);
                    $total += $atotal;
                    $expired += $aexpired;
                    $files = array_merge($files, $afiles);
                }
            }
        }
        closedir($handle);
    }

    return array($total, $expired, $files);
}

/**
 * Update session variables with configuration values
 *
 */
function update_session()
{
    global $listcolumns, $personslistcolumns, $competitionslistcolumns, $clubslistcolumns, $gallerylistcolumns, $stadiumslistcolumns;
    
    if ($listcolumns) $_SESSION['pcs']['listcolumns']                          = $listcolumns;
    if ($personslistcolumns) $_SESSION['pcs']['personslistcolumns']            = $personslistcolumns;
    if ($competitionslistcolumns) $_SESSION['pcs']['competitionslistcolumns']  = $competitionslistcolumns;
    if ($clubslistcolumns) $_SESSION['pcs']['clubslistcolumns']                = $clubslistcolumns;
    if ($gallerylistcolumns) $_SESSION['pcs']['gallerylistcolumns']            = $gallerylistcolumns;
	if ($stadiumslistcolumns) $_SESSION['pcs']['stadiumslistcolumns']	       = $stadiumslistcolumns;

}

?>
