<?php

/**
 * Security functions
 *
 * @package Core
 * @author  Eric Gallene   <okrome@free.fr>
 * @version $Id: security.php,v 1.0 2006/10/26 18:20:04
 */

/**
 * Allow these tags
 */
$allowedTags = '<h1><h2><h3><h4><b><strong><i><a><ol><ul><li><pre><hr><blockquote><img><image>';

/**
 * Disallow these attributes/prefix within a tag
 */
$stripAttrib = 'javascript:|onclick|ondblclick|onmousedown|onmouseup|onmouseover|'.
               'onmousemove|onmouseout|onkeypress|onkeydown|onkeyup';

/**
 * @return string
 * @param string
 * @desc Strip forbidden attributes from a tag
 */
function removeEvilAttributes($tagSource)
{
    global $stripAttrib;
    return stripslashes(preg_replace("/$stripAttrib/i", 'forbidden', $tagSource));
}

/**
 * @return string
 * @param string
 * @desc Strip forbidden tags and delegate tag-source check to removeEvilAttributes()
 */
function removeEvilTags($source)
{
    global $allowedTags;
    $source = strip_tags($source, $allowedTags);
    return preg_replace('/<(.*?)>/ie', "'<'.removeEvilAttributes('\\1').'>'", $source);
}

?>