<?php
/**
 * Output functions
 *
 * Functions for HTML output generation (Not templates!)
 *
 *
 * @package Core
 * @author  Eric GALLENE <okrome@free.fr>
 * @version $Id: output.php,v 1.00 2006/10/22 18:21:09
 */

require_once './core/functions.php';

/**
 * Convert SQL result array into associative key=>value array
 *
 * @param   $key    key index name
 * @param   $value  value index name
 * @param   $result SQL result array
 * @return  array   resulting associative array
 */
function associateResultSet($key, $value, &$result)
{
    $ary = array();
    foreach ($result as $row)
    {
        $ary[$row[$key]] = $row[$value];
    }
    return $ary;
}

/**
 * Display Select boxes
 *
 * @param  array $lang  selected langage
 * @return                  string HTML for genre checkboxes
 */

function out_selectbox($sname, $selected, $myarray)
{
global $config;
global $lang;
$out = '<select name="'.$sname.'">';
	foreach ($myarray as $mydata) {
		if ($mydata == $selected) {
		$out .= '<option value="'.$mydata.'" selected>'.$lang[$mydata].'</option>';
		}
		else {
		$out .= '<option value="'.$mydata.'">'.$lang[$mydata].'</option>';
		}
	}
$out .= '</select>';
return $out;
}

/**
 * Display Select boxes
 *
 * @param  array $lang  selected langage
 * @return                  string HTML for genre checkboxes
 */

function out_selectseason($sname, $selected, $myarray)
{
global $config;
global $lang;

$out = '<select name="'.$sname.'">';
	foreach ($myarray as $mydata) {
		if ($mydata[1] == $selected) {
		$out .= '<option value="'.$mydata['id_season'].'" selected>'.$mydata['season'].'</option>';
		}
		else {
    	$out .= '<option value="'.$mydata['id_season'].'">'.$mydata['season'].'</option>';
		}
	}
$out .= '</select>';
return $out;
}

/**
 * Display Select boxes
 *
 * @param  array $lang  selected langage
 * @return                  string HTML for genre checkboxes
 */

function out_selectcountry($sname, $selected, $myarray)
{
global $config;
global $lang, $countrylng;

for ($x=0; $x<count($myarray); $x++) {
	$allcountrys[$x]['id'] = $myarray[$x]['country'];
	$allcountrys[$x]['country'] = $countrylng[$myarray[$x]['country']];
	$cle[$x] = $myarray[$x]['country'];	
	$cle2[$x] = $countrylng[$myarray[$x]['country']];	
}
array_multisort($cle2,SORT_ASC, SORT_STRING,$allcountrys);

$out = '<select name="'.$sname.'"  id="'.$sname.'" onchange="submit()"><option value="">'.$lang['all'].'</option>';
	for ($x=0;$x<count($allcountrys);$x++) {
		if ($allcountrys[$x]['id'] == $selected) {
		$out .= '<option value="'.$allcountrys[$x]['id'].'" selected>'.$allcountrys[$x]['country'].'</option>';
		}
		else {
    	$out .= '<option value="'.$allcountrys[$x]['id'].'">'.$allcountrys[$x]['country'].'</option>';
		}
	}
$out .= '</select>';
return $out;
}

/**
 * Converts datetime in astro time
 *
 * @author  
 * @param   Datetime
 * @param   
 * @return  string                 MySQL compatible list
 */

function out_date($naissance, $type) {
global $lang;

// Date au format Jour-mois ou bien Jour/mois
// l'anne peut etre passe, mais est ignore
list($annee, $mois, $jour) = split('/|-',$naissance);
$mydate = '';
	if ($type == 1) {
	$mydate = $jour . ' ' . $mois . ' ' . $annee;
	}
	if ($type == 2) {
	$mydate = $jour . ' ' . $lang['month'.$mois] . ' ' . $annee;
	}
	else {
	$mydate = $jour . ' ' . $mois . ' ' . $annee;
	}

return $mydate;
}

/**
 * Converts datetime in astro time
 *
 * @author  
 * @param   Datetime
 * @param   
 * @return  string                 MySQL compatible list
 */

 function out_astro($naissance) {
// Date au format Jour-mois ou bien Jour/mois
// l'anne peut etre passe, mais est ignore

list($annee, $mois, $jour) = split('/|-',$naissance);
$jour += 0;
$mois += 0;

$signe='nosign';
if ($mois && $jour) {
	if ($mois == 1 && $jour >=20 || $mois == 2 && $jour <=18) {$signe = "aquarius";}
	if ($mois == 1 && $jour > 31) {$signe = "nosign";}
	if ($mois == 2 && $jour >=19 || $mois == 3 && $jour <=20) {$signe = "pisces";}
	if ($mois == 2 && $jour > 29) {$signe = "nosign";}
	if ($mois == 3 && $jour >=21 || $mois == 4 && $jour <=19) {$signe = "aries";}
	if ($mois == 3 && $jour > 31) {$signe = "nosign";}
	if ($mois == 4 && $jour >=20 || $mois == 5 && $jour <=20) {$signe = "taurus";}
	if ($mois == 4 && $jour > 30) {$signe = "nosign";}
	if ($mois == 5 && $jour >=21 || $mois == 6 && $jour <=21) {$signe = "gemini";}
	if ($mois == 5 && $jour > 31) {$signe = "nosign";}
	if ($mois == 6 && $jour >=22 || $mois == 7 && $jour <=22) {$signe = "cancer";}
	if ($mois == 6 && $jour > 30) {$signe = "nosign";}
	if ($mois == 7 && $jour >=23 || $mois == 8 && $jour <=22) {$signe = "leo";}
	if ($mois == 7 && $jour > 31) {$signe = "nosign";}
	if ($mois == 8 && $jour >=23 || $mois == 9 && $jour <=22) {$signe = "virgo";}
	if ($mois == 8 && $jour > 31) {$signe = "nosign";}
	if ($mois == 9 && $jour >=23 || $mois == 10 && $jour <=22) {$signe = "libra";}
	if ($mois == 9 && $jour > 30) {$signe = "nosign";}
	if ($mois == 10 && $jour >=23 || $mois == 11 && $jour <=21) {$signe = "scorpio";}
	if ($mois == 10 && $jour > 31) {$signe = "nosign";}
	if ($mois == 11 && $jour >=22 || $mois == 12 && $jour <=21) {$signe = "sagittarius";}
	if ($mois == 11 && $jour > 30) {$signe = "nosign";}
	if ($mois == 12 && $jour >=22 || $mois == 1 && $jour <=19) {$signe = "capricorn";}
	if ($mois == 12 && $jour > 31) {$signe = "nosign";}
}
return $signe;

}


/**
 * Converts keys of an array to MySQL compatible list
 *
 * @author  Chinamann <chinamann@users.sourceforge.net>
 * @param   Array   $owners        Array from out_owners
 * @param   boolean $isString      return list of strings?
 * @return  string                 MySQL compatible list
 */
function owners2list($owners, $isString = true)
{
    if ($isString) return "'".join("', '", array_keys($owners))."'";
    else return join(", ", array_keys($owners));
}


?>