<?php
/**
 * Make Graph functions
 *
 * Contains globally available tool functions. It is included in every
 * page and sets up some defaults like error reporting, environment
 * setups and config loading
 *
 *
 * @package Core
 * @author  Eric GALLENE <okrome@free.fr>
 * @version $Id: tables.php,v 1.00 2006/10/23 18:15:53
 */

/**
 * Return UserId to a given UserName
 *
 * @author Chinamann <chinamann@users.sourceforge.net>
 * @param   string  $userName user name
 * @result  integer user id
 */
function makegraph($team1, $team2, $numdays, $numclubs,$id)
{
global $lang;

$largeur=415;
$hauteur=150;
$marge_gauche=10;
$marge_haut=10;

//Header("Content-type: image/png");

$image = ImageCreate($largeur+40,$hauteur+40+$marge_haut);
$rouge = ImageColorAllocate($image,255,0,0);
$vert = ImageColorAllocate($image,0,106,54);
$bleu = ImageColorAllocate($image,0,0,255);
$blanc = ImageColorAllocate($image,255,255,255);
$noir = ImageColorAllocate($image,0,0,0);
$gris = ImageColorAllocate($image,150,150,150);


ImageFilledRectangle($image,0,0,$largeur+40,$hauteur+40+$marge_haut,$blanc);


ImageFilledRectangle($image,20+$marge_gauche,10+$marge_haut,20+$marge_gauche,$hauteur+5+$marge_haut,$noir); // trait vertical  gauche
$titre = $lang['evolteam'];
$titrePolice = 4;
imageString($image, $titrePolice, ($largeur+40+$marge_gauche-ImageFontWidth($titrePolice)*strlen($titre))/2, 0, $titre, $noir); // titre


// Tracer des journes en ordonnes

$y=1;
while ($y<=$numdays) {
	if (($y%2)==0)
	{
	$titre = $y;
	$titrePolice = 2;
	ImageFilledRectangle($image,($y-1)*($largeur)/$numdays+$marge_gauche+20,20,($y-1)*($largeur)/$numdays+$marge_gauche+20,$hauteur+$marge_haut,$gris); // trait vertical  gauche
	imageString($image, $titrePolice, ($y-1)*($largeur)/$numdays+$marge_gauche+20, $hauteur+$marge_haut, $titre, $noir); // numrotation journes
	$y++;
	}
	else {$y++;}
}






// Tracer du classement en abscisse
$x=$hauteur/$numclubs;
$y=1;
while ($x<=$hauteur)
{
ImageFilledRectangle($image,$marge_gauche+15,$x+ $marge_haut,$largeur+15,$x+$marge_haut,$gris); // traits par place

$titre = $y;
$titrePolice = "2";
if ($y<$numclubs){ImageString($image, $titrePolice, $marge_gauche+1, $x-8+$marge_haut, $titre, $noir);} // numrotation place
$x=$x+($hauteur/$numclubs);
$y++;
}


//Calcul des Placement des points

$x=$marge_gauche+20; //pas nb equipes !
$points=0;
$place=0;
$place=array();
$points=array();
for ($i=1; $i<count($team1); $i++) 
{
    $place[$i] = $team1[$i]['rang'];
	$points[$i][0] = $x;
	$points[$i][1] = $hauteur+$marge_haut-($numclubs-$team1[$i]['rang'])*$hauteur/$numclubs;
	$x+= ($largeur-$marge_gauche+11)/$numdays;
	$titrePolice=2;
}
imagesetthickness($image,3);
for($i=1;$i<count($team1)-1;$i++){	
	ImageLine($image, $points[$i][0],$points[$i][1],$points[$i+1][0],$points[$i+1][1],$rouge);
}

$x=$marge_gauche+20; //pas nb equipes !
for ($i=1; $i<count($team2); $i++) 
{
    $place2[$i] = $team1[$i]['rang'];
	$points2[$i][0] = $x;
	$points2[$i][1] = $hauteur+$marge_haut-($numclubs-$team2[$i]['rang'])*$hauteur/$numclubs;
	$x+= ($largeur-$marge_gauche+11)/$numdays;
	$titrePolice=2;
}
for($i=1;$i<count($team2)-1;$i++){
	ImageLine($image, $points2[$i][0],$points2[$i][1],$points2[$i+1][0],$points2[$i+1][1],$vert);
}




for($i=0;$i<count(team1);$i++)
{
    if (!isset($place[$i+1])){imageString($image, $titrePolice, $points[$i][0],$points[$i][1] , $place[$i], $rouge);}
	elseif ($place[$i+1]<=$place[$i]){imageString($image, $titrePolice, $points[$i][0],$points[$i][1] , $place[$i], $rouge);}
	elseif ($place[$i+1]>$place[$i]){imageString($image, $titrePolice, $points[$i][0],$points[$i][1]-11 , $place[$i], $rouge);}
	else {imageString($image, $titrePolice, $points[$i][0], $points[$i][1], $place[$i], $rouge);}
}




$titre = "";
$titrePolice = 4;
imageString($image, $titrePolice, ($largeur+$marge_gauche-ImageFontWidth($titrePolice)*strlen($titre))/2, $hauteur+30, $titre, $vert);

ImagePNG($image, "cache/img/graphs/graph_".$id.".png");
ImageDestroy($image);

return("cache/img/graphs/graph_".$id.".png");

}



?>