<?php
/**
 * Constants
 *
 * Contains global constants for table names
 * Must only be loaded after config.inc.php
 *
 * @package Core
 * @author  Eric GALLENE <okrome@free.fr>
 * @version $Id: constants.php,v 1.00 2006/10/23 18:46:00 andig2 Exp $
 */

// Config file
define ('CONFIG_FILE', './config.inc.php');
define ('VERSION', 'v0.84');

// User Permission bit masks
define('PERM_ADMIN', 1);
define('PERM_READ',  2);
define('PERM_MKCOMMENT',  4);
define('PERM_GALLERY', 8);
define('PERM_MKBET', 16);
define('PERM_ADDGALLERY', 32);
define('PERM_NEWS', 64);
define('PERM_WRITE', 128);

if (!isset($config['db_prefix'])) {$config['db_prefix']="";}
// Table names
define('TBL_BET',               $config['db_prefix'].'bet');
define('TBL_BETLIST',           $config['db_prefix'].'betlist');
define('TBL_BETTABLE',          $config['db_prefix'].'bettable');
define('TBL_BETWINNER',         $config['db_prefix'].'betwinner');
define('TBL_CANDIDATES',        $config['db_prefix'].'candidates');
define('TBL_CARACS',            $config['db_prefix'].'caracs');
define('TBL_CARDS',             $config['db_prefix'].'cards');
define('TBL_CATEGORIES',        $config['db_prefix'].'categories');
define('TBL_CLMNT',             $config['db_prefix'].'classification');
define('TBL_CLUBS',             $config['db_prefix'].'clubs');
define('TBL_CODES',             $config['db_prefix'].'codes');
define('TBL_COMMENTS',          $config['db_prefix'].'comments');
define('TBL_COMPETITIONS',      $config['db_prefix'].'competitions');
define('TBL_CONFIG',            $config['db_prefix']. (empty($config['conf_table']) ? 'config' : $config['conf_table']));
define('TBL_DAYS',              $config['db_prefix'].'days');
define('TBL_GALLERY',           $config['db_prefix'].'gallery');
define('TBL_GOALS',             $config['db_prefix'].'goals');
define('TBL_LINEUP',            $config['db_prefix'].'lineup');
define('TBL_MATCHS',            $config['db_prefix'].'matchs');
define('TBL_NEWS',              $config['db_prefix'].'news');
define('TBL_PARAMS',            $config['db_prefix'].'paramcompetitions');
define('TBL_PERSONS',           $config['db_prefix'].'persons');
define('TBL_PRIZELIST',         $config['db_prefix'].'prizelist');
define('TBL_SEASONS',           $config['db_prefix'].'seasons');
define('TBL_SUBS',              $config['db_prefix'].'subs');
define('TBL_STADIUMS',          $config['db_prefix'].'stadiums');
define('TBL_TEAMS',             $config['db_prefix'].'teams');
define('TBL_USERCONFIG',        $config['db_prefix'].'userconfig');
define('TBL_USERS',             $config['db_prefix'].'users');
define('TBL_VALUES',            $config['db_prefix'].'values');
// Required database version
define('DB_REQUIRED', 084);



?>