<?php
/**
 * Compatibility functions
 *
 * Borrowed simplified functions from PEAR module PHP_Compat
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: compatibility.php,v 1.00 2006/10/22 18:15:00
 */

/**
 * Implements file_get_contents
 */
if (!function_exists('file_get_contents')) 
{
	function file_get_contents($filename) 
    {
		$fh = @fopen($filename, 'rb');
		if (!$fh) return false;
		$content = fread($fh, filesize($filename));
		fclose($fh);
		return $content;
	}
}

/**
 * Implements file_put_contents
 */
if (!function_exists('file_put_contents')) 
{
	function file_put_contents($filename, $content) 
    {
		$fh = @fopen($filename, 'wb');
		if (!$fh) return false;
		if (!fwrite($fh, $content, strlen($content))) return false;
		fclose($fh);
		return true;
	}
}

/**
 * Implements html_entity_decode introduced in v4.3.0
 * @author <martin@swertcw.com>
 * @param   string  $string  HTML encoded string
 * @return  string           HTML decoded string
 */
if (!function_exists('html_entity_decode')) 
{
	function html_entity_decode($string) 
    {
		// replace numeric entities
		$string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
		$string = preg_replace('~&#([0-9]+);~e', 'chr(\\1)', $string);
		// replace literal entities
		$trans_tbl = get_html_translation_table(HTML_ENTITIES);
		$trans_tbl = array_flip($trans_tbl);
   		return strtr($string, $trans_tbl);
	}
}

/**
 * Implements http_build_query introduced in v5.0.0
 */
if (!function_exists('http_build_query'))
{
	function http_build_query ($formdata, $numeric_prefix = null)
	{
		// Check we have an array to work with
		if (!is_array($formdata)) {
			return $formdata;
		}

		// Start building the query
		$tmp = array ();
		foreach ($formdata as $key => $val)
		{
			array_push($tmp, urlencode($key).'='.urlencode($val));
		}

		return implode('&', $tmp);
	}
}

?>
