<?php
/**
 * Browse View
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: index.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';


$international = $international[0];


// SET DEFAULTS
if (!isset($filter)) 
{
	$filter       = $_SESSION['pcs']['competsfilter'];
	$countryfilter   = $_SESSION['pcs']['competscountryfilter'];

    if (!isset($filter)) 
    {
        $filter = $config['filterdefault'];
		$countryfilter = $config['countryfilterdefault'];
    }
}

$_SESSION['pcs']['competsfilter']  = $filter;
$_SESSION['pcs']['competscountryfilter']  = $countryfilter;

// standard filters
$filter_expr = array(
  'NUM'  => '^["\\\' ]*[^A-Za-z]',  // simplified '^["\\\' ]*[^ABCabcDEFdefGHIghiJKLjklMNOmnoPQRSpqrsTUVtuvWXZwxy"\\\' ]',
  'ABC'  => '^["\\\' ]*[ABCabc]',
  'DEF'  => '^["\\\' ]*[DEFdef]',
  'GHI'  => '^["\\\' ]*[GHIghi]',
  'JKL'  => '^["\\\' ]*[JKLjkl]',
  'MNO'  => '^["\\\' ]*[MNOmno]',
  'PQRS' => '^["\\\' ]*[PQRSpqrs]',
  'TUV'  => '^["\\\' ]*[TUVtuv]',
  'WXYZ' => '^["\\\' ]*[WXZwxy]'
);


// create SQL according to selected filter
switch ($filter)
{
    case 'all':
					$ORDER  = TBL_COMPETITIONS.'.longname';
                    break;
    case 'full':
                    $WHERES = 'WHERE 1=1';  // secret filter for exposing all data
                    break;
    default:
                    // make sure filter is valid
                    if (!array_key_exists($filter, $filter_expr)) $filter = 'ABC';
                    // apply filter
                    $WHERES = 'WHERE '.TBL_COMPETITIONS.'.shortname RLIKE \''.$filter_expr[$filter].'\'';
}

if ($countryfilter) {
	if ($WHERES) {$WHERES .= ' AND ';}
	else {$WHERES .= ' WHERE ';}
	$WHERES .= TBL_COMPETITIONS.'.country=\''.$countryfilter.'\'';
}
if ($range) {
	if ($WHERES) {$WHERES .= ' AND ';}
	else {$WHERES .= ' WHERE ';}
	$WHERES .= TBL_COMPETITIONS.'.range=\''.$range.'\'';
}

if ($type) {
	if ($WHERES) {$WHERES .= ' AND ';}
	else {$WHERES .= ' WHERE ';}
	$WHERES .= TBL_COMPETITIONS.'.type=\''.$type.'\'';
}

//Show only visible
if ($WHERES) {$WHERES .= ' AND visible = 1';}
	else {$WHERES .= ' WHERE visible = 1';}
$WHERES .= ' AND subcompet = 0';

// default order
if (!$ORDER)  {
	$ORDER   = TBL_COMPETITIONS.'.shortname';
}

// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
                              FROM '.TBL_COMPETITIONS.' '.$WHERES);
 
// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned


// do hard work
$select = 'SELECT id, shortname, imgurl FROM '.TBL_COMPETITIONS.' '.$WHERES.' ORDER BY '.$ORDER.' '.$LIMIT;
$result = runSQL($select);
$smarty->assign('number', count($result));

// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);


//DISPLAY PAGE
// prepare
tpl_page('competitions');
tpl_list($result);
tpl_filters_competitions($filter, $countryfilter, $range, $type);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('filters_competitions.tpl');
smarty_display('list_competitions.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('competitions', httpCacheCaptureEnd());
} 
?>