<?php
/**
 * Comments View
 *
 * Lets you browse through comments
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: gallery.php,v 1.00 2006/12/17 16:15:00
 */

require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';

// check for localnet
localnet_or_die();
check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);

// set defaults
if (!$cat || !$subcat ) 
{
redirect('index.php');
}
else{
$WHERES = "WHERE cat_id =".$cat." AND subcat_id =".$subcat;
$smarty->assign('cat', $cat);
$smarty->assign('subcat', $subcat);
}
if ($idcomment) {
	$WHERES .= " AND comment_id =".$idcomment;
	$ORDER = ' ORDER BY created ASC ';
	$smarty->assign('idcomment', $idcomment);
	$select = 'SELECT id, cat_id, subcat_id, comment_id, title, plot, owner_id, created FROM '.TBL_COMMENTS.' WHERE id='.$idcomment.';'; 
	$mycomment = runSQL($select);
	$smarty->assign('mycomment', $mycomment[0]);
	$smarty->assign('idcomment', $idcomment);	
}
else {
	$WHERES .= " AND comment_id =0";
	$ORDER = ' ORDER BY created DESC ';
}
// add owner selection for multiuser mode
if ($config['multiuser']) 
{
	$myuser = $_COOKIE['PCSuserid'];
	if (check_permission(PERM_WRITE, $_COOKIE['PCSuserid'])) 
        {
            $smarty->assign('editable', 'true');
		}
	if (check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']) && $config['activecomments']) 
        {
            $smarty->assign('commentable', 'true');
		}
	if (check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']) && $config['activegallery']) 
        {
            $smarty->assign('seegallery', 'true');
		}

    //$smarty->assign('owner', $owner);
}

// XML / RSS / PDF export
if ($export && $config[$export])
{
    $func = $export.'export';
    if ($export == 'rss') $export = 'xml';
    require_once './core/'.$export.'.php';

    if (function_exists($func)) $func("$WHERES ORDER BY $ORDER $LIMIT");
    exit();
}

// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);

	// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
                              FROM '.TBL_COMMENTS.' '.$WHERES);

	// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;

    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned
}

switch ($cat)
{
	case 1:
	$SELECT = 'SELECT id, shortname, imgurl, plot FROM '.TBL_CLUBS.' WHERE id = '.$subcat;  
	$res   = runSQL($SELECT);
	$res[0]['imgurl'] = getThumbnail($res[0]['imgurl']);
	$res[0]['tt'] = $res[0]['shortname'];
	$res[0]['title'] = '<a href="show_clubs.php?id='.$res[0]['id'].'">'.$res[0]['shortname'].'</a>';
	$res[0]['plot'] = bbdecode($res[0]['plot']);
	$smarty->assign('item', $res[0]);

	break;
	
	case 2:
	$SELECT = 'SELECT id, longname, imgurl, plot FROM '.TBL_COMPETITIONS.' WHERE id = '.$subcat;  
	$res   = runSQL($SELECT);
	$res[0]['imgurl'] = getThumbnail($res[0]['imgurl']);
	$res[0]['tt'] = $res[0]['longname'];
	$res[0]['title'] = '<a href="show_competitions.php?id='.$res[0]['id'].'">'.$res[0]['longname'].'</a>';
	$res[0]['plot'] = bbdecode($res[0]['plot']);
	$smarty->assign('item', $res[0]);	
	break;
	
	case 3:
	$SELECT = 'SELECT id, longname, country, plot AS plot FROM '.TBL_STADIUMS.' WHERE id = '.$subcat;  
	$res   = runSQL($SELECT);
	$res[0]['imgurl'] = getThumbnail($res[0]['imgurl']);
	$res[0]['tt'] = $res[0]['longname'];
	$res[0]['title'] = '<a href="show_studios.php?id='.$res[0]['id'].'">'.$res[0]['longname'].'</a>';
	$res[0]['plot'] = bbdecode($res[0]['plot']);	
	$smarty->assign('item', $res[0]);	
	break;
	
	case 4:
	$SELECT = 'SELECT id, firstname, lastname, imgurl, plot FROM '.TBL_PERSONS.' WHERE id = '.$subcat;  
	$res   = runSQL($SELECT);
	$res[0]['imgurl'] = getThumbnail($res[0]['imgurl']);
	$res[0]['tt'] = $res[0]['firstname'].' '.$res[0]['lastname'];
	$res[0]['title'] = '<a href="show_persons.php?id='.$res[0]['id'].'">'.$res[0]['firstname'].' '.$res[0]['lastname'].'</a>';
	$res[0]['plot'] = bbdecode($res[0]['plot']);	
	$smarty->assign('item', $res[0]);	
	break;
	
	default:
	$SELECT = 'SELECT id, firstname, lastname, imgurl, plot FROM '.TBL_PERSONS.' WHERE id = '.$subcat;  
	$res   = runSQL($SELECT);
	$res[0]['imgurl'] = getThumbnail($res[0]['imgurl']);
	$res[0]['tt'] = $res[0]['firstname'].' '.$res[0]['lastname'];
	$res[0]['title'] = '<a href="show_persons.php?id='.$res[0]['id'].'">'.$res[0]['firstname'].' '.$res[0]['lastname'].'</a>';
	$res[0]['plot'] = bbdecode($res[0]['plot']);	
	$smarty->assign('item', $res[0]);	
	break;	
}

if ($new) {
$smarty->assign('new', 1);
	if ($editcomment) {
	$SELECT = 'SELECT id, title, cat_id, subcat_id, comment_id, plot FROM '.TBL_COMMENTS.' WHERE id = '.$id;  
	$comment   = runSQL($SELECT);
	$smarty->assign('editmycomment', $comment[0]);		
	}
}

if ($save) {
	$SETS = "cat_id = ".$cat.", subcat_id = ".$subcat;
	$SETS .= ", owner_id=".$_COOKIE['PCSuserid'];
		if ($idcomment) {
		$SETS .= ", comment_id=".$idcomment; 
		}
		else {
		$SETS .= ", comment_id=0";
		}
		
		if ($title) {
		$title = addslashes($title);
		$SETS .= ", title='".$title."'"; 
		}
		if ($plot) {
		$plot = addslashes($plot);
		$SETS .= ", plot='".$plot."'"; 
		}
	
	
		if ($id) {
		$INSERT = 'UPDATE '.TBL_COMMENTS.' SET '.$SETS.' WHERE id='.$id;
		}
		else
        {
            // insert new record
            $INSERT = 'INSERT INTO '.TBL_COMMENTS.' SET '.$SETS.', created = NOW()';
        }
    runSQL($INSERT);
	redirect('comments.php?cat='.$cat.'&subcat='.$subcat);
}


	
// do hard work
$select = 'SELECT '.TBL_COMMENTS.'.id, '.TBL_COMMENTS.'.cat_id, '.TBL_COMMENTS.'.subcat_id, '.TBL_COMMENTS.'.title, '.TBL_COMMENTS.'.plot, '.TBL_COMMENTS.'.owner_id, 
		  '.TBL_COMMENTS.'.created, '.TBL_USERS.'.name AS name, '.TBL_USERCONFIG.'.value AS avatar
		  FROM '.TBL_COMMENTS.'
		  LEFT JOIN '.TBL_USERCONFIG.' ON '.TBL_COMMENTS.'.owner_id = '.TBL_USERCONFIG.'.user_id
		  LEFT JOIN '.TBL_USERS.' ON '.TBL_COMMENTS.'.owner_id = '.TBL_USERS.'.id
		  '.$WHERES.' AND '.TBL_USERCONFIG.'.opt = \'avatar\' '.$ORDER.$LIMIT.';'; 
$result = runSQL($select);

for ($x=0; $x<count($result); $x++) {
	if (check_permission(PERM_WRITE, $_COOKIE['PCSuserid']) || $result[$x]['owner_id'] == $_COOKIE['PCSuserid']) {
	$result[$x]['editable'] = 'true';
	}
	if (check_permission(PERM_ADMIN, $_COOKIE['PCSuserid'])) {
	$result[$x]['deletable'] = 'true';
	}
} 

// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);

// prepare
tpl_page('list_comments');
tpl_list($result);

// docpart support
if ($docpart)
{
    smarty_display('list_comments.tpl');
    exit;
}

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

$smarty->assign('moreless', true);           // show more/less control in list view

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');
//smarty_display('filters_actors.tpl');
if (!$config['http_caching']) flush();

smarty_display('list_comments.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('comments'.$cat.$subcat, httpCacheCaptureEnd());
}

?>