<?php
/**
 * Clubs View
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: index.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';


if (!$q) {
	// SET DEFAULTS
	if (!isset($filter)) 
	{
		$filter       = $_SESSION['pcs']['clubsfilter'];
		$countryfilter   = $_SESSION['pcs']['clubscountryfilter'];
	
		if (!isset($filter)) 
		{
			$filter = $config['filterdefault'];
			$countryfilter = $config['countryfilterdefault'];
		}
	}
	
	$_SESSION['pcs']['clubsfilter']  = $filter;
	$_SESSION['pcs']['clubscountryfilter']  = $countryfilter;
	$_SESSION['pcs']['nationalteamfilter']  = $nationalteamfilter;
	
	// standard filters
	$filter_expr = array(
	  'NUM'  => '^["\\\' ]*[^A-Za-z]',  // simplified '^["\\\' ]*[^ABCabcDEFdefGHIghiJKLjklMNOmnoPQRSpqrsTUVtuvWXZwxy"\\\' ]',
	  'ABC'  => '^["\\\' ]*[ABCabc]',
	  'DEF'  => '^["\\\' ]*[DEFdef]',
	  'GHI'  => '^["\\\' ]*[GHIghi]',
	  'JKL'  => '^["\\\' ]*[JKLjkl]',
	  'MNO'  => '^["\\\' ]*[MNOmno]',
	  'PQRS' => '^["\\\' ]*[PQRSpqrs]',
	  'TUV'  => '^["\\\' ]*[TUVtuv]',
	  'WXYZ' => '^["\\\' ]*[WXZwxy]'
	);
	
	
	// create SQL according to selected filter
	switch ($filter)
	{
		case 'all':
						$ORDER  = TBL_CLUBS.'.shortname';
						break;
		case 'country':
						$WHERES = 'WHERE '.TBL_CLUBS.'.country = '.$countryfilter;
						$ORDER  = TBL_CLUBS.'.shortname';
						break;
		case 'full':
						$WHERES = 'WHERE 1=1';  // secret filter for exposing all data
						break;
		default:
						// make sure filter is valid
						if (!array_key_exists($filter, $filter_expr)) $filter = 'ABC';
						// apply filter
						$WHERES = 'WHERE '.TBL_CLUBS.'.shortname RLIKE \''.$filter_expr[$filter].'\'';
	}
	
	if ($countryfilter) {
		if ($WHERES) {$WHERES .= ' AND ';}
		else {$WHERES .= ' WHERE ';}
		$WHERES .= TBL_CLUBS.'.country=\''.$countryfilter.'\'';
	}
	
	if (!$teamfilter) {
		if ($config['nationalclubbydefault']) {$teamfilter = 1;}
		else {$teamfilter=2;}
	}
	$smarty->assign('teamfilter', $teamfilter);

	
	if ($teamfilter == 1) {
		if ($WHERES) {$WHERES .= ' AND ';}
		else {$WHERES .= ' WHERE ';}
		$WHERES .= TBL_CLUBS.'.nationalteam=\''.$teamfilter.'\'';
	}

	else {
		if ($WHERES) {$WHERES .= ' AND ';}
		else {$WHERES .= ' WHERE ';}
		$WHERES .= TBL_CLUBS.'.nationalteam != 1';
	}
	
	// default order
	if (!$ORDER)  {
		$ORDER   = TBL_CLUBS.'.shortname';
	}

}

//IF SEARCH ACTION
//DEFINE QUERY
// prepare search query
else {
require_once './core/queryparser.php';
$fields = array('longname', 'shortname', 'city', 'plot');
$QUERY = '';

	if (!empty($q))
	{
		$error  = '';
		$tokens = queryparser($q, $error);
		$wild_char = (empty($nowild)) ? '%' : '';

		foreach ($tokens as $token)
		{
            // escape search token
			$token['token'] = addslashes($token['token']);
            // concatenate tokens with token operator
			$QUERY .= $token['ops'].' (';
            // concatenate all searchable fields with OR
			foreach ($fields as $field) {
				$QUERY .= " ($field LIKE '$wild_char".$token['token']."$wild_char') OR ";
			}
			$QUERY .= ' 1=2)';
		}
	$WHERES = "WHERE 1=1 ".$QUERY;
	
	}
$smarty->assign('q', $q); 
$ORDER   = TBL_CLUBS.'.longname DESC';
}




// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
                              FROM '.TBL_CLUBS.' '.$WHERES);
 
// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned


// do hard work
$select = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.longname, '.TBL_CLUBS.'.imgurl FROM '.TBL_CLUBS.' '.$WHERES.' ORDER BY '.$ORDER.' '.$LIMIT;
$result = runSQL($select);
$smarty->assign('number', count($result));


// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);

//DISPLAY PAGE
// prepare
tpl_page('clubs');
tpl_list($result);
tpl_filters_clubs($filter, $countryfilter, $nationalteamfilter);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');
smarty_display('filters_clubs.tpl');
if (!$config['http_caching']) flush();

smarty_display('list_clubs.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('clubs', httpCacheCaptureEnd());
} 
?>