<?php
/**
 * calendar page
 *
 * Display calendar for form page.
 *
 * @package Setup
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: lookup_calendar.php,v 1.00 2006/12/06 18:15:00
 */

require_once './core/functions.php';
require_once './core/template.php';

// Definition des mois
$mymonths = Array($lang['month01'], $lang['month02'], $lang['month03'], $lang['month04'], $lang['month05'], $lang['month06'], 
		  $lang['month07'], $lang['month08'], $lang['month09'], $lang['month10'], $lang['month11'], $lang['month12']);

// Definition des mois
$myyears = Array(2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010);

if ($mymonth && $myyear) {
$periode = mktime(0, 0, 0, $mymonth, 1, $myyear);
}
else {
$periode = time();
}

$monthperiode = Date("m", $periode);
$yearperiode = Date("Y", $periode);
$tableau = Array("0", "1", "2", "3", "4", "5", "6", "0");

//Matchs date
$SELECT = 'SELECT count('.TBL_MATCHS.'.id) AS count, DAY('.TBL_MATCHS.'.date_day) AS day, '.TBL_DAYS.'.day AS id_day, '.TBL_DAYS.'.id_compet, '.TBL_DAYS.'.id_season, '.TBL_COMPETITIONS.'.shortname FROM '.TBL_MATCHS.'
JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id
JOIN '.TBL_COMPETITIONS.' ON '.TBL_DAYS.'.id_compet = '.TBL_COMPETITIONS.'.id
WHERE YEAR('.TBL_MATCHS.'.date_day) = '.$yearperiode.' AND MONTH('.TBL_MATCHS.'.date_day) = '.$monthperiode.' 
GROUP BY '.TBL_COMPETITIONS.'.id, DAY('.TBL_MATCHS.'.date_day) ORDER BY '.TBL_MATCHS.'.date_day';
$allmatchs = runSQL($SELECT);

  
$nb_jour = Date("t", $periode);
$indexe = 1;
$pas=0;
$myweek=1;

while ($pas < $nb_jour) {

    if (Date("w", mktime(0, 0, 0, $monthperiode, 1 + $pas, $yearperiode)) == $tableau[$indexe]) {
	$dday = 1;
	$daytag = Date("d", mktime(0, 0, 0, $monthperiode, 1 + $pas, $yearperiode));
    // Si jour calendrier == aujourd'hui
    $dates[$myweek][$indexe] = $daytag;
	
		//Evenement de la journe
		for ($x=0; $x<count($allmatchs); $x++) {
			if ($allmatchs[$x]['day'] == 1 + $pas) {
			$mydates[$daytag][$dday]['shortname'] =  $allmatchs[$x]['shortname'];
			$mydates[$daytag][$dday]['count'] =  $allmatchs[$x]['count'];
			
			$mydates[$daytag][$dday]['id_compet'] = $allmatchs[$x]['id_compet'];
			$mydates[$daytag][$dday]['id_season'] = $allmatchs[$x]['id_season'];
			$mydates[$daytag][$dday]['day'] = $allmatchs[$x]['id_day'];
			$dday++;
			}
		}
    $pas++;
    }
    else {
    $dates[$myweek][$indexe] = '';
    }

	if ($indexe == 7 && $pas < $nb_jour) {
	$myweek++; $indexe = 1;
	} 
	else {
	$indexe++;
	}
}

// Ajustement du tableau
for ($i = $indexe; $i <= 7; $i++) {
$dates[$myweek][$indexe] = '';
}

$smarty->assign('pmonth',	$monthperiode);
$smarty->assign('pyear',	$yearperiode);
$smarty->assign('month',	$lang[month.$monthperiode]);
$smarty->assign('months',	$mymonths);
$smarty->assign('years',	$myyears);
$smarty->assign('style',	$config['style']);
$smarty->assign('langcode', $config['language']);
$smarty->assign('year',     $yearperiode);
$smarty->assign('dates',    $dates);
$smarty->assign('mydates',  $mydates);
//DISPLAY PAGE
// prepare
tpl_page('calendar');

smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('calendar.tpl');
smarty_display('footer.tpl');
?>
