#include "examplewindow.h"

ExampleWindow::ExampleWindow()
: m_VBox(Gtk::ORIENTATION_VERTICAL)
{
  set_title("Simple Widget");
  set_default_size(100, 100);

  add(m_VBox);
  m_VBox.pack_start(m_EventBox, Gtk::PACK_EXPAND_WIDGET);

  m_EventBox.add(m_SimpleWidget);
  m_EventBox.set_events(Gdk::BUTTON_PRESS_MASK|Gdk::SCROLL_MASK|Gdk::POINTER_MOTION_MASK);
  m_EventBox.signal_button_press_event().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_eventbox_button_press) );

  m_EventBox.signal_button_release_event().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_eventbox_button_release) );

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

bool ExampleWindow::on_eventbox_button_press(GdkEventButton* button_event)
{
  m_SimpleWidget.set_red();
  m_SimpleWidget.queue_draw();
  return true;
}

bool ExampleWindow::on_eventbox_button_release(GdkEventButton* button_event)
{
  m_SimpleWidget.reset_color();
  m_SimpleWidget.queue_draw();
  return true;
}