#include "simplewidget.h"
#include <gdkmm/general.h>
#include <iostream>
#include <cstring>


SimpleWidget::SimpleWidget() :
  Glib::ObjectBase("simplewidget"),
  Gtk::Widget()
{
  w_color.red = 0.8;
  w_color.green = 0.8;
  w_color.blue = 0.8;
  w_color.alpha = 1;
  std::cout << "GType name: " << G_OBJECT_TYPE_NAME(gobj()) << std::endl;
}

SimpleWidget::~SimpleWidget()
{
}

Gtk::SizeRequestMode SimpleWidget::get_request_mode_vfunc() const
{
  return Gtk::Widget::get_request_mode_vfunc();
}

void SimpleWidget::get_preferred_width_vfunc(int& minimum_width, int& natural_width) const
{
  minimum_width = 100;
  natural_width = 100;
}

void SimpleWidget::get_preferred_height_for_width_vfunc(int /* width */,
   int& minimum_height, int& natural_height) const
{
  minimum_height = 100;
  natural_height = 100;
}

void SimpleWidget::get_preferred_height_vfunc(int& minimum_height, int& natural_height) const
{
  minimum_height = 100;
  natural_height = 100;
}

void SimpleWidget::get_preferred_width_for_height_vfunc(int /* height */,
   int& minimum_width, int& natural_width) const
{
  minimum_width = 100;
  natural_width = 100;
}

void SimpleWidget::on_size_allocate(Gtk::Allocation& allocation)
{
  set_allocation(allocation);

  if(m_refGdkWindow)
  {
    m_refGdkWindow->move_resize( allocation.get_x(), allocation.get_y(),
            allocation.get_width(), allocation.get_height() );
  }
}

void SimpleWidget::on_realize()
{
  set_realized();

  if(!m_refGdkWindow)
  {
    GdkWindowAttr attributes;
    memset(&attributes, 0, sizeof(attributes));

    Gtk::Allocation allocation = get_allocation();

    attributes.x = allocation.get_x();
    attributes.y = allocation.get_y();
    attributes.width = allocation.get_width();
    attributes.height = allocation.get_height();

    attributes.event_mask = get_events () | Gdk::EXPOSURE_MASK;
    attributes.window_type = GDK_WINDOW_CHILD;
    attributes.wclass = GDK_INPUT_OUTPUT;

    m_refGdkWindow = Gdk::Window::create(get_parent_window(), &attributes,
            GDK_WA_X | GDK_WA_Y);
    set_window(m_refGdkWindow);

    //make the widget receive expose events
    m_refGdkWindow->set_user_data(gobj());
  }
}

bool SimpleWidget::on_draw(const Cairo::RefPtr<Cairo::Context>& cr)
{
  const Gtk::Allocation allocation = get_allocation();
  const double scale_x = (double)allocation.get_width() / 100.0;
  const double scale_y = (double)allocation.get_height() / 100.0;

  cr->set_source_rgba(w_color.red, w_color.green, w_color.blue, w_color.alpha);
  cr->rectangle(10*scale_x, 10*scale_y, 80*scale_x, 80*scale_y);
  cr->fill();

  return true;
}

void SimpleWidget::on_parsing_error(const Glib::RefPtr<const Gtk::CssSection>& section, const Glib::Error& error)
{
  std::cerr << "on_parsing_error(): " << error.what() << std::endl;
}

void SimpleWidget::set_red()
{
  w_color.red = 1.0;
  w_color.green = 0.0;
  w_color.blue = 0.0;
  w_color.alpha = 1;  
}

void SimpleWidget::reset_color()
{
  w_color.red = 0.8;
  w_color.green = 0.8;
  w_color.blue = 0.8;
  w_color.alpha = 1;
}