unit uRotationDeplacementXE10;

// Auteur : Alain Weber
// Date AAAAMMJJ : 20170702
// email : alainweberfmx@gmail.com
// libre de copie en conservant les informations sur l'auteur
// TRotationDeplacement3axes - Traitement rotation dplacement et profondeur

interface

uses
  System.Classes, System.Types, System.UITypes, System.SysUtils, System.Math,
  FMX.Types, FMX.Types3D, System.Math.Vectors, FMX.StdCtrls, FMX.Objects3D,
  FMX.Controls3D, FMX.Viewport3D, FMX.MaterialSources, FMX.Dialogs;

type
  TRotationDeplacement3axes = class
  private
    fRotationObjet: TPoint3D;
    fPositionObjet: TPoint3D;
  public
    bMouseActif: boolean;
    bRotationActif: boolean;
    aCtrl3DXY: TControl3D;
    aViewport: TViewport3D;
    PositionSouris: TPointf;
    CorrectionRotation: TPoint3D;
    CorrectionPosition: TPoint3D;
    InterpoleYZ: boolean;
    ProfondeurInit: Integer;
    Profondeur: Integer;
    HauteurdeBase: Integer;
    NbrePas: Integer;
    constructor Create(aCtrl3D: TControl3D; aVP: TViewport3D);
    procedure InitialiseWheelPAram(HauteurdeBase1, NbrePas1,
      Profondeur1: Integer);
    procedure MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Single);
    procedure MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single);
    procedure ReportMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Single;
      RayPos, RayDir: TVector3D);
    procedure ReportMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
    procedure ReportMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
    procedure ReportMouseEvent(aControl3D: TControl3D);
    procedure MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
      X, Y: Single);
    procedure aViewport3MouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; var Handled: boolean);
    procedure DessineObjet;
    procedure Reset;
  end;

var
  arCubeX3D: array [0 .. 3] of TStrokeCube; // Cube  ;
  DummyPourCube: TDummy; // pour dterminer la position relative autres fenetres
  bMoveActif: boolean = true;
  MiseAJourEnCOurs: boolean = false;

implementation

{ TRotation2axes }

procedure TRotationDeplacement3axes.aViewport3MouseWheel(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; var Handled: boolean);

  function f1(Line1, Col1: Integer): Single;
  begin
    result := ((Col1 / (NbrePas - Line1)) - (1 / NbrePas)) * 1.23 * NbrePas;
  end;

begin
  if (WheelDelta < 0) then
    Profondeur := Profondeur + 1;
  if (WheelDelta > 0) then
    Profondeur := Profondeur - 1;
  if Profondeur > (NbrePas - 1) then
    Profondeur := NbrePas - 1;
  if Profondeur < 0 then
    Profondeur := 0;
  fPositionObjet.Y := f1(Profondeur, HauteurdeBase);
  DessineObjet;
end;

constructor TRotationDeplacement3axes.Create(aCtrl3D: TControl3D;
  aVP: TViewport3D);
begin
  aCtrl3DXY := aCtrl3D;
  aViewport := aVP;
  fRotationObjet := Point3D(0, 0, 0);
  CorrectionRotation := Point3D(0, 0, 0);
  aViewport.OnMouseDown := MouseDown;
  aViewport.OnMouseMove := nil;
  bMouseActif := false;
  bRotationActif := true;
  CorrectionPosition := Point3D(1, 1, 1);
  InterpoleYZ := false;
  aViewport.OnMouseUp := MouseUp;
end;

procedure TRotationDeplacement3axes.MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Single);
begin
  if not bMoveActif then
    exit;
  PositionSouris := PointF(X, Y); // Pour MouseMove
  aViewport.OnMouseMove := MouseMove;
  bMouseActif := true;
end;

procedure TRotationDeplacement3axes.MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single);
const
  k1 = 0.01;
var
  Delta: TPointf;
  h2, depl: Single;
begin
  if not bMoveActif then
    exit;
  Delta := PointF(PositionSouris.X - X, PositionSouris.Y - Y);
  // Privilgie le plus grand des deux
  if abs(Delta.X) > abs(Delta.Y) then
    Delta.Y := 0
  else
    Delta.X := 0;
  if bRotationActif then
  begin
    if (abs(Delta.X) + (abs(Delta.Y)) < 5) then
      exit;
    h2 := TViewport3D(Sender).Height; // / 2;
    PositionSouris := PointF(X, Y);
    if (Y <= h2) and (Delta.X <> 0) then
      Delta.X := -Delta.X;
    if ssLeft in Shift then
    begin
      fRotationObjet.Z := fRotationObjet.Z + ((Delta.X) / 3);
      fRotationObjet.X := fRotationObjet.X - (Delta.Y / 3);
    end;
    if ssRight in Shift then
      fRotationObjet.Y := fRotationObjet.Y + (Delta.X / 3);
  end
  else
  begin
    if (abs(Delta.X) + (abs(Delta.Y)) < 10) then
      exit;
    if Delta.Y = 0 then
    begin
      if Delta.X > 0 then
        depl := k1
      else
        depl := -k1;
      fPositionObjet.X := fPositionObjet.X - depl ;
    end;
    if Delta.X = 0 then
    begin
      if Delta.Y > 0 then
        depl := k1
      else
        depl := -k1;
      fPositionObjet.Z := fPositionObjet.Z + depl ;
    end;
  end;
  DessineObjet;
end;

procedure TRotationDeplacement3axes.MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Single);
begin
  aViewport.OnMouseMove := nil;
  bMouseActif := false;
end;

procedure TRotationDeplacement3axes.ReportMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Single;
  RayPos, RayDir: TVector3D);
begin
  MouseDown(aViewport, Button, Shift, X, Y);
end;

procedure TRotationDeplacement3axes.ReportMouseEvent(aControl3D: TControl3D);
begin
  aControl3D.OnMouseDown := ReportMouseDown;
  aControl3D.OnMouseMove := ReportMouseMove;
  aControl3D.OnMouseUp := ReportMouseUp;
end;

procedure TRotationDeplacement3axes.ReportMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Single; RayPos, RayDir: TVector3D);
begin
  if bMouseActif then
    MouseMove(aViewport, Shift, X, Y);
end;

procedure TRotationDeplacement3axes.ReportMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Single;
  RayPos, RayDir: TVector3D);
begin
  MouseUp(aViewport, Button, Shift, X, Y);
end;

procedure TRotationDeplacement3axes.Reset;
var
  b1: boolean;
begin
  fRotationObjet := Point3D(0, 0, 0);
  Profondeur := ProfondeurInit;
  fPositionObjet := Point3D(0, 0, 0);
  Profondeur := ProfondeurInit;
  aViewport3MouseWheel(nil, [ssShift], 0, b1);
end;

procedure TRotationDeplacement3axes.InitialiseWheelPAram(HauteurdeBase1,
  NbrePas1, Profondeur1: Integer);
var
  b1: boolean;
begin
  Profondeur := Profondeur1;
  ProfondeurInit := Profondeur1;;
  HauteurdeBase := HauteurdeBase1;
  NbrePas := NbrePas1;
  aViewport3MouseWheel(nil, [ssShift], 0, b1);
  aViewport.OnMouseWheel := aViewport3MouseWheel;
end;

procedure TRotationDeplacement3axes.DessineObjet;
begin
  if MiseAJourEnCOurs then
    exit;
  MiseAJourEnCOurs := true;
  aCtrl3DXY.BeginUpdate;
  aCtrl3DXY.ResetRotationAngle;
  aCtrl3DXY.RotationAngle.X := fRotationObjet.X;
  aCtrl3DXY.RotationAngle.Y := fRotationObjet.Y;
  aCtrl3DXY.RotationAngle.Z := fRotationObjet.Z;
  aCtrl3DXY.Position.X := fPositionObjet.X;
  aCtrl3DXY.Position.Y := fPositionObjet.Y;
  aCtrl3DXY.Position.Z := fPositionObjet.Z;
  aCtrl3DXY.EndUpdate;
  MiseAJourEnCOurs := false;
  aCtrl3DXY.Repaint;
end;

end.
