unit HorlogeFMXa;

// Auteur : Alain Weber
// Date AAAAMMJJ : 20170702
// email : alainweberfmx@gmail.com
// libre de copie en conservant les informations sur l'auteur

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  System.Math.Vectors, FMX.Types3D, FMX.Objects3D, FMX.MaterialSources,
  FMX.Controls3D, FMX.Viewport3D, uRotationDeplacementXE10,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Ani, FMX.Layers3D, FMX.Objects,
  FMX.Edit, FMX.EditBox, FMX.SpinBox;

type
  TForm1 = class(TForm)
    Viewport3D1: TViewport3D;
    Light1: TLight;
    Dummy1: TDummy;
    Dummy2: TDummy;
    Light2: TLight;
    Button1: TButton;
    Panel1: TPanel;
    cbRotation: TCheckBox;
    Timer1: TTimer;
    StrokeCube1: TStrokeCube;
    Dummy3: TDummy;
    Sphere1: TSphere;
    TextureMaterialSource1: TTextureMaterialSource;
    Cylinder1: TCylinder;
    Dummy4: TDummy;
    Dummy5: TDummy;
    Cylinder2: TCylinder;
    Dummy6: TDummy;
    Cylinder3: TCylinder;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure cbRotationChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure Timer1Timer(Sender: TObject);
  end;

var
  Form1: TForm1;
  aRotationDeplacement3axes: TRotationDeplacement3axes;
  P1, R1, P2, R2: TPoint3D;

implementation

{$R *.fmx}

procedure TForm1.Button1Click(Sender: TObject);
begin
  aRotationDeplacement3axes.Reset;
end;

procedure TForm1.cbRotationChange(Sender: TObject);
begin
  aRotationDeplacement3axes.bRotationActif := cbRotation.IsChecked;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  if aRotationDeplacement3axes <> nil then
    exit;
  aRotationDeplacement3axes := TRotationDeplacement3axes.create(Dummy2,
    Viewport3D1);
  aRotationDeplacement3axes.InitialiseWheelPAram(1, 24, 7);
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  cbRotation.IsChecked := not cbRotation.IsChecked;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  HH,MN,SS,MS :Word;
begin
  DecodeTime(Now,HH,MN,SS,MS);
  Dummy6.RotationAngle.Z := -30 * HH + 90 ; // 30 = 360 / 24
  Dummy5.RotationAngle.Z := -6 * MN + 90 ; // 6 = 360 / 60
  Dummy4.RotationAngle.z := -6 * SS + 90   ;
  //Dummy5
end;

end.
