/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Roulette;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PanelRoulette
extends JPanel {
    private static final long serialVersionUID = 1L;
    static BufferedImage imagechiffres = null;
    int Size = 160;
    Roulette roulette = new Roulette();

    public static void main(String[] args) throws IOException {
        JFrame frame = new JFrame();
        frame.setSize(320, 200);
        PanelRoulette pr = new PanelRoulette(160);
        frame.add(pr);
        frame.setVisible(true);
    }

    public PanelRoulette(int dimension) throws IOException {
        this.Size = dimension;
        if (imagechiffres == null) {
            imagechiffres = ImageIO.read(this.getClass().getResource("chiffres.jpg"));
            Image k = imagechiffres.getScaledInstance(this.Size, this.Size * 11, 16);
            imagechiffres = PanelRoulette.toBufferedImage(k);
        }
        this.initialize();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = false;
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private void initialize() {
        Dimension dim = new Dimension(this.Size, this.Size);
        this.setSize(this.Size, this.Size);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int V0 = (int)this.roulette.position - 1;
        float V1 = this.roulette.position / 1.018f;
        float remains = this.roulette.position - V1;
        g.drawImage(imagechiffres, 0, 0, this.Size, this.Size, 0, (int)(0.0f + V1 * (float)this.Size) + this.Size / 8, this.Size, this.Size + (int)(0.0f + V1 * (float)this.Size) + this.Size / 8, this);
    }
}

