# -*- coding: utf-8 -*-
"""
Copyright 2009 Vincent Maillol Benoît Gaëtan

This file is part of mbg Sqlite.

mbg Sqlite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mbg Sqlite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mbg Sqlite.  If not, see <http://www.gnu.org/licenses/>.
"""

import sqlite3 as sqlite
import re


def parse( connection ):
    #con = sqlite.connect( bdd_name )

    cur = connection.cursor()
    cur.execute( "select name, sql from sqlite_master where type = 'table' " )
    table_and_sql = cur.fetchall()


    table_constraint = {}
    regex_pk = re.compile( r"PRIMARY\s*KEY\s*\(\s*((\w*,?\s*)*)", re.IGNORECASE )
    regex_pk_multiple = re.compile( r"[\(,]\s*(\w+).*\sPRIMARY\s*KEY", re.IGNORECASE)
    
    regex_fk = re.compile( r"FOREIGN\s+KEY\s*\(((?:\s*\w+\s*,?)+)\)\s*REFERENCES\s+(\w+)\s*\(((?:\s*\w+\s*,?)+)\s*\)", re.IGNORECASE)
    regex_fk2 = re.compile(  r",\s*(?!FOREIGN)(\w+).*\sREFERENCES\s*(\w*)\s*\(((\s*\w*\s*,?)*)", re.IGNORECASE)

    for table, sql in table_and_sql :
        
        # Recherche des champs.
        cur.execute( "select * from %s" % table )
        fieldNames = [ fieldName[ 0 ].lower() for fieldName in cur.description ]

        # Recherche des clefs primaires.
        if regex_pk.findall( sql ) != [] :
            pks = regex_pk.findall( sql )[ 0 ][ 0 ]
            pk = [ champ.strip().lower() for champ in pks.split(",") ]      
        elif regex_pk_multiple.findall( sql ) != []  :
            pk = regex_pk_multiple.findall( sql )
        else :
            pk = []
     
        # Recherche des clefs Ã©trangÃ©res.
        fk = []
        if regex_fk.findall( sql ) != [] : 
            for iterable in regex_fk.findall( sql ):
                for champ, champ_etrange in zip( iterable[0].split( ',' ), iterable[2].split( ',' ) ):
                    fk.append( [ champ.strip().lower(), iterable[1].lower(), champ_etrange.strip().lower() ] )
                
        elif regex_fk2.findall( sql ) != [] :
            for iterable in regex_fk2.findall( sql ):
                fk.append( [ e.strip().lower() for e in iterable if e != '' ] )

        # Insertion des donnÃ©es dans un dictionnaire.
        table_constraint[ table.lower() ] = { "field" : fieldNames,
                                      "pks"   : pk,
                                      "fks"   : fk}
    cur.close()
    return table_constraint

if __name__ == "__main__" :

    con = sqlite.connect( ":memory:" )
    cur = con.cursor()
    try :
        cur.execute( """CREATE TABLE a ( id INTEGER NOT NULL PRIMARY KEY, id2, data );""" )
        cur.execute( """CREATE TABLE b ( ID INTEGER NOT NULL PRIMARY KEY );""" )
        cur.execute( """CREATE TABLE C (
           id INTEGER NOT NULL PRIMARY KEY,
           a_iD INTEGER NOT NULL CONSTRAINT fk_id_a REFERENCES  a ( id ),
           b_id INTEGER NOT NULL CONSTRAINT fk_id_b REFERENCES  B  (ID) );""" )
        cur.execute( """CREATE TABLE d (
           a_id INTEGER NOT NULL,
           b_Id INTEGER NOT NULL,
           foreign key (a_id, b_id) references   A( id , id2 ) ,
           foreign key (b_id) references b( id ) );""" )
        cur.execute( """CREATE TABLE vendre(
           cliENt_id INTEGER NOT NULL,
           fouRNisseur_id INTEGER NOT NULL,
           primary key ( cliENT_id, fournisseur_id)); """ )

        
    except Exception as error :
        print( error )

    d = parse( con )
    for k, v in d.items():
        print( "\ntable :", k )
        for k2, v2 in v.items() :
            print( "\t", k2, "-->", v2 )

    cur.close()
    con.close()
