# -*- coding: utf-8 -*-
"""
Copyright 2009 Vincent Maillol Benoît Gaëtan

This file is part of mbg Sqlite.

mbg Sqlite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mbg Sqlite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mbg Sqlite.  If not, see <http://www.gnu.org/licenses/>.
"""

from platform import python_version
is_version_3 = python_version().startswith( '3' )

if is_version_3 :
    from tkinter import Listbox, Toplevel, Scrollbar, StringVar, IntVar, Button, Label, LabelFrame, Entry, Checkbutton
    import tkinter.messagebox as messagebox
    import tkinter.filedialog as filedialog
else :
    from Tkinter import Listbox, Toplevel, Scrollbar, StringVar, IntVar, Button, Label, LabelFrame, Entry, Checkbutton   
    import tkMessageBox as messagebox
    import tkFileDialog as filedialog

import pickle
import otherWidget.infobull as infobull
import sqlite3


class Searchconnection( Toplevel ):
    """
    Fenêtre pour la recherche d'une connexion.
    Permet l'ouverture d'un navigateur de fichier et
    d'afficher les connexions récentes 
    """

    def __init__(self, master=None, file_name="old.pkl", variable = StringVar, cnf={}, **kw) :
        Toplevel.__init__(self, master, cnf, **kw)

        self.file_name = file_name
        file_ac = open( file_name, "rb" )
        self.anciennes_connexions = pickle.loads( file_ac.read() )
        file_ac.close()

        self.cheminVar = variable
        self.var = IntVar()# Pour le checkButton

        self.frame_1 = LabelFrame( self, text = "Ouvrir"              )
        self.frame_2 = LabelFrame( self, text = "Nouvelle"            ) 
        self.frame_3 = LabelFrame( self, text = "Récemment utilisées" )
        
        # Widgets enfants de la frame 1.
        self.but_1 = Button( self.frame_1, text = "Ouvrir", command = self.ouvrir_bdd )
        # Widgets enfants de la frame 2.        
        self.lab_1 = Label ( self.frame_2, anchor = "e", text = "Travailler en RAM : " )
        self.chkbt = Checkbutton( self.frame_2, variable=self.var,
                    offvalue=0, onvalue=1, command=self.change_state_entry ) 
        self.lab_2 = Label ( self.frame_2, anchor = "e", text = "Nom BDD : " )
        self.entry = Entry ( self.frame_2)
        self.but_2 = Button( self.frame_2, text = "Connexion", command = self.make_bdd )       
        # Widgets enfants de la frame 3.
        self.listbox    = Listbox(   self.frame_3)
        self.scrollbarV = Scrollbar( self.frame_3, command = self.listbox.yview)
        self.scrollbarH = Scrollbar( self.frame_3, command = self.listbox.xview, orient = "horizontal")
        self.listbox.configure( yscrollcommand = self.scrollbarV.set )
        self.listbox.configure( xscrollcommand = self.scrollbarH.set )
        self.but_3     = Button(    self.frame_3, text = "Connexion", command = self.open_selected_bdd )
        for i, con in enumerate( self.anciennes_connexions ) :
            self.listbox.insert( "end", con )           
            infobull.InfobullListbox( self.listbox, i ,con )
        #GDP
        self.frame_1.grid( row = 0, column = 0, sticky = "we", pady = 2, padx = 2 )
        self.frame_2.grid( row = 1, column = 0, sticky = "we", pady = 2, padx = 2 )        
        self.frame_3.grid( row = 2, column = 0, sticky = "we", pady = 2, padx = 2 )    

        self.but_1.grid( row = 0, column = 0, sticky='e' )

        self.lab_1.grid( row=0, column=0, sticky='e' )
        self.chkbt.grid( row=0, column=1, sticky='w')
        self.lab_2.grid( row=1, column=0, sticky='e' )
        self.entry.grid( row=1, column=1, sticky='w')
        self.but_2.grid( row=2, column=1, sticky='e' )

        self.listbox.grid(   row = 0, column = 0)
        self.scrollbarV.grid(row = 0, column = 1, sticky = "ns")
        self.scrollbarH.grid(row = 1, column = 0, sticky = "ew")
        self.but_3.grid(     row = 0, column = 2, sticky = "s" )

        #GDE
        self.listbox.bind( "<Double-Button-1>", self.open_selected_bdd  )

    def change_state_entry( self ):
        """
        DÃ©sactive le champ de saisie pour le nom d'une nouvelle bdd
        si l'utilisateur a cochÃ© "travailler en RAM" ( chkbut ). 
        """
        if self.var.get() :
            self.entry.config( state = 'disable' )
            self.lab_2.config( state = 'disable' )
        else :
            self.entry.config( state = 'normal' )
            self.lab_2.config( state = 'normal' )

    def ouvrir_bdd( self ):
        """
        Recherche une base de donnÃ©es dans l'arborescence de fichiers.
        """
        chemin = filedialog.askopenfilename(filetypes= [ ('sqlite3','*.db3'), ('tous','*.*') ])
        if chemin != '' :
            file = open( chemin, 'rb' )
            entete = file.read( 15 )
            file.close()

            fichier_valide =( entete == b"SQLite format 3" )

            if not fichier_valide :
                fichier_valide = \
                "yes" == messagebox.askquestion( '', "Le fichier sÃ©lectionnÃ© semble ne pas Ãªtre valide.\n Voulez-vous l'ouvrir  ?", icon = "warning" )

            if fichier_valide :
                try :
                    sqlite3.connect( chemin ).execute("select * from sqlite_master")
                except Exception as sqlite_msg :
                    messagebox.showerror("Erreur Sqlite3", "Sqlite3 ne peut pas ouvrir ce fichier.\n%s" % sqlite_msg )
                else :
                    if chemin not in self.anciennes_connexions :
                        self.anciennes_connexions.insert( 0, chemin )
                        a = pickle.dumps( self.anciennes_connexions )
                        file_ac = open( self.file_name, 'wb' )
                        file_ac.write( a )
                        file_ac.close()

                    self.cheminVar.set(chemin)      
            
    def make_bdd( self ) :
        if self.var.get() :
            self.cheminVar.set( ":memory:")
        else :
            chemin = ( filedialog.asksaveasfilename( initialfile = self.entry.get(),
                                          defaultextension = ".db3" ) )
            if chemin != '' :
                self.anciennes_connexions.insert( 0, chemin )
                a = pickle.dumps( self.anciennes_connexions )
                file_ac = open( self.file_name, 'wb' )
                file_ac.write( a )
                file_ac.close()
                self.cheminVar.set( chemin )
                
    def open_selected_bdd( self, event = None ) :
        """
        Ouvre une base de donnÃ©es sÃ©lectionnÃ©e dans la listbox. 
        """
        indices = self.listbox.curselection()
        if indices == () :
            messagebox.showinfo("", "Vous devez sÃ©lectionner une base de donnÃ©es dans la liste avant\n de cliquer sur ce bouton de connexion ")
        else :
            self.cheminVar.set( self.listbox.get( indices[0] ) )

if __name__ == "__main__" :
    from tkinter import *

    root = Tk()
    var = StringVar()
    lab = Label( root, text="En attente...")
    lab.pack()
    print("1")
    Searchconnection( root, variable = var )
    print("2")
    root.wait_variable( var )
    print("3")
    lab.configure( text = var.get() )
    print("4")
    root.mainloop()
    

