# -*- coding: utf-8 -*-
"""
Copyright 2009 Vincent Maillol BenoÃ®t GaÃ«tan

This file is part of mbg Sqlite.

mbg Sqlite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mbg Sqlite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mbg Sqlite.  If not, see <http://www.gnu.org/licenses/>.
"""
from platform import python_version
is_version_3 = python_version().startswith( '3' )

if is_version_3 :
    from tkinter import Label, Frame
else :
    from Tkinter import Label, Frame


class Onglet( Frame ) :
    """
    Menu sous forme d'onglet.
    Chaque label est rattachÃ© Ã  une frame, un clic sur un label affiche la frame correspondante 
    """
    def __init__( self, master = None,  labels = (), position = 'top' ) :
        """
        Options :
            labels => ( 'nom_onglet_1', 'nom_onglet_2', 'nom_onglet_3' )
            position => 'bottom' | 'top'
        """
        Frame.__init__( self, master )
        
        nmb_onglet = len( labels )
        self.__frames = {}        # { 'text_label' : Frame(), ... }
        self.__label_actif = None # Label()
        self.frame_label = Frame( self ) 
        self.__last_column = 0 # DerniÃ¨re position grinder
        
        if position == 'top' :
            self.row_label = 0
            self.row_frame = 1
        elif position == 'bottom' :
            self.row_label = 1
            self.row_frame = 0
        else :
            raise ValueError( "bad position %r: must be top or bottom" % position )

        self.rowconfigure( self.row_frame, weight=1 )

        if nmb_onglet > 0 :
            for i in range( nmb_onglet ) :
                self.frame_label.columnconfigure( i, weight=1 )

            for i, text in enumerate( labels ) :
                if i > 0 :
                    lab = Label( self.frame_label, text = text, relief = 'sunken' )
                else :
                    lab = Label( self.frame_label, text = text, relief = 'flat' )
                    self.__label_actif = lab
                lab.grid( row = self.row_label, column = i )
                lab.bind( "<Button-1>", self.change_onglet )
                self.__frames[ text ] = Frame( self )
                self.__frames[ text ].grid( row=self.row_frame, column=0, sticky = "nsew" )
                self.__frames[ text ].grid_remove()
                
            self.__last_column = i
            self.__frames[ labels[0] ].grid( row=self.row_frame, column=0, sticky = "nsew" )
        self.frame_label.grid( row=self.row_label, column=0, sticky = 'w' )

    def onglet_actif( self ) :
        "Retourne la clef de l'onglet affichÃ©."
        return self.__label_actif.cget( "text" )

    def add_onglet( self, label ) :
        """
        Ajoute un nouvel onglet, retourne True si l'onglet n'existe pas encore sinon False.
        """
        if label not in self.__frames :
            
            self.__last_column += 1 
            self.frame_label.columnconfigure( self.__last_column, weight=1 )
            
            lab = Label( self.frame_label, text = label, relief = 'flat' )
            lab.bind( "<Button-1>", self.change_onglet )
            lab.grid( row = self.row_label, column = self.__last_column )
            if self.__label_actif is not None :
                self.__frames[ self.__label_actif.cget( 'text' ) ].grid_remove()
                self.__label_actif.configure( relief = 'sunken')
            self.__label_actif = lab
      
            self.__frames[ label ] = Frame( self )
            self.__frames[ label ].grid( row=self.row_frame, column=0, sticky = "nsew" )
            return True
            
        else :
            return False
    
    def change_onglet( self, event ) :
        self.__label_actif.configure( relief = 'sunken' )
        event.widget.configure( relief = 'flat' )
        self.__frames[ event.widget.cget( 'text' ) ].grid()
        if event.widget.cget( 'text' ) != self.__label_actif.cget( 'text' ) :
            self.__frames[ self.__label_actif.cget( 'text' ) ].grid_remove()
        self.__label_actif = event.widget

    def del_onglet( self, text_label ) :
        """
        DÃ©truit l'onglet Label.
        """
        if len( self.__frames ) > 1 :
            # Si l'on dÃ©truit l'onglet actif, on change d'onglet actif. 
            if self.__label_actif.cget( 'text' ) == text_label :
                for key, frame in self.__frames.items() :# Cherche un onglet diffÃ©rant de celui actif. 
                    if key != text_label : break
                    
                # Effectue le changement.
                for label in self.frame_label.grid_slaves() :
                    if label.cget( "text" ) == key : 
                        self.__label_actif = label 
                        label.configure( relief = 'flat' )
                        frame.grid()
                        break
                    
            # Destruction
            self.__frames.pop( text_label ).destroy()
            for label in self.frame_label.grid_slaves() :
                if label.cget( "text" ) == text_label : break

            label.destroy()
                    

        

    def get_frame( self, frame_name ) :
        return self.__frames[ frame_name ]

    def get_onglets( self ) :
        """
        Retourne la liste des onglets.
        """
        return list( self.__frames.keys() )

    def nmb_onglet( self ) :
        """
        Retourne le nombre d'onglet.
        """
        return len( tuple( self.frame_label.grid_slaves() ) )

if __name__ == "__main__" :
    if is_version_3 :
        from tkinter import Tk
    else :
        from Tkinter import Tk
        
    root = Tk()
    MyOnglet = Onglet( root, ('color', 'font'  ), position = 'bottom' )
    MyOnglet.add_onglet( 'size' )
    
    Label( MyOnglet.get_frame( 'color' ), text = 'red' ).grid()
    Label( MyOnglet.get_frame( 'color' ), text = 'blue' ).grid()
    Label( MyOnglet.get_frame( 'color' ), text = 'black' ).grid()
    Label( MyOnglet.get_frame( 'font' ), text = 'Arial send sherif, time new romant' ).grid()
    Label( MyOnglet.get_frame( 'font' ), text = 'new black Courier' ).grid()
    Label( MyOnglet.get_frame( 'size' ), text = '11' ).grid()
    Label( MyOnglet.get_frame( 'size' ), text = '13' ).grid()
    Label( MyOnglet.get_frame( 'size' ), text = '20' ).grid()
    Label( MyOnglet.get_frame( 'size' ), text = '24' ).grid()
    Label( MyOnglet.get_frame( 'size' ), text = '48' ).grid()
    MyOnglet.grid()
    #MyOnglet.del_onglet( 'size' )
    #MyOnglet.add_onglet( 'size' )
    #print( MyOnglet.get_onglets())
    root.mainloop()
