# -*- coding: utf-8 -*-
"""
Copyright 2009 Vincent Maillol Benoît Gaëtan

This file is part of mbg Sqlite.

mbg Sqlite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mbg Sqlite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mbg Sqlite.  If not, see <http://www.gnu.org/licenses/>.
"""
from platform import python_version
is_version_3 = python_version().startswith( '3' )

if is_version_3 :
    from tkinter import *
    import tkinter.font as tkFont
else :
    from Tkinter import *
    import tkFont

# Pour les clef recursif ( gare_dep, gare_arr ) 
class MLD( Canvas ):
    """Canvas pour le dessin des MLD"""
    FAMILLY_FONT = 'Courier New'
    SIZE_FONT    = 10


    def __init__( self, master, **kw  ):
        Canvas.__init__(self, master, **kw )
        # Dico contenant les entities sous le format :
        # { id_entities : (id_item_1_de_l'entities, id_item_2_de_l'entities, ...  ) }.
        self.__idWidjetDict = {}
        
        # Dico contenant les lien sous le format :
        # { id_lien : { table1 : col1, table2 : col2 }, ... }
        self.__linkDictList = {}
        
        self.current_table = None
        #GDE
        self.bind( "<Button-1>",              self.catchItem   )
        self.bind( "<Button1-Motion>",        self.moveItem    )
        self.bind( "<Button1-ButtonRelease>", self.DeCatchItem )

    def link( self, dictTableCol, update = None, **kw ):
        """ 
        dictTableCol = { table1 : col1, table2 : col2 }
        update : id_link
        Relie deux tables par une ligne et retourne sont id. si update est donnÃ©, il servira
        Ã  relier les deux table sinon, une ligne sera crÃ©Ã©e. En cas d'update, l'update est retournÃ©.
        """
        tbl1, tbl2 = dictTableCol.keys()
        
        # Recherche le widjet text dans la table 1 dont le nom est Ã©gal Ã  col1, puis extraie sa position.
        for widjet in self.__idWidjetDict[ tbl1 ] :
            if self.type( widjet ) == "text" :
                if self.itemcget( widjet, "text" ) == dictTableCol[ tbl1 ] :
                    coord1 = list( self.coords( widjet ) )
                    lenTextWidget1 = self.__lenText( self.itemcget( widjet, "text"  ) )
                    break

        #  Recherche le widjet texte dans la table 2 dont le nom est Ã©gal Ã  col2, puis extraie sa position. 
        for widjet in self.__idWidjetDict[ tbl2 ] :
            if self.type( widjet ) == "text" :
                if self.itemcget( widjet, "text" ) == dictTableCol[ tbl2 ] :
                    coord2 = list( self.coords( widjet ) )
                    lenTextWidget2 = self.__lenText( self.itemcget( widjet, "text"  ) )
                    break

        # Pour que le lien soi placÃ© Ã  gauche ou Ã  droite du mot selon la position des tables.
        if coord1[ 0 ] < coord2[ 0 ] :
            # +1 -1, Ã©cart entre le lien et le texte. 
            coord1[ 0 ] += ( lenTextWidget1 +1 )
            coord2[ 0 ] -= 1
                
        elif coord1[ 0 ] > coord2[ 0 ] :
            coord2[ 0 ] += ( lenTextWidget2 +1 )
            coord1[ 0 ] -= 1


        if update is not None :
            self.coords( update, coord1[ 0 ], coord1[ 1 ], coord2[ 0 ], coord2[ 1 ] )
            return update
        else :
            id_link = self.create_line( coord1, coord2, **kw)
            self.__linkDictList[ id_link ] = dictTableCol
            
        return id_link
    
    def __lenText( self, text, style = 'normal' ) :
        "Retourne la taille en pixel de texte" 
        slant   = 'roman'
        weight  = 'normal'
        underline = overstrike = 0
        if 'underline' in style :
            underline  = 1
        if 'overstrike' in style :
            overstrike = 1
        if 'italic' in style :
           slant = 'italic'
        if 'bold' in style :
           weight = 'bold'
        return tkFont.Font( family = self.FAMILLY_FONT, size = self.SIZE_FONT,
                            slant = slant, weight = weight,
                            underline = underline, overstrike = overstrike ).measure( text )


    def create_entity( self, *args, **kw ):
        """
        CrÃ©e une entitÃ© et retourne son id.
        new kw : str head, list columns, list pks, list fks
        """ 

        head    = kw.pop( "head"    ) if "head"    in kw else "head"
        columns = kw.pop( "columns" ) if "columns" in kw else ["",]
        pks     = kw.pop( "pks" )     if "pks"     in kw else ["",]
        fks     = kw.pop( "fks" )     if "fks"     in kw else ["",]

        # Calcul la taille de l'entitÃ©. 
        longueurEntity = max( ( self.__lenText( column ) for column in columns ) )
        longueurEntity = max( ( longueurEntity, self.__lenText( head, "bold" ) ) )
        longueurEntity += 10 #padx

        hauteur = self.SIZE_FONT + 14    # hauteur titre
        hauteur += len( columns ) * ( self.SIZE_FONT + 4 )
 
        idW = []
        x1, y1 = args
        x2 = x1 + longueurEntity
        y2 = y1 + hauteur

        # Dessiner l'entitÃ©.
        idW.append( self.create_rectangle(x1, y1, x2, y2, **kw) )
        idW.append( self.create_line( x1, ( y1 + self.SIZE_FONT + 4 ),
                                      x2, ( y1 + self.SIZE_FONT + 4 ) ) )
        y1 += 8
        x1 += 4
        idW.append( self.create_text(x1, y1, text = head.upper(), font = ( self.FAMILLY_FONT, self.SIZE_FONT, 'bold' ), anchor = W) )
        y1 += 4

        # inscrit les champs dans une police diffÃ©rentes en fonction
        # que le champs sois fk, pk ou autre.
        for column in columns :
            y1 += ( self.SIZE_FONT + 4 )
            if column in pks and column in fks :
                idW.append( self.create_text(x1, y1, text = column, font = ( self.FAMILLY_FONT, self.SIZE_FONT, 'italic', 'underline' ), anchor = W ) )
            elif column in pks :
                idW.append( self.create_text(x1, y1, text = column, font = ( self.FAMILLY_FONT, self.SIZE_FONT, 'underline' ), anchor = W) )
            elif column in fks :
                idW.append( self.create_text(x1, y1, text = column, font = ( self.FAMILLY_FONT, self.SIZE_FONT, 'italic' ), anchor = W ) )
            else :
                idW.append( self.create_text(x1, y1, text = column, font = ( self.FAMILLY_FONT, self.SIZE_FONT, 'normal' ), anchor = W ) )
                

        self.__idWidjetDict[ idW[ 0 ] ] = idW
        return  idW[ 0 ]

    def delete( self,  *args ) :
        """Efface un widjet sur le canvas."""
        item = args[0]
        # Si l'item est une entities.
        if item in self.__idWidjetDict :
            for items_of_entities in self.__idWidjetDict[ item ] :
                Canvas.delete( self, items_of_entities )
            del self.__idWidjetDict[ item ]

            # Supprime le lien du dico interne et de l'Ã©cran si,
            # le lien a un rapport avec la table supprimÃ©e.
            tmp_list = self.__linkDictList.copy()
            for id_link, dico in tmp_list.items():
                if item in dico :
                    del self.__linkDictList[ id_link ]
                    Canvas.delete( self, id_link )
            
        elif item == 'all' :
            Canvas.delete( self, 'all' )
            self.__idWidjetDict = {}
            self.__linkDictList = {}
            
        else :
            Canvas.delete( self, item )
            
        
    def move( self, *args ):
        """DÃ©place un widjet sur le canvas."""
        for item in self.__idWidjetDict[ args[0] ] :
            Canvas.move( self, item, args[ 1 ], args[ 2 ] )


    def catchItem( self, event ):
        """
        catchItem est relier Ã  l'enfoncement du bouton gauche de la sourie.
        Mettre l'item sous le pointeur de la sourie en CURRENT_OBJECT si
        celui-ci est une entities. Puis l'encadrer en rouge. Si l'entities
        a des liens, les replier sur eux mÃªme et les re-Ã©tendre vers la nouvelle
        position de l'entities quand le bouton gauche de la sourie sera relachÃ©.
        """
        self.cur_tbl_x, self.cur_tbl_y = event.x, event.y
        if  self.find_closest( event.x, event.y ) != () :
            self.current_table = self.find_closest( event.x, event.y )[0]
            if self.current_table :
                # Si l'utilisateur a bien selectionne une table.
                if self.current_table in self.__idWidjetDict.keys() : 
                    self.itemconfig( self.current_table, outline = "red" )
                    # Effacement des liens
                    for link in self.__linkDictList.keys() :
                        coords = tuple( self.coords( link ) )
                        self.coords( link, coords[0], coords[1], coords[0], coords[1] )
                else :
                    self.current_table = None
                

    def DeCatchItem( self, event ):
        """
        DeCatchItem est relier au relachement du bouton gauche de la sourie.
        encadre le CURRENT_OBJECT en noir redimentione les liens vers leurs nouvelle
        position.
        """
        if self.current_table :
            self.itemconfig( self.current_table, outline = "black" )
            # Retrace les liens :
            for id_link, dico in self.__linkDictList.items() :
                self.link( dico, id_link )

    def moveItem( self, event ):
        "DÃ©placer self.current_table"
        x2, y2 = event.x, event.y
        dx, dy = x2 - self.cur_tbl_x, y2 - self.cur_tbl_y
        if self.current_table :
            self.move( self.current_table, dx, dy)
            self.cur_tbl_x, self.cur_tbl_y = x2, y2

    def sizeItem( self, entity ):
        """ Retourne ( longeur, hauteur ) """
        x, y, x2, y2 = tuple( self.coords( entity ) )
        return x2 - x, y2 - y

if __name__ == "__main__" :
    root = Tk()

    can = MLD( root, bg = "beige" )
    can.pack(  expand = True, fill = BOTH )

    tableMouton = can.create_entity(
            20,20,
            head = 'mouton',
            fill = 'white',
            columns = ['id','berger', 'paturage','age', 'sexe', 'couleur' ],
            pks = ['id'],
            fks = ['berger'] )

    tableBerger = can.create_entity(
            20,20,
            head = 'Berger',
            fill = 'white',
            columns = [ 'id','nom', 'prenom' ],
            pks = ['id'] )

    tableChien = can.create_entity(
            20,20,
            head = 'Chien',
            fill = 'white',
            columns = [ 'id', 'berger', 'nom' ],
            pks = ['id'],
            fks = ['berger'])


    longeur = can.sizeItem( tableMouton ) [ 0 ]
    longeur += 20
    can.move( tableBerger, longeur, 0 )
    
    longeur += can.sizeItem( tableBerger ) [ 0 ]
    longeur += 20
    can.move( tableMouton, longeur, 0 )


    can.link( { tableBerger  : "id",
                tableChien : "berger" }  )
    can.link( { tableMouton : "berger",
                tableBerger : "id" }  )
    
    root.mainloop()

