# -*- coding: utf-8 -*-
"""
Copyright 2009 Vincent Maillol Benoît Gaëtan

This file is part of mbg Sqlite.

mbg Sqlite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mbg Sqlite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mbg Sqlite.  If not, see <http://www.gnu.org/licenses/>.
"""
from platform import python_version
is_version_3 = python_version().startswith( '3' )

if is_version_3 :
    from tkinter import *
else :
    from Tkinter import *    

class Infobull( Toplevel ) :
    """
    Label flottants apparaissant quand la souris passe sur le widget master.
    """
    def __init__( self, master, text = "" ) :
        Toplevel.__init__( self, master )
        self.wm_overrideredirect( True )
        self.withdraw()
        Label( self, text = text, bg = "yellow" ).pack()
        master.bind( "<Enter>", lambda event : self.change_state( event ) )
        master.bind( "<Leave>", lambda event : self.change_state( event ) )

    def change_state( self, event ):
        if event.type == "7" : # Si la souris entre dans le master.
            self.wm_deiconify()
            geo = '+%s+%s' % ( event.x_root, event.y_root )
            self.geometry( geo )
        elif event.type == "8" : # Si la souris sort dans le master.
            self.withdraw()


class InfobullTextCursor( Toplevel ) :
    """
    Label flottants apparaissant et disparaissant
    en desous du curseur d'un widget text. 
    """
    
    def __init__( self, master, textvariable ) :

        Toplevel.__init__( self, master )
        self.master = master
        self.wm_overrideredirect( True )
        self.withdraw()
        Label( self, textvariable = textvariable, bg = "yellow" ).pack()

    def show_label( self ) :
        self.wm_deiconify()

        # RÃ©cuper la position en pixel du curseur du widget text.
        pixel_y = 0
        fin = self.master.index( "insert linestart" )
        while float( self.master.index( "@0,%d" % pixel_y  ) ) <= float( fin ) :
            pixel_y += 1

        pixel_y -= 1

        pixel_x = 0
        fin = self.master.index( "insert" )
        while self.master.index( "@%d,%d" % ( pixel_y, pixel_x )  ) != fin :
            pixel_x += 1

        # Affiche la fenÃªtre proche du curseur.
        x = int( self.master.winfo_rootx() ) + int( pixel_x )
        y = int( self.master.winfo_rooty() ) + int( pixel_y )
        geo = '+%s+%s' % ( x, y )
        self.geometry( geo )



class InfobullListbox( Infobull ) :
    """
    Infobull pouvant Ãªtre rattachÃ©e Ã  un item d'une Listbox.
    """
    def __init__( self, master, item=0, text = "" ) :
        Infobull.__init__( self, master, text )
        self.item = item
        self.master.unbind( "<Enter>" )
        self.master.bind("<Motion>", self.change_state, '+' )
        self.master.bind("<Leave>", lambda event : self.withdraw(), '+' )
        
    def change_state( self, event ):
        """
        Si le pointeur de la souris est au-dessus de l'item, apparition de
        l'infobull si elle n'Ã©tait pas visible. 
        """
        if self.master.nearest( event.y ) == self.item :
            if self.state() == "withdrawn" :
                self.wm_deiconify()
                geo = '+%s+%s' %  (event.x_root, event.y_root)
                self.geometry( geo )
        else :
            self.withdraw()
    
        
if __name__ == "__main__" :
    
    def tab( event ):
        if sv.get() == "" :
            sv.set( "Pas de tabulations S.V.P" )
            info.show_label()
        elif sv.get() == "Pas de tabulations S.V.P" :
            sv.set( "Je ne veux pas de tabulations" )
            info.show_label()
        elif sv.get() == "Je ne veux pas de tabulations" :
            sv.set( "J'interdie la tabulations" )
            info.show_label()
        else :
            text.unbind( "<Key-Tab>", foncid[0] ) # Pour ne pas provoquer d'erreur
            text.unbind( "<Key>", foncid[1] )     # au prochain <tab> ou <key>
            fen1.destroy()
            
        return "break" # Empecher la tabulation
            


    def key( event ):
        info.withdraw()
        
    root = Tk()
    lstbox = Listbox( root )
    lstbox.insert( "end", "Den..." )
    lstbox.insert( "end", "Ken..." )
    lstbox.pack()
    InfobullListbox( lstbox, 0, "Dennis MacAlistair Ritchie"  )
    InfobullListbox( lstbox, 1, "Kenneth Lane Thompson"  )

    fen1 = Toplevel( root )
    text = Text( fen1 )
    text.pack()
    sv = StringVar()
    sv.set( "" )
    info = InfobullTextCursor( text, textvariable = sv )
    foncid = ( text.bind( "<Key-Tab>", tab ),
               text.bind( "<Key>",     key ))
    
    mainloop()
