# -*- coding: utf-8 -*-
"""
Copyright 2009 Vincent Maillol Benoît Gaëtan

This file is part of mbg Sqlite.

mbg Sqlite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mbg Sqlite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mbg Sqlite.  If not, see <http://www.gnu.org/licenses/>.
"""
import sqlite3
import time
from otherWidget.virtualConsol import VirtualConsol 

class Client( object ) :
    "Client sqlite3"
    def __init__( self, connection_path ) :
        self.connection = sqlite3.connect( connection_path, detect_types=sqlite3.PARSE_DECLTYPES )
        self.connection.isolation_level = None
        self.cursor = self.connection.cursor()
        self.buffer = ""
        self.last_query  = "" # Pour sauvegarder la derniére requête

    def close( self ):
        """
        Referme proprement la connexion.
        """
        self.cursor.close()
        self.connection.commit()
        self.connection.close()
        
    def execute_query( self, query, force_execute_query = False ) :
            """
            Interprète le contenu de self.buffer s-il est considéré comme une
            requête finie. Il arrive qu'une requête erronée contenant des "begin"
            ne veuille pas être interprétée, mettre force_execute_query à True
            dans ce cas-là.
            """ 
            line = query

            self.buffer += line

            if line == "exit()":
                self.cursor.close()
                self.connection.commit()
                self.connection.close()
                return( 0, 'base de données fermée' )


            elif sqlite3.complete_statement( self.buffer ) or force_execute_query :
                try:
                    self.buffer = self.buffer.strip()
                    t1 = time.clock()
                    self.cursor.execute( self.buffer )
                    t2 = time.clock()
                    delta = t2 - t1

                    if self.buffer.lstrip().upper().startswith( "SELECT" ):
                        fieldNames = [ fieldName[ 0 ] for fieldName in self.cursor.description ]

                        reponse = self.cursor.fetchall()
                        if len( reponse ) > 0 : # Si le curseur renvoi des données
                            nmbCol = len( reponse[0] )
                            nmbRowM1 = len( reponse ) -1
                            tailleMaxCols = [ len( fieldName ) for fieldName in fieldNames ]

                            for row in reponse :# Récupère la taille de la donnée la plus longue de chaque colonne.
                                for i in range( nmbCol ):
                                    newLen = len(  str( row[ i ] ) )
                                    oldLen = tailleMaxCols[ i ]
                                    tailleMaxCols[ i ] = max( newLen, oldLen )

                            # Création du modèle des inter-lignes.
                            interligne = "├"
                            for e in tailleMaxCols :
                                interligne += '─' * e
                                interligne += '┼'
                            interligne = interligne[:-1] + "┤\n"
                            
                            # Dessiner l'entête 
                            entete = "┌"
                            for e in tailleMaxCols :
                                entete += '─' * e
                                entete += '┬'
                            entete = entete[:-1] + '┐\n'

                            ma_reponse = entete

                            rowForAff = "│"
                            for fieldName, lenCase in zip( fieldNames, tailleMaxCols ) :
                                    rowForAff += str( fieldName ).center( lenCase ) + '│'
                            rowForAff += '\n'
                            ma_reponse += rowForAff
                            ma_reponse += interligne

                            # Corp du tableau.
                            numRow = 0
                            for numRow, row in enumerate( reponse ) :
                                rowForAff = "│"
                                for data, lenCase in zip( row, tailleMaxCols ) :
                                    rowForAff += str( data ).center( lenCase ) + '│'
                                rowForAff += "\n"

                                ma_reponse += rowForAff
                                if numRow < nmbRowM1 :
                                    ma_reponse +=  interligne
                                else :
                                    piedDeTableau = "└"
                                    for e in tailleMaxCols :
                                        piedDeTableau += '─' * e
                                        piedDeTableau += '┴'
                                    ma_reponse += piedDeTableau[:-1] + '┘\n'

                            ma_reponse += "%d lignes sélectionnées\nEn %f secondes\n" %  ( nmbRowM1 + 1, delta )

                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, ma_reponse )

                        else :
                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, '' )

                    elif  self.buffer.lstrip().upper().startswith( "CREATE" ):
                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, "<objet créé>\nEn %f secondes\n" % delta )

                    elif  self.buffer.lstrip().upper().startswith( "DROP" ):
                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, "<objet détruit>\nEn %f secondes\n" % delta )

                    elif  self.buffer.lstrip().upper().startswith( "INSERT" ):
                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, "<données insérées>\nEn %f secondes\n" % delta )

                    elif  self.buffer.lstrip().upper().startswith( "DELETE" ):
                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, "<données détruites>\nEn %f secondes\n" % delta )
                    elif self.buffer.lstrip() == '' :
                            return( 1 ,"")
                    else :
                            self.last_query = self.buffer
                            self.buffer = ""
                            return( 1, "<opération effectuée >\nEn %f secondes\n" % delta )
                        
                except sqlite3.Error as e:
                    self.last_query = self.buffer
                    self.buffer = ""
                    return( 0, "Une erreur est survenue: %s\n" % e.args[0] )

                except Exception as e :
                    self.last_query = self.buffer
                    self.buffer = ""
                    return( 0, "Une erreur inconnue est survenue : %s\n" % e.args[0] )


            else :
                self.buffer += '\n'
                return ( 2, None )
               

if __name__ == "__main__" :


    kws =( 'ABORT','ADD','AFTER','ALL','ALTER','ANALYZE','AND','AS','ASC', 'ATTACH','AUTOINCREMENT',
            'BEFORE','BEGIN','BETWEEN','BY','CASCADE','CASE','CAST','CHECK','COLLATE',
            'COLUMN','COMMIT','CONFLICT','CONSTRAINT','CREATE','CROSS','CURRENT_DATE','CURRENT_TIME',
            'CURRENT_TIMESTAMP','DATABASE','DEFAULT','DEFERRABLE','DEFERRED','DELETE',
            'DESC','DETACH','DISTINCT','DROP','EACH','ELSE','END','ESCAPE','EXCEPT',
            'EXCLUSIVE','EXISTS','EXPLAIN','FAIL','FOR','FOREIGN','FROM','FULL','GLOB',
            'GROUP','HAVING','IF','IGNORE','IMMEDIATE','IN','INDEX','INITIALLY','INNER',
            'INSERT','INSTEAD','INTERSECT','INTO','IS','ISNULL','JOIN','KEY','LEFT',
            'LIKE','LIMIT','MATCH','NATURAL','NOT','NOTNULL','NULL','OF','OFFSET',
            'ON','OR','ORDER','OUTER','PLAN','PRAGMA','PRIMARY','QUERY','RAISE','REFERENCES',
            'REGEXP','REINDEX','RENAME','REPLACE','RESTRICT','RIGHT','ROLLBACK','ROW',
            'SELECT','SET','TABLE','TEMP','TEMPORARY','THEN','TO','TRANSACTION','TRIGGER',
            'UNION','UNIQUE','UPDATE','USING','VACUUM','VALUES','VIEW','VIRTUAL','WHEN','WHERE')



    from platform import python_version
    is_version_3 = python_version().startswith( '3' )

    if is_version_3 :
        from tkinter import *
    else :
        from Tkinter import *
        
    a = Client("test.bdd")
    root = Tk()
    #command = lambda query : a.execute_query( query, force_execute_query = True )
    text = VirtualConsol( root,
                          invite1 = "sqlite3 --> ",
                          invite2 = "sqlite3 ... ",
                          #command = lambda query : a.execute_query( query, force_execute_query = True )
                          command =  a.execute_query,
                          comment = '--',
                          kw_ignorcase = True, 
                          kw_command   = kws )
    text.pack()
    mainloop()


