VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "XGui"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'*****************************************************************************************************************
'* Composant XScriptGUI - Ajoute une interface graphique  tout langage script capable de grer un composant COM *
'* Adaptation pour www.developpez.com                                                                            *
'* Auteur: omen999 - omen999@hotpop.com                                                                          *
'*****************************************************************************************************************
Option Explicit
'constantes API Windows
Private Const HWND_TOPMOST = -&H1
Private Const HWND_NOTOPMOST = -&H2
Private Const SWP_NOSIZE = &H1
Private Const SWP_NOMOVE = &H2
Private Const SWP_SHOWWINDOW = &H40
Private Const GWL_STYLE = -16
Private Const WS_DLGFRAME = &H400000
Private Const WS_BORDER = &H800000
Private Const WS_POPUP = &H80000000
Private Const WS_CAPTION = &HC00000
'procdure api win32 pour rendre la feuille toujours visible
Private Declare Sub SetWindowPos Lib "user32" (ByVal hWnd As Long, _
                                               ByVal hWndInsAft As Long, _
                                               ByVal x As Long, _
                                               ByVal y As Long, _
                                               ByVal cx As Long, _
                                               ByVal cy As Long, _
                                               ByVal wFlags As Long)
Private WithEvents cDynItems As IDynCol 'pour identifier le contrle  l'origine de l'evt
Attribute cDynItems.VB_VarHelpID = -1
Private cDynItem As IDynCtl
Private oCBck As Object                 'OLE CallBack reprsentant l'handler du script client
Private acGrp As String                 'stocke le nom du groupe actif
Private ctName As String                'stocke le nom du contrle qui ferme le dlg

'variables mode automatique
Private xCur As Long                    'position courante du curseur contrle x & y
Private yCur As Long
Public iSpaceH As Integer               'espace horizontal entre les contrles
Public iSpaceV As Integer               'idem vertical
Private xLeftM As Long                  'marge gauche pour les contrles
Private maxWForm As Long                'largeur courante de la feuille
Private maxHForm As Long                'hauteur courante de la feuille
Private fH As Long                      'hauteur courante du cadre
Private fW As Long                      'largeur courante du cadre
Private sgFSize As Single               'taille fonte du contrle courant

'******************************************************************************* VARIABLES PUBLIQUES
Public WithEvents XForm As Form 'objet feuille dialogue
Attribute XForm.VB_VarHelpID = -1

'****************************************************************************** INTERFACE PRIVEE
Private Sub Class_Initialize()
'initialisation des variables
   Set XForm = scForm                   'expose l'objet feuille du composant
   bEvD = False                         'par dfaut, pas de gestion des evts clavier/souris
   acGrp = ""                           'pas de groupe actif
   ctName = ""                          'raz contrle qui ferme le dlg
   
                                        'init variables mode auto
   xLeftM = 10
   xCur = xLeftM
   yCur = 10
   iSpaceH = 80
   iSpaceV = 80
   maxWForm = 0
   maxHForm = 0
   fH = 0
   fW = 0
End Sub

Private Property Let AlwaysOnTop(frm As Form, bOnTop As Boolean)
'force la feuille  tre toujours visible si bOnTop est true
    Dim lFlag As Long
    If bOnTop Then lFlag = HWND_TOPMOST Else lFlag = HWND_NOTOPMOST
    SetWindowPos frm.hWnd, lFlag, 0&, 0&, 0&, 0&, (SWP_NOSIZE Or SWP_NOMOVE)
End Property

Private Sub cDynItems_GlobalEvent(cItem As IDynCtl, inf As EventInfo)
'vnements globaux des contrles crs dynamiquement
    Dim vParams() As Variant
    Dim vValue As Variant
    Dim sParams As String
    Dim n As Integer
    If oCBck Is Nothing Then 'si pas de gestion des vnements
        If InStr(1, cItem.Control.Tag, inf.Name, vbTextCompare) > 0 Then 'si l'vnement fait partie de la liste
            sParams = ""
            If inf.EventParameters.Count > 0 Then
                For Each vValue In inf.EventParameters
                    sParams = "|" & sParams & vValue
                Next
            End If
            ctName = cItem.Control.Name & "|" & inf.Name & sParams 'dfini la valeur qui sera renvoye par ShowForm
            scForm.Hide
'           Unload scForm (finalement non, on laisse au script le soin de dcharger explicitement la feuille)
            Exit Sub
        End If
    Else
        On Error Resume Next 'pas d'erreur mme si la procdure d'vnement n'a t prvue dans le script
        If inf.EventParameters.Count = 0 Then
            CallByName oCBck, cItem.Control.Name & "_" & inf.Name, VbMethod
        Else
            ReDim vParams(inf.EventParameters.Count)
            n = 0
            For Each vValue In inf.EventParameters
                vParams(n) = vValue
                n = n + 1
            Next
            Select Case n - 1
            'maxi 5 paramtres transmis aux procdures vnements du script.(pas trs lgant mais pas grave en pratique...)
            Case 0
                CallByName oCBck, cItem.Control.Name & "_" & inf.Name, VbMethod, vParams(0)
            Case 1
                CallByName oCBck, cItem.Control.Name & "_" & inf.Name, VbMethod, vParams(0), vParams(1)
            Case 2
                CallByName oCBck, cItem.Control.Name & "_" & inf.Name, VbMethod, vParams(0), vParams(1), vParams(2)
            Case 3
                CallByName oCBck, cItem.Control.Name & "_" & inf.Name, VbMethod, vParams(0), vParams(1), vParams(2), _
                    vParams(3)
            Case Else 'maxi 5
                CallByName oCBck, cItem.Control.Name & "_" & inf.Name, VbMethod, vParams(0), vParams(1), vParams(2), _
                    vParams(3), vParams(4)
            End Select
        End If
    End If
End Sub

Private Sub cDynItems_GlobalEventLabel(cItem As IDynCtl, inf As EvInfo)
'vnement global des contrles label crs dynamiquement
    If Not (oCBck Is Nothing) Then
        On Error Resume Next 'pas d'erreur mme si la procdure d'vnements n'a t dfinie dans le script
        CallByName oCBck, cItem.ControlLabel.Name & "_" & inf.Name, VbMethod
    End If
End Sub

'**************************************************************************** INTERFACE PUBLIQUE
'*********************************************** PROPRIETES EXPOSEES PAR LE COMPOSANT XScriptGUI
Public Property Set EvHandler(oEH As Variant) 'criture objet uniquement (pas de Property Get)
'active la gestion des vnements par le composant
    Set oCBck = oEH '***IMPORTANT*** l'objet callback est dfini APRES l'objet form (late binding) sinon bin a marche p ...
    scForm.InitEvents oCBck 'transmet l'objet callback  la feuille pour les vnements load et unload
    'note: peut-tre inutile si oCBck est dclar public dans le module Dclarations?
End Property

Public Property Let EventsDevice(bE As Boolean) 'criture
'active/dsactive les vnements clavier/souris (par dfaut false)
    bEvD = bE
End Property

Public Property Get EventsDevice() As Boolean 'lecture
'permet au script de lire l'tat courant du flag vnements clavier/souris
    EventsDevice = bEvD
End Property

Public Property Let SpaceHorizontal(iSpace As Integer)  'criture seule
    iSpaceH = iSpace
End Property

Public Property Let SpaceVertical(iSpace As Integer)  'criture seule
    iSpaceV = iSpace
End Property

'************************************************* METHODES EXPOSEES PAR LE COMPOSANT XScriptGUI
Public Function ShowForm(Optional ByVal sCaption As String = "", Optional ByVal bOnTop As Boolean = False, Optional ByVal xL As Long = -1, _
    Optional ByVal xT As Long = -1, Optional ByVal xH As Long = -1, Optional ByVal xW As Long = -1, Optional sFocus As String = "") As String
'affiche la feuille dialogue (mode modal)
    sCtrlFocus = sFocus
    AlwaysOnTop(scForm) = bOnTop
    scForm.Caption = sCaption
    If xH > -1 Then scForm.Height = xH
    If xW > -1 Then scForm.Width = xW
    'maj de la position du filigrane XScriptGUI sur la feuille
    If scForm.oMenu.Visible Then
        scForm.labMark.Top = scForm.Height - 512
    Else
        scForm.labMark.Top = scForm.Height - 224
    End If
    If scForm.Caption <> "" Then scForm.labMark.Top = scForm.labMark.Top - 320
    If xL > -1 Then scForm.Left = xL Else scForm.Left = (Screen.Width - scForm.Width) / 2 'centrage auto
    If xT > -1 Then scForm.Top = xT Else scForm.Top = (Screen.Height - scForm.Height) / 2
    scForm.Show vbModal 'affichage de la feuille
    ShowForm = ctName   'renvoie une chaine identifiant le contrle  l'origine de la fermeture de la feuille,
                        'si les evts ne sont pas grs par le script
End Function

Public Sub CloseForm()
'ferme la feuille dialogue
    Unload scForm
End Sub

Public Function AddControl(ByRef sType As String, ByRef sNomCtrl As String, ByRef sData As String, ByRef xL As Long, _
    ByRef xT As Long, ByRef xH As Long, ByRef xW As Long, Optional ByVal tabI As Integer = -1, _
    Optional ByVal sValidate As String = "", Optional ByVal sKey As String = vbLf) As Object
'ajoute un contrle dynamiquement  la feuille de dialogue
    Dim ctx As Control      'contrle courant
    Dim aData As Variant    'tableau des donnes combobox ou listbox
    Dim sID As String       'progID du contrle ajout
    Dim n As Integer
    Select Case LCase(sType)
    Case "button"
        sID = "MSWLess.WLCommand"
    Case "label"            'le contrle label est le seul contrle intrinsque
        sID = "VB.Label"
    Case "textbox"          'les autres contrles sont des contrles allgs...
        sID = "MSWLess.WLText"
    Case "listbox"
        sID = "MSWLess.WLList"
    Case "combobox"
        sID = "MSWLess.WLCombo"
    Case "checkbox"
        sID = "MSWLess.WLCheck"
    Case "radiobox"
        sID = "MSWLess.WLOption"
    Case "frame"
        sID = "MSWLess.WLFrame"
    Case Else 'contrle inconnu
        sID = ""
    End Select
    If cDynItems Is Nothing Then
        Set cDynItems = New IDynCol 'nouvelle collection d'items dynamiques si elle n'existe pas
    End If
    Set ctx = scForm.Controls.Add(sID, sNomCtrl) 'ajoute dynamiquement le contrle  la feuille
    With ctx
        If sData <> vbLf Then 'si contrle visuel maj proprits gnrales
            .Left = xL
            .Top = xT
            .Width = xW
            .Height = xH
            .Visible = True
            If tabI > -1 Then .TabIndex = tabI 'tabindex est facultatif
            'tag sert de container pour mmoriser les vnements validant la fermeture (pas de gestion standard des evts)
            If sValidate <> "" Then .Tag = sValidate
        End If
        Select Case sID 'maj de certaines proprits selon les contrles
        Case "VB.Label"
            .Tag = "label" 'la proprit tag est utilise comme discriminant pour la gestion des vnements
            .Caption = sData
        Case "MSWLess.WLText"
            .Text = sData
        Case "MSWLess.WLCommand", "MSWLess.WLFrame", "MSWLess.WLCheck"
            .Caption = sData
        Case "MSWLess.WLOption"
            .Caption = sData
            .Group = acGrp
        Case "MSWLess.WLList", "MSWLess.WLCombo"
            aData = Split(sData, "|")
            For n = 0 To UBound(aData)
                .AddItem aData(n)
            Next
        End Select
        If acGrp <> "" Then .ZOrder 'force le contrle en avant-plan si mode groupe actif (le rend visible dans le cadre)
    End With
    Set cDynItem = cDynItems.Add(ctx)   'ajoute le contrle  la collection
    Set AddControl = ctx                'retourne au script l'objet contrle cr
End Function

Public Function AddControlAuto(ByVal sType As String, ByVal sNomCtrl As String, ByVal sData As String, _
    Optional ByVal xH As Long = 0, Optional ByVal xW As Long = 0, Optional ByVal sValidate As String = "", Optional ByVal bNoCr As Boolean = False, _
    Optional ByVal oFont As Object = Nothing, Optional ByVal sKey As String = vbLf) As Object
'ajoute un contrle dynamiquement  la feuille de dialogue en le disposant automatiquement (trs grosses amliorations  prvoir...)
    Dim ctx As Control      'contrle courant
    Dim aData As Variant    'tableau des donnes combobox ou listbox
    Dim sID As String       'progID du contrle ajout
    Dim lgH As Long         'hauteur  ajouter pour tenir compte de la barre titre, du filigrane et du menu
    Dim n As Integer
    Select Case LCase(sType)
    Case "button"
        sID = "MSWLess.WLCommand"
        If xH = 0 Then xH = 40 'hauteur minimum
        If xW = 0 Then xW = (Len(sData) * 8.7) + 44 ' ajoute une marge pour le cadre et les majuscules
    Case "label" 'le contrle label est le seul contrle intrinsque
        sID = "VB.Label"
        If xH = 0 Then xH = 24 'hauteur minimum
        If xW = 0 Then xW = Len(sData) * 8.7 ' largeur moyenne d'un caractre 8.7 x sa taille (empirique)
    Case "textbox"
        sID = "MSWLess.WLText"
        If xH = 0 Then xH = 34 'hauteur minimum
        If xW = 0 Then xW = (Len(sData) * 8.7) + 44 ' ajoute une marge pour le cadre et les majuscules
    Case "listbox"
        sID = "MSWLess.WLList"
        'la hauteur sera calcule lors de l'ajout des items en fonction du nombre d'items (plafonne)
        'la largeur sera calcule lors de l'ajout des items en fonction de la taille du plus grand
    Case "combobox"
        sID = "MSWLess.WLCombo"
        If xH = 0 Then xH = 34 'hauteur minimum
        'la largeur sera calcule lors de l'ajout des items en fonction de la taille du plus grand
    Case "checkbox"
        sID = "MSWLess.WLCheck"
        If xH = 0 Then xH = 24 'hauteur minimum
        If xW = 0 Then xW = (Len(sData) * 8.7) + 50 ' ajoute une marge pour la coche et les majuscules
    Case "radiobox"
        sID = "MSWLess.WLOption"
        If xH = 0 Then xH = 24 'hauteur minimum
        If xW = 0 Then xW = (Len(sData) * 8.7) + 50 ' ajoute une marge pour le bouton et les majuscules
    Case "frame"
        sID = "MSWLess.WLFrame"
        If xH = 0 And sData <> "" Then xH = 24 'pour rendre la lgende visible
        If xH = 0 And sData = "" Then xH = 2 ' c'est une simple ligne
        If xW = 0 Then xW = (Len(sData) * 8.7) + 50 ' ajoute une marge pour le cadre et les majuscules
    Case Else 'contrle inconnu
        sID = ""
    End Select
    
    If cDynItems Is Nothing Then
        Set cDynItems = New IDynCol 'nouvelle collection d'items dynamiques si elle n'existe pas
    End If
    Set ctx = scForm.Controls.Add(sID, sNomCtrl) 'ajoute dynamiquement le contrle  la feuille
    
    With ctx
        'tag sert de container pour mmoriser les vnements validant la fermeture (pas de gestion standard des evts)
        If sValidate <> "" Then .Tag = sValidate
        Select Case sID 'maj de certaines proprits selon les contrles
        Case "VB.Label"
            .Tag = "label" 'la proprit tag est utilise comme discriminant pour la gestion des vnements
            .Caption = sData
        Case "MSWLess.WLText"
            .Text = sData
        Case "MSWLess.WLCommand", "MSWLess.WLFrame", "MSWLess.WLCheck"
            .Caption = sData
        Case "MSWLess.WLOption"
            .Caption = sData
            .Group = acGrp
        Case "MSWLess.WLList", "MSWLess.WLCombo"
            aData = Split(sData, "|")
            If sID = "MSWLess.WLList" And xH = 0 Then xH = 26 * (UBound(aData) + 1)                'hauteur en fonction du nb d'items
            For n = 0 To UBound(aData)
                .AddItem aData(n)
                If xW = 0 And xW < (Len(aData(n)) * 8.7) + 60 Then xW = (Len(aData(n)) * 8.7) + 60 'ajoute une marge pour le cadre et les majuscules
            Next
        End Select
        If sData <> vbLf Then   'si contrle visuel on place le contrle automatiquement sur la feuille
            sgFSize = 0
            On Error Resume Next
            IsObject (.Font)    'le contrle at-il un objet font ?
            Select Case Err.Number
            Case 0 ' oui
                If Not oFont Is Nothing Then
                    .Font.Name = oFont.Name
                    .Font.Size = oFont.Size
                    .Font.Bold = oFont.Bold
                    .Font.Italic = oFont.Italic
                    .Font.Underline = oFont.Underline
                    sgFSize = .Font.Size        'la taille fonte courante est celle du contrle
                Else
                    sgFSize = scForm.Font.Size  'sinon celle de la fonte feuille
                End If
            Case 438 'pas d'objet font, on essaie une proprit + ancienne (vb4)
                .FontName = oFont.Name
                .FontSize = oFont.Size
                .FontBold = oFont.Bold
                .FontItalic = oFont.Italic
                .FontUnderline = oFont.Underline
                sgFSize = .FontSize
                If sgFSize = 0 Then sgFSize = scForm.Font.Size 'la proprit n'existe pas donc taille de la fonte feuille
            End Select
                
            'maj des dimensions et de la position du contrle
   
            .Width = xW * sgFSize  'ajustement en fonction de la taille de la fonte du contrle
            .Height = xH * sgFSize 'idem
            .Left = xCur + iSpaceH 'ajustement de l'espace entre contrles
            .Top = yCur + iSpaceV
            
            'maj du curseur contrle et des dims max de la feuille
            'situation diffrente suivant qu'on est en mode groupe auto ou non (on doit tenir compte du cadre)
            If bNoCr Then ' maintient du curseur contrle sur la mme ligne
                xCur = .Left + .Width
                If maxWForm < xCur Then maxWForm = xCur
                maxHForm = .Top + .Height
            Else
                If maxWForm < (xCur + .Width) Then maxWForm = xCur + .Width 'prcalcule la largeur de la feuille
                If acGrp <> "" Then 'mode groupe activ donc <cr> align sur le cadre
                    If fH > 0 Then 'mode groupe auto donc gestion des dims du cadre
                        'If fW < xCur Then fW = xCur + .Width
                        If fW < xCur + .Width - scForm.Controls(acGrp).Left Then fW = xCur + .Width - scForm.Controls(acGrp).Left
                        fH = fH + .Height 'maj la hauteur du cadre
                        scForm.Controls(acGrp).Width = fW + (1.5 * iSpaceH) 'maj + ajust de la marge droite du cadre
                        scForm.Controls(acGrp).Height = fH + (3 * iSpaceV)
                    End If
                    xCur = scForm.Controls(acGrp).Left
                Else '<cr> align sur la feuille
                    xCur = xLeftM
                End If
                yCur = .Top + .Height
            End If
            .Visible = True
            
            'maj dimension feuille
            scForm.Width = maxWForm + 280 'marge droite identique  celle de gauche
            lgH = 280
            If maxHForm > yCur Then scForm.Height = maxHForm + lgH Else scForm.Height = yCur + lgH
            ' pas de tabindex en mode auto
        End If
            
        If acGrp <> "" Then .ZOrder   'force le contrle en avant-plan si mode groupe actif (le rend visible dans le cadre)
    End With
    Set cDynItem = cDynItems.Add(ctx) 'ajoute le contrle  la collection
    Set AddControlAuto = ctx          'retourne au script l'objet contrle cr
End Function

Public Sub SetLeftMargin(ByVal xM As Long)
'modifie la marge gauche d'insertion des contrles par rapport au bord gauche de la feuille - utile mode auto
    xLeftM = xM * scForm.Font.Size 'ajuste en fonction de la taille de police
    xCur = xLeftM
End Sub

Public Sub MoveCursor(Optional ByVal xX As Long = -1, Optional ByVal xY As Long = -1)
'dplace le curseur d'insertion des contrles - utile en mode auto
    If xX > -1 Then xCur = xX * scForm.Font.Size
    If xY > -1 Then yCur = xY * scForm.Font.Size
End Sub

Public Sub WithGroup(ByVal sNomCtrl As String, ByVal xL As Long, ByVal xT As Long, ByVal xH As Long, ByVal xW As Long, _
    ByVal tabI As Integer, Optional ByVal sCaption As String = "")
    'cre un contrle frame et active le groupe pour les contrles radio
    Dim ctx As Control
    acGrp = sNomCtrl
    Set ctx = scForm.Controls.Add("MSWLess.WLFrame", sNomCtrl)
    With ctx
        .Left = xL
        .Top = xT
        .Width = xW
        .Height = xH
        .TabIndex = tabI
        If sCaption <> "" Then 'si caption vide, cadre invisible
            .Caption = sCaption
            .Visible = True
        End If
    End With
    Set cDynItem = cDynItems.Add(ctx)
End Sub

Public Sub WithGroupAuto(ByVal sNomCtrl As String, Optional ByVal xH As Long = 0, Optional ByVal xW As Long = 0, _
    Optional ByVal sCaption As String = "")
    'cre un contrle frame auto et active le groupe pour les contrles radio
    'le flag bNoCr n'aurait pas de sens ici puis que les contrles qui suivent doivent figurer DANS le cadre
    'si on ne fixe pas de dims au cadre, les DEUX dims doivent tre vides
    Dim ctx As Control
    If xH = 0 Or xW = 0 Then 'si l'une des dims est nulle, raz pour tout le monde
        xH = 0: xW = 0
    End If
    acGrp = sNomCtrl
    Set ctx = scForm.Controls.Add("MSWLess.WLFrame", sNomCtrl)
    With ctx
        .Left = xCur + iSpaceH
        .Top = yCur + iSpaceV
        xCur = .Left
        yCur = .Top
         'en donnant une valeur  fH & fW, on signale que les dims du cadre devront tre gr en auto
        If xH = 0 Then fH = iSpaceV Else .Height = xH * scForm.Font.Size 'ajustement en fonction de la taille de la fonte
        If xW = 0 Then fW = iSpaceH Else .Width = xW * scForm.Font.Size
        If sCaption <> "" Then 'si caption vide, cadre invisible
            .Caption = sCaption
            .Visible = True
            yCur = yCur + (24 * scForm.Font.Size) 'ajust avec la lgende du cadre
            If xH = 0 Then fH = fH + (24 * scForm.Font.Size)
        End If
    End With
    Set cDynItem = cDynItems.Add(ctx)
End Sub

Public Sub EndGroup(Optional ByVal bNoCr As Boolean = False)
    'reinit le curseur contrle en fonction de bNoCr
    If bNoCr Then
        xCur = scForm.Controls(acGrp).Left + fW + iSpaceH
        yCur = scForm.Controls(acGrp).Top
    Else
        xCur = xLeftM
        yCur = yCur + (1.5 * iSpaceV)
    End If
    'dsactive le mode groupe
    acGrp = ""
    'raz variables mode auto
    fH = 0
    fW = 0
End Sub
