if (!window.uu) {
// === Global namespace pollution ==========================
var uu, // core and class namespace
    UU, // const and config namespace
    uudoc = document; // document cache

// === Core ================================================
window.uu = uu = function() {
  return uu._impl.apply(this, arguments); // adapter
};

window.UU = UU = {
  VERSION: 0.01,
  TRIM:         /^\s+|\s+$/g, // String.prototype.trim()
  TRIM_QUOTE:   /^\s*["']?|["']?\s*$/g
};

// uu.mix - mixin
uu.mix = function(base, flavor, aroma, override /* = true */) {
  var i, ride = (override === void 0) || override;

  for (i in flavor) {
    if (ride || !(i in base)) {
      base[i] = flavor[i];
    }
  }
  return aroma ? uu.mix(base, aroma, null, ride) : base;
};

uu.mix(uu, {
  // uu.uuid - unique-id generator
  uuid: function() {
    return ++uu._uuid;
  },
  _uuid: 0,

  // uu.id - query id
  id: function(id, really /* = false */) {
    return uudoc.getElementById(id);
  },

  // uu.tag - query tag
  tag: function(expr, context /* = document */, really /* = false */) {
    var nodeList = (context || uudoc).getElementsByTagName(expr),
        rv, ri, v, i, iz;

    if (!uu.ua.ie || expr !== "*") {
      return uu.toArray(nodeList);
    }

    rv = [], ri = -1, i = 0, iz = nodeList.length;

    for (; i < iz; ++i) {
      v = nodeList[i];
      if (v.nodeType === 1) {
        rv[++ri] = v;
      }
    }
    return rv;
  },

  // uu.className - query className
  className: function(expr, context /* = document */, really /* = false */) {
    if (uudoc.getElementsByClassName) {
      return uu.toArray((context || uudoc).getElementsByClassName(expr));
    }
    var nodeList = (context || uudoc).getElementsByTagName("*"),
        name = expr.replace(UU.TRIM, "").split(/\s+/),
        rv = [], ri = -1, v, m, c, i = 0,
        iz = nodeList.length, nz = name.length,
        rex = RegExp("\\b(" + name.join("|") + ")\\b", "g"); // /\b(AA|BB|CC)\b/g

    for (; i < iz; ++i) {
      v = nodeList[i];
      c = v.className;
      if (c) {
        m = c.match(rex);
        (m && m.length >= nz) && (rv[++ri] = v);
      }
    }
    return rv;
  },

  // uu.css - query css
  css: function(expr, context /* = document */, really /* = false */) {
    var ctx = context || uudoc;
    if (uudoc.querySelectorAll) {
      // :after  :before  :contains  :digit :first-letter  :first-line
      // :link  :negative :playing  :target  :visited  !=  ?=
      if (!/(\:(a|b|co|dig|first\-l|li|ne|p|t|v))|\!\=|\?\=/.test(expr)) {
        try {
          return uu.toArray(ctx.querySelectorAll(expr));
        } catch(err) {} // case: extend pseudo class / operators
      }
    }
    return uu.css.querySelectorAll(expr.replace(UU.TRIM, ""), ctx, really);
  }
});

// === Hash ================================================
// depend: ua

uu.mix(uu, {
  // uu.toArray - convert FakeArray or Array to Array
  toArray: function(fake, fromIndex /* = 0 */) {
    fromIndex = fromIndex || 0;

    if (!uu.ua.ie) {
      return Array.prototype.slice.call(fake, fromIndex);
    }

    var i = 0, iz = fake.length || 0,
        rv = (iz - fromIndex > 0) ? Array(iz - fromIndex) : [];

    for (; fromIndex < iz; ++i, ++fromIndex) {
      rv[i] = fake[fromIndex];
    }
    return rv;
  }
});

// === User Agent ==========================================
// depend: none

// ie
//    version: 6.0, 7.0, 8.0
//    engine: 6(ie6), 7(ie7), 8(ie8)
// gecko
//    firefox version: 2.0 3.0 3.1
//    engine(gecko): 1.81(fx2) 1.9(fx3) 1.91(fx3.1)
//
// webkit
//    chrome version: 0.4 1.0
//    safari version: 3.0 3.1
//    engine(webkit): 525.19(chrome1) 525.21(safari3.1)
//
// opera
//    version: 9.2 9.5 9.6 10.0
//    engine(presto): 0(opera9.27), 0(opera9.52) 2.11(opera9.61) 2.2(opera10.00)

(function(navi, ver, eng, ie, cmpt, mode) {
uu.ua = {
  version: parseFloat((navi.match(ver) || [,0])[1]),
  engine: parseFloat(((navi.match(eng) || [,0])[1]).toString().
                     replace(/[^\d\.]/g, "").
                     replace(/^(\d+\.\d+)(\.(\d+))?$/, "$1$3")),
  ie: ie,
  opera: !!window.opera,
  gecko: /Gecko\//.test(navi),
  webkit: /WebKit/.test(navi),
  quirks: ie && cmpt !== "CSS1Compat",
  ie8mode8: mode >= 8
};
})(navigator.userAgent,
    /(?:IE |fox\/|ome\/|ion\/|era\/)(\d+\.\d+)/,
    /(?:IE |rv\:|ari\/|sto\/)(\d+\.\d+(\.\d+)?)/,
    !!uudoc.uniqueID, uudoc.compatMode || "", uudoc.documentMode || 0);

// === Aid =================================================
// depend: ua

uu.aid = {
  textContent: uu.ua.ie || (uu.ua.opera && uu.ua.version < 9.5) ? "innerText"
                                                                : "textContent"
};

// === Query ===============================================
// depend: array, ua, aid

// --- local scope -----------------------------------------
(function() {
    // root - ref document root element (<html>)
var rootElement = uudoc.documentElement ||
                  uudoc.getElementsByTagName("html")[0],
    headElement = uudoc.getElementsByTagName("head")[0],
    textContent = uu.aid.textContent,
    // traversal - support DOM Element Traversal Module
    //    Firefox3.1+, Opera9.5+, !Opera9.2x(buggy)
    traversal = (uu.ua.gecko && uu.ua.engine >= 1.91) ||  // Firefox3.1+(gecko:1.9.1.0)
                (uu.ua.opera && uu.ua.version >= 9.5),    // Opera9.5+
    _ie       = uu.ua.ie,
    _ie8mode8 = uu.ua.ie8mode8,
    // tag dict( { a: "A", A: "A", ... } )
    htmlTag = {},
    xmlTag  = {},
    QUICK_STATIC = {
      "*":      function(ctx) { return uu.tag("*", ctx); },
      "*:root": function()    { return [rootElement]; }, // fix 27 (*:root)
      ":root":  function()    { return [rootElement]; }, // fix 27 (*:root)
      "html":   function()    { return [rootElement]; },
      "head":   function()    { return [headElement]; },
      "body":   function()    { return [uudoc.body]; },
      ":link":  function()    { return uu.toArray(uudoc.links); } // spoof
    },
    QUICK_QUERY = /^(?:\*?(\.|#)([a-z_\u00C0-\uFFEE\-][\w\u00C0-\uFFEE\-]*)|(\w+)(?:\s*,\s*(\w+)(?:\s*,\s*(\w+))?)?|(\w+)\s+(\w+)(?:\s+(\w+))?)$/i,
    QUICK_HEAD  = /^#([a-z_\u00C0-\uFFEE\-][\w\u00C0-\uFFEE\-]*)\b(?![#\.:\[])|^((?:\.[a-z_\u00C0-\uFFEE\-][\w\u00C0-\uFFEE\-]*)+)$/i, // ]
    QUICK_COMMA = /^[^"'\(\)]*,/, // split(",")
    ID_OR_CLASS = /^[#\.]([a-z_\u00C0-\uFFEE\-][\w\u00C0-\uFFEE\-]*)/i,
    PSEUDO      = /^::?([\w\-]+)(?:\((?:(["'])?(.*?)\2|([^\(\)]+))\))?/,
    ATTR        = /^\[\s*(?:([^~\^$*|=!\/\s]+)\s*([~\^$*|!\/]?\=)\s*(["'])?(.*?)\3([ig]?)|([^\]\s]+))\s*\]/,
    NTH_ANB     = /^((even)|(odd)|(\d+)|(1n\+0|n\+0|n)|((-?\d*)n((?:\+|-)?\d*)))$/,
    TAG_DICT    = "*,div,p,a,ul,ol,li,span,td,tr,dl,dt,dd,h1,h2,h3,h4,iframe,form,input,textarea,select,body,style,script",
    JOINT1      = { ">": 1, "+": 2, "~": 3 },
    JOINT2      = { "#": 1, ".": 2, ":": 3, "[": 4 }, // ]
    JOINT3      = { "*": 1, "#": 2, ".": 3 }, // :not( ... )
    ATTR_ALIAS  = { "class": "className", "for": "htmlFor" },
    ATTR_IE_BUG = { href: 1, src: 1 },
    ATTR_OPERATOR = { "=": 1,  "!=": 2, "/=": 3, "*=": 4, "^=": 5, "$=": 6, "~=": 7, "|=": 8 },
    ATTR_CASESENS = { title: 0, id: 0, name: 0, "class": 0, "for": 0 },
    FILTER = {
      "first-child":      [0x01, childFilter],
      "last-child":       [0x02, childFilter],
      "only-child":       [0x03, childFilter],
      "nth-child":        [0x04, nthFilter],
      "nth-last-child":   [0x05, nthFilter],
      "nth-of-type":      [0x06, nthTypeFilter],
      "nth-last-of-type": [0x07, nthTypeFilter],
      "first-of-type":    [0x09, ofTypeFilter],
      "last-of-type":     [0x0a, ofTypeFilter],
      enabled:            [0x0b, simpleFilter],
      disabled:           [0x0c, simpleFilter],
      checked:            [0x0d, simpleFilter],
      // [0x0e - 0x11] reserved.
      empty:              [0x12, empty],
      lang:               [0x13, lang],
      "only-of-type":     [0x14, onlyOfType],
      not:                [0x15, not],
      root:               [0x16, root],
      target:             [0x17, target],
      contains:           [0x18, contains],
      // [0x40 - 0x4d] reserved.
      before:             [0x100, null], // 0x100 is none operation
      after:              [0x100, null],
      "first-letter":     [0x100, null],
      "first-line":       [0x100, null]
    };

// quickQuery - Quick CSS Query
function quickQuery(match, context, really) {
  var rv = [], ri = -1, unq = {}, uuid,
      m1, m2, m3, nodeList1, nodeList2, nodeList3,
      v, i, j, k, iz, jz, kz;

  // "#id" or ".class"
  if (match[1]) {
    if (match[1] === ".") {
      return uu.className(match[2], context, really);
    }
    nodeList1 = (context.ownerDocument || uudoc).getElementById(match[2]);
    return nodeList1 ? [nodeList1] : [];
  }

  // "E" or "E,F" or "E,F,G"
  if (match[3]) {
    m1 = match[3], m2 = match[4], m3 = match[5];

    unq[m1] = 1, nodeList1 = uu.toArray(context.getElementsByTagName(m1));
    if (m2 && !(m2 in unq)) {
      unq[m2] = 1, nodeList2 = uu.toArray(context.getElementsByTagName(m2));
    }
    if (m3 && !(m3 in unq)) {
      unq[m3] = 1, nodeList3 = uu.toArray(context.getElementsByTagName(m3));
    }
    return [].concat(nodeList1, nodeList2 || [], nodeList3 || []);
  }

  // "E F" or "E F G"
  m1 = match[6], m2 = match[7], m3 = match[8];

  nodeList1 = context.getElementsByTagName(m1); // "E"
  for (i = 0, iz = nodeList1.length; i < iz; ++i) {

    nodeList2 = nodeList1[i].getElementsByTagName(m2); // "E F"
    for (j = 0, jz = nodeList2.length; j < jz; ++j) {

      if (m3) {
        nodeList3 = nodeList2[j].getElementsByTagName(m3); // "E F G"
        for (k = 0, kz = nodeList3.length; k < kz; ++k) {

          v = nodeList3[k];
          uuid = v.uuid || (v.uuid = ++uu._uuid);
          if (!(uuid in unq)) {
            rv[++ri] = v;
            unq[uuid] = 1;
          }
        }
      } else {
        v = nodeList2[j];
        uuid = v.uuid || (v.uuid = ++uu._uuid);
        if (!(uuid in unq)) {
          rv[++ri] = v;
          unq[uuid] = 1;
        }
      }
    }
  }
  return rv;
}

// uu.css.querySelectorAll
uu.css.querySelectorAll = function(expr, context, really) {
  context = context || document.documentElement;
  var _xml, _tags, _firstChild, _nextSibling, _ie = uu.ua.ie, // alias
      // --- double registration guard ---
      uuid,       // unique-id
      guard = {}, // global guard
      unq   = {}, // local guard
      mixed = 0,  // 1: mixed
      // --- result and context elements ---
      rv  = [],
      ctx = [context],
      // --- loop out flag --
      lastExpr1 = 0, // expr last length (outer loop)
      lastExpr2 = 0, // expr last length (inner loop)
      // --- iterator and loop counter ---
      iter, i, j, iz, jz,
      // --- quick flags(complex state mode) ---
      withcomma = expr.indexOf(",") >= 0, // with comma(",")
      // --- work ---
      tag,   // the E or F or universal selector("*")
      univ,  // true: tag is universal selector("*")
      joint, // >+~_#.:[ // ]
      nodeList,
      needle, pseudo, filter,
      v, w, r, ri, bowwow, operator,
      match;

  // --- Quick phase ---
  if (!withcomma && expr in QUICK_STATIC) { // "*" ":root" "body" ...
    return QUICK_STATIC[expr](context);
  }
  if ( (match = expr.match(QUICK_QUERY)) ) { // "#id" ".class" "E" "E F" "E,F"...
    return quickQuery(match, context, really);
  }
  if (withcomma && QUICK_COMMA.test(expr)) { // split("#id, .class, E")
    w = expr.split(","); // "expr, expr, expr"
    for (i = 0, iz = w.length; i < iz; ++i) {
      v = w[i].replace(UU.TRIM, "");
      r = uu.css.querySelectorAll(v, context, really);
      mix(r, rv, unq);
    }
    return rv;
  }
  if (!withcomma) {
    if ( (match = expr.match(QUICK_HEAD)) ) { // complex
      if (match[1]) {
        w = uu.id(match[1]);
        ctx = w ? [w] : [];
      } else {
        v = match[2].replace(/\./g, " "); // ".class.class" -> " class class"
        return uu.className(v, context);
      }
      expr = expr.slice(match[0].length);
    }
  }

  // --- Generic phase ---
  _xml = isXMLDocument(context);
  _tags = _xml ? xmlTag : htmlTag;
  _firstChild  = traversal ? "firstElementChild"  : "firstChild";
  _nextSibling = traversal ? "nextElementSibling" : "nextSibling";

  // --- outer loop ---
  while (expr.length && expr.length !== lastExpr1) {
    lastExpr1 = expr.length;

    r = [], ri = -1, unq = {}, i = 0, iz = ctx.length;

    // "E > F"  "E + F"  "E ~ F"  "E"  "E F" phase
    if ( (match = expr.match(/^\s*(?:([>+~])\s*)?(\*|\w*)/)) ) {
      tag = match[2];
      tag = tag ? (_tags[tag] || addTag(tag, _xml)) : "*";
      univ = tag === "*"; // true: tag is universal selector

      if (match[1]) {
        joint = JOINT1[match[1]];

        if (joint === 2) { // 2: "E + F"
          for (; i < iz; ++i) {
            for (v = ctx[i][_nextSibling]; v; v = v[_nextSibling]) {
              if (traversal || v.nodeType === 1) {
                if (_ie && v.tagName.charAt(0) === "/") {
                  continue; // fix #25
                }
                if (univ || v.tagName === tag) {
                  r[++ri] = v;
                }
                break;
              }
            }
          }
        } else { // 1: "E > F" or 3: "E ~ F"
          iter = (joint === 1) ? _firstChild : _nextSibling;
          bowwow = joint === 3; // E ~ F break flag
          for (; i < iz; ++i) {
            for (v = ctx[i][iter]; v; v = v[_nextSibling]) {
              if (traversal || v.nodeType === 1) {
                if (univ || v.tagName === tag) {

                  uuid = v.uuid || (v.uuid = ++uu._uuid);
                  if (uuid in unq) {
                    if (bowwow) { // E ~ F
                      break;
                    }
                  } else {
                    r[++ri] = v;
                    unq[uuid] = 1;
                  }
                }
              }
            }
          }
        }
      } else {
        // >+~ is not found
        if (iz === 1) { // complex
          r = uu.tag(tag, ctx[0]);
        } else {
          for (; i < iz; ++i) {
            nodeList = ctx[i].getElementsByTagName(tag);

            for (j = 0, jz = nodeList.length; j < jz; ++j) {
              v = nodeList[j];
              // tag("*") has text/comment node(in IE)
              if (!_ie || !univ || v.nodeType === 1) {
                if (univ || v.tagName === tag) {

                  uuid = v.uuid || (v.uuid = ++uu._uuid);
                  if (!(uuid in unq)) {
                    r[++ri] = v;
                    unq[uuid] = 1;
                  }
                }
              }
            }
          }
        }
      }
      ctx = r;
      expr = expr.slice(match[0].length);
    }

    // --- inner loop ---
    // Attribute, Class, Pseudo, ID phase
    while (expr.length && expr.length !== lastExpr2) {
      lastExpr2 = expr.length;
      match = null;

      r = [], ri = -1, i = 0, iz = ctx.length;

      joint = JOINT2[expr.charAt(0)] || 9;

      switch (joint) {
      case 1: // 1: "#id"
      case 2: // 2: ".class"
        --joint;
        if ( (match = expr.match(ID_OR_CLASS)) ) {
          needle = joint ? (" " + match[1] + " ") // " className "
                         : match[1];              // "id"
          jz = needle.length;

          for (; i < iz; ++i) {
            v = ctx[i];
            w = joint ? v.className : v.id;
            if (w) {
              if (joint ? (" " + w + " ").indexOf(needle) >= 0 : w === needle) {
                r[++ri] = v;
              }
            }
          }
        }
        break;

      case 3: // 3: pseudo
        if ( (match = expr.match(PSEUDO)) ) {
          if (iz) {
            pseudo = match[1];

            // xxx-child and xxx-type
            if (/[a-z]+\-(child|type)$/.test(pseudo) && ctx[0] === rootElement) {
              r = [];
            } else {
              if ( !(filter = FILTER[pseudo]) ) {
                throw ":%s unsupported".replace("%s", pseudo);
              }
              if (filter[0] & 0x100) { // 0x100 is none operation
                r = ctx;
              } else {
                v = match[3] || match[4];
                r = filter[1].call(this, filter[0], ctx, pseudo, v, _tags, _xml);
              }
            }
          }
        }
        break;

      case 4: // 4: Attr "[A=V]" or "[A]"
        if ( (match = expr.match(ATTR)) ) {
          if (match[6]) { // "[A]"
            needle = match[6];
            for (; i < iz; ++i) {
              v = ctx[i];
              if (_ie) {
                w = v.getAttributeNode(needle);
                if (w && w.specified) {
                  r[++ri] = v;
                }
              } else if (v.hasAttribute(needle)) {
                r[++ri] = v;
              }
            }
          } else { // "[A=V]"
            needle = match[4].replace(UU.TRIM_QUOTE, "");
            operator = ATTR_OPERATOR[match[2]];
            w = match[5] || "";

            if (operator === 3) { // 3: "/=" is regexp operator
              needle = RegExp(needle, w);
            } else {
              // fix [class=i] -> match[4] = "", match[5] = "i"
              w && (needle += w);
            }
            r = judgeAttr(ctx, match[1], operator, needle);
          }
        }
      }

      if (match) {
        ctx = r;
        expr = expr.slice(match[0].length);
      }
    }

    // "E,F" phase
    if (withcomma && expr && (match = expr.match(/^\s*,\s*/)) ) { // complex
      ++mixed;
      mix(ctx, rv, guard);
      ctx = [context];
      lastExpr1 = lastExpr2 = 0;
      expr = expr.slice(match[0].length);
    }
  }

  if (expr.length) {
    throw ":%s unsupported".replace("%s", expr);
  }
  return mixed ? mix(ctx, rv, guard) : ctx;
}

// mix results
function mix(ctx, rv, unq) {
  var ri = rv.length - 1, i = 0, iz = ctx.length, v, uuid;

  for (; i < iz; ++i) {
    v = ctx[i];
    uuid = v.uuid || (v.uuid = ++uu._uuid);

    if (!(uuid in unq)) {
      rv[++ri] = v;
      unq[uuid] = 1;
    }
  }
  return rv;
}

function isXMLDocument(context) {
  var owner = context.ownerDocument || uudoc,
      p = owner.createElement("p"),
      P = owner.createElement("P");
  // see http://d.hatena.ne.jp/uupaa/20081010/1223630689 [THX! id:os0x]
  return p.tagName !== P.tagName; // true: XMLDocument, false: HTMLDocument
}

function addTag(tag, xml /* = false */) {
  var lo = tag.toLowerCase(), up = tag.toUpperCase();
  if (!(lo in htmlTag)) {
    xmlTag[up] = htmlTag[lo] = htmlTag[up] = up;
    xmlTag[lo] = lo;
  }
  return xml ? tag : up;
}

// [attr operator "value"]
function judgeAttr(elms, attr, operator, value) {
  var rv = [], ri = -1, ok, r, e, v = value, i = 0,
      insens = !(attr in ATTR_CASESENS), // case insensitive
      ie = _ie, ie8mode8 = _ie8mode8, iebug = ATTR_IE_BUG; // scope solver

  if (operator !== 3) { // 3: "/="
    v = v.replace(UU.TRIM_QUOTE, "");
    if (insens) {
      v = v.toLowerCase();
    }
    if (operator === 7) { // 7: "~="
      if (v.indexOf(" ") > -1) { return []; } // fix #7b
      v = " " + v + " ";
    }
  }

  while ( (e = elms[i++]) ) {
    if (ie) {
      if (ie8mode8 || iebug[attr]) { // fix a[href^="#"]
        r = e.getAttribute(attr, 2);
      } else {
        r = e.getAttribute(ATTR_ALIAS[attr] || attr);
      }
    } else {
      r = e.getAttribute(attr);
    }

    r = r || "";

    if (r) {
      if (insens) {
        r = r.toLowerCase();
      }
      ok = 0;
      switch (operator) {
      case 1: ok = v === r; break;            // [attr =  value]
      case 2: ok = v !== r; break;            // [attr != value]
      case 3: ok = v.test(r); break;          // [attr /= "regexp"ig]
      case 4: ok = r.indexOf(v) >= 0; break;  // [attr *= value]
      case 5: ok = !r.indexOf(v); break;      // [attr ^= value]
      case 6: ok = (r.lastIndexOf(v) + v.length) === r.length; break; // [attr $= value]
      case 7: ok = (" " + r + " ").indexOf(v) !== -1; break;          // [attr ~= value]
      case 8: ok = ((v === r) ||
                    (r.substring(0, v.length + 1) === v + "-"));      // [attr |= value]
      }
      if (ok) {
        rv[++ri] = e;
      }
    }
  }
  return rv;
}

// :first-child  :last-child  :only-child
function childFilter(fid, elms) {
  var rv = [], ri = -1, i = 0, v, c, f,
      iter1 = "previousSibling",
      iter2 = "nextSibling";

  while ( (v = elms[i++]) ) {
    f = 0;
    // first-child
    if (fid & 1) {
      for (c = v[iter1]; c; c = c[iter1]) {
        if (c.nodeType === 1) {
          ++f;
          break;
        }
      }
    }
    // last-child
    if (!f && fid & 2) {
      for (c = v[iter2]; c; c = c[iter2]) {
        if (c.nodeType === 1) {
          ++f;
          break;
        }
      }
    }
    if (!f) {
      rv[++ri] = v;
    }
  }
  return rv;
}

// :nth-child  :nth-last-child
function nthFilter(fid, elms, pseudo, value, tags, xml) {
  if (value === "n") {
    return elms;
  }
  // 0x4 = nth-child, 0x5 = nth-last-child
  var v = elms[0].tagName,
      tag = tags[v] || addTag(v, xml),
      rv = [], ri = -1, i = 0, iz = elms.length, uuid, unq = {},
      pn, cn, idx, ok,
      iter1 = (fid === 0x5) ? "lastChild" : "firstChild",
      iter2 = (fid === 0x5) ? "previousSibling" : "nextSibling",
      f = nth(value), a = f.a, b = f.b, k = f.k;

  for (; i < iz; ++i) {
    pn = elms[i].parentNode;
    uuid = pn.uuid || (pn.uuid = ++uu._uuid);

    if (!(uuid in unq)) {
      unq[uuid] = 1;
      idx = 0;

      for (cn = pn[iter1]; cn; cn = cn[iter2]) {
        if (cn.nodeType === 1) {
          ++idx;

          ok = 0;
          switch (k) {
          case 1:  ok = (idx === b); break;
          case 2:  ok = (idx >= b); break;
          case 3:  ok = (!((idx - b) % a) && (idx - b) / a >= 0); break;
          default: ok = (idx <= b);
          }
          if (ok) {
            if (cn.tagName === tag) {
              rv[++ri] = cn;
            }
          }
        }
      }
    }
  }
  return rv;
}

// :nth-of-type  :nth-last-of-type
function nthTypeFilter(fid, elms, pseudo, value) {
  if (fid === 0x07) { // 0x07: nth-last-of-type
    elms.reverse();
  }

  var rv = [], ri = -1, v, i = 0, unq = {},
      idx, pn, currentParent = null, tagName, ok,
      f = nth(value), a = f.a, b = f.b, k = f.k;

  while ( (v = elms[i++]) ) {
    pn = v.parentNode;
    if (pn !== currentParent) {
      currentParent = pn;
      unq = {};
    }

    tagName = v.tagName;
    if (tagName in unq) {
      ++unq[tagName];
    } else {
      unq[tagName] = 1;
    }
    idx = unq[tagName];
    ok = 0;

    switch (k) {
    case 1:  ok = (idx === b); break;
    case 2:  ok = (idx >=  b); break;
    case 3:  ok = (!((idx - b) % a) && (idx - b) / a >= 0); break;
    default: ok = (idx <=  b);
    }
    if (ok) {
      rv[++ri] = v;
    }
  }
  return rv;
}

// :first-of-type  :last-of-type
function ofTypeFilter(fid, elms) {
  if (fid === 0x0a) { // 0x0a: last-of-type
    elms.reverse();
  }
  var rv = [], ri = -1, v, i = 0, unq = {},
      pn, currentParent = null;

  while ( (v = elms[i++]) ) {
    pn = v.parentNode;
    if (pn !== currentParent) {
      currentParent = pn;
      unq = {};
    }
    if (v.tagName in unq) {
      ++unq[v.tagName];
    } else {
      unq[v.tagName] = 1;
    }
    if (unq[v.tagName] === 1) {
      rv[++ri] = v;
    }
  }
  return rv;
}

// :enabled  :disabled  :checked  :digit  :negative  :tween  :playing
function simpleFilter(fid, elms) {
  var rv = [], ri = -1, v, i = 0, ok;

  while ( (v = elms[i++]) ) {
    ok = 0;
    switch (fid) {
    case 0x0b: ok = !v.disabled; break;   // 0x0b: enabled
    case 0x0c: ok = !!v.disabled; break;  // 0x0c: disabled
    case 0x0d: ok = !!v.checked; break;   // 0x0d: checked
    }
    if (ok) {
      rv[++ri] = v;
    }
  }
  return rv;
}

// :root
function root(fid, elms) {
  return elms.length ? [] : [rootElement]; // fix 27b (* html, * root) as IE6 CSS Hack
}

// :target
function target(fid, elms) {
  var rv = [], ri = -1, i = 0, v, needle = location.hash.slice(1);

  if (needle) {
    while ( (v = elms[i++]) ) {
      (v.id || v.name) === needle && (rv[++ri] = v);
    }
  }
  return rv;
}

// :contains
function contains(fid, elms, pseudo, value) {
  var rv = [], ri = -1, v, i = 0, txt,
      needle = value.replace(UU.TRIM_QUOTE, "");

  while ( (v = elms[i++]) ) {
    txt = v[textContent];
    if (txt && txt.indexOf(needle) >= 0) {
      rv[++ri] = v;
    }
  }
  return rv;
}

// :empty
function empty(fid, elms) {
  var rv = [], ri = -1, i = 0, v, c, match;

  while ( (v = elms[i++]) ) {
    if (!v[textContent]) {
      match = 0;
      for (c = v.firstChild; c; c = c.nextSibling) {
        if (c.nodeType === 1) {
          ++match;
          break;
        }
      }
      if (!match) {
        rv[++ri] = v;
      }
    }
  }
  return rv;
}

// :lang
function lang(fid, elms, pseudo, value) {
  var rv = [], ri = -1, v, i = 0, iz = elms.length,
      rex = RegExp("^(" + value + "$|" + value + "-)", "i");

  for (; i < iz; ++i) {
    v = elms[i];
    while (v && v !== uudoc && !v.getAttribute("lang")) {
      v = v.parentNode;
    }
    if ((v && v !== uudoc) && rex.test(v.getAttribute("lang"))) {
      rv[++ri] = elms[i];
    }
  }
  return rv;
}

// :only-of-type
function onlyOfType(fid, elms, pseudo, value, tags, xml) {
  var rv = [], ri = -1, v, i = 0, c, f, t, tagName,
      iter1 = "nextSibling",
      iter2 = "previousSibling";

  while ( (v = elms[i++]) ) {
    f = 0;
    tagName = v.tagName,
    t = tags[tagName] || addTag(tagName, xml);
    for (c = v[iter1]; c; c = c[iter1]) {
      if (c.nodeType === 1 && c.tagName === t) {
        ++f;
        break;
      }
    }
    if (!f) {
      for (c = v[iter2]; c; c = c[iter2]) {
        if (c.nodeType === 1 && c.tagName === t){
          ++f;
          break;
        }
      }
    }
    !f && (rv[++ri] = v);
  }
  return rv;
}

// :not
function not(fid, elms, pseudo, value, tags, xml) {
  var rv = [], ri = -1, i = 0,
      v, w, expr, match, tag;

  switch (JOINT3[value.charAt(0)] || 0) {
  case 1: // :not(*)
    break;
  case 2: // :not(#id)
    expr = value.slice(1);
    while ( (v = elms[i++]) ) {
      (v.id !== expr) && (rv[++ri] = v);
    }
    break;
  case 3: // :not(.class)
    expr = " " + value.slice(1) + " ";
    while ( (v = elms[i++]) ) {
      w = v.className;
      (!w || (" " + w + " ").indexOf(expr) < 0) && (rv[++ri] = v);
    }
    break;
  default: // :not(E)
    if ((match = value.match(/^(\w+)$/))) {
      tag = match[1];
      tag = tags[tag] || addTag(tag, xml);
      while ( (v = elms[i++]) ) {
        (v.tagName !== tag) && (rv[++ri] = v);
      }
      break;
    }
    throw ":not(%s) unsupported".replace("%s", value);
  }
  return rv;
}

// parse :nth-xxx(an+b)
function nth(anb) {
  var a, b, c, match = anb.match(NTH_ANB);

  if (!match) { throw "%s unsupported".replace("%s", anb); }
  if (match[2]) { return { a: 2, b: 0, k: 3 }; } // nth(even)
  if (match[3]) { return { a: 2, b: 1, k: 3 }; } // nth(odd)
  if (match[4]) { return { a: 0, b: parseInt(match[4], 10), k: 1 }; } // nth(1)
  if (match[5]) { return { a: 0, b: 0, k: 2 }; } // nth(1n+0), nth(n+0), nht(n)
  a = (match[7] === "-" ? -1 : match[7] || 1) - 0;
  b = (match[8] || 0) - 0;
  c = a < 2;
  return {
    a: c ? 0 : a,
    b: b,
    k: c ? a + 1 : 3
  };
}

// --- export ---
uu.css.querySelectorAll.FILTER = FILTER;
uu.css.querySelectorAll.childFilter = childFilter;

(function() {
  // prebuild node.uuid
  var ary = uu.tag("*"), v, i = 0, iz = ary.length;
  for (; i < iz; ++i) {
    v = ary[i];
    v.uuid || (v.uuid = ++uu._uuid);
  }
  // create tag dict.
  ary = TAG_DICT.split(",");
  for (i = 0, iz = ary.length; i < iz; ++i) {
    addTag(ary[i]);
  }
})();

})(); // end (function())() scope

} // if (window.uu)
