////////////////////////////////////////////////
// Modifi le 10 juillet 2009
////////////////////////////////////////////////

#ifndef PARSERXML_H
#define PARSERXML_H

#include "tinystr.h"
#include "tinyxml.h"

#include <stdio.h>
#include <stdlib.h>

#include <string>
#include <vector>

#include <iostream>
#include <list>

using namespace std;

//const char *fichier="donnees3.xml";

class experimentateur
{
	public :
		std::string nom;
		std::string surnom;
};

class gaz
{
public :
	std::string nom;
	std::string symbole;
	double masse_moleculaire;
	double temperature_critique;
	double pression_critique;
	double temperature_ebullition;
	double omega;
};

class cellule
{
public :
	int numero;
	double volume_total;
	double volume_calo;
};

void Initialisation_XML();
bool ConfigsExists();
TiXmlElement * NewElement(std::string nom_element, std::string text_element);
TiXmlElement * NewElement(std::string nom_element, int int_element);
TiXmlElement * NewElement(std::string nom_element, float float_element);
TiXmlElement * NewElement(std::string nom_element, double double_element);


vector<experimentateur> GetExperimentateurs();
bool Rajout_Experimentateur(std::string nom,std::string surnom,int index=-1);
bool Rajout_Experimentateur(experimentateur new_exp,int index=-1);
bool Suppression_Experimentateur(int index);
bool Modif_Experimentateur(std::string nom, std::string surnom,int index);
bool Modif_Experimentateur(experimentateur new_exp,int index);


vector<gaz> GetGazs();
bool Rajout_Gaz(std::string nom,std::string symbole,double masse,double temp_critique, 
				double pres_critique, double temp_ebullition, int index=-1);
bool Rajout_Gaz(gaz new_gaz,int index=-1);
bool Suppression_Gaz(int index);
bool Modif_Gaz(std::string nom,std::string symbole,double masse,double temp_critique, 
			   double pres_critique, double temp_ebullition, int index);
bool Modif_Gaz(gaz new_gaz,int index);

vector<cellule> GetCellules();
bool Rajout_Cellule(int num, double total, double calo, int index=-1);
bool Rajout_Cellule(cellule new_cellule,int index=-1);
bool Suppression_Cellule(int index);
bool Modif_Cellule(int num, double total, double calo, int index);
bool Modif_Cellule(cellule new_cellule,int index=-1);

void creation_xml();
void recherche();
void Parcours();
void testliens();

#endif