////////////////////////////////////////////////
// Modifi le 10 juillet 2009
////////////////////////////////////////////////


#include "StdAfx.h"
#include "ParserXML.h"

#include <sstream>

const char* fichierXML = "Donnees.xml";

/////////////////////////////////////////////////////////////
//  XML



void Initialisation_XML()
{
	// Make xml: <?xml ..><Hello>World</Hello>
	TiXmlDocument doc;
	TiXmlDeclaration * decl = new TiXmlDeclaration( "1.0", "iso-8859-1", "" );
	TiXmlElement * element_principal = new TiXmlElement( "experience" );
	TiXmlElement * element = new TiXmlElement( "experimentateurs" );
	TiXmlElement * groupe_gaz = new TiXmlElement( "gazs" );
	TiXmlElement * cellules = new TiXmlElement( "cellules" );
	TiXmlElement * configs = new TiXmlElement( "configs" );


	element_principal->LinkEndChild( element );
	element_principal->LinkEndChild( groupe_gaz );
	element_principal->LinkEndChild( cellules );
	element_principal->LinkEndChild( configs );
	doc.LinkEndChild( decl );
	doc.LinkEndChild( element_principal );

	doc.SaveFile(fichierXML);

	//Rajout des gaz
	//Rajout_Gaz(nom,symbole,masse,temp_critique,pres_critique,temp_ebullition);
	Rajout_Gaz("Azote","N2",28.0134,126.20,33.999,77.35);
	Rajout_Gaz("Helium","He",4.0026,5.20,2.275,4.22);
	Rajout_Gaz("Dioxyde de carbone","CO2",44.0099,304.00,73.825,194.50);
	Rajout_Gaz("Mthane","CH4",16.0430,190.30,45.960,111.40);
	Rajout_Gaz("Monoxyde de carbone","CO",28.0100,132.91,34.987,81.62);
	Rajout_Gaz("Oxygne","O2",31.9900,154.58,50.430,90.18);
	Rajout_Gaz("Propyne","C3H4",40.0650,402.39,56.280,249.94);
	Rajout_Gaz("Ethane","C2H6",31.9900,154.58,50.430,90.18);
	Rajout_Gaz("Propane","C3H8",44.0960,369.82,42.500,231.11);
	Rajout_Gaz("Argon","Ar",39.9480,150.86,48.980,87.29);
	Rajout_Gaz("Hydrogne","H2",2.0160,33.24,12.980,20.38);
	Rajout_Gaz("Butane","C4H10",58.1230,425.18,37.960,272.65);
	Rajout_Gaz("Propylne","C3H6",42.0800,364.75,46.100,225.43);
}

bool ConfigsExists()
{
	TiXmlDocument doc(fichierXML);
	return doc.LoadFile();
}

TiXmlElement * NewElement(string nom_element, string text_element)
{
	TiXmlElement * elem = new TiXmlElement(nom_element.c_str());
	TiXmlText * text = new TiXmlText(text_element.c_str());
	elem->LinkEndChild(text);
	return elem;
}

TiXmlElement * NewElement(string nom_element, int int_element)
{
	ostringstream text_element;
	text_element << int_element;

	return NewElement(nom_element,text_element.str());
}

TiXmlElement * NewElement(string nom_element, float float_element)
{
	ostringstream text_element;
	text_element << float_element;

	return NewElement(nom_element,text_element.str());
}

TiXmlElement * NewElement(string nom_element, double double_element)
{
	ostringstream text_element;
	text_element << double_element;

	return NewElement(nom_element,text_element.str());
}


///////////////////////////////////////////////////////////////////////////////
// Fonctions experimentateur

vector<experimentateur> GetExperimentateurs()
{
	vector<experimentateur> t_experimentateur;
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		return t_experimentateur;
	}


	TiXmlHandle docHandle( &doc );
	TiXmlNode *root;

	TiXmlHandle handle_root(docHandle.FirstChild("experience").FirstChild("experimentateurs")
					.FirstChild("experimentateur").Node());

	root = handle_root.Node();

	experimentateur tableau_experimentateur[10];
	int compteur = 0;
	while(root)
	{
		experimentateur exp;
		exp.nom = root->FirstChildElement("nom")->GetText();
		exp.surnom = root->FirstChildElement("surnom")->GetText();

		t_experimentateur.push_back(exp);

		root = root->NextSibling();
	}

	return t_experimentateur;

}



bool Rajout_Experimentateur(string nom,string surnom,int index)
{
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		return FALSE;
	}

	TiXmlHandle hdl(&doc);
	TiXmlElement *elem = hdl.FirstChild("experience").FirstChild("experimentateurs").Element();


	TiXmlElement nouvel_experimentateur("experimentateur");
	TiXmlElement * element_nom = NewElement("nom", nom);

	TiXmlElement * element_surnom = NewElement("surnom",surnom);
	nouvel_experimentateur.LinkEndChild(element_nom);
	nouvel_experimentateur.LinkEndChild(element_surnom);


	TiXmlElement *elem_parcours = hdl.FirstChild("experience").FirstChild("experimentateurs").
									FirstChild("experimentateur").Element();

	for(int i=0;i<index && (elem_parcours);i++)
		elem_parcours = elem_parcours->NextSiblingElement();

	if ((index==-1) || (!elem_parcours))
		elem->InsertEndChild(nouvel_experimentateur);
	else
		elem->InsertBeforeChild(elem_parcours,nouvel_experimentateur);

	return doc.SaveFile(fichierXML);
}


bool Rajout_Experimentateur(experimentateur new_exp,int index)
//void Rajout_Experimentateur()
{
	return Rajout_Experimentateur(new_exp.nom,new_exp.surnom,index);
}


//index : position dans le vector<experimentateur utilis
bool Suppression_Experimentateur(int index)
{
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		/*
		cerr << "erreur lors du chargement" << endl;
		cerr << "error #" << doc.ErrorId() << " : " << doc.ErrorDesc() << endl;
		*/
		//return 1;
		return FALSE;
	}

	TiXmlHandle hdl(&doc);
	TiXmlElement *elem = hdl.FirstChild("experience").FirstChild("experimentateurs").
							FirstChild("experimentateur").Element();
	TiXmlElement *f = hdl.FirstChild("experience").FirstChild("experimentateurs").Element();

	for(int i=0;i<index;i++)
		elem=elem->NextSiblingElement();
	f->RemoveChild(elem);
	return doc.SaveFile(fichierXML);
}

bool Modif_Experimentateur(string nom, string surnom,int index)
{
	Suppression_Experimentateur(index);
	return Rajout_Experimentateur(nom,surnom,index);
}

bool Modif_Experimentateur(experimentateur new_exp,int index)
{
	Suppression_Experimentateur(index);
	return Rajout_Experimentateur(new_exp,index);
}




//////////////////////////////////////////////////////////////////////////
// Fonctions Gaz


vector<gaz> GetGazs()
{
	vector<gaz> t_gaz;
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		return t_gaz;
	}

	


	TiXmlHandle docHandle( &doc );
	TiXmlNode *root;//,  *child;

	TiXmlHandle handle_root(docHandle.FirstChild("experience").FirstChild("gazs")
					.FirstChild("gaz").Node());



	root = handle_root.Node();

	while(root)
	{
		gaz m_gaz;
		m_gaz.nom = root->FirstChildElement("nom")->GetText();
		m_gaz.symbole = root->FirstChildElement("symbole")->GetText();
		m_gaz.masse_moleculaire = atof(root->FirstChildElement("masse_moleculaire")->GetText());
		m_gaz.temperature_critique = atof(root->FirstChildElement("temperature_critique")->GetText());
		m_gaz.pression_critique = atof(root->FirstChildElement("pression_critique")->GetText());
		m_gaz.temperature_ebullition = atof(root->FirstChildElement("temperature_ebullition")->GetText());
		m_gaz.omega = atof(root->FirstChildElement("omega")->GetText());


		t_gaz.push_back(m_gaz);
		root = root->NextSibling();
	}
	return t_gaz;
}

bool Rajout_Gaz(string nom,string symbole,double masse,double temp_critique, 
				double pres_critique, double temp_ebullition, int index)
{
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		/*
		cerr << "erreur lors du chargement" << endl;
		cerr << "error #" << doc.ErrorId() << " : " << doc.ErrorDesc() << endl;
		*/
		return FALSE;
	}

	TiXmlHandle hdl(&doc);
	TiXmlElement *elem = hdl.FirstChild("experience").FirstChild("gazs").Element();

	TiXmlElement nouveau_gaz("gaz");

	TiXmlElement * element_nom = NewElement("nom",nom);
	TiXmlElement * element_symbole = NewElement("symbole",symbole);
	TiXmlElement * element_masse = NewElement("masse_moleculaire",masse);
	TiXmlElement * element_temp_critique = NewElement("temperature_critique",temp_critique);
	TiXmlElement * element_pres_critique = NewElement("pression_critique",pres_critique);
	TiXmlElement * element_temp_ebullition = NewElement("temperature_ebullition",temp_ebullition);
	TiXmlElement * element_omega = NewElement("omega",temp_ebullition/temp_critique);


	nouveau_gaz.LinkEndChild(element_nom);
	nouveau_gaz.LinkEndChild(element_symbole);
	nouveau_gaz.LinkEndChild(element_masse);
	nouveau_gaz.LinkEndChild(element_temp_critique);
	nouveau_gaz.LinkEndChild(element_pres_critique);
	nouveau_gaz.LinkEndChild(element_temp_ebullition);
	nouveau_gaz.LinkEndChild(element_omega);

	//elem->InsertEndChild(nouveau_gaz);

	TiXmlElement *elem_parcours = hdl.FirstChild("experience").FirstChild("gazs").
									FirstChild("gaz").Element();

	for(int i=0;i<index && (elem_parcours);i++)
		elem_parcours = elem_parcours->NextSiblingElement();
	if ((index==-1) || (!elem_parcours))
		elem->InsertEndChild(nouveau_gaz);
	else
		elem->InsertBeforeChild(elem_parcours,nouveau_gaz);


	return doc.SaveFile(fichierXML);
}

bool Rajout_Gaz(gaz new_gaz,int index)
{
	return Rajout_Gaz(new_gaz.nom,new_gaz.symbole,new_gaz.masse_moleculaire,new_gaz.temperature_critique,
		new_gaz.pression_critique,new_gaz.temperature_ebullition,index);
}


bool Suppression_Gaz(int index)
{
	//TiXmlDocument doc("Donnees2.xml");
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		/*
		cerr << "erreur lors du chargement" << endl;
		cerr << "error #" << doc.ErrorId() << " : " << doc.ErrorDesc() << endl;
		*/
		//return 1;
		return FALSE;
	}

	TiXmlHandle hdl(&doc);
	TiXmlElement *elem = hdl.FirstChild("experience").FirstChild("gazs").
							FirstChild("gaz").Element();
	TiXmlElement *f = hdl.FirstChild("experience").FirstChild("gazs").Element();

	for(int i=0;i<index;i++)
		elem=elem->NextSiblingElement();
	f->RemoveChild(elem);
	//return doc.SaveFile("Donnees2.xml");
	return doc.SaveFile(fichierXML);
}

bool Modif_Gaz(string nom,string symbole,double masse,double temp_critique, 
				double pres_critique, double temp_ebullition, int index)
{
	Suppression_Gaz(index);
	return Rajout_Gaz(nom,symbole,masse,temp_critique,
					  pres_critique,temp_ebullition,index);
}

bool Modif_Gaz(gaz new_gaz,int index)
{
	Suppression_Gaz(index);
	return Rajout_Gaz(new_gaz,index);
}


//////////////////////////////////////////////////////////////////////////////////
// Fonctions Cellule


vector<cellule> GetCellules()
{
	vector<cellule> t_cellule;
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		return t_cellule;
	}


	TiXmlHandle docHandle( &doc );
	TiXmlNode *root;

	TiXmlHandle handle_root(docHandle.FirstChild("experience").FirstChild("cellules")
					.FirstChild("cellule").Node());

	root = handle_root.Node();

	while(root)
	{
		cellule cell;
		cell.numero = atoi(root->FirstChildElement("numero")->GetText());
		cell.volume_total = atof(root->FirstChildElement("volume_total")->GetText());
		cell.volume_calo = atof(root->FirstChildElement("volume_calo")->GetText());

		t_cellule.push_back(cell);

		root = root->NextSibling();
	}

	return t_cellule;

}



bool Rajout_Cellule(int num, double total, double calo, int index)
{
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		return FALSE;
	}

	TiXmlHandle hdl(&doc);
	TiXmlElement *elem = hdl.FirstChild("experience").FirstChild("cellules").Element();


	TiXmlElement nouvel_cellule("cellule");
	TiXmlElement * element_numero = NewElement("numero", num);

	TiXmlElement * element_total = NewElement("volume_total",total);
	TiXmlElement * element_calo = NewElement("volume_calo",calo);
	nouvel_cellule.LinkEndChild(element_numero);
	nouvel_cellule.LinkEndChild(element_total);
	nouvel_cellule.LinkEndChild(element_calo);


	TiXmlElement *elem_parcours = hdl.FirstChild("experience").FirstChild("cellules").
									FirstChild("cellule").Element();

	for(int i=0;i<index && (elem_parcours);i++)
		elem_parcours = elem_parcours->NextSiblingElement();

	if ((index==-1) || (!elem_parcours))
		elem->InsertEndChild(nouvel_cellule);
	else
		elem->InsertBeforeChild(elem_parcours,nouvel_cellule);

	return doc.SaveFile(fichierXML);
}


bool Rajout_Cellule(cellule new_cellule,int index)
//void Rajout_Experimentateur()
{
	return Rajout_Cellule(new_cellule.numero,new_cellule.volume_total,new_cellule.volume_calo,index);
}


//index : position dans le vector<experimentateur utilis
bool Suppression_Cellule(int index)
{
	TiXmlDocument doc(fichierXML);
	if(!doc.LoadFile()){
		/*
		cerr << "erreur lors du chargement" << endl;
		cerr << "error #" << doc.ErrorId() << " : " << doc.ErrorDesc() << endl;
		*/
		//return 1;
		return FALSE;
	}

	TiXmlHandle hdl(&doc);
	TiXmlElement *elem = hdl.FirstChild("experience").FirstChild("cellules").
							FirstChild("cellule").Element();
	TiXmlElement *f = hdl.FirstChild("experience").FirstChild("cellules").Element();

	for(int i=0;i<index;i++)
		elem=elem->NextSiblingElement();
	f->RemoveChild(elem);
	return doc.SaveFile(fichierXML);
}

bool Modif_Cellule(int num, double total, double calo, int index)
{
	Suppression_Cellule(index);
	return Rajout_Cellule(num,total,calo,index);
}

bool Modif_Cellule(cellule new_cellule,int index)
{
	Suppression_Cellule(index);
	return Rajout_Cellule(new_cellule,index);
}


//////////////////////////////////////////////////////////////////////////////////
// Fonctions Tests

void creation_xml()
{
	// Make xml: <?xml ..><Hello>World</Hello>
	TiXmlDocument doc;
	TiXmlDeclaration * decl = new TiXmlDeclaration( "1.0", "iso-8859-1", "" );
	TiXmlElement * element_principal = new TiXmlElement( "experience" );
	TiXmlElement * element = new TiXmlElement( "experimentateurs" );
	TiXmlElement * groupe_gaz = new TiXmlElement( "gazs" );
	TiXmlElement * cellules = new TiXmlElement( "cellules" );
	TiXmlElement * configs = new TiXmlElement( "configs" );

	TiXmlElement * simple_gaz = new TiXmlElement( "gaz" );
	TiXmlElement * element_nom_gaz = new TiXmlElement("nom");
	TiXmlText * text_nom_gaz = new TiXmlText( "Azote" );
	element_nom_gaz->LinkEndChild(text_nom_gaz);

	TiXmlElement * element_symbole_gaz = new TiXmlElement("symbole");
	TiXmlText * text_symbole_gaz = new TiXmlText( "N2" );
	element_symbole_gaz->LinkEndChild(text_symbole_gaz);

	simple_gaz->LinkEndChild(element_nom_gaz);
	simple_gaz->LinkEndChild(element_symbole_gaz);

	groupe_gaz->LinkEndChild(simple_gaz);


	element_principal->LinkEndChild( element );
	element_principal->LinkEndChild( groupe_gaz );
	element_principal->LinkEndChild( cellules );
	element_principal->LinkEndChild( configs );
	doc.LinkEndChild( decl );
	doc.LinkEndChild( element_principal );

	doc.SaveFile("Donnees.xml");
}

/*
<liens>
  <lien id="a1">up</lien>
  <lien id="a2">down</lien>
</liens>
*/

void recherche()
{
	TiXmlDocument doc( "donnees.xml" );
	doc.LoadFile(); // Charge ton fichier
		 
	TiXmlHandle docHandle( &doc );
	TiXmlNode *root,  *child;
		 
	root = docHandle.FirstChild("experimentateurs").Node(); // Noeud principal (la balise <liens>)
	child =  docHandle.Node();
		 
		 
	if ( root && (root->Value() != "experimentateurs")) // Si le n oeud principal !=la balise <liens>
	{
		//mess << "Fichier donnees.xml non valide";
		//throw (mess.str());
	}
		 
	string val = root->FirstChild()->Value(); //REcuperation du 1er fils (ici up)

	child = root->IterateChildren( child ); // Passe a la balise suivante

	string val2 = child->FirstChild()->Value(); //REcuperation du 2eme fils (ici down) 
}

void Parcours()
{
	TiXmlDocument doc( "donnees3.xml" );
	//TiXmlDocument doc(fichier);	 
	doc.LoadFile(); // Charge ton fichier

	TiXmlHandle docHandle( &doc );
	TiXmlNode *root,  *child;
		 
	root = docHandle.FirstChild("experience").FirstChild("experimentateurs").FirstChild("experimentateur").Node(); // Noeud principal (la balise <liens>)
	//child =  docHandle.Node();
		 
	/*	 
	if ( root && (root->ValueStr() != "experimentateurs")) // Si le n oeud principal !=la balise <liens>
	{
		mess << "Fichier donnees.xml non valide";
		throw (mess.str());
	}
	*/
		 
	const char* val = root->FirstChild()->Value(); //REcuperation du 1er fils (ici up)



	child = root->NextSibling(); // Passe a la balise suivante

	//const char* val2 = child->FirstChild()->Value(); //REcuperation du 2eme fils (ici down) 
	
	const char* val2 = child->FirstChildElement ()->GetText();
	cerr  << val << " " << val2 << endl;

}

void testliens()
{
TiXmlDocument doc( "liens.xml" );
  doc.LoadFile(); // Charge ton fichier
 
  TiXmlHandle docHandle( &doc );
  TiXmlNode *root,  *child;
 
  root = docHandle.FirstChild("liens").Node(); // Noeud principal (la balise <liens>)
  child =  docHandle.Node();
 
 /*
  if ( root && (root->ValueStr() != "liens")) // Si le n oeud principal !=la balise <liens>
    {
     // mess << "Fichier lien.xml non valide";
     // throw (mess.str());
    }
 */

//string val = root->FirstChild()->Value(); //REcuperation du 1er fils (ici up)
  const char* val_char = root->FirstChild()->Value();

//child = root->IterateChildren( child ); // Passe a la balise suivante

//string val2 = child->FirstChild()->Value(); //REcuperation du 2eme fils (ici down) 
cerr  << val_char << " " /*<< val2 */<< endl;

}