// Parametres_experience.cpp: fichier d'implmentation
//

#include "stdafx.h"
#include "Kaolla.h"
#include "Parametres_experience.h"

//#include "ParserXML.h"

#include "SpinBtnCtrl.h"

#include <sstream>


///////////////////////////////////////////////////////////////////
//
// Bote de dialogue CGeneral

IMPLEMENT_DYNAMIC(CGeneral, CPropertyPage)

CGeneral::CGeneral()
	: CPropertyPage(CGeneral::IDD)
	, m_strNomFichier(_T(""))
	, m_strChemin(_T(""))
	, m_strNomEchantillon(_T(""))
	, m_fMasseEchantillon(0)
	, m_nIndexGaz(0)
	, m_StrCommentaires(_T(""))
	, m_nIndexExperimentateur(0)
{

}

CGeneral::~CGeneral()
{
}

void CGeneral::DoDataExchange(CDataExchange* pDX)
{
TRACE("Entering CGeneral::DoDataExchange -- %d\n",
          pDX->m_bSaveAndValidate);

	CPropertyPage::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_NOM_FICHIER, m_strNomFichier);
	DDX_Text(pDX, IDC_NOM_CHEMIN, m_strChemin);
	DDX_Text(pDX, IDC_NOM_ECHANTILLON, m_strNomEchantillon);
	DDX_Text(pDX, IDC_MASSE_ECHANTILLON, m_fMasseEchantillon);
	DDV_MinMaxFloat(pDX, m_fMasseEchantillon, 0, 5);
	DDX_Control(pDX, IDC_SPIN_MASSE_ECHANTILLON, pSpinMasseEchantillon);
	DDX_Control(pDX, IDC_COMBO_GAZ, m_CBGaz);
	DDX_CBIndex(pDX, IDC_COMBO_GAZ, m_nIndexGaz);
	DDX_Control(pDX, IDC_COMMENTAIRES, m_EditCommentaires);
	DDX_Text(pDX, IDC_COMMENTAIRES, m_StrCommentaires);
	DDX_Control(pDX, IDC_COMBO_EXPERIMENTATEUR, m_CBExperimentateur);
	DDX_CBIndex(pDX, IDC_COMBO_EXPERIMENTATEUR, m_nIndexExperimentateur);
}

BOOL CGeneral::OnCommand(WPARAM wParam, LPARAM lParam)
{
	SetModified(TRUE);
	return CPropertyPage::OnCommand(wParam,lParam);
}

BEGIN_MESSAGE_MAP(CGeneral, CPropertyPage)
	ON_CBN_SELCHANGE(IDC_COMBO_GAZ, &CGeneral::OnCbnSelchangeComboGaz)
	ON_CBN_SELCHANGE(IDC_COMBO_EXPERIMENTATEUR, &CGeneral::OnCbnSelchangeComboExperimentateur)
	ON_EN_CHANGE(IDC_NOM_ECHANTILLON, &CGeneral::OnEnChangeNomEchantillon)
END_MESSAGE_MAP()


// Gestionnaires de messages de CGeneral

BOOL CGeneral::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	CString strValue;

	if(!ConfigsExists())
		Initialisation_XML();

	list_gaz=GetGazs();
	list_experimentateur=GetExperimentateurs();
	for(int i=0;i<list_gaz.size();i++)
	{
		CString StrSymbole;
		StrSymbole.Format(_T("%s"),list_gaz[i].symbole.c_str());
		m_CBGaz.InsertString(-1,StrSymbole);
	}

	for(int i=0;i<list_experimentateur.size();i++)
	{
		CString StrSurnom;
		StrSurnom.Format(_T("%s"),list_experimentateur[i].surnom.c_str());
		m_CBExperimentateur.InsertString(-1,StrSurnom);
	}




	pSpinMasseEchantillon.SetRange(0,5);
	pSpinMasseEchantillon.SetPos(1);
	pSpinMasseEchantillon.SetInc(-0.0001);
	pSpinMasseEchantillon.SetFormat("%1.4f");
	pSpinMasseEchantillon.UpdateBuddy();
	
	

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: les pages de proprits OCX devraient retourner FALSE
}


void CGeneral::RajoutSymboleCombo(CString StrSymbole)
{
	m_CBGaz.InsertString(-1,StrSymbole);
}



void CGeneral::OnCbnSelchangeComboGaz()
{
	UpdateData(TRUE);
	gaz_exp=list_gaz[m_nIndexGaz];
	CString extention=_T(".csv");
	CString string_gaz;
	string_gaz.Format(_T("%s_"), gaz_exp.symbole.c_str());


	CString string_experimentateur;
	string_experimentateur.Format(_T("_%s"), experimentateur_exp.surnom.c_str());

	m_strNomFichier = string_gaz + m_strNomEchantillon + string_experimentateur + extention;

	UpdateData(FALSE);
}



void CGeneral::OnCbnSelchangeComboExperimentateur()
{
	UpdateData(TRUE);
	experimentateur_exp=list_experimentateur[m_nIndexExperimentateur];
	CString extention=_T(".csv");
	CString string_gaz;
	string_gaz.Format(_T("%s_"), gaz_exp.symbole.c_str());

	CString string_experimentateur;
	string_experimentateur.Format(_T("_%s"), experimentateur_exp.surnom.c_str());

	//m_strNomFichier = string_gaz + string_experimentateur + extention;
	m_strNomFichier = string_gaz + m_strNomEchantillon + string_experimentateur + extention;

	UpdateData(FALSE);
}

void CGeneral::OnEnChangeNomEchantillon()
{
	UpdateData(TRUE);
	CString extention=_T(".csv");
	CString string_gaz;
	string_gaz.Format(_T("%s_"), gaz_exp.symbole.c_str());

	CString string_experimentateur;
	string_experimentateur.Format(_T("_%s"), experimentateur_exp.surnom.c_str());



	m_strNomFichier = string_gaz + m_strNomEchantillon + string_experimentateur + extention;

	UpdateData(FALSE);
}

BOOL CGeneral::OnApply()
{
	// TODO : ajoutez ici votre code spcialis et/ou l'appel de la classe de base

	return CPropertyPage::OnApply();

}


//////////////////////////////////////////////////////////////////////////////////////
//
// Bote de dialogue CDivers

IMPLEMENT_DYNAMIC(CDivers, CPropertyPage)

CDivers::CDivers()
	: CPropertyPage(CDivers::IDD)
	, m_nNumCellule(0)
	, m_fVolumeTotal(0)
	, m_fVolumeCalo(0)
	, m_nTempsLigneBase(0)
	, m_nTempsVide(0)
{

}

CDivers::~CDivers()
{
}

void CDivers::DoDataExchange(CDataExchange* pDX)
{
	TRACE("Entering CDivers::DoDataExchange -- %d\n",
		pDX->m_bSaveAndValidate);
	CPropertyPage::DoDataExchange(pDX);
	if(!pDX->m_bSaveAndValidate){
		DDX_Control(pDX, IDC_COMBO_CELLULE, m_CBCellule);
		DDX_CBIndex(pDX, IDC_COMBO_CELLULE, m_nNumCellule);
		DDX_Control(pDX, IDC_EDIT_TEMPS_LIGNE_BASE, m_EditTempsLigneBase);
		DDX_Text(pDX, IDC_EDIT_TEMPS_LIGNE_BASE, m_nTempsLigneBase);
		DDX_Control(pDX, IDC_SPIN_TEMPS_LIGNE_BASE, m_SpinTempsLigneBase);/*
		DDX_Control(pDX, IDC_BUTTON1, m_ButtonCellule);
		DDX_Control(pDX, IDC_EDIT_VOLUME_TOTAL, m_EditVolumeTotal);
		DDX_Text(pDX, IDC_EDIT_VOLUME_TOTAL, m_fVolumeTotal);
		DDX_Control(pDX, IDC_EDIT_VOLUME_CALO, m_EditVolumeCalo);
		DDX_Text(pDX, IDC_EDIT_VOLUME_CALO, m_fVolumeCalo);
		//DDX_Control(pDX, IDC_CHECK_MISE_SOUS_VIDE, m_CheckMiseSousVide);
		DDX_Control(pDX, IDC_EDIT_TEMPS_VIDE, m_EditTempsVide);
		DDX_Text(pDX, IDC_EDIT_TEMPS_VIDE, m_nTempsVide);
		DDX_Control(pDX, IDC_SPIN_TEMPS_VIDE, m_SpinTempsVide);*/
	}
}

BOOL CDivers::OnCommand(WPARAM wParam, LPARAM lParam)
{
	SetModified(TRUE);
	return CPropertyPage::OnCommand(wParam,lParam);
}

BEGIN_MESSAGE_MAP(CDivers, CPropertyPage)
	ON_CBN_SELCHANGE(IDC_COMBO_CELLULE, &CDivers::OnCbnSelchangeComboCellule)
END_MESSAGE_MAP()


// Gestionnaires de messages de CDivers

BOOL CDivers::OnInitDialog()
{
	//CPropertyPage::OnInitDialog();

	list_cellule=GetCellules();
	if (list_cellule.size()==0)
	{
		GetDlgItem (IDC_COMBO_CELLULE)->EnableWindow ( false ) ;
		m_nNumCellule=-1;
	}


	for(int i=0;i<list_cellule.size();i++)
	{
		CString StrNumero;
		StrNumero.Format(_T("%d "),list_cellule[i].numero);
		m_CBCellule.InsertString(-1,StrNumero);
	}


		m_SpinTempsLigneBase.SetRange(2,120);
	m_SpinTempsLigneBase.SetPos(15);
	m_SpinTempsLigneBase.SetInc(-1);
	m_SpinTempsLigneBase.SetFormat("%d");
	m_SpinTempsLigneBase.UpdateBuddy();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: les pages de proprits OCX devraient retourner FALSE
}


void CDivers::OnCbnSelchangeComboCellule()
{
	UpdateData(TRUE);
	cellule_exp=list_cellule[m_nNumCellule];

	UpdateData(FALSE);
}


/////////////////////////////////////////////////////////////////////////////////
//
// CProprietes_experience

IMPLEMENT_DYNAMIC(CProprietes_experience, CPropertySheet)

CProprietes_experience::CProprietes_experience(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{

}

CProprietes_experience::CProprietes_experience(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
	AddPage(&m_general);
	AddPage(&m_divers);
}

CProprietes_experience::~CProprietes_experience()
{
}


BEGIN_MESSAGE_MAP(CProprietes_experience, CPropertySheet)
END_MESSAGE_MAP()


// Gestionnaires de messages de CProprietes_experience


