#include "stdafx.h"
#include "cdbMapping.h"

#using <System.Xml.dll>
#using <System.dll>

using namespace System;
using namespace System::Xml;
using namespace System::Xml::Serialization;
using namespace System::IO;
using namespace cdbTest;

template <typename T>
public ref class Serializer
{
public:
   static void start(String^ filename, T^ t)
   {
      // Read and write purchase orders.
      Serializer^ s = gcnew Serializer;
      s->Read(filename, t);
   }

   static void create(String^ filename, T^ t)
   {
      // Read and write purchase orders.
      Serializer^ s = gcnew Serializer;
      s->Write(filename, t);
   }


protected:
  void Write(String^ filename, T^ t)
  {
      // Create an instance of the XmlSerializer class;
      // specify the type of object to serialize.
      XmlSerializer^ serializer = gcnew XmlSerializer( T::typeid );
      TextWriter^ writer = gcnew StreamWriter( filename );

      // Serialize the purchase order, and close the TextWriter.
      serializer->Serialize( writer, t );
      writer->Close();
   }


   void Read( String^ filename, T^ t)
   {
      // Create an instance of the XmlSerializer class;
      // specify the type of object to be deserialized.
      XmlSerializer^ serializer = gcnew XmlSerializer( T::typeid );

      /* If the XML document has been altered with unknown 
            nodes or attributes, handle them with the 
            UnknownNode and UnknownAttribute events.*/
      serializer->UnknownNode += gcnew XmlNodeEventHandler( this, &Serializer::serializer_UnknownNode );
      serializer->UnknownAttribute += gcnew XmlAttributeEventHandler( this, &Serializer::serializer_UnknownAttribute );

      // A FileStream is needed to read the XML document.
      FileStream^ fs = gcnew FileStream( filename,FileMode::Open );

      // Declare an object variable of the type to be deserialized.

      /* Use the Deserialize method to restore the object's state with
            data from the XML document. */
      t = dynamic_cast<T^>(serializer->Deserialize( fs ));

   }

private:
   void serializer_UnknownNode( Object^ /*sender*/, XmlNodeEventArgs^ e )
   {
      Console::WriteLine( "Unknown Node:{0}\t{1}", e->Name, e->Text );
   }

   void serializer_UnknownAttribute( Object^ /*sender*/, XmlAttributeEventArgs^ e )
   {
      System::Xml::XmlAttribute^ attr = e->Attr;
      Console::WriteLine( "Unknown attribute {0}='{1}'", attr->Name, attr->Value );
   }
};



