#include "stdafx.h"
#include "etl.h"
#include "ConfTraitement_2Car.h"

#include "ConfTraitement_2Mois.h"
#include "DlgSaisieDate.h"
#include "GestionBD.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgCalendrierDechargement dialog


CDlgCalendrierDechargement::CDlgCalendrierDechargement(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgCalendrierDechargement::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgCalendrierDechargement)
	m_strHeureMois = _T("");
	//}}AFX_DATA_INIT

	oDatePrevue = COleDateTime::GetCurrentTime();

	m_oDechMensuel.type = CGestionDechargementsAuto::CPeriode::MENSUEL;
	m_oDechMensuel.oHeure = COleDateTime::GetCurrentTime();
}


void CDlgCalendrierDechargement::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgCalendrierDechargement)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgCalendrierDechargement, CDialog)
	//{{AFX_MSG_MAP(CDlgCalendrierDechargement)
	ON_BN_CLICKED(IDC_MODIF_MENSUEL, OnMensJour)
	ON_BN_CLICKED(IDC_RADIO_MENSUEL, OnMensuel)
	ON_BN_CLICKED(IDC_RADIO_DATE, OnDate)
	ON_BN_CLICKED(IDC_RADIO_HEBDO, OnHebdo)
	ON_BN_CLICKED(IDC_MODIF_DATE, OnModifDate)
	ON_BN_CLICKED(IDC_RADIO_QUOT, OnTLJ)
	ON_BN_CLICKED(IDOK, OnOK)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgCalendrierDechargement message handlers



void CDlgCalendrierDechargement::OnMensuel() 
{
	// on rend visible les controles concernes
	// -> bouton 'Jour du mois'
	GetDlgItem(IDC_AFF_MENSUEL)->ShowWindow(TRUE);
	GetDlgItem(IDC_MODIF_MENSUEL)->ShowWindow(TRUE);
}

void CDlgCalendrierDechargement::OnHebdo() 
{
	CacheTousCtrl();

	// on rend visible les controles concernes
	// -> liste pour le jour dans la semaine
	GetDlgItem(IDC_HEBDO_STATIC1)->ShowWindow(TRUE);
	GetDlgItem(IDC_HEBDO_JOUR)->ShowWindow(TRUE);

	// -> zone edit pour l'heure
	GetDlgItem(IDC_HEBDO_STATIC2)->ShowWindow(TRUE);
	GetDlgItem(IDC_HEBDO_HEURE)->ShowWindow(TRUE);
}

void CDlgCalendrierDechargement::OnDate() 
{
	CacheTousCtrl();

	// on rend visible les controles concernes
	// -> liste pour le jour 
	GetDlgItem(IDC_AFF_DATE)->ShowWindow(TRUE);
	GetDlgItem(IDC_MODIF_DATE)->ShowWindow(TRUE);
}

void CDlgCalendrierDechargement::OnTLJ() 
{
	CacheTousCtrl();
	
	// -> zone edit pour l'heure
	GetDlgItem(IDC_STATIC_QUOT)->ShowWindow(TRUE);
	GetDlgItem(IDC_HEURE_QUOT)->ShowWindow(TRUE);
}

void CDlgCalendrierDechargement::CacheTousCtrl()
{
	// -> mensuel
	GetDlgItem(IDC_AFF_MENSUEL)->ShowWindow(FALSE);
	GetDlgItem(IDC_MODIF_MENSUEL)->ShowWindow(FALSE);

	// -> hebdomadaire
	GetDlgItem(IDC_HEBDO_STATIC1)->ShowWindow(FALSE);
	GetDlgItem(IDC_HEBDO_STATIC2)->ShowWindow(FALSE);
	GetDlgItem(IDC_HEBDO_JOUR)->ShowWindow(FALSE);
	GetDlgItem(IDC_HEBDO_HEURE)->ShowWindow(FALSE);

	// -> date
	GetDlgItem(IDC_AFF_DATE)->ShowWindow(FALSE);
	GetDlgItem(IDC_MODIF_DATE)->ShowWindow(FALSE);

	// -> tous les jours
	GetDlgItem(IDC_STATIC_QUOT)->ShowWindow(FALSE);
	GetDlgItem(IDC_HEURE_QUOT)->ShowWindow(FALSE);
}



BOOL CDlgCalendrierDechargement::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if (m_oDechPrevu.type == CGestionDechargementsAuto::CPeriode::MENSUEL)
	{
		m_oDechMensuel = m_oDechPrevu;
	}

	// TODO: Add extra initialization here

	CacheTousCtrl();

	// remplissage de la liste des jours de la semaine
	CString chaine;
	for (unsigned i=0; i<7; i++)
	{
		chaine.LoadString(IDS_DIMANCHE+i); // dimanche, ...
		((CComboBox*)GetDlgItem(IDC_HEBDO_JOUR))->AddString(chaine);
	}

	((CComboBox*)GetDlgItem(IDC_HEBDO_JOUR))->SetCurSel(0);

	((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_NBJOURS))->SetRange(1, 366);
	((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_NBJOURS))->SetPos(m_oDechPrevu.numJoursADecharger);

	GetDlgItem(IDC_NOM_NE)->SetWindowText(m_sNomNE);
	GetDlgItem(IDC_NOM_TD)->SetWindowText(m_sTypeDonnees);

	// remplissage de la liste des mois

	switch (m_oDechPrevu.type)
	{
	case CGestionDechargementsAuto::CPeriode::QUOTIDIEN:
		((CButton*)GetDlgItem(IDC_RADIO_QUOT))->SetCheck(TRUE);
		OnTLJ();
		((CDateTimeCtrl*)GetDlgItem(IDC_HEURE_QUOT))->SetTime(m_oDechPrevu.oHeure);
		break;

	case CGestionDechargementsAuto::CPeriode::HEBDO:
		OnHebdo();
		((CButton*)GetDlgItem(IDC_RADIO_HEBDO))->SetCheck(TRUE);
		((CComboBox*)GetDlgItem(IDC_HEBDO_JOUR))->SetCurSel(m_oDechPrevu.numJourSemaine);
		((CDateTimeCtrl*)GetDlgItem(IDC_HEBDO_HEURE))->SetTime(m_oDechPrevu.oHeure);
		break;

	case CGestionDechargementsAuto::CPeriode::MENSUEL:
		((CButton*)GetDlgItem(IDC_RADIO_MENSUEL))->SetCheck(TRUE);
		OnMensuel();
		break;

	case CGestionDechargementsAuto::CPeriode::DATE_FIXE:
		((CButton*)GetDlgItem(IDC_RADIO_DATE))->SetCheck(TRUE);
		OnDate();
		oDatePrevue = m_oDechPrevu.oDateFixe;
		break;
	}

	CString sMens = m_oDechMensuel.sFormat();
	GetDlgItem(IDC_AFF_MENSUEL)->SetWindowText(sMens);

	CString sDate = oDatePrevue.Format((UINT)IDS_FORMAT_DATE_HEURE);
	GetDlgItem(IDC_AFF_DATE)->SetWindowText(sDate);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgCalendrierDechargement::OnMensJour() 
{
	// choix du jour dans le mois
	CConfTraitement_2Mois dlgJour;

	dlgJour.m_oPeriode = m_oDechMensuel;

	if (dlgJour.DoModal() == IDOK)
	{
		m_oDechMensuel = dlgJour.m_oPeriode;
		CString sMens = m_oDechMensuel.sFormat();
		GetDlgItem(IDC_AFF_MENSUEL)->SetWindowText(sMens);
	}
}

void CDlgCalendrierDechargement::OnModifDate() 
{
	CDlgSaisieDate oDlg;

	oDlg.m_oDate = oDatePrevue;

	if (oDlg.DoModal() == IDOK)
	{
		oDatePrevue = oDlg.m_oDate;
		CString sDate = oDatePrevue.Format((UINT)IDS_FORMAT_DATE_HEURE);
		GetDlgItem(IDC_AFF_DATE)->SetWindowText(sDate);
	}
}

void CDlgCalendrierDechargement::OnOK() 
{
	if (((CButton*)GetDlgItem(IDC_RADIO_HEBDO))->GetCheck())
	{
		m_oDechPrevu.type = CGestionDechargementsAuto::CPeriode::HEBDO;
		m_oDechPrevu.numJourSemaine = ((CComboBox*)GetDlgItem(IDC_HEBDO_JOUR))->GetCurSel();
		((CDateTimeCtrl*)GetDlgItem(IDC_HEBDO_HEURE))->GetTime(m_oDechPrevu.oHeure);
	}

	if (((CButton*)GetDlgItem(IDC_RADIO_DATE))->GetCheck())
	{
		m_oDechPrevu.type = CGestionDechargementsAuto::CPeriode::DATE_FIXE;
		m_oDechPrevu.oDateFixe = oDatePrevue;
	}

	if (((CButton*)GetDlgItem(IDC_RADIO_QUOT))->GetCheck())
	{
		m_oDechPrevu.type = CGestionDechargementsAuto::CPeriode::QUOTIDIEN;
		((CDateTimeCtrl*)GetDlgItem(IDC_HEURE_QUOT))->GetTime(m_oDechPrevu.oHeure);
	}

	if (((CButton*)GetDlgItem(IDC_RADIO_MENSUEL))->GetCheck())
	{
		m_oDechPrevu = m_oDechMensuel;
	}

	m_oDechPrevu.numJoursADecharger = ((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_NBJOURS))->GetPos();

	CDialog::OnOK();
}
