#include <cstdlib>
#include <iostream>

#include <gtk/gtk.h>

using namespace std;

G_MODULE_EXPORT int cb_quit (GtkWidget * p_wid, gpointer p_data) {
    gtk_main_quit();
    cout<<"quitting"<<endl;
    return 1;
}

//open an openfile dialog and after chhosing a file, start execution
G_MODULE_EXPORT void cb_ok (GtkWidget * p_wid, gpointer p_data) {
    cout<<"hello"<<endl;
}

//loads the UI and starts the main loop
int main (int argc, char ** argv) {
    GtkBuilder  *  p_builder   = NULL;
    GError      *  p_err       = NULL;
    /* Initialisation de GTK+ */
    gtk_init (& argc, & argv);

    /* Creation d'un nouveau GtkBuilder */
    p_builder = gtk_builder_new ();

    if (p_builder != NULL) {
        /* Chargement du XML dans p_builder */
        gtk_builder_add_from_file (p_builder, "interface.xml", & p_err);

        if (p_err == NULL) {
            GtkWidget * p_win = (GtkWidget *) gtk_builder_get_object (
                                    p_builder, "window1");
            g_signal_connect (
                gtk_builder_get_object (p_builder, "okBtn"),
                "clicked", G_CALLBACK (cb_ok), NULL);
            g_signal_connect (
                gtk_builder_get_object (p_builder, "quitBtn"),
                "clicked", G_CALLBACK (cb_quit), NULL);
            g_signal_connect (G_OBJECT (p_win), "destroy", G_CALLBACK (cb_quit), NULL);
            gtk_builder_connect_signals (p_builder, NULL);
            gtk_widget_show_all (p_win);
            gtk_main();
        } else {
            /* Affichage du message d'erreur de GTK+ */
            g_error ("%s", p_err->message);
            g_error_free (p_err);
        }
    }
    exit(EXIT_SUCCESS);
}
