#pragma once
#include "Stl.h"

class CEEDProcessListObj_;
 
class CSubEntityTypeToLoad
{
public:
	CSubEntityTypeToLoad(long a_nSubEntityType, CEEDProcessListObj_* a_pListObj);
	virtual ~CSubEntityTypeToLoad();

public:
	long m_nSubEntityType;
	CEEDProcessListObj_* m_pListObj;
	bool m_bIsListLoaded;
};

class CVectorSubEntityTypesToLoad
	: public std::vector<CSubEntityTypeToLoad*>
{
public:
	CVectorSubEntityTypesToLoad();
	virtual ~CVectorSubEntityTypesToLoad();
	void Clear();
};

class CSubEntityTypesToLoad
	: public CVectorSubEntityTypesToLoad
{
public:
	CSubEntityTypesToLoad(void);
	virtual ~CSubEntityTypesToLoad(void);
	void Add(long a_nSubEntityType, CEEDProcessListObj_* a_pListObj);
	bool ExistsInList(long a_nSubEntityType);
	bool IsLoaded(long a_nSubEntityType);
	void SetLoaded(long a_nSubEntityType);
	void SetAllLoaded();
	CEEDProcessListObj_* GetItems(long a_nSubEntityType);
	CSubEntityTypesToLoad* NewPartialLoad(CSubEntityTypesToLoad* a_SubEntityTypesToLoad);
	
protected:
	CSubEntityTypesToLoad* m_pSubEntityTypesToLoad;
};
