#include "StdAfx.h"
#include ".\subentitytypestoload.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CSubEntityTypeToLoad::CSubEntityTypeToLoad(long a_nSubEntityType, CEEDProcessListObj_* a_pListObj)
{
	m_nSubEntityType = a_nSubEntityType;
	m_pListObj = a_pListObj;
	m_bIsListLoaded = false;
}

CSubEntityTypeToLoad::~CSubEntityTypeToLoad()
{
}

CVectorSubEntityTypesToLoad::CVectorSubEntityTypesToLoad()
{
}

CVectorSubEntityTypesToLoad::~CVectorSubEntityTypesToLoad()
{
	Clear();
}

void CVectorSubEntityTypesToLoad::Clear()
{
	for(long i = 0; i < (long)size(); i++)
		delete at(i);
	
	clear();
}

CSubEntityTypesToLoad::CSubEntityTypesToLoad(void)
{
	m_pSubEntityTypesToLoad = NULL;
}

CSubEntityTypesToLoad::~CSubEntityTypesToLoad(void)
{
	if(m_pSubEntityTypesToLoad)
		delete m_pSubEntityTypesToLoad;
}

void CSubEntityTypesToLoad::Add(long a_nSubEntityType, CEEDProcessListObj_* a_pListObj)
{
	push_back(new CSubEntityTypeToLoad(a_nSubEntityType, a_pListObj));
}

bool CSubEntityTypesToLoad::ExistsInList(long a_nSubEntityType)
{
	for(long i = 0; i < (long)size(); i++)
	{
		if(at(i)->m_nSubEntityType == a_nSubEntityType)
			return true;
	}
	return false;
}

bool CSubEntityTypesToLoad::IsLoaded(long a_nSubEntityType)
{
	for(long i = 0; i < (long)size(); i++)
	{
		if(at(i)->m_nSubEntityType == a_nSubEntityType)
			return at(i)->m_bIsListLoaded;
	}
	return false;
}

CEEDProcessListObj_* CSubEntityTypesToLoad::GetItems(long a_nSubEntityType)
{
	for(long i = 0; i < (long)size(); i++)
	{
		if(at(i)->m_nSubEntityType == a_nSubEntityType)
			return at(i)->m_pListObj;
	}
	return NULL;
}

CSubEntityTypesToLoad* CSubEntityTypesToLoad::NewPartialLoad(CSubEntityTypesToLoad* a_SubEntityTypesToLoad)
{
	if(!m_pSubEntityTypesToLoad)
		m_pSubEntityTypesToLoad = new CSubEntityTypesToLoad();
	else
		m_pSubEntityTypesToLoad->Clear();

	for(long i = 0; i < (long)size(); i++)
	{
		if(!at(i)->m_bIsListLoaded)
		{
			long type = at(i)->m_nSubEntityType;
			if(a_SubEntityTypesToLoad->ExistsInList(type))
			{
				m_pSubEntityTypesToLoad->push_back(new CSubEntityTypeToLoad(at(i)->m_nSubEntityType, NULL));
			}
		}
	}

	return m_pSubEntityTypesToLoad;
}

void CSubEntityTypesToLoad::SetLoaded(long a_nSubEntityType)
{
	for(long i = 0; i < (long)size(); i++)
	{
		if(at(i)->m_nSubEntityType == a_nSubEntityType)
			at(i)->m_bIsListLoaded = true;
	}
}

void CSubEntityTypesToLoad::SetAllLoaded()
{
	for(long i = 0; i < (long)size(); i++)
	{
		at(i)->m_bIsListLoaded = true;
	}
}