
#pragma once

#include "comutil.h"

#include <string>
#include <vector>
#include <map>
#include <set>

#include <algorithm>

const cLCID = LOCALE_USER_DEFAULT;
//CODE_BASE (200 hex) to error number so that we follow
//COM's suggestion that custom error numbers be in the range of 0200 hex to FFFF hex
const CODE_BASE = 0x0200;

// browser labels

#define LabelEquipments                         "Equipments"
#define LabelSemiEquipments                     "Connective Equipments"
#define LabelCablesAndWires                     "Cables and Wires"
#define LabelPlugMaps                     "Contact Layouts"
#define LabelInterConnections                   "Interconnection Devices" /*ts*/
#define LabelEndFittingRules                    "End Fitting Rules" /*ts:2.30/a/001*/
#define LabelAccessories                        "Accessories" /*ts:2.30/a/005 22.06.06*/
#define LabelToolings                           "Toolings"/*RTS TS08818   2.40/A/001 29.01.07*/
#define LabelSimulations                      "Models of Simulation" // ALP 29 01 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation

#define LabelEquipment                          "Equipment"
#define LabelSemiEquipment                      "Connective Equipment"
#define LabelCablesAndWire                      "Cable/Wire"
#define LabelPlugMap                            "Contact Layout"
#define LabelInterConnection                    "Interconnection Device" /*ts*/
#define LabelEndFittingRule                     "End Fitting Rule" /*ts:2.30/a/001*/
#define LabelAccessory                          "Accessory" /*ts:2.30/a/005 22.06.06*/
#define LabelTooling                            "Tooling"/*RTS TS08818  2.40/A/001 29.01.07*/
#define LabelToolingPopUp                       "Tool or Tools Accessory"/*RTS TS08818  2.40/A/001 29.01.07*/
#define LabelSimulation                         "Model or External Library " // ALP 21 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation

#define LabelTabAttributes                "Attributes"
#define LabelTabConnectivity              "Connectivity"
#define LabelTabView                   "View"
#define LabelTabAttachedDocument          "Attached Documents"
#define LabelTabEndFitting                "End Fitting"
#define LabelTabLifeCycle                 "LifeCycle"
#define LabelTabPassThrough                     "PassThrough" // ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define LabelTabAccessories                     "Accessories" // RTS TS08818  2.40/A/001 20.03.07 New tab for Tooling:Accessories   
#define LabelTabManufacturer               "Manufacturers" //RTS TS08818  << 2.40/A/001 7.6.2007 New tab for Tooling:Manufacturer
#define LabelTabERPManagement              "ERPManagement" // njr >> 29 jan 07: TS08626 : SOPHIA 2.40/A : GE-005  : Management of part number ERP
#define LabelTabSimulation                 "Simulation" // ALP 21 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
#define LabelTabRuleDefinition                  "Rule Definitions" /*ts:2.30/a/001*/
#define LabelTabCategoryAtt                     "Category Attributes" /*ts:category in editor*/
#define LabelTabCategoryEndFitting              "Category Default End Fitting Rules" /*ts:category in editor*/

#define _ActiveXEditorName_                     "Equipment Editor"
#define _ActiveXBrowserName_                    "Equipment Browser"
#define _DisplayPartNo_                         "DisplayPartNo"
#define _DisplayDescription_                    "DisplayDescription"
#define _DisplayVersion_                        "DisplayVersion"
#define _DisplayLifeCycle_                      "DisplayLifeCycle"
#define _DisplayEditMode_                       "DisplayEditMode"
#define _DisplayImage_                          "DisplayImage"
#define _SplitterPosInPers_                     "SplitterPosInPersents"
#define _SplitterPlugMapPosInPers_              "SplitterPosInPersentsForPlugMap"
#define _SplitterEndFittingPosInPers_           "SplitterPosInPersentsForEndFitting"
#define _SplitterCategoryEndFittingPosInPers_   "SplitterPosInPersentsForCategoryEndFitting"
#define _SplitterErpManagementPosInPers_        "SplitterPosInPersentsForErpManagement"
#define _SplitterPosInCategoryAtt_              "SplitterPosInPersentsForCategoryAtt" //ts >>27 sep 06
#define _SplitterPosInCategoryLifeC_            "SplitterPosInPersentsForCategoryLifeC" //ts >>27 sep 06
#define _FilterInWorkEnabled_                   "FilterInWorkEnabled"
#define _FilterValideEnabled_                   "FilterValideEnabled"
#define _FilterObsoleteEnabled_                 "FilterObsoleteEnabled"
#define _FilterLastVersionEnabled_              "FilterLastVersionEnabled"
#define _FilterProductFamily_                   "FilterProductFamily"
#define _LeftColumnWidthAttributes_             "LeftColumnWidthAttributes"
#define _LeftColumnWidthCatAttributes_          "LeftColumnWidthCategoryAttributes"
#define _LeftColumnWidthCatLifeCycle_           "LeftColumnWidthCategoryLifeCycle"
#define _LeftColumnWidthConnectivity_           "LeftColumnWidthConnectivity"
#define _LeftColumnWidthImage_                  "LeftColumnWidthImage"
#define _LeftColumnWidthAttachedDocument_       "LeftColumnWidthAttachedDocument"
#define _LeftColumnWidthEndFitting_             "LeftColumnWidthEndFitting"
#define _LeftColumnWidthLifeCycle_              "LeftColumnWidthLifeCycle"
#define _LeftColumnWidthPassThrough_            "LeftColumnWidthPassThrough" // ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define _LeftColumnWidthManufacturer_           "LeftColumnWidthManufacturer" // RTS TS08818  << 2.40/A/001 7.6.2007 New tab for Tooling:Manufacturer
#define _LeftColumnWidthERPManagement_          "LeftColumnWidthERPManagement" // njr >> 14 feb 07: TS08626 : SOPHIA 2.40/A : GE-005  : Management of part number ERP
#define _LeftColumnWidthSimulation_          "LeftColumnWidthSimulation" // ALP 21 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
#define _DescriptionAreaSizeAttributes_         "DescriptionAreaSizeAttributes"
#define _DescriptionAreaSizeCatAttributes_      "DescriptionAreaSizeCategoryAttributes"
#define _DescriptionAreaSizeCatLifeCycle_       "DescriptionAreaSizeCategoryLifeCycle"
#define _DescriptionAreaSizeConnectivity_       "DescriptionAreaSizeConnectivity"
#define _DescriptionAreaSizeImage_              "DescriptionAreaSizeImage"
#define _DescriptionAreaSizeAttachedDocument_   "DescriptionAreaSizeAttachedDocument"
#define _DescriptionAreaSizeEndFitting_         "DescriptionAreaSizeEndFitting"
#define _DescriptionAreaSizeLifeCycle_          "DescriptionAreaSizeLifeCycle"
#define _DescriptionAreaSizePassThrough_        "DescriptionAreaSizePassThrough"// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define _DescriptionAreaSizeManufacturer_       "DescriptionAreaSizeManufacturer"// RTS TS08818  << 2.40/A/001 7.6.2007 New tab for Tooling:Manufacturer
#define _DescriptionOfFindPartNoInCategory_     "FindPartNoInCategoryDLG"//ts >>27 sep 06
#define _DescriptionAreaSizeERPManagement_      "DescriptionAreaSizeERPManagement"// njr >> 14 feb 07: TS08626 : SOPHIA 2.40/A : GE-005  : Management of part number ERP
#define _DescriptionAreaSizeSimulation_         "DescriptionAreaSizeSimulation" // ALP 21 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
#define _BackGroundImagePlugMap_                "BackGroundImagePlugMap"
#define _PlugMapPinXCoordinate_                 "X"
#define _PlugMapPinYCoordinate_                 "Y"
#define _PlugMapPinScale_                       "Scale"
#define _PlugMapPinGauge_                       "ContactGauge"
#define _PlugMapPinFamily_                      "ContactFamily"
#define _PlugMapPinGaugeWSTR_                   L"ContactGauge"
#define _PlugMapPinFamilyWSTR_                  L"ContactFamily"
#define _ZKeyForLeft_                           "Left"//ts >>27 sep 06
#define _ZKeyForRight_                          "Right"//ts >>27 sep 06
#define _ZKeyForTop_                            "Top"//ts >>27 sep 06
#define _ZKeyForBottom_                         "Bottom"//ts >>27 sep 06
#define _EquTypesToShow_                   "EquTypesToShow" // ts >> 9 jan 07
#define _FilterZoneType_                       "FilterEnvironmentalZoneType" // Mamy_Tahiana TS10935
#define _FilterLCStatesReleaseEnable_           "FilterLifeCycleReleaseEnable"         
#define _FilterLCStatesObsoleteEnable_          "FilterLifeCycleObsoleteEnable"

// editor labels
#define LabelEConnectedPins                  "Connected contacts"
#define LabelEPinName                      "Contact name"
#define LabelEGroups                   "Net Groups"
//[R.Josia] 25:2:2008 >> TS10382 16-Equipment-Internal Links-Shunt
#define LabelELinks                    "Internal Links"
#define LabelEMatingPartNos                     "Mating part numbers"
#define LabelEMatingPartNo                  "Mating part number"
#define LabelEPins                           "Contacts"
#define LabelERevisionHistory                "Revision History"
#define LabelEWires                        "Wires"
#define LabelEAdditivePartNumbers               "Additive part numbers"
/*ts:2.11/a/ge-004/3*/
#define LabelECompPartNos                       "Mating part numbers"// ts >> january 2007 : TS08710 <>16 - Review of Attributes and Values(compatible->mating)
/*ts:2.30/a/005*/
#define LabelEAccessoryMatingPartNos            "(Accessory)Mating part numbers"
#define LabelEAccessoryMatingPartNo             "Mating part number"
#define LabelECompPartNo                  "Mating part number"// ts >> january 2007 : TS08710 <>16 - Review of Attributes and Values(compatible->mating)
//ts
#define LabelECables							"Cables"
#define LabelEGeneralAttributes				   	"General attributes"
#define LabelEGeneralCategoryAtt				"General attributes"
#define LabelELifeCycleAttributes				"Life Cycle"
#define LabelEEquConectivity					"Connectivity"
#define LabelEConnectors						"Connectors"
#define LabelEEquPassThroughs					"PassThroughs"// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define LabelEPassThroughs						"PassThroughs"// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define LabelEEquPowers						    "Equipment powers"
#define LabelEEquProductFamilies				"Product Families Applicability"//"Equipment product families" //ts11362
#define LabelEOperatingTime				   		"Operating time"
#define LabelEIncludedPins					    "Included contacts"
#define LabelE2DView							"2D View"
#define LabelE3DView							"3D View"
#define LabelESchematicView				   		"Schematic View"
#define LabelEInstallationView			   		"Installation View"
#define LabelEImageAttributes			        "Image attributes"
#define LabelEConnector					        "Connector"
#define LabelEPassThrough				        "PassThrough"// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define LabelEContact					        "Contact"
#define LabelECable					            "Cable"
#define LabelEWire					            "Wire"
#define LabelEContactLayout                     "Contact Layout"
#define LabelEManufacturerInTooling             "Manufacturers" // RTS TS08818  << 2.40/A/001 11.6.2007 Tooling:Manufacturer
//#define LabelSimulationModelicaFile          "ModelicaFile"/* ALP 27 8 2007 : TS08512 : SOPHIA 2.40 */  Comment By 
#define LabelEManufacturerInErpManagement    "Manufacturers" // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
#define LabelECGCodeInErpManagement          "Certification Group Code" // njr >>[11/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
#define LabelEERPManagementTree                 "Product Families" // rth 08-04-08 /2.40/A/GE 001/23

#define LabelECategory                          "Category"
#define LabelECategories                        "Categories"
#define LabelEConsumptionType                   "Consumption Type"
#define LabelEConsumptionTypes                  "Consumption Types"
#define LabelEImage                             "Image"
#define LabelEImages                            "Images"
#define LabelEFile                              "File"
#define LabelEFiles                             "Files"
#define LabelEExternalDocument                  "External Document"
#define LabelEExternalDocuments                 "External Documents"
#define LabelEEndFittingZones                   "End Fitting Zones"
#define LabelEImageGeneralAttributes            "General Image attributes"
#define LabelESimulationModelicaFile            "Simulation Modelica File"// ALP 03 05 2007  :  TS 08512
#define LabelESimulationModelicaFiles           "Simulation Modelica Files"
#define LabelESimulationFunctionalModel         "Functional Model"
#define LabelESimulationComponentModel          "Component Model"
#define LabelESimulationExternalLibrary         "Library Definition"
#define LabelESimulationParameters              "Parameters"
#define LabelEModelofSimulation                 "Model of simulation" // Mammy_tahiana  
// End Fitting Rules labels
#define LabelEFRulesContact                  "EndFittingRulesContact"
#define LabelEFRuleContact                "EndFittingRuleContact"
#define LabelEFRulesLug                   "EndFittingRulesLug"
#define LabelEFRuleLug                    "EndFittingRuleLug"
#define LabelEFRulesSplice                "EndFittingRulesSplice"
#define LabelEFRuleSplice                 "EndFittingRuleSplice"
#define LabelEFRulesCapAndStow               "EndFittingRulesCapAndStow"
#define LabelEFRuleCapAndStow             "EndFittingRuleCapAndStow"
#define LabelEFRulesShieldingWireTermination "EndFittingRulesShieldingWireTermination"
#define LabelEFRuleShieldingWireTermination     "EndFittingRuleShieldingWireTermination"

//Tool Accessories labels
#define AccessoryNum                            "Accessory Number"
#define AccessoryPartNum                        "Accessory Part Number"
#define AccessoryName                           "Accessory Name"
#define SequenceNum                             "Sequence Number"

#define DescriptionESubCables					"These are the subcables of the selected Cable"
#define DescriptionESubWires					"These are the wires of the selected Cable"
#define DescrEGeneralAttributes					"These are the attributes of the selected EquDefinition"
#define DescrEGeneralCategoryAtt				"These are the attributes of the selected Category"
#define DescrELifeCycleCategoryAtt				"These are the lifecycle attributes of the selected Category"
#define DescrELifeCycleAttributes				"These are the lifecycle attributes of the selected EquDefinition"
#define DescrEEquCables							"These are the cables of the selected EquDefinition"
#define DescrEEquConectivity					"These are the connectivity groups of the selected EquDefinition"
#define DescrEEquPassThrough					"These are the passthroughs of the selected Equipment" // ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
#define DescrEEquConnectors						"These are the connectors of the selected EquDefinition"
#define DescrESubConnectors					   	"These are the subconnectors of the selected Connector"
#define DescrEEquMatingPartNos				   	"These are the mating part numbers for the selected Connective Equipment"
#define DescrEEquAdditivePartNos		   		"These are the additive part numbers for the selected EquDefinition"
#define DescrEEquGroups						   	"These are the net groups of the selected EquDefinition"
//[R.Josia] 25:2:2008 >> TS10382 -16- Equipment-Internal Links-Shunt
#define DescrEEquLinks              "These are the internal links of the selected EquDefinition"
#define DescrE2DView						    "This is the description of the equipment's associated image"
#define DescrE3DView							""
#define DescrESchematicView					   	""
#define DescrEInstallationView					""
#define DescrEEquPins							"These are the contacts of the selected EquDefinition"
#define DescrEPlugMapPins					   	"These are the contacts of the selected Contact Layout"
#define DescrEEquPowers							"These are the equipment's powers of the selected EquDefinition"
#define DescrEEquProductFamilies			    "These are the equipment's product families of the selected EquDefinition"
#define DescrEEquWires						    "These are the wires of the selected EquDefinition"
#define DescrESubGroups							"These are the net subgroups of the selected Net Group"
#define DescrEIncludedPins					   	"These are the included contacts of the selected Net Group"
#define DescrEIncludedPinsLink					   	"These are the included contacts of the selected Internal Link Group"

#define DescrEConnectedPins						"These are the connected contacts of the selected Net Group"
#define DescrEConnectorPins					   	"These are the contacts of the selected Connector"
#define DescrEConnectorMatingPartNos		   	"These are the mating part numbers for the selected Connector"
#define DescrEConnectorGroups					"These are the net groups of the selected Connector"
#define DescrEConnectorAdditivePartNos			"These are the additive part numbers for the selected Connector"
#define DescrERevisionHistory				    "These are the revision history groups of the selected EquDefinition"
#define DescrEImageAttributes					"These are the attributes of the contact layout's associated image"
/*ts:2.11/a/ge-004/3*/ 
#define DescrEEquCompPartNos               "These are the mating part numbers for the selected Interconnection Device"// ts >> january 2007 : TS08710 <>16 - Review of Attributes and Values(compatible->mating)
/*ts:2.30/a/005*/ 
#define DescrEEquAccessoryMatingPartNos         "These are the mating part numbers for the selected Accessory"
#define DescrEManufacturerInTooling             "These are the list of manufacturers for the selected Tooling"
//ALP 15 05 2007 : TS08512 : SOPHIA 2.40
#define DescrESimulationModelicaFile         "This is the description of the File Modelica"
#define DescrESimulationParameters           "Simulation parameters" 
// njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
#define DescrECertificationGroupCodeInErpManagement    "This is the Certification Group Code for the selected Product Family"
#define DescrEManufacturerInErpManagement    "These are the list of manufacturers for the selected Product Family"

// common messages
#define MessageSaveForCategories           "Category '%s' is modified. \r\nDo you want to save it?"
#define MessageSaveForEntities                  "Entity '%s' is modified. \r\nDo you want to save it?"
#define DescrEModelofSimulation            "these are the description of  the Simulation model"
//ts
#define LabelECategoryProductFamilies				"Category product families" //els 18-03-08
#define DescrECategoryProductFamilies			   "These are the product families of the selected Category" //els 25-03-08

#define NEW_BUFSIZ                                          2048

#define IC_ROOT_IMAGE_INDEX                                 0
#define IC_EQU_IMAGE_INDEX                                  1
#define IC_EQU_SELECTED_IMAGE_INDEX                         2

#define IC_EQUDEF_ACTIVE_IMAGE_INDEX                        3
#define IC_EQUDEF_PASSIVE_IMAGE_INDEX                       4

#define IC_SEMIEQUDEF_ACTIVE_IMAGE_INDEX                    5
#define IC_SEMIEQUDEF_PASSIVE_IMAGE_INDEX                   6

#define IC_EQUDEF_ACTIVE_VALIDATED_IMAGE_INDEX              11//7
#define IC_EQUDEF_PASSIVE_VALIDATED_IMAGE_INDEX             12//8

#define IC_SEMIEQUDEF_ACTIVE_VALIDATED_IMAGE_INDEX          13//9
#define IC_SEMIEQUDEF_PASSIVE_VALIDATED_IMAGE_INDEX         14//10

#define IC_EQUDEF_ACTIVE_OBSOLETED_IMAGE_INDEX              7//11
#define IC_EQUDEF_PASSIVE_OBSOLETED_IMAGE_INDEX             8//12

#define IC_SEMIEQUDEF_ACTIVE_OBSOLETED_IMAGE_INDEX          9//13
#define IC_SEMIEQUDEF_PASSIVE_OBSOLETED_IMAGE_INDEX         10//14

#define IC_CABLE_PASSIVE_IMAGE_INDEX                        15
#define IC_CABLE_PASSIVE_VALIDATED_IMAGE_INDEX              17//16
#define IC_CABLE_PASSIVE_OBSOLETED_IMAGE_INDEX              16//17

#define IC_PLUGMAP_PASSIVE_IMAGE_INDEX                      18
#define IC_PLUGMAP_PASSIVE_VALIDATED_IMAGE_INDEX            20 //19
#define IC_PLUGMAP_PASSIVE_OBSOLETED_IMAGE_INDEX            19 //20

#define IC_LOAD_FROM_DATABASE_IMAGE_INDEX                   21

#define IC_INTERCONNECTION_PASSIVE_IMAGE_INDEX              22
#define IC_INTERCONNECTION_PASSIVE_VALIDATED_IMAGE_INDEX    24 //23
#define IC_INTERCONNECTION_PASSIVE_OBSOLETED_IMAGE_INDEX    23 //24
   
#define IC_EndFittingRule_PASSIVE_IMAGE_INDEX               25
#define IC_EndFittingRule_PASSIVE_VALIDATED_IMAGE_INDEX     27 //26
#define IC_EndFittingRule_PASSIVE_OBSOLETED_IMAGE_INDEX     26 //27

#define IC_Accessory_PASSIVE_IMAGE_INDEX                    28
#define IC_Accessory_PASSIVE_VALIDATED_IMAGE_INDEX          30 //29 
#define IC_Accessory_PASSIVE_OBSOLETED_IMAGE_INDEX          29 //30 

#define IC_TOOLING_PASSIVE_IMAGE_INDEX                      31 /*RTS TS08818  2.40/A/001 29.01.07*/
#define IC_TOOLING_PASSIVE_VALIDATED_IMAGE_INDEX            32 /*RTS TS08818  2.40/A/001 29.01.07*/
#define IC_TOOLING_PASSIVE_OBSOLETED_IMAGE_INDEX            33 /*RTS TS08818  2.40/A/001 29.01.07*/

#define IC_SIMULATION_PASSIVE_IMAGE_INDEX                   34// ALP 13 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
#define IC_SIMULATION_PASSIVE_VALIDATED_IMAGE_INDEX         36// ALP 13 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
#define IC_SIMULATION_PASSIVE_OBSOLETED_IMAGE_INDEX         35// ALP 13 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation

//Attach Documents ListCtrl column indexes
#define AD_INDEX_FILE_NAME                                  0
#define AD_INDEX_FILE_SIZE                                  1
#define AD_INDEX_DATE_CREATION                              2
#define AD_INDEX_DATE_MODIFICATION                          3
#define AD_INDEX_DATE_LASTACCESS                            4

#define VT_PBSTR   VT_BYREF|VT_BSTR
#define VT_PBOOL   VT_BYREF|VT_BOOL
#define VT_PI4     VT_BYREF|VT_I4

//#define _CLASSNAME  "%s_Class_%s"
//#define _CLASSNAMEDEFAULT  "%s_ClassDefault_%s"

#define _CLASSNAME  "EED_ATT_Equi_%s"
#define _CLASSNAMEDEFAULT  "EED_OBJ_DEF_%s"

#define PROGRESSBAR_CANCEL_CLICKED                          -27
#define ADDITIONALITEMS_PROGRESSBAR_EQUDEFINITION           7
#define ADDITIONALITEMS_PROGRESSBAR_CABLE                   3
#define ADDITIONALITEMS_PROGRESSBAR_EQUANDSEMIEQU           5
#define ADDITIONALITEMS_PROGRESSBAR_PLUGMAP                 1
#define ADDITIONALITEMS_PROGRESSBAR_SEMIEQU                 2
#define RENAME_ERP_PN_CANCEL_CLICKED                        -28
#define ADDITIONALITEMS_PROGRESSBAR_PINS                    6 //<< rjosia - ts10770

#define REGISTRY_GENERALFILTERS_MAINSECTION                 "GeneralFilters"
#define REGISTRY_GENERALFILTERS_ACTIVEFILTERS               "ActiveGeneralFilters"
#define REGISTRY_GENERALFILTERS_FILTERSDEFINITIONS          "FiltersDefinitions"


/*-- Mamy_Tahiana--*/
#define EXTERNAL_LIBRARY_CLASS                              "ExternalLibrary"
#define MODEL_CLASS                                         "Model"
#define MODELICAFILE_MENU_INDEX                             8
#define MODELOFSIMULATION_MENU_INDEX                        9
#define SIMULATIONPARAMETERS_MENU_INDEX                    10
#define MODELTYPE_INDEX                                     3
#define MODELNAME_INDEX                                     4
/*-- End Mamy_Tahiana--*/
//moved from outlookbar.h
//define modified by Bija
#define IndexEquipmentsPage         0
#define IndexSemiEquipmentsPage     1
#define IndexCablesAndWiresPage     2
#define IndexInterConnectionsPage   3 /*ts*/
#define IndexAccessoriesPage        4 /*ts:2.30/a/005*/
#define IndexToolingPage				5
#define IndexPlugMapsPage           6
#define IndexEndFittingRulesPage    7 /*ts:2.30/a/001*/
//ts:IndexMaxPageValue=max{IndexEquipmentsPage,IndexSemiEquipmentsPage,IndexCablesAndWiresPage,IndexPlugMapsPage,IndexInterConnectionsPage }
#define IndexSimulationsPage        8//Simulations 2007.01.31

#define IndexMaxPageValue           8 /*ts*/

#define  MSG_SEPARATOR              L"\n" //Bija - 18.01.08 - For warning msg

#define  CAPTION_AWG                _T("AWG")
#define  CAPTION_MM2                _T("mm2")

#define  IDS_TO_STRING(IDS)         CString( (LPCSTR)IDS ) //Bija - use resource string table to put strings

//utils for gauge/section - Bija - 10-03-2008
#define  DEFAULT_FLOAT_ROUND        6
#define CONST_FOR_SECTION           0.7859
#define PRECISION                   (double)(1/pow(10, DEFAULT_FLOAT_ROUND))

//Bija - 14-08-2008 - Events BeforeCreate
#define DEFAULT_PART_NO             L"-999999"
#define CANCEL_PN_CREATION          L"CANCEL_PN_CREATION"

enum EGaugeSectionManagement
{
   eGaugeMngtNothing = -1,
   eGaugeMngtAWG     = 0,
   eGaugeMngtMm2     = 1
};

//******* update njarasoa 2008.06.19 *********//
#define ERP_HISTORY_COMMENT_DELETE_RULE                  "Deletion of a rule <%s>"
#define ERP_HISTORY_COMMENT_ADDITION_NEW_RULE            "Addition a new rule <%s>"
#define ERP_HISTORY_COMMENT_MODIF_RULE                   "Modification of a rule <%s>"
#define ERP_HISTORY_COMMENT_MODIF_STATUS_PN_MANUF        "Modification of the PN manufacturer status <%s>,<%s>,<%s> in the rule <%s> : the old value is <%s>, the new value is <%s> "
#define ERP_HISTORY_COMMENT_DEL_MANUF_PN_MANUF           "Deletion of a manufacturer <%s> - <%s> and PN manufacturer <%s> in the rule <%s>"
#define ERP_HISTORY_COMMENT_ADD_MANUF                    "Addition a new manufacturer <%s> - <%s> and PN manufacturer <%s> in the rule <%s>"


/*Properties of Controls on all Dialog Add/Change Mating Part number - Toky : Code optimization */ 
#define EditCtrl_Width       200
#define EditCtrl_Height      20 
#define StaticCtrl_Width     100
#define StaticCtrl_Height    20
#define ButtonCtrl_Width     70
#define ButtonCtrl_Height    25
#define DialogCtrl_Width     570
#define DialogCtrl_Height    600
#define BrowserCtrl_Width    550
#define BrowserCtrl_Height   360
#define AllStaticCtrl_Width  560 
#define AllStaticCtrl_Height 590
#define XPos                 14
#define YPos                 25



enum EFiltersComboboxType
{
   enFCTNone               = -1,
   enFCTProductFamilies    =  0,
   enFCTGeneralFilters     =  1, 
   enFCTEnvironmentalZone  =  2
};

enum EPropListCtrlType
{
   enPLCTUnknown           = 0,
    enPLCTAttributes = 1,
    enPLCTConnectivity = 2,
    enPLCTView = 3,
    enPLCTAttachedDocument = 4,
    enPLCTEndFitting = 5,
    enPLCTLifeCycle = 6,
	enPLCTRuleDefinition = 7,
	enPLCTPassThrough = 8,
    enPLCTCategoryGeneralAttributes = 9,
    enPLCTCategoryEndFitting = 10,
	enPLCTERPManagement = 11, // njr >> 30 jan 07: TS08626 : SOPHIA 2.40/A : GE-005  : Management of part number ERP
    enPLCTManufacturer = 12, // RTS TS08818  << 2.40/A/001 7.6.2007 New tab for Tooling:Manufacturer
	enPLCTSimulation = 13, // ALP 21 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
   enPLCTAccessories  = 14,
    enPLCTCategoryLifeCycle = 15,
    enPLCTErpHistory = 16
};

enum EVisibilityDlgType
{
   enVisibleNodes,
   enExpandedNodes
};

enum EAddRenameConnDlgType
{
   enCreateEquConnector,
   enRenameEquConnector,

   enChangePartNoEquConnector,
   enAddCompPartNoForConnector,

   enCreateSemiEquConnector,
   enRenameSemiEquConnector,

   enChangePartNoSemiEquConnector,
   enAddCompPartNoForSemiEquConnector,
   enAddCompPartNoForSemiEquipment,
   enCreateCable,
   enRenameCable,
   enChangePartNoCable,

   // ts >> 20 dec 06 PassThrough
   enARCDT_CreatePassThrough,
   enARCDT_RenamePassThrough,
   enARCDT_ChangePartNoPassThrough
   // ts <<
};

enum EConnectivityItemTypes
{
   enCITEquipment,
   enCITConnector
};

enum ESelectionTypes
{
   enSTNone      = -1,
   enSTRoot      = 0,
   enSTCategory  = 1,
   enSTEquipment = 2
};

enum ESaveResult
{
   enSaveYes,
   enSaveNo,
   enSaveCancel
};

enum EEnumTypes
{
   enDocumentStatus,
   enInUseStatus,
   enLifeCycleStatus,
   enCheckStatus,
   enUnknown
};
////////// to be deleted later
enum EXMLType_internal
{
   enXMLTUnknown_internal                       = 0,
   enXMLTCategories_internal                    = 1, 
   enXMLTCategory_internal                      = 2,
   enXMLTEquDefinitions_internal                = 3,
   enXMLTEquDefinition_internal                 = 4,
   enXMLTEquDefinition_Equipment_internal       = 5,
   enXMLTEquDefinition_SemiEquipment_internal   = 6,
   enXMLTEquDefinition_Cable_internal           = 7,
   enXMLTEquDefinition_PlugMap_internal         = 8,
   enXMLTEquDefinition_InterConnection_internal = 9,/*ts*/
   enXMLTEquDefinition_EndFittingRule_internal  = 10, /*ts:2.30/a/001*/
   enXMLTEquDefinition_Accessory_internal       = 11, /*ts:2.30/a/005 22.06.06*/
   enXMLTEquDefinition_Tooling_internal         = 12, /* RTS TS08818  2.40/A/001 29.01.07*/
   enXMLTEquDefinition_Simulation_internal      = 13// ALP 27 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
 };

enum EDocumentStatus_internal
{
   enDSFree_internal                            = 1, 
   enDSLocked_internal                          = 2
};

enum ECheckStatus_internal
{
   enCheckedNone_internal                       = 0,
   enCheckedIn_internal                         = 1,
   enCheckedOut_internal                        = 2,
   enCheckedOutByThis_internal                  = 3
};

enum EInUseStatus_internal
{
   enIUSValidate_internal                       = 1, 
   enIUSObsolete_internal                       = 2
};

enum ELifeCycleStatus_internal
{
   enLCSNone_internal                           = 0, 
   enLCSInWork_internal                         = 1, 
   enLCSValidate_internal                       = 2, 
   enLCSObsolete_internal                       = 4
};

enum EListStyles_internal
{
   enDotNetStyle_internal                       = 0,
   enNonDotNetStyle_internal                    = 1
};
////////// to be deleted later

enum EEquipmentTypes
{
   enAll                                        = 0, 
   enEquipments                                 = 1, 
   enSemi_Equipments                            = 2,
   enCablesAndWires                             = 4,
   enPlugMaps                                   = 8,
   enInterConnections                           = 16,/*ts*/
   enEndFittingRules                            = 32,/*ts:2.30/a/001*/
   enAccessories                                = 64,/*ts:2.30/a/005 22.06.06*/
   enToolings                                   = 128,/*RTS TS08818  2.40/A/001 29.01.07*/
   enSimulations                                = 256,//ALP 2007.02.08 : TS08512 : SOPHIA 2.40/A : : Add Simulation
   enAllEquipmentTypes                          = 511,//ALP 11 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
   //vesi: EEquipmentTypes enum changed
   enEquDefinitionActive                        = -1, 
   enEquDefinitionPassive                       = -2,
   enEquDefinitionCable                         = -3,
   enEquDefinitionPlugMaps                      = -4,
   enEquDefinitionInterConnections              = -5,/*ts*/
   enEquDefinitionEndFittingRules               = -6,/*ts:2.30/a/001*/
   enEquDefinitionAccessories                   = -7,/*ts:2.30/a/005 22.06.06*/
   enEquDefinitionTooling                       = -8,/*RTS TS08818  2.40/A/001 29.01.07*/
   enEquDefinitionSimulations                   = -9,// ALP 11 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
   enRoot                                       = 512,/*ts:2.30/a/001*/
   enEquTypeUnknown                             = -256
};

enum EPropListItemTypes
{
   enAllPropListItemTypes                       = -1,
   enGroup                                      = 0,
   enEquAttributes_Group                        = 1,
   enLifeCycleGroup                             = 2,
   enConnectivity_Group                         = 3,
   enConnectors_Group                           = 4,
   enConnector                                  = 5,
   enConnectorOld                               = 6,
   enConnector_UserField                        = 7,
   enGroups_Group                               = 8,
   enGroupItem                                  = 9,
   enGroup_UserField                            = 10,
   enGroupIncludedPins_Group                    = 11,
   enGroupConnectedPins_Group                   = 12,
   enGroup_IncludedPins                         = 13,               // combobox
   enGroup_ConnectedPins                        = 14,              // combobox
   enEquTime                                    = 15,
   enEquTime_OperatingTime                      = 16,
   enEquTime_UserField                          = 17,
   enConsumption_Watts                          = 18,
   enEquPowersGroup                             = 19,
   enEquPower                                   = 20,
   enEquPower_Caption                           = 21,                 // combobox
   enEquPower_UserField                         = 22,
   enEquDefinition_Caption                      = 23,
   enEquDefinition_PartNo                       = 24,
   enEquDefinition_Version                      = 25,            // must be not editable
   enEquDefinition_UserFieldValue               = 26,
   enPin_UserField                              = 27,
   enPins_Group_Equipment                       = 28,
   enPin                                        = 29,
   enPin_GroupedBy                              = 30,                   
   enEquProductFamilies_Group                   = 31,
   enEquProductFamily                           = 32,                 
   enEquDefinition                              = 33,
   enConnectorPermissibleEquDefsGroup           = 34,
   enEquPermissibleEquDefsGroup                 = 35,
   enPermissibleEquDef                          = 36,
   enPin_InterfaceType                          = 37,                // combobox
   enPin_Phase                                  = 38,
   enPin_SignalType                             = 39,
   enPin_SignalName                             = 40,
   en2DView_Group                               = 42,
   enImageDefinition_UserField                  = 43,
   enConnector_PinsCount                        = 45,
   enRevisionHistoric_Group                     = 46,
   enRevisionHistoric                           = 47,
   enRevisionHistoric_UserField                 = 48,
   enAttachedDocument_Group                     = 49,
   enEndFitting_Group                           = 50,
   enEquAdditivePartNumber_Group                = 51,
   enConnectorAdditivePartNumber_Group          = 52,
   enAdditivePartNumber                         = 53,
   enAdditivePartNumber_UserField               = 54,
   enCables_Group                               = 55,
   enCable                                      = 56,
   enCable_UserField                            = 57,
   enWires_Group                                = 58,
   enWire                                       = 59,
   enWire_UserField                             = 60,
   enPlugMapPins_Group                          = 61,
   enPlugMapPin                                 = 62,
   enPlugMapPin_UserField                       = 63,
   enPlugMap_Connector_Caption                  = 64,
// enPlugMap_EquDef_Caption = 65,
   enPlugMap_Semi_EquDef_Caption                = 66,
   enCableOld                                   = 67,
   enImageDefinition_Attributes                 = 68, 
   enPins_Group_Connector                       = 69,
   enEquProductFamily_Status                    = 70,        // combobox
   enPin_ContactType                            = 71,
   enConnector_ContactType                      = 72,
   enPin_Gender                                 = 73,
   enConnector_Gender                           = 74,
   enView_3DView_Group                          = 75,
   enView_SchematicView_Group                   = 76,
   enView_InstallationView_Group                = 77,
	enView_3DView_FileName                       = 78,
	enView_3DView_XMLFile                        = 79,
	enSemiEqu_Type_UserField                     = 80,
	enEquImageDefinition_Attributes              = 81,

	enCompPartNo                                 = 82, /*ts:2.11/a/ge-004/3*/
	enEquCompPartNo_Group                        = 83, /*ts:2.11/a/ge-004/3*/
	enCompPartNo_UserField                       = 84, /*ts:2.11/a/ge-004/3*/

	enRuleDefinition_Group                       = 85,  /*ts:2.30/a/001*/

	enAccessoryMatingPartNo                      = 86, /*ts:2.30/a/005*/
	enEquAccessoryMatingPartNo_Group             = 87, /*ts:2.30/a/005*/
	enAccessoryMatingPartNo_UserField            = 88, /*ts:2.30/a/005*/

	//isk
	enEndFittingZones		                        = 89,
	enEndFittingRule		                        = 90,

	enPassThrough                                = 91 ,// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
	enPassThrough_Group                          = 92 ,// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
	enPassThrough_UserField                      = 93 ,// ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough

	enConnectorToPassThrough                     = 94 ,// ts >> 27 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
	enConnectorsToPassThrough_UserField          = 95 , // ts >> 27 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
	enConnectorToPassThrough_Range               = 96 , // ts >> 27 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough

   //enManufacturerInTooling_Group                = 97, // RTS TS08818  << 2.40/A/001 11.6.2007 Tooling:Manufacturer
   enManufacturer                               = 97,
   enManufacturerInTooling_Group                = 98, // RTS TS08818  << 2.40/A/001 11.6.2007 Tooling:Manufacturer
   enManufacturerInTooling_UserField            = 99,
   enSetManufacturerInTooling_UserField         = 144,


 
    //ALP 08 05 2007 : TS08512 : SOPHIA 2.40
   enSimulationFunctionalModel_Group            = 100,
   enSimulationComponentModel_Group             = 101,
   enSimulationExternaLibrary_Group             = 102,
   enSimulation_ModelicaFile                    = 103,  //ALP 08 05 2007 : TS08512 : SOPHIA 2.40
   enSimulation_parameters_Group                = 104,
   enSimulation_Parameter                       = 105,
   
   enSimulation_UserField                       = 106,

   enView_SimulationModelicaFile_XMLFile        = 107,

   enManufacturerErpManagement_Group               = 108 , // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
   enManufacturerErpManagement_UserField           = 109 , // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP

   enCertificationGroupCode                        = 110, // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
   enCertificationGroupCode_Group                  = 111, // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
   enCertificationGroupCode_UserField              = 112, // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP

   enErpManagement_Group                           = 113, // njr >>[10/10/2007]: TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP


   enPLIT_CategoryAtt_Group  = 114,
   enPLIT_CategoryLifeCycle_Group  = 115,
   enEquProductFamily_UserField = 116,
   enPin_Power = 117,

   enModelOfSimulation_Group                       = 118,
   enModelOfSimulation_UserField                   = 119,
   //[R.Josia] 25:2:2008 >> TS10382 16-Equipment Internal Links-Shunt(for voltage drop)
   enGroups_Links = 120,
   enObjManufacturer                               = 130,
   enObjManufacturer_Group                         = 131,
   enObjManufacturer_UserField                     = 132,
   enObjSetManufacturer_UserField                  = 133,
   enGroupInternal                                 = 134,
   enGroupInternal_Resistance                      = 135,
   enGroupIncludedPins_Internal                    = 136,
   enGroupInternal_IncludedPins                    = 137,
   enGroupInternal_Resistance_UserField            = 138,
   
   enCategoryProductFamilies_Group                 = 139, //els 18-03-08
   enCategoryProductFamily                         = 140, //els 18-03-08

   enAccessoriesInTooling_Group                    = 141, // rth 08-04-08 /2.40/A/GE 001/23
   enSimulationComp_parameters_Group               = 142, // rth 08-04-08 /2.40/A/GE 001/23 - Only Use for the visibility expand
   enSimulationFunc_parameters_Group               = 143,  // rth 08-04-08 /2.40/A/GE 001/23 - Only Use for the visibility expand
   //enSetManufacturerInTooling_UserField = 144 last value Bija 18-08-2008
   enEnvironmentalZoneType                         = 144 // Mamy_Tahiana TS10935
   //next value 145 
};

enum EOperations
{
   enNone,
   enCutOperation,
   enCopyOperation,
   enPasteOperation,
   enDeleteOperation,
   enNewOperation,
   enRenameOperation,
   enFilterOperation,
   enImportXMLOperation,
   enChangePartNoOperation
};

enum EListObjClasses
{
   enLOCUnknown,
   enLOCEquDefinitions
};

enum EEquDefinitionAvailability
{
   enEquipmentAvailable                         = 1, 
   enSemiEquipmentAvailable                     = 2,
   enCablesAndWiresAvailable                    = 4,
   enPlugMapAvailable                           = 8,
   enInterConnectionsAvailable                  = 16, 
   enEndFittingRulesAvailable                   = 32, /*ts:2.30/a/001*/
   enAccessoriesAvailable                       = 64, /*ts:2.30/a/005 22.06.06*/
   enToolingAvailable                           = 128,/* RTS TS08818  2.40/A/001 29.01.07*/
   enSimulationsAvailable                       = 256,// ALP 27 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
   enAllEquDefinitionAvailable                  = 511 
};

enum EDataCurrentOperationTypes
{
   enDCOT_Unknown                               = 0,
   enDCOT_XMLCategoriesImport                   = 1, 
   enDCOT_XMLEquDefinitionImport                = 2,
   enDCOT_XMLImport                             = 4,
   enDCOT_XMLConnectorImport                    = 8,
   enDCOT_XMLPinImport                          = 16,
   enDCOT_XMLCategoriesExport                   = 32,
   enDCOT_EquDefinition_CreateNewVersion        = 64,
   enDCOT_XMLCableImport                        = 128,
   enDCOT_XMLWireImport                         = 256,
   enDCOT_XMLPlugMapPinImport                   = 512,
   enDCOT_CreateNewConnector                    = 1024,
   enDCOT_CreateNewCable                        = 2048,
   enDCOT_Paste                                 = 4096,
   enDCOT_SaveEquDefinition                     = 8192,
   enDCOT_LoadEquDefinition                     = 16384,
   enDCOT_XMLEndFittingZoneRuleImport           = 32768,
   enDCOT_XMLPassThroughImport                  = 65536 // ts >> 16 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
};

enum EEquipmentBrowserPages
{
   enNoPageInBrowser                            = 0,
   enEquipmentPage                              = 1,
   enSemiEquipmentPage                          = 2,
   enCablesAndWiresPage                         = 3,
   enPlugMapsPage                               = 4, 
   /*ts*/
   enInterConnectionsPage                       = 5,
   enEndFittingRulesPage                        = 6,/*ts:2.30/a/001*/
   enAccessoriesPage                            = 7,/*ts:2.30/a/005 22.06.06*/
   enToolingPage                                = 8,/* RTS TS08818  2.40/A/001 29.01.07*/
   enSimulationsPage                            = 9 // ALP 27 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
};

enum TFieldType
{
   eFieldUnknown                                = 1,
   eSystemField                                 = 2,
   eUserField                                   = 4,
   eLifeCycleField                              = 8,
   eSystemCalculatedField                       = 16
}
;

enum TListType
{
    eListTypeNotSet,
    eListTypeRecommended,
    eListTypeObligatory
}
;

enum EPropListProcedures
{
   enFillDataProcedure,
   enRefreshDataProcedure
};

enum EXMLImportModes
{
   eXMLImportMode_Normal                        = 1,
   eXMLImportMode_Silent                        = 2,
   eXMLImportMode_Cut                           = 4,
   eXMLImportMode_Copy                          = 8,
   eXMLImportMode_Paste                         = 16,
   eXMLImportMode_CreateEquDefinitionFromXML    = 32

};

enum EPlugMapItemChange
{
   enAddPlugMapItem                             = 0,
   enDeletePlugMapItem                          = 1,
   enRemovePlugMapItem                          = 2,
   enRedrawPlugMapItem                          = 3,
   enRedrawPlugMapItems                         = 4
};

enum EUserAttributesTypes
{
   enUATConnectorAttributes,
   enUATAdditivePartNoAttributes,
   enUATPinAttributes,
   enUATGroupAttributes,
   enUATEquPowerAttributes,
   enUATEquTimeAttributes,
   enUATImageDescriptionAttributes,
   enUATImagePlugMapAttributes,
   enUATHistoricAttributes,
   enUATCableAttributes,
   enUATWireAttributes,
   enUATPlugMapPinAttributes,
   enUAT_PassThrough_Attributes,             // ts >> 22 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
   enUAT_ConnectorsToPassThrough_Attributes, // ts >> 27 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
    enUATToolManufacturer,                     // RTS TS08818  << 2.40/A/001 10.7.2007 Tooling:Manufacturer
   enUATModelicaFileDescriptionAttributes,
   enUAT_SimulationModelicaFile_Attributes,
	enUAT_SimulationFunctionalModel_Attributes,
	enUAT_SimulationComponentModel_Attributes,
	enUAT_EquProductFamily_Attributes,
	enUAT_CertificationGroupCode_Attributes,
   enUAT_ModelOfSimulation_Attributes,
   enUATLinkAttributes //Toky :InternalLinks

};

enum EAttributesNodes_internal
{
   enANUnknownNode                              = 0,
   enANEquGeneralAttributes                     = 1,
   enANEquLifeCycleAttributes                   = 2,
   enANConnectivityAttributes                   = 4,//3,
   enANEquSchematicViewAttributes               = 8,//4,
   enANEquInstallationViewAttributes            = 16,//5,
   enANEqu2DViewAttributes                      = 32,//6,
   enANEqu3DViewAttributes                      = 64,//7

   enANEquRevisionHistory                       = 128,
   enANEquContact                               = 256,
   enANEquConnector                             = 512,
   enANEquWire                                  = 1024,
   enANEquCable                                 = 2048,
   enANPlugMapPin                               = 4096,
   /*ts:*/

   enANGeneral_ImageAttributes                  = 8192,

   enANPassThroughAttributes                   = 16384,

   enANToolManufacturer                        = 32768,
  

	enANSimulationFunctionalModelAttributes		= 65536,
	enANSimulationComponentModelAttribute		   = 131072,
   enANSimulationExternalLibraryAttribute       = 262144,
	enANSimulationParameterAttributes				= 524288,
	enANEquProductFamilyAttributes				   = 1048576,
	enANCertificationGroupCodeAttributes		   = 2097152,
   enANModelOfSimulationAttributes              = 4194304,
   enANObjManufacturer                          = 8388608// Christian
	//enANEquMatingPartNo = 512,
	//enANEquNetGroup = 1024,
	//enANEquIncludedPin = 2048,
	//enANEquConnectedPin = 4096,
	//enANEquAdditivePartNo = 8192,
};

const long c_lBasicNodes  = enANEquGeneralAttributes + enANEquConnector + enANEquContact + enANEquRevisionHistory + enANEquCable + enANEquWire + enANPlugMapPin+ enANSimulationFunctionalModelAttributes + enANSimulationComponentModelAttribute;
const long c_lEntityNodes = enANEquGeneralAttributes + enANEquLifeCycleAttributes + enANConnectivityAttributes + enANEquSchematicViewAttributes + enANEquInstallationViewAttributes + enANEqu2DViewAttributes + enANEqu3DViewAttributes + enANSimulationFunctionalModelAttributes + enANSimulationComponentModelAttribute;

//Attributes SubNodes
enum EASN_Contact_internal
{
   enASNContact                                 = 1,
   enASNStud                                    = 2,
   enASNPowerConsumer                           = 4,
   enASNPowerSupply                             = 8,
   enASNSignal                                  = 16,
   enASNContact_ConnEquTypeOther                = 32,
   enASNContact_ConnEquTypeSplice               = 64,
   enASN_PowerDC 								= 128
};

enum EASN_ConnEquType_internal
{
   enASNConnector                               = 1,
   enASNTerminalBlock                           = 2,
   enASNGroundBlock                             = 4,
   enASNSplice                                  = 8
};

enum EASN_2DView_internal
{
   enASNContactLayoutAttributes                 = 1,
   enASNContactLayoutImageAttributes            = 2
};

enum EASN_Cable_internal
{
   enASNUnshielded                              = 1,
   enASNShielded                                = 2,
   enASNDoubleShielded                          = 4,
   enASNTripleShielded                          = 8,
   enASNOpticFiber                              = 16,
   enASNWire                                    = 32,
   enASNQuadrax                                 = 64,
   enASNAnotherCableFamily                      = 128
};

enum EASN_Accessory_internal
{
   enASNSubcategoryBackshell                    = 1,
   enASNSubcategoryAnother                      = 2
};

enum EASN_InterConnection_internal
{
   enASNContact_icd                             = 1,
   enASNLug_icd                                 = 2,
   enASNShieldTermination_icd                   = 4,
   enASNInsulatingEndFitting_icd                = 8,
   enASNIdentificationElement_icd               = 16,
   enASNOther_icd                               = 32,
   enASNSealingPlug_icd           				= 64,
   enASNDummyContact_icd          				= 128
};
/*ts:2.30/A / R&D/GE-001  END FITTING 14.06.2006*/
//"Contact" or "Lug" or "Splice" or "Shielding Wire Termination" or "Cap & Stow" or "Cable Marking" 
enum EASN_EndFittingRule_internal
{
   enASNContact_efr                             = 1,
   enASNLug_efr                                 = 2,
   enASNSplice_efr                              = 4,
   enASNShieldingWireTermination_efr            = 8,
   enASNCapAndStow_efr                          = 16,
   enASNCableMarking_efr                        = 32

};

/*ts:2.30/A / R&D/GE-001  END FITTING 14.06.2006*/
//ObjectsTypes
enum EObjectsTypes_internal
{
   enOTUnknown                                  = 0,
   enOTPin                                      = 1,
   enOTConnector                                = 2,
   enOTPlugMapPin                               = 3,
   enOTCable                                    = 4,
   enOTWire                                     = 5,
   enOTEquZone                                  = 6,
   enOTEquZoneRule                              = 7,
   enOTCatZone                                  = 8,
   enOTCatZoneRule                              = 9,
   enOTEquEndFitFamily                          = 10,
   enOTCatEndFitFamily                          = 11,
   enOTPassThrough                              = 12, // ts >> 21 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
   enOTErpManagement                            = 13
   /*ts:problem*/
};
#define EObjectsTypesSize                       6

//EObjectsOptionsTypes
enum EObjectsOptionsTypes_internal
{
   enOOTCaptionModels                           = 1
};

enum EFileTypes
{
   enFTEmpty                                    = 0,
   enFTUnKnown                                  = 1,
   enFTVarious                                  = 2,
   enFTTXT                                      = 3,
   enFTXML                                      = 4,
   enFTHTM                                      = 5,
   enFTHTML                                     = 6,
   enFTModelica                                 = 7  
};

enum EImageAttributes
{
   enIAZero                                     = 1,
   enIASize                                     = 2,
   enIAScale                                    = 4,
   enIAClear                                    = 8
};

enum EBool3
{
   enB3NotSet, 
   enB3True, 
   enB3False
};

enum EMultipleEntitiesDlgTypes
{
   enMEGroup                                    = 0,
   enMEValue                                    = 1,
   enMEAttribute                                = 2,
   enMEAttrValue                                = 3
};

enum EEndFittingTreeCtrlItemDataTypes
{
   enEFRoot                                     = 0,
   enEFProdFamily                               = 1,
   enEFZones                                    = 2,
   enEFZone                                     = 3,
   enEFRules                                    = 4,
   enEFRule                                     = 5
};

enum EErpManagementTreeCtrlItemDataTypes
{
   enERPMRoot                                   = 0,
   enERPMProdFamily                             = 1
};

enum EProcessSubEntityTypes_internal
{
   enEProcessSETUnknown                         = 0,  
   enEProcessSETCables                          = 3,
   enEProcessSETConnectors                      = 5,
   enEProcessSETPins                            = 6,
   enEProcessSETGroups                          = 7,
   enEProcessSETConnectedSemiEquipments         = 9,
   enEProcessSETEndFittingRules                 = 10,
   enEProcessSETEndFittingZones                 = 11,
   enEProcessSETAccessoryMatingPartNos          = 12,
   enEProcessSETCompPartNos                     = 13,
   enEProcessSETConnectedPins                   = 14,
   enEProcessSETIncludedPins                    = 15,
   enEProcessSETEquTimes                        = 17,
   enEProcessSETPlugMapPins                     = 18,
   enEProcessSETHistorics                       = 19,
   enEProcessSETCategory                        = 20,
   enEProcessSETEquProductFamilies              = 21,
   enEProcessSETAdditivePartNumbers             = 22,
   enEProcessSETEquPowers                       = 23,
   enEProcessSETEndFittingZoneRules             = 24,
   enEProcessSETWires                           = 25,
   enEProcessSETEndFittingProductFamilies       = 26,

   enEProcessSETEquipment                       = 1,
   enEProcessSETConnectiveEquipment             = 2,
   enEProcessSETEntityCable                     = 4,
   enEProcessSETPlugMaps                        = 8,
   enEProcessSETInterConnections                = 16,
   enEProcessSETEndFittings                     = 32,
   enEProcessSETAccessories                     = 64,
      enEProcessSETTooling                         = 128,
   enEProcessSETSimulations                     = 256 // ALP 27 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation

};

enum EProcessSearchResults_internal
{
   enEProcessSRNotFound                         = 0,
   enEProcessSRFound                            = 1,
   enEProcessSRNotPrepared                      = 2,
   enEProcessSRPrepared                         = 3
   //enEProcessSREntityNotFound,
   //enEProcessSREntityNotInProperStatus,
   //enEProcessSRNotSetCurrentProductFamily
};

// enums used for general filters
enum EFCOperators
{
   enFCONone                                    = -1,
   enFCOAnd                                     = 0,
   enFCOOr                                      = 1
};

enum EFCRelations
{
   enFCRInactive                                = 0,
   enFCRLess                                    = 1,
   enFCRLessEqual                               = 2,
   enFCREqual                                   = 3,
   enFCRGreaterEqual                            = 4,
   enFCRGreater                                 = 5,
   enFCRDifferent                               = 6,
   enFCRContains                                = 7,
   enFCRContVal                                 = 8
};

enum EFCCapsLowercase
{
   enFCCNone                                    = -1,
   enFCCNo                                      = 0,
   enFCCYes                                     = 1
};

enum EGeneralFiltersType
{
   enGFTGeneralFilters                          = 0,
   enGFTCustomQueries                           = 1
};

enum EProcessEntityStatus
{
   enPESNotLoaded                               = 0,
   enPESLoading                                 = 1,
   enPESLoaded                                  = 2,
   enPESFullLoaded                              = 3
};

enum EUserAccessOperationType
{
   enUAOT_EntityModification,
   enUAOT_EntityCreation,
   enUAOT_EntityDelete,
   enUAOT_EntityObsolete,
   enUAOT_EntityValidate,
   enUAOT_EntityValidateAll,

   enUAOT_CategoryModification,
   enUAOT_CategoryCreation,
   enUAOT_CategoryDelete,
   enUAOT_CategoryProductFamilyManagement,//els

   enUAOT_GlobalConsultation,
   enUAOT_GlobalXMLExport,
   enUAOT_GlobalXMLImport,
   enUAOT_GlobalCut,
   enUAOT_GlobalPaste,
   
   enUAOT_ProductFamilyManagement,//els
   enUAOT_EndFittingRulesManagement, //els
   enUAOT_ErpManagement,                // ChrR TS09405 : 02 - 04 - 08
   enUAOT_InternalLinks                 //Bija - 24-04-2008
};
enum EErpHistoricType   //njr 20080305
{
   enAdditionRule                              = 0,
   enDeletionRule                              = 1,
   enModificationRule                          = 2,
   enAdditionManufacturer                      = 3,
   enDeletionManufacturer                      = 4,
   enModificationManufacturer                  = 6,
   enUnKnownManufacturer                       = 7
};

enum EERPReturnMsg
{
   ERP_ERROR                         = -1,
   ERP_OK                            = 0,
   ERP_OREDERNUMBER_REDUDANCY        = 1, 
   ERP_NO_CERT_MANUFACTURER          = 2,
   ERP_REPLACE_PN_ERP_XMLIMPORT      = 3,
   ERP_REPLACE_PN_ERP                = 4,     
   ERP_PN_ERP_EMPTY_XMLIMPORT        = 5,
   ERP_PN_ERP_EMPTY                  = 6
};

//Bija - 14-08-2008 - Events
enum EOperationType
{
   eOpTypeModification     = 0,
   eOpTypeManualCreation   = 1,
   eOpTypeXMLImport        = 2,
   eOpTypePaste            = 3,
   eOpTypeNewVersion       = 4
};

//<< rj - ts10770 
//to mark pin's fill
enum EFillType
{
   eFillTypeDefault             = 0,
   eFillTypeStart               = 1,
   eFillTypeExpandGroup         = 2,
   eFillTypeCollapseGroup       = 3,
   eFillTypeExpandPin           = 4,
   eFillTypeCollapsePin         = 5,
   eFillTypeRenamePin           = 6,
   eFillTypeDeletePin           = 7,
   eFillTypeNew                 = 8,
   eFillTypeNewVersion          = 9
};

//<< rjosia - TS07514
enum EItemType_addition
{
   enUnknown_addition             = 0,
   enItemError_addition           = -5,
   enItemExistInCategory_addition = -6,
   enItemExist_addition = -1
};

// vector wstring
typedef std::vector<std::wstring>               CVecWStr;
// vector wstring
typedef std::vector<CVecWStr>                   CVecVecWStr;
// vector string
typedef std::vector<std::string>                CVecStr;
// map string to vector string
typedef std::map<std::string, CVecStr>          CMapStr2VecStr;
// map wstring to vector wstring
typedef std::map<std::wstring, CVecWStr>        CMapWStr2VecWStr;
// vector int
typedef std::vector<unsigned int>               CVecUInt;
// vector int
typedef std::vector<unsigned long>              CVecULong;
// variant vector
typedef std::vector<_variant_t>                 CVecVariant;
// set int
typedef std::set<unsigned int>                  CSetUInt;
// vector CString
typedef std::vector<CString>                    CVecCStr;
// map CString to long
typedef std::map<CString, long>		            CMapCStrLong;
// map int to int
typedef std::map<int, int>  CMapIntInt;

//CONSTANTS
const int MaxNumberOfCategoriesTypes = 9; //ALP 13 02 2007 pour tree view

//STRING CONSTANTS


//Tables Names:
const std::wstring EED_EquConsumptionsTableName                                        = L"EED_OBJ_Equi_Consumptions";
const std::wstring EED_EquPowerTimeOptionsTableName                                       = L"EED_OBJ_Equi_Powers_Time";
const std::wstring EED_ConsumptionTypesTableName                                       = L"EED_SET_ConsumptionTypes";
const std::wstring EED_TimesTableName                                               = L"EED_SET_Times";
const std::wstring EED_EquPowerOptionsTableName                                        = L"EED_OBJ_Equi_Powers";
const std::wstring EED_SystemTableName                                              = L"EED_SYS_Definition";
const std::wstring EED_DBVersionTableName                                           = L"EED_SYS_DBVersion";
const std::wstring EED_EquViaProductFamiliesTableName                                  = L"EED_LNK_Equi_Product";
const std::wstring EED_ProductFamiliesTableName                                        = L"EED_SET_ProductFamilies";
const std::wstring EED_GroupsConnToPinsTableName                                       = L"EED_LNK_Groups_Pins";
const std::wstring EED_PinsTableName                                                = L"EED_OBJ_Equi_Pins";
const std::wstring EED_GroupsTableName                                              = L"EED_OBJ_PinsGroups";
const std::wstring EED_PowersTableName                                              = L"EED_SET_Powers";
const std::wstring EED_ConnectorsTableName                                             = L"EED_OBJ_Connectors";
const std::wstring EED_EquDefinitionsTableName                                         = L"EED_OBJ_Entity";
const std::wstring EED_CategoriesTableName                                             = L"EED_OBJ_Categories";
const std::wstring EED_PinsConnToEquipmentsTableName                                   = L"EED_LNK_Equi_Pins";
const std::wstring EED_ConnectorsConnToEqupmentsTableName                                 = L"EED_LNK_Connector_Mating";
const std::wstring EED_SemiEquConnToSemiEquTableName                                   = L"EED_LNK_Equi_Mating";
const std::wstring EED_EquipmentsImagesTableName                                       = L"EED_OBJ_Image_Blob";
const std::wstring EED_EquipmentsImagesDescriptionTableName                               = L"EED_OBJ_Images";
const std::wstring EED_EquipmentsFilesDescriptionTableName                                = L"EED_OBJ_Files";
const std::wstring EED_EquAdditivePartNoTableName                                      = L"EED_LNK_Equi_Additive";
const std::wstring EED_ConnAdditivePartNoTableName                                     = L"EED_LNK_Connector_Additive";
const std::wstring EED_InternalLinkTableName                                           = L"EED_OBJ_Internal_Group";//Toky
const std::wstring EED_InternalGroupLnkTable                                           = L"EED_LNK_Group_Internal";
//ts:2.11/a/004/3
const std::wstring EED_EquCompPartNoTableName                                          = L"EED_LNK_Equi_Compatible";
//ts
//ts:2.11/a/004/3
const std::wstring EED_EquAccessoryMatingPartNoTableName                               = L"EED_LNK_Equi_AccessoryMating";
//ts
// ts >> 16 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
const std::wstring EED_IDConnectorToIDPassThrough_TableName                               = L"EED_LNK_ConnectorToPassThrough";
const std::wstring EED_PassThrough_TableName                                        = L"EED_OBJ_PassThrough";
// ts <<
const std::wstring EED_EquDefHistoryTableName                                          = L"EED_OBJ_Equi_History";
const std::wstring EED_CategoryClassesTableName                                        = L"EED_SET_Classes";
const std::wstring EED_EquDefinitions_ClassDefault_EquipmentsTableName                       = L"EED_OBJ_DEF_Equipment";
const std::wstring EED_EquDefinitions_ClassDefault_SemiEquipmentsTableName                   = L"EED_OBJ_DEF_ConnectiveEqui";
const std::wstring EED_EquDefinitions_ClassDefault_CablesAndWiresTableName                   = L"EED_OBJ_DEF_Cable_Wire";
const std::wstring EED_EquDefinitions_ClassDefault_PlugMapTableName                          = L"EED_OBJ_DEF_PlugMap";
/*ts*/
const std::wstring EED_EquDefinitions_ClassDefault_InterConnectionTableName                     = L"EED_OBJ_DEF_INTERCONNECTION";
/*ts:2.30/a/001*/
const std::wstring EED_EquDefinitions_ClassDefault_EndFittingRuleTableName                   = L"EED_OBJ_DEF_EndFittingRule";
const std::wstring EED_EquDefinitions_ClassDefault_AccessoryTableName                        = L"EED_OBJ_DEF_Accessory";/*ts:2.30/a/005 22.06.06*/

const std::wstring EED_EquDefEndFittingRulesContactTableName                              = L"EED_OBJ_END_Fitting_Rules_Contact";
const std::wstring EED_EquDefEndFittingRulesLugTableName                               = L"EED_OBJ_END_Fitting_Rules_Lug";
const std::wstring EED_EquDefEndFittingRulesSpliceTableName                               = L"EED_OBJ_END_Fitting_Rules_Splice";
const std::wstring EED_EquDefEndFittingRulesShieldingWireTerminationTableName                = L"EED_OBJ_END_Fitting_Rules_ShieldingWireTermination";
const std::wstring EED_EquDefEndFittingRulesCapsAndStowTableName                          = L"EED_OBJ_END_Fitting_Rules_CapsAndStow";
const std::wstring EED_EquDefEndFittingRulesCableMarkingTableName                         = L"EED_OBJ_END_Fitting_Rules_CableMarking";
const std::wstring EED_EquDefEndFittingRulesContactTableName_Ora                              = L"EED_OBJ_EFR_CONTACT";//rjn TS09493 dildil : EED_OBJ_END_Fitting_Rules_Contact
const std::wstring EED_EquDefEndFittingRulesLugTableName_Ora                               = L"EED_OBJ_EFR_LUG";//rjn TS09493 dildil : EED_OBJ_END_FITTING_RULES_LUG
const std::wstring EED_EquDefEndFittingRulesSpliceTableName_Ora                               = L"EED_OBJ_EFR_SPLICE";//rjn TS09493 dildil EED_OBJ_END_FITTING_RULES_SPLICE
const std::wstring EED_EquDefEndFittingRulesShieldingWireTerminationTableName_Ora                = L"EED_OBJ_EFR_SWT";//rjn TS09493 dildil EED_OBJ_END_FITTING_RULES_SPLICE
const std::wstring EED_EquDefEndFittingRulesCapsAndStowTableName_Ora                          = L"EED_OBJ_EFR_CAPSANDSTOW";//rjn TS09493 dildil EED_OBJ_END_FITTING_RULES_CAPSANDSTOW
const std::wstring EED_EquDefEndFittingRulesCableMarkingTableName_Ora                         = L"EED_OBJ_EFR_CABLEMARKING";//rjn TS09493 dildil EED_OBJ_END_FITTING_RULES_CABLEMARKING
const std::wstring EED_SET_ColorListTableName                                          = L"EED_SET_ColorList";
const std::wstring EED_SET_ColorValueTableName                                         = L"EED_SET_ColorValue";
const std::wstring EED_ObjectOptionsTableName                                          = L"EED_SYS_ObjectOptions";
const std::wstring EED_CableTableName                                               = L"EED_OBJ_Cables";
const std::wstring EED_WiresTableName                                               = L"EED_OBJ_Wires";
const std::wstring EED_WiresConnToEquipmentsTableName                                  = L"EED_LNK_Wires_Equi";
const std::wstring EED_DEF_PlugMapPinTableName                                         = L"EED_OBJ_PlugMapPin";
const std::wstring EED_SET_PINTableName                                                = L"EED_SET_Pin";
const std::wstring EED_OBJ_Pin_BlobTableName                                        = L"EED_SET_Pin_Blob";
const std::wstring EED_EquipmentsExternalDocumentsTableName                               = L"EED_OBJ_External_Document_Blob";
const std::wstring EED_EquipmentsExternalDocumentsDescriptionTableName                       = L"EED_OBJ_External_Documents";
const std::wstring EED_EquipmentsEndFittingZoneRulesTableName                             = L"EED_LNK_EndFitting_ZoneRules";
const std::wstring EED_EquipmentsEndFittingZonesTableName                                 = L"EED_OBJ_EndFitting_Zones";
const std::wstring EED_CategoryEndFittingZoneRulesTableName                               = L"EED_LNK_Category_EndFitting_ZoneRules";
const std::wstring EED_CategoryEndFittingZonesTableName                                   = L"EED_OBJ_Category_EndFitting_Zones";
const std::wstring EED_EquipmentsEndFittingProductFamiliesTableName                          = L"EED_LNK_EndFitting_ProductFamilies";
const std::wstring EED_CategoryEndFittingProductFamiliyTableName                          = L"EED_LNK_Category_EndFitting_ProductFamilies";
const std::wstring EED_CategoryEndFittingZoneRulesTableName_Ora                               = L"EED_LNK_CAT_ENDFIT_ZONERULES";//rjn TS09493 dildil : instead of EED_LNK_CATEGORY_ENDFITTING_ZONERULES
const std::wstring EED_CategoryEndFittingZonesTableName_Ora                                   = L"EED_OBJ_CATEGORY_ENDFIT_ZONES";//rjn TS09493 dildil instead of EED_OBJ_CATEGORY_ENDFITTING_ZONES
const std::wstring EED_EquipmentsEndFittingProductFamiliesTableName_Ora                          = L"EED_LNK_ENDFIT_PRODUCTFAMILIES";////rjn TS09493 dildil : instead of EED_LNK_EndFitting_ProductFamilies
const std::wstring EED_CategoryEndFittingProductFamiliyTableName_Ora                          = L"EED_LNK_CAT_EF_PRODFAMILIES";//rjn TS09493 dildil : instead of EED_LNK_CATEGORY_ENDFITTING_PRODUCTFAMILIES

// NJR >> 27-9-2007 TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
const std::wstring EED_EquipmentsErpManagementProductFamiliesTableName                    = L"EED_LNK_ERP_ProductFamilies";
const std::wstring EED_ClassDefault_CGCodeTableName                                       = L"EED_OBJ_CGCodes";
const std::wstring EED_CGCodeTableName                                                    = L"EED_OBJ_CGCodes";
const std::wstring EED_CGCodeXMLTagName                                                   = L"EED_OBJ_CGCodesTagName";
const std::wstring EED_CGCodeXMLItemTagName                                               = L"EED_OBJ_CGCodeTagName";
// Christian
const std::wstring EED_ObjManufacturerTableName                                           = L"EED_OBJ_Manufacturers";
const std::wstring EED_ClassDefault_ManufacturerTableName                                 = L"EED_OBJ_Manufacturers";
const std::wstring EED_ObjManufacturerXMLTagName                                          = L"EED_OBJ_ManufacturersTagName";
const std::wstring EED_ObjManufacturerXMLItemTagName                                      = L"EED_OBJ_ManufacturerTagName";

const  std::wstring EED_ClassDefault_SetLCStatesTableName                                 = L"EED_Set_LCStatus";
const  std::wstring EED_SetLCStatesXMLTagName                                             = L"States";
const  std::wstring EED_SetLCStatesXMLItemTagName                                         = L"State";

const  std::wstring EED_ClassDefault_SetLCTransitionsTableName                            = L"EED_Set_LCTransitions";
const  std::wstring EED_SetLCTransitionsXMLTagName                                        = L"Transitions";
const  std::wstring EED_SetLCtransitionsXMLItemTagName                                    = L"Transition";

/* RTS TS08818 << 2.40/A/001 26.02.07 */
const std::wstring EED_EquDefinitions_ClassDefault_ToolingTableName						= L"EED_OBJ_DEF_Tooling";
const std::wstring EED_EquDefinitions_ClassDefault_Tooling_XMLTagName					= L"EED_OBJ_DEF_Entity_Toolings";
const std::wstring EED_EquDefinitions_ClassDefault_Tooling_XMLItemTagName				= L"EED_OBJ_DEF_Entity_Tooling";

const std::wstring EED_ToolAccessoryTableName                                       = L"EED_OBJ_Tool_Accessory";
const std::wstring EED_ToolAccessoryXMLTagName		                              	= L"EED_OBJ_Equi_ToolAccessories";
const std::wstring EED_ToolAccessoryXMLItemTagName		                              = L"EED_OBJ_Equi_ToolAccessory";

const std::wstring EED_ToolManufacturerTableName                                    = L"EED_LNK_Tool_Manufacturer";
const std::wstring EED_ToolManufacturerXMLTagName		                             	= L"EED_LNK_Equi_ToolManufacturers";
const std::wstring EED_ToolManufacturerXMLItemTagName		                           = L"EED_LNK_Equi_ToolManufacturer";

const std::wstring EED_ClassDefault_SetManufacturerTableName			               = L"EED_SET_Manufacturer";
const std::wstring EED_SetManufacturerXMLTagName		                             	= L"EED_SET_ManufacturersTagName";
const std::wstring EED_SetManufacturerXMLItemTagName		                           = L"EED_SET_ManufacturerTagName";

// rth
const std::wstring EED_ClassDefault_SetManufacturerHistoricTableName                        = L"EED_SET_Manufacturer_History";
//njr
const std::wstring EED_ClassDefault_ObjErpHistoricTableName                               = L"EED_OBJ_ERP_History";
const std::wstring EED_ObjErpHistoricTableName                                                    = L"EED_OBJ_ERP_History";
const std::wstring EED_ObjErpHistoricXMLTagName                                                   = L"EED_OBJ_ERP_HistoriesTagName";
const std::wstring EED_ObjErpHistoricXMLItemTagName                                               = L"EED_OBJ_ERP_HistoryTagName";

// ALP 27 02 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation

const std::wstring EED_EquipmentsSimulationModelicaFileDescriptionTableName                     = L"EED_OBJ_Simulation_Info";

const std::wstring EED_EquDefinitions_ClassDefault_SimulationTableName                       = L"EED_OBJ_DEF_Simulation";
const std::wstring EED_EquDefinitions_ClassDefault_Simulation_XMLTagName                     = L"EED_OBJ_DEF_SimulationTagName"; //RRB
const std::wstring EED_EquDefinitions_ClassDefault_Simulation_XMLItemTagName                 = L"EED_OBJ_DEF_Entity_Simulation";
//begin RRB
const std::wstring EED_Simulation_ModelicaFileTagName                                           = L"EED_Simulation_ModelicaFileTagName";
const std::wstring EED_Simulation_ModelicaFile                                                  = L"EED_OBJ_Simulation_Info";
//end RRB
// Begin Mamy_Tahiana
const std::wstring EED_Simulation_ModelicaFileBlobTagName                                       = L"EED_OBJ_Simulation_BlobTagName"; 
const std::wstring EED_Simulation_ModelicaFileBlob                                              = L"EED_OBJ_Simulation_Blob"; 
const std::wstring EED_SimulationXMLItemTagName_ModelicaFile                                    = L"ModelicaFile";
/******************************** For Simulation parameter *******************************/ 
const std::wstring EED_EquDefinitions_ClassDefault_SimulationParameterTableName                 = L"EED_OBJ_Simulation_Parameters";
const std::wstring EED_SimulationParameterXMLTagName                                            = L"EED_OBJ_SimulationParametersTagName";
const std::wstring EED_SimulationParameterXMLItemTagName                                        = L"EED_OBJ_SimulationParameters";
/*---------------------- For Simulation Model ------------------------------*/
const std::wstring EED_EquDefinitions_ClassDefault_SimulationModelTableName                     = L"EED_OBJ_Simulation_Model";
const std::wstring EED_SimulationModelXMLTagName                                                = L"EED_OBJ_SimulationModelsTagName";
const std::wstring EED_SimulationModelXMLItemTagName                                            = L"EED_OBJ_Simulation_Model";
// end Mamy_Tahiana
// ALP 
const std::wstring EED_XML_Version = L"2.12";
const std::wstring EED_XML_Version_Old_5 = L"2.11";
const std::wstring EED_XML_Version_Old_4 = L"2.10";

const std::wstring EED_XML_Version_Old_3															= L"2.09";
const std::wstring EED_XML_Version_Old_2															= L"2.06";
const std::wstring EED_XML_Version_Old_1															= L"2.05";
//const std::wstring EED_XML_Version_Old_x = L"??";


const std::wstring EED_EquDefinitionsXMLTagName                                        = L"EED_OBJ_Entities";
const std::wstring EED_EquDefinitionsXMLItemTagName                                       = L"EED_OBJ_Entity";
//const std::wstring EED_EquDefinitionsXMLTableName = L"EED_EquDefinitions";
const std::wstring EED_EquDefinitionsXMLTagName_Old_1                                  = L"EED_EquDefinitions";
const std::wstring EED_EquDefinitionsXMLItemTagName_Old_1                                 = L"EED_EquDefinition";


const std::wstring EED_EquDefinitions_ClassDefault_Equipments_XMLTagName                     = L"EED_OBJ_DEF_Equipments";
const std::wstring EED_EquDefinitions_ClassDefault_Equipments_XMLItemTagName                 = L"EED_OBJ_DEF_Equipment";

const std::wstring EED_EquDefinitions_ClassDefault_SemiEquipments_XMLTagName                 = L"EED_OBJ_DEF_ConnectiveEquipments";
const std::wstring EED_EquDefinitions_ClassDefault_SemiEquipments_XMLItemTagName             = L"EED_OBJ_DEF_ConnectiveEquipment";

const std::wstring EED_EquDefinitions_ClassDefault_CablesAndWires_XMLTagName                 = L"EED_OBJ_DEF_Entity_Cables";
const std::wstring EED_EquDefinitions_ClassDefault_CablesAndWires_XMLItemTagName             = L"EED_OBJ_DEF_Entity_Cable";

const std::wstring EED_EquDefinitions_ClassDefault_InterConnection_XMLTagName                = L"EED_OBJ_DEF_Entity_InterConnections";
const std::wstring EED_EquDefinitions_ClassDefault_InterConnection_XMLItemTagName               = L"EED_OBJ_DEF_Entity_InterConnection";

const std::wstring EED_EquDefinitions_ClassDefault_PlugMap_XMLTagName                        = L"EED_OBJ_DEF_Entity_PlugMaps";
const std::wstring EED_EquDefinitions_ClassDefault_PlugMap_XMLItemTagName                    = L"EED_OBJ_DEF_Entity_PlugMap";
/*ts:2.30/a/001*/
const std::wstring EED_EquDefinitions_ClassDefault_EndFittingRule_XMLTagName                 = L"EED_OBJ_DEF_Entity_EndFittingRules";
const std::wstring EED_EquDefinitions_ClassDefault_EndFittingRule_XMLItemTagName             = L"EED_OBJ_DEF_Entity_EndFittingRule";
/*ts:2.30/a/001*/
 /*ts:2.30/a/005 22.06.06*/
const std::wstring EED_EquDefinitions_ClassDefault_Accessory_XMLTagName                      = L"EED_OBJ_DEF_Entity_Accessories";
const std::wstring EED_EquDefinitions_ClassDefault_Accessory_XMLItemTagName                     = L"EED_OBJ_DEF_Entity_Accessory";
 /*ts:2.30/a/005 22.06.06*/

// ALP 05 03 2007 : TS08512 : SOPHIA 2.40/A : : Add Simulation
const std::wstring EED_EquDefinitions_ClassDefault_Simulations_XMLTagName                    = L"EED_OBJ_DEF_Entity_Simulations";
const std::wstring EED_EquDefinitions_ClassDefault_Simulations_XMLItemTagName                = L"EED_OBJ_DEF_Entity_Simulation";



const std::wstring EED_CategoriesXMLItemTagName                                        = L"EED_OBJ_Category";
const std::wstring EED_CategoriesXMLTagName                                            = L"EED_OBJ_Categories";
const std::wstring EED_CategoriesXMLItemTagName_Old_1                                  = L"EED_Category";
const std::wstring EED_CategoriesXMLTagName_Old_1                                      = L"EED_Categories";
//const std::wstring EED_CategoriesXMLTableName = L"EED_Categories";
const std::wstring EED_CategoryToProductFamilies                                       = L"EED_LNK_Category_ProductFamilies"; //els
const std::wstring EED_CategoryToProductFamiliesXMLTagName                             = L"EED_LNK_Category_ProductFamilies"; //els
const std::wstring EED_CategoryToProductFamiliesXMLItemTagName                             = L"EED_LNK_Category_ProductFamily"; //els


const std::wstring EED_PinsXMLItemTagName                                           = L"EED_OBJ_Equi_Pin";
const std::wstring EED_PinsXMLTagName                                               = L"EED_OBJ_Equi_Pins";
const std::wstring EED_PinsXMLItemTagName_Old_1                                        = L"EED_Pin";
const std::wstring EED_PinsXMLTagName_Old_1                                            = L"EED_Pins";
//const std::wstring EED_PinsXMLTableName = L"EED_Pins";

const std::wstring EED_PlugMapPinsXMLItemTagName                                       = L"EED_OBJ_PlugMapPin";
const std::wstring EED_PlugMapPinsXMLTagName                                        = L"EED_OBJ_PlugMapPins";
const std::wstring EED_PlugMapPinsXMLItemTagName_Old_1                                    = L"EED_PlugMapPin";
const std::wstring EED_PlugMapPinsXMLTagName_Old_1                                     = L"EED_PlugMapPins";
//const std::wstring EED_PlugMapPinsXMLTableName = L"EED_OBJ_PlugMapPin";

//const std::wstring EED_InterConnectionPinsXMLItemTagName                                = L"EED_OBJ_InterConnectionPin";/*ts*/
//const std::wstring EED_InterConnectionPinsXMLTagName                                    = L"EED_OBJ_InterConnectionPins";/*ts*/
const std::wstring EED_InterConnectionPinsXMLItemTagName_Old_1                            = L"EED_InterConnectionPin";/*ts*/
const std::wstring EED_InterConnectionPinsXMLTagName_Old_1                                = L"EED_InterConnectionPins";/*ts*/
//const std::wstring EED_InterConnectionPinsXMLTableName = L"EED_OBJ_InterConnectionPin";/*ts*/

const std::wstring EED_ConnectorsXMLItemTagName                                        = L"EED_OBJ_Connector";
const std::wstring EED_ConnectorsXMLTagName                                            = L"EED_OBJ_Connectors";
const std::wstring EED_ConnectorsXMLItemTagName_Old_1                                  = L"EED_Connector";
const std::wstring EED_ConnectorsXMLTagName_Old_1                                      = L"EED_Connectors";
//const std::wstring EED_ConnectorsXMLTableName = L"EED_Connectors";

// ts >> 16 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
const std::wstring EED_PassThroughsXMLItemTagName                                      = L"EED_OBJ_PassThrough";
const std::wstring EED_PassThroughsXMLTagName                                          = L"EED_OBJ_PassThroughs";
const std::wstring EED_PassThroughsXMLItemTagName_Old_1                                   = L"EED_PassThrough";
const std::wstring EED_PassThroughsXMLTagName_Old_1                                       = L"EED_PassThroughs";
// ts <<

const std::wstring EED_GroupsXMLItemTagName                                            = L"EED_OBJ_PinsGroup";
const std::wstring EED_GroupsXMLTagName                                                = L"EED_OBJ_PinsGroups";
const std::wstring EED_GroupsXMLItemTagName_Old_1                                      = L"EED_Group";
const std::wstring EED_GroupsXMLTagName_Old_1                                          = L"EED_Groups";
//const std::wstring EED_GroupsXMLTableName = L"EED_Groups";

const std::wstring EED_InternalLinksXMLItemTagName                                     = L"EED_OBJ_Internal_Group";//Toky : Internal Links
const std::wstring EED_InternalLinksXMLTagName                                         = L"EED_OBJ_Internal_Groups";
const std::wstring EED_InternalLinksXMLItemTagName_Old_1                               = L"EED_InternalLink";
const std::wstring EED_InternalLinksXMLTagName_Old_1                                   = L"EED_InternalLinks";

const std::wstring EED_EquPowerOptionsXMLItemTagName                                   = L"EED_OBJ_Equi_Power";
const std::wstring EED_EquPowerOptionsXMLTagName                                       = L"EED_OBJ_Equi_Powers";
const std::wstring EED_EquPowerOptionsXMLItemTagName_Old_1                                = L"EED_EquPowerOption";
const std::wstring EED_EquPowerOptionsXMLTagName_Old_1                                    = L"EED_EquPowerOptions";
//const std::wstring EED_EquPowerOptionsXMLTableName = L"EED_EquPowerOptions";

const std::wstring EED_EquPowerTimeOptionsXMLItemTagName                               = L"EED_OBJ_Equi_Power_Time";
const std::wstring EED_EquPowerTimeOptionsXMLTagName                                   = L"EED_OBJ_Equi_Powers_Time";
const std::wstring EED_EquPowerTimeOptionsXMLItemTagName_Old_1                            = L"EED_EquPowerTimeOption";
const std::wstring EED_EquPowerTimeOptionsXMLTagName_Old_1                                = L"EED_EquPowerTimeOptions";
//const std::wstring EED_EquPowerTimeOptionsXMLTableName = L"EED_EquPowerTimeOptions";

const std::wstring EED_TimesXMLItemTagName                                             = L"EED_SET_Times";
const std::wstring EED_TimesXMLName                                                 = L"EED_SET_Times";
const std::wstring EED_TimesXMLItemTagName_Old_1                                       = L"EED_Times";
const std::wstring EED_TimesXMLTagName_Old_1                                        = L"EED_Times";

const std::wstring EED_PowersXMLItemTagName                                            = L"EED_SET_Power";
const std::wstring EED_PowersXMLTagName                                                = L"EED_SET_Powers";
const std::wstring EED_PowersXMLItemTagName_Old_1                                      = L"EED_Power";
const std::wstring EED_PowersXMLTagName_Old_1                                          = L"EED_Powers";

const std::wstring EED_EquConsumptionsXMLItemTagName                                   = L"EED_OBJ_Equi_Consumption";
const std::wstring EED_EquConsumptionsXMLTagName                                       = L"EED_OBJ_Equi_Consumptions";
const std::wstring EED_EquConsumptionsXMLItemTagName_Old_1                                = L"EED_EquConsumption";
const std::wstring EED_EquConsumptionsXMLTagName_Old_1                                    = L"EED_EquConsumptions";
//const std::wstring EED_EquConsumptionsXMLTableName = L"EED_EquConsumptions";

const std::wstring EED_ConsumptionTypesXMLItemTagName                                  = L"EED_SET_ConsumptionType";
const std::wstring EED_ConsumptionTypesXMLTagName                                      = L"EED_SET_ConsumptionTypes";
const std::wstring EED_ConsumptionTypesXMLItemTagName_Old_1                               = L"EED_ConsumptionType";
const std::wstring EED_ConsumptionTypesXMLTagName_Old_1                                   = L"EED_ConsumptionTypes";

const std::wstring EED_HistoricsXMLItemTagName                                         = L"EED_OBJ_Equi_History";
const std::wstring EED_HistoricsXMLTagName                                             = L"EED_OBJ_Equi_Historics";
const std::wstring EED_HistoricsXMLItemTagName_Old_1                                   = L"EED_Historic";
const std::wstring EED_HistoricsXMLTagName_Old_1                                       = L"EED_Historics";
//const std::wstring EED_HistoricsXMLTableName = L"EED_EquDefHistory";

const std::wstring EED_CablesXMLItemTagName                                            = L"EED_OBJ_Cable";
const std::wstring EED_CablesXMLTagName                                                = L"EED_OBJ_Cables";
const std::wstring EED_CablesXMLItemTagName_Old_1                                      = L"EED_Cable";
const std::wstring EED_CablesXMLTagName_Old_1                                          = L"EED_Cables";
//const std::wstring EED_CablesXMLTableName = L"EED_Cables";

const std::wstring EED_WiresXMLItemTagName                                             = L"EED_OBJ_Wire";
const std::wstring EED_WiresXMLTagName                                              = L"EED_OBJ_Wires";
const std::wstring EED_WiresXMLItemTagName_Old_1                                       = L"EED_Wire";
const std::wstring EED_WiresXMLTagName_Old_1                                        = L"EED_Wires";
//const std::wstring EED_WiresXMLTableName = L"EED_Wires";

const std::wstring EED_ConnectedPinsXMLItemTagName                                     = L"EED_ConnectedPin";
const std::wstring EED_ConnectedPinsXMLTagName                                         = L"EED_ConnectedPins";
//const std::wstring EED_ConnectedPinsXMLTableName = L"EED_ConnectedPins";

const std::wstring EED_IncludedPinsXMLItemTagName                                      = L"EED_IncludedPin";
const std::wstring EED_IncludedPinsXMLTagName                                          = L"EED_IncludedPins";
//const std::wstring EED_IncludedPinsXMLTableName = L"EED_IncludedPins";

// ts >> 16 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
const std::wstring EED_IncludedToPassThroughConnectorXMLItemTagName                          = L"EED_IncludedToPassThroughConnector";
const std::wstring EED_IncludedToPassThroughConnectorsXMLTagName                          = L"EED_IncludedToPassThroughConnectors";
// ts <<


const std::wstring EED_ConnectedSemiEquipmentsXMLItemTagName_Connector                       = L"EED_LNK_Connector_Mating";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagName_Connector                           = L"EED_LNK_Connector_Matings";
const std::wstring EED_ConnectedSemiEquipmentsXMLItemTagName_Connector_Old_1                 = L"EED_ConnectedSemiEquipment_Connector";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagName_Connector_Old_1                     = L"EED_ConnectedSemiEquipments_Connector";
//const std::wstring EED_ConnectedSemiEquipmentsXMLTableName_Connector = L"EED_ConnectorsConnToEquipments";

const std::wstring EED_ConnectedSemiEquipmentsXMLItemTagName_SemiEqu                         = L"EED_LNK_Equi_Mating";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagName_SemiEqu                             = L"EED_LNK_Equi_Matings";
const std::wstring EED_ConnectedSemiEquipmentsXMLItemTagName_SemiEqu_Old_1                   = L"EED_ConnectedSemiEquipment_SemiEqu";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagName_SemiEqu_Old_1                       = L"EED_ConnectedSemiEquipments_SemiEqu";
//const std::wstring EED_ConnectedSemiEquipmentsXMLTableName_SemiEqu = L"EED_SemiEquConnToSemiEqu";

const std::wstring EED_ConnectedSemiEquipmentsXMLItemTagName_Old									= L"EED_ConnectedSemiEquipment";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagName_Old										= L"EED_ConnectedSemiEquipments";


const std::wstring EED_EquipmentsImagesXMLItemTagName                                        = L"EED_OBJ_Image";
const std::wstring EED_EquipmentsImagesXMLItemTagName_Image                                  = L"Image";
const std::wstring EED_EquipmentsImagesXMLTagName                                            = L"EED_OBJ_Images";
const std::wstring EED_EquipmentsImagesXMLItemTagName_Old_1                                  = L"EED_EquipmentsImage";
const std::wstring EED_EquipmentsImagesXMLItemTagName_Image_Old_1                            = L"Image";
const std::wstring EED_EquipmentsImagesXMLTagName_Old_1                                      = L"EED_EquipmentsImages";
//const std::wstring EED_EquipmentsImagesDescriptionXMLTableName = L"EED_EquipmentsImagesDescription";
//const std::wstring EED_EquipmentsImagesXMLTableName = L"EED_EquipmentsImages";

const std::wstring EED_EquipmentsFilesXMLTagName                                             = L"EED_OBJ_Files";
const std::wstring EED_EquipmentsFilesXMLItemTagName                                         = L"EED_OBJ_File";
const std::wstring EED_EquipmentsFilesXMLItemTagName_File                                    = L"File";

const std::wstring EED_EquViaProductFamiliesXMLItemTagName                                   = L"EED_LNK_Equi_Product";
const std::wstring EED_EquViaProductFamiliesXMLTagName                                       = L"EED_LNK_Equi_Products";
const std::wstring EED_EquViaProductFamiliesXMLItemTagName_Old_1                             = L"EED_EquViaProductFamily";
const std::wstring EED_EquViaProductFamiliesXMLTagName_Old_1                                 = L"EED_EquViaProductFamilies";
//const std::wstring EED_EquViaProductFamiliesXMLTableName = L"EED_EquViaProductFamilies";

const std::wstring EED_ProductFamiliesXMLItemTagName                                         = L"EED_SET_ProductFamily";
const std::wstring EED_ProductFamiliesXMLTagName                                             = L"EED_SET_ProductFamilies";
const std::wstring EED_ProductFamiliesXMLItemTagName_Old_1                                   = L"EED_ProductFamily";
const std::wstring EED_ProductFamiliesXMLTagName_Old_1                                       = L"EED_ProductFamilies";


const std::wstring EED_AdditivePartNumbers_Connector_XMLItemTagName                          = L"EED_LNK_Connector_Additive";
const std::wstring EED_AdditivePartNumbers_Connector_XMLTagName                              = L"EED_LNK_Connector_Additives";
const std::wstring EED_AdditivePartNumbers_Connector_XMLItemTagName_Old_1                    = L"EED_Connector_AdditivePartNumber";
const std::wstring EED_AdditivePartNumbers_Connector_XMLTagName_Old_1                        = L"EED_Connector_AdditivePartNumbers";
//const std::wstring EED_AdditivePartNumbers_Connector_XMLTableName = L"EED_ConnAdditivePartNo";

// ts >> 16 nov 06 :  TS08590 : SOPHIA  2.30/A : GE-005  :4 - New tab for Equipment: PassThrough
const std::wstring EED_Connectors_PassThrough_XMLItemTagName                                 = L"EED_LNK_ConnectorsToPassThrough";
const std::wstring EED_Connectors_PassThrough_XMLTagName                                     = L"EED_LNK_ConnectorsToPassThroughs";
const std::wstring EED_Connectors_PassThrough_XMLItemTagName_Old_1                           = L"EED_LNK_ConnectorsToPassThrough";
const std::wstring EED_Connectors_PassThrough_XMLTagName_Old_1                               = L"EED_LNK_ConnectorsToPassThroughs";
// ts <<

const std::wstring EED_AdditivePartNumbers_Equipment_XMLItemTagName                          = L"EED_LNK_Equi_Additive";
const std::wstring EED_AdditivePartNumbers_Equipment_XMLTagName                              = L"EED_LNK_Equi_Additives";
const std::wstring EED_AdditivePartNumbers_Equipment_XMLItemTagName_Old_1                    = L"EED_Equipment_AdditivePartNumber";
const std::wstring EED_AdditivePartNumbers_Equipment_XMLTagName_Old_1                        = L"EED_Equipment_AdditivePartNumbers";
//const std::wstring EED_AdditivePartNumbers_Equipment_XMLTableName = L"EED_EquAdditivePartNo";

//ts:2.11/a/004/3
const std::wstring EED_CompPartNos_Equipment_XMLItemTagName                                  = L"EED_LNK_Equi_Compatible";
const std::wstring EED_CompPartNos_Equipment_XMLTagName                                      = L"EED_LNK_Equi_Compatibles";
//const std::wstring EED_CompPartNos_Equipment_XMLItemTagName_Old_1                          = L"EED_CompatiblePartNumber";
//const std::wstring EED_CompPartNos_Equipment_XMLTagName_Old_1                              = L"EED_CompatiblePartNumbers";
//ts
//ts:2.30/a/005
const std::wstring EED_AccessoryMatingPartNos_Equipment_XMLItemTagName                       = L"EED_LNK_Equi_AccessoryMating";
const std::wstring EED_AccessoryMatingPartNos_Equipment_XMLTagName                           = L"EED_LNK_Equi_AccessoryMatings";
//const std::wstring EED_AccessoryMatingPartNos_Equipment_XMLItemTagName_Old_1                  = L"EED_AccessoryMatingPartNumber";
//const std::wstring EED_AccessoryMatingPartNos_Equipment_XMLTagName_Old_1                   = L"EED_AccessoryMatingPartNumbers";
//ts

const std::wstring EED_ColorLists_XMLItemTagName                                          = L"EED_SET_ColorList";
const std::wstring EED_ColorLists_XMLTagName                                              = L"EED_SET_ColorLists";
const std::wstring EED_ColorLists_XMLItemTagName_Old_1                                    = L"EED_ColorList";
const std::wstring EED_ColorLists_XMLTagName_Old_1                                       = L"EED_ColorLists";

const std::wstring EED_ColorValues_XMLItemTagName                                         = L"EED_SET_ColorValue";
const std::wstring EED_ColorValues_XMLTagName                                             = L"EED_SET_ColorValues";
const std::wstring EED_ColorValues_XMLItemTagName_Old_1                                   = L"EED_ColorValue";
const std::wstring EED_ColorValues_XMLTagName_Old_1                                       = L"EED_ColorValues";

const std::wstring EED_EndFittingRuleContactXMLItemTagName                                = L"EED_OBJ_Equi_EndFittingRuleContact";
const std::wstring EED_EndFittingRulesContactXMLTagName                                   = L"EED_OBJ_Equi_EndFittingRulesContact";
const std::wstring EED_EndFittingRuleLugXMLItemTagName                                    = L"EED_OBJ_Equi_EndFittingRuleLug";
const std::wstring EED_EndFittingRulesLugXMLTagName                                       = L"EED_OBJ_Equi_EndFittingRulesLug";
const std::wstring EED_EndFittingRuleSpliceXMLItemTagName                                 = L"EED_OBJ_Equi_EndFittingRuleSplice";
const std::wstring EED_EndFittingRulesSpliceXMLTagName                                    = L"EED_OBJ_Equi_EndFittingRulesSplice";
const std::wstring EED_EndFittingRuleShieldingWireTerminationXMLItemTagName               = L"EED_OBJ_Equi_EndFittingRuleShieldingWireTermination";
const std::wstring EED_EndFittingRulesShieldingWireTerminationXMLTagName                  = L"EED_OBJ_Equi_EndFittingRulesShieldingWireTermination";
const std::wstring EED_EndFittingRuleCapsAndStowXMLItemTagName                            = L"EED_OBJ_Equi_EndFittingRuleCapsAndStow";
const std::wstring EED_EndFittingRulesCapsAndStowXMLTagName                               = L"EED_OBJ_Equi_EndFittingRulesCapsAndStow";
const std::wstring EED_EndFittingRuleCableMarkingXMLItemTagName                           = L"EED_OBJ_Equi_EndFittingRuleCableMarking";
const std::wstring EED_EndFittingRulesCableMarkingXMLTagName                              = L"EED_OBJ_Equi_EndFittingRulesCableMarking";

const std::wstring EED_EquipmentsExternalDocumentsXMLTagName                              = L"EED_OBJ_ExternalDocuments";
const std::wstring EED_EquipmentsExternalDocumentsXMLItemTagName                          = L"EED_OBJ_ExternalDocument";
const std::wstring EED_EquipmentsExternalDocumentsXMLItemTagName_File                     = L"ExternalDocument";
// ALP 03 05 2007 
const std::wstring EED_EquipmentsSimulationModelicaFileXMLTagName                         = L"EED_OBJ_SimulationModelicaFiles";
const std::wstring EED_EquipmentsSimulationModelicaFileXMLItemTagName                     = L"EED_OBJ_SimulationModelicaFile";
const std::wstring EED_EquipmentsSimulationModelicaFileXMLItemTagName_File                = L"SimulationModelicaFile";

/*-- Mamy_Tahiana TS10944 --*/
const std::wstring EED_AdditvePNforMatingPNXMLTagName                                     = L"EED_LNK_Mating_Additives";
const std::wstring EED_AdditvePNforMatingPNXMLItemTagName                                 = L"EED_LNK_Mating_Additive";
const std::wstring EED_AdditvePNforMatingPNTableName                                      = L"EED_LNK_Mating_Additive";
/*-- Mamy_Tahiana TS10944 --*/
/*-- Mamy_Tahiana TS10935 --*/
const std::wstring EED_EnvironmentalZoneTypeXMLItemTagName                                         = L"EED_SET_Environmental_ZoneType";
const std::wstring EED_EnvironmentalZoneTypeXMLTagName                                             = L"EED_SET_Environmental_ZoneTypes";

/*-- Mamy_Tahiana TS10935 --*/
const std::wstring EED_EndFitting_Zones_XMLTagName                                        = L"EndFitting_Zones";
const std::wstring EED_EndFitting_Zones_XMLItemTagName                                    = L"EndFitting_Zone";

const std::wstring EED_EndFitting_Zones_XMLTagName2                                       = L"Category_EndFitting_Zones";
const std::wstring EED_EndFitting_Zones_XMLItemTagName2                                   = L"Category_EndFitting_Zone";

const std::wstring EED_EndFitting_ZoneRules_XMLTagName                                    = L"Entity_EndFitting_ZoneRules";
const std::wstring EED_EndFitting_ZoneRules_XMLItemTagName                                = L"Entity_EndFitting_ZoneRule";

const std::wstring EED_EndFitting_ZoneRules_XMLTagName2                                   = L"Category_EndFitting_ZoneRules";
const std::wstring EED_EndFitting_ZoneRules_XMLItemTagName2                               = L"Category_EndFitting_ZoneRule";

const std::wstring EED_EndFitting_Families_XMLTagName                                     = L"EndFitting_ProductFamilies";
const std::wstring EED_EndFitting_Families_XMLItemTagName                                 = L"EndFitting_ProductFamily";

const std::wstring EED_EndFitting_Families_XMLTagName2                                    = L"Category_EndFitting_ProductFamilies";
const std::wstring EED_EndFitting_Families_XMLItemTagName2                                = L"Category_EndFitting_ProductFamily";

// NJR >> 27-9-2007 TS09405 : SOPHIA 2.40/A : EL-005  : Management of part number ERP
const std::wstring EED_ErpManagement_Families_XMLTagName                                  = L"ErpManagement_ProductFamilies";
const std::wstring EED_EED_ErpManagement_Families_XMLItemTagName                          = L"EED_ErpManagement_ProductFamily";
const std::wstring EED_ErpManagement_Families_XMLItemTagName                              = L"ErpManagement_ProductFamily";


// Attributes added by hand in XSD file:

// EED_EquPowerOption
const std::wstring EED_EquPowerOptionsXMLTagAttribute1                                    = L"SystemPower";

// EED_EquPowerTimeOption
const std::wstring EED_EquPowerTimeOptionsXMLTagAttribute1                                = L"SystemTime";

// EED_EquConsumption
const std::wstring EED_EquConsumptionsXMLTagAttribute1                                    = L"ConsumptionWatts";
const std::wstring EED_EquConsumptionsXMLTagAttribute2                                    = L"SystemConsumptionType";

// EED_Connector
const std::wstring EED_ConnectorsXMLTagAttribute1                                         = L"PartNoVersion";
const std::wstring EED_ConnectorsXMLTagAttribute2                                         = L"PartNo";

// EED_ContactLayout
const std::wstring EED_ContactLayoutXMLTagAttribute1                                      = L"ContactLayoutVersion";
const std::wstring EED_ContactLayoutXMLTagAttribute2                                      = L"ContactLayoutNo";

// EED_Cable
const std::wstring EED_CablesXMLTagAttribute1                                             = L"PartNoVersion";
const std::wstring EED_CablesXMLTagAttribute2                                             = L"PartNo";

// EED_Pin
const std::wstring EED_PinsXMLTagAttribute1                                               = L"Group";
const std::wstring EED_PinsXMLTagAttribute2                                               = L"EquPower";

// EED_Category
const std::wstring EED_CategoryXMLTagAttribute1Old                                        = L"Class";
const std::wstring EED_CategoryXMLTagAttribute1                                           = L"ClassName";

// EED_End_Fitting_Zones_Rule
const std::wstring EED_ZonesRuleXMLTagAttribute1                                          = L"EndFittingRuleName";
const std::wstring EED_ZonesRuleXMLTagAttribute2                                          = L"RuleNode";
const std::wstring EED_ZonesRuleXMLTagAttribute3                                          = L"Prefix";
const std::wstring EED_ZonesRuleXMLTagAttribute4                                          = L"EndFittingRuleVersion";

// EED_End_Fitting_ProductFamilies
const std::wstring EED_EndFittingProductFamiliesXMLTagAttribute1                          = L"ProductFamilyName";
const std::wstring EED_EndFittingProductFamiliesXMLTagAttribute2                          = L"EntityType";

// EED_Erp_Management_ProductFamilies
const std::wstring EED_ErpManagementProductFamiliesXMLTagAttribute1                       = L"ProductFamilyName";
const std::wstring EED_ErpManagementProductFamiliesXMLTagAttribute2                       = L"EntityType";

// EED_OBJ_PassTrough
const std::wstring EED_PassTroughAccessoryXMLTagAttribute1                                = L"AccessoryPartNo";
const std::wstring EED_PassTroughAccessoryXMLTagAttribute2                                = L"AccessoryVersion";

// EED_ConnectedSemiEquipment
//const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute1 = L"Name";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute2                            = L"PartNo";
const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute3                            = L"Version";
//const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute2 = L"ID";
//const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute3 = L"IDConnector";
//const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute4 = L"IDEquipment";
//const std::wstring EED_ConnectedSemiEquipmentsXMLTagAttribute5 = L"System";

// EED_EquViaProductFamily
const std::wstring EED_EquViaProductFamiliesXMLTagAttribute1                              = L"ProductFamily";
const std::wstring EED_EquViaProductFamiliesXMLTagAttribute2                              = L"InUseStatus";

// EED_EquipmentsImage
const std::wstring EED_EquipmentsGroupXMLTagAttribute1                                    = L"IDEquipment";

// EED_EquipmentsImage
const std::wstring EED_EquipmentsImageXMLTagAttribute1                                    = L"IDEquipment";
const std::wstring EED_EquipmentsImageXMLTagAttribute2                                    = L"LastModified";
const std::wstring EED_EquipmentsImageXMLTagAttribute3                                    = L"Description";
const std::wstring EED_EquipmentsImageXMLTagAttribute4                                    = L"FileName";
const std::wstring EED_EquipmentsImageXMLTagAttribute5                                    = L"FileType";

// EED_EquipmentsFile
const std::wstring EED_EquipmentsFileXMLTagAttribute1                                     = L"IDEquipment";
const std::wstring EED_EquipmentsFileXMLTagAttribute2                                     = L"LastModified";
const std::wstring EED_EquipmentsFileXMLTagAttribute3                                     = L"Description";
const std::wstring EED_EquipmentsFileXMLTagAttribute4                                     = L"FileName";
const std::wstring EED_EquipmentsFileXMLTagAttribute5                                     = L"FileType";

// EED_EquipmentsExternalDocument
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute1                         = L"IDEquipment";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute2                         = L"DateCreation";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute3                         = L"DateModification";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute4                         = L"DateLastAccess";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute5                         = L"Description";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute6                         = L"FileName";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute7                         = L"FileType";
const std::wstring EED_EquipmentsExternalDocumentXMLTagAttribute8                         = L"FileSize";


// ALP 5 6 2007 : TS08512 : SOPHIA 2.40
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute1                       = L"IDEquipment";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute2                       = L"DateCreation";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute3                       = L"DateModification";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute4                       = L"DateLastAccess";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute5                       = L"Description";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute6                       = L"FileName";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute7                       = L"FileType";
const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute8                       = L"FileSize";

// EED_EquAccessory
const std::wstring EED_EquAccessoryXMLTagAttribute1                                       = L"KeyingValue";

// EED_EquipmentsImage, Image
const std::wstring ImageXMLTagAttribute1                                                  = L"Encoding";
const std::wstring ImageXMLTagAttribute2                                                  = L"Picture";
const std::wstring ImageXMLTagAttribute3                                                  = L"FileName";

// EED_EquipmentsImage, Image
const std::wstring FileXMLTagAttribute1                                                   = L"Encoding";
const std::wstring FileXMLTagAttribute2                                                   = L"File";
const std::wstring FileXMLTagAttribute3                                                   = L"FileName";

// EED_EquipmentsImage, Image, Picture
const std::wstring PictureXMLTagName                                                      = L"Picture";
const std::wstring PictureXMLTagAttribute1Prefix                                          = L"Part";

// EED_EquipmentsFile, File
const std::wstring FileXMLTagName                                                         = L"File";
const std::wstring FileXMLTagAttribute1Prefix                                             = L"Part";

// EED_EquipmentsExternalDocument, Document
const std::wstring ExternalDocumentXMLTagAttribute1                                       = L"Encoding";
const std::wstring ExternalDocumentXMLTagAttribute2                                       = L"ExternalDocument";
const std::wstring ExternalDocumentXMLTagAttribute3                                       = L"FileName";

// EED_EquipmentsExternalDocument, Document
const std::wstring ExternalDocumentXMLTagName                                             = L"ExternalDocument";
const std::wstring ExternalDocumentXMLTagAttribute1Prefix                                 = L"Part";


// ALP 5 6 2007 : TS08512 : SOPHIA 2.40
const std::wstring SimulationModelicaXMLTagAttribute1                                     = L"Encoding";
const std::wstring SimulationModelicaXMLTagAttribute2                                     = L"ModelicaFile"; //Change By Mamy_Tahiana  
const std::wstring ModelicaFileXMLTagAttribute1Prefix                                     = L"Part";
//const std::wstring SimulationModelicaXMLTagAttribute3                                     = L"FileName";

// Mamy_Tahiaa
const std::wstring EED_AdditivePNForMatingXMLTagAttribute2                                = L"PartNo";
const std::wstring EED_AdditivePNForMatingXMLTagAttribute3                                = L"Version";
// Mamy_Tahiana
//const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute6                        = L"FileName";
//const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute7                        = L"FileType";
//const std::wstring EED_EquipmentsSimulationModelicaXMLTagAttribute8                        = L"FileSize";
//Mamy_Tahiana TS10935
const std::wstring EED_EnvironmentalZoneTypeTableName                                        = L"EED_SET_Environmental_Zone";
// Mamy_Tahiana TS10935


// EED_ConnAdditivePartNo
//const std::wstring EED_ConnAdditivePartNoXMLTagAttribute1 = L"Quantity";

// EED_EquAdditivePartNo
//const std::wstring EED_EquAdditivePartNoXMLTagAttribute1 = L"Quantity";



// XML Import/Export filenames
const std::wstring wstrImageFileNamePrefix                                                = L"image";
const std::wstring wstrImageFileNameExt                                                   = L".base64";
const std::wstring wstrXMLFileNameInZip                                                   = L"eed_equdefs.xml";
const std::wstring wstrXMLFileNamePrefix                                                  = L"FILE NAME:";


const std::wstring wstrSimulationModelicaFileNamePrefix                                   = L"ModelicaFile";/*L"image";*/
const std::wstring wstrSimulationModelicaFileNameExt                                      = L".base64";
//const std::wstring wstrXMLFileNameInZip                                           = L"eed_equdefs.xml";
//const std::wstring wstrXMLFileNamePrefix                                             = L"FILE NAME:";


// some field names:

// ConnectivityType
const std::wstring wstrFieldName_ConnectivityType                                         = L"ConnectivityType";
// old names
const std::wstring wstrFieldName_Old_ConnectivityType_Connectors                          = L"ConnectorType";
const std::wstring wstrFieldName_Old_ConnectivityType_Entity                              = L"Equipement_type";

// Gender
const std::wstring wstrFieldName_Gender                                                   = L"Gender";
// old names
const std::wstring wstrFieldName_Old_Gender_EquAndSemiEqu											= L"ContactGender";



// End Fitting Rules Splice: WireGaugeExtremity1, WireGaugeExtremity2
const std::wstring wstrFieldName_WireGaugeExtremity1_EFRSplice = L"WireGaugeExtremity1";
const std::wstring wstrFieldName_WireGaugeExtremity2_EFRSplice = L"WireGaugeExtremity2";
// old names
const std::wstring wstrFieldName_Old_WireGaugeExtremity1_EFRSplice = L"WireGaugeExtremly1";
const std::wstring wstrFieldName_Old_WireGaugeExtremity2_EFRSplice = L"WireGaugeExtremly2";
const char* const szLabelProgressBarLoad															= "Loading Items:";
const char* const szLabelProgressBarSave															= "Saving Items:";
const std::wstring wstrFieldName_OrderByCreation                                          = L"OrderByCreation";
// Dialog Captions for ProgressBar
const std::wstring WSTR_DLG_CAPTION_XMLIMPORT = L"XML Import";
const std::wstring WSTR_DLG_CAPTION_LOADPARCEXML = L"Load and parse XML";
const std::wstring WSTR_DLG_CAPTION_SAVEBDXMLIMPORT = L"Save to DB after XML Import";
