#pragma once

struct SSaveGdiObj
{
	HDC /*const*/ m_hdc;
	DWORD /*const*/ m_objectType; //Main purpose of this one is debugging
	HGDIOBJ /*const*/ m_hFirstObject;
	BOOL m_bDeleteSelected;
	HGDIOBJ m_hCurrentObject; //Main purpose of this one is debugging
	BOOL m_bDestroyed;  //Ensure the destructor is not called twice.
	BOOL m_bIsCppClass; //Ensure we don't try to SSaveGdiObj_Delete a C++ obj, or the reverse. 
};

EXTERN_C void SSaveGdiObj_ConstructFromNothing(struct SSaveGdiObj *pThis);
EXTERN_C void SSaveGdiObj_ConstructFromType(struct SSaveGdiObj *pThis, HDC hdc, DWORD objectType);
EXTERN_C BOOL SSaveGdiObj_ConstructFromObj(struct SSaveGdiObj *pThis, HDC hdc, HGDIOBJ hNewObj, BOOL bDeleteSelected);
EXTERN_C void SSaveGdiObj_Destroy(struct SSaveGdiObj *pThis);

EXTERN_C struct SSaveGdiObj * SSaveGdiObj_NewFromType(HDC hdc, DWORD objectType);
EXTERN_C struct SSaveGdiObj * SSaveGdiObj_NewFromObj(HDC hdc, HGDIOBJ hNewObj, BOOL bDeleteSelected);
EXTERN_C void SSaveGdiObj_Delete(struct SSaveGdiObj *pThis);

EXTERN_C void SSaveGdiObj_AssertValid(struct SSaveGdiObj const * pcThis);
EXTERN_C BOOL SSaveGdiObj_Select(struct SSaveGdiObj *pThis, HGDIOBJ hNewObj, BOOL bDeleteSelected);
EXTERN_C void SSaveGdiObj_Swap(struct SSaveGdiObj *pA, struct SSaveGdiObj *pB);

#ifdef INLINE_SSaveGdiObj
#include "Inline.h"
static CCPP_INLINE HDC SSaveGdiObj_GetSafeHdc(struct SSaveGdiObj *pThis) //Not const
{
	return (pThis==NULL ? NULL : pThis->m_hdc);
}
#endif