/*
CSaveGdiObj.hpp : C++ header for class CSaveGdiObj.
	This class uses RAII to ensure the old GDI object of a device context is restored.
	An object of this class must be destroyed before the DC is.

This class is now based on a C structure, which it wraps to take advantage of RAII.
While the C structure is swappable, the C++ class is not.
*/
#pragma once
#ifndef __cplusplus//C++-only Header
#error Must use a C++ compiler
#endif

#include <cstddef>
#include "SSaveGdiObj.h"

/* Class/struct declaration:
Non-copiable, non-assignable, non-swappable. */
class CSaveGdiObj : protected SSaveGdiObj
{
public:
	explicit CSaveGdiObj(
	 HDC hdc,         //[in/hold] Handle to the device context to monitor.
	 DWORD objectType //[in] Object type.
	 );
	explicit CSaveGdiObj(
	 HDC hdc,             //[in/hold] Handle to the device context to monitor.
	 HGDIOBJ hNewObj,     //[in/freed?] Handle to the new object to select (the type is obtained from this object).
	 bool bDeleteSelected //[in] If true, delete hNewObj when restoring the old object or selecting a new one.
	 );
	~CSaveGdiObj();
	
	bool Select(
	 HGDIOBJ hNewObj,     //[in/freed?] Handle to the new object to select (must be of the same type).
	 bool bDeleteSelected //[in] If true, delete hNewObj when restoring the old object or selecting a new one.
	 );
	HDC GetHdc(void)
	{
		SSaveGdiObj_AssertValid(this);
		return m_hdc;
	}
private:
	//Forbidden copy constructor: Not implemented.
	CSaveGdiObj(CSaveGdiObj const &);
	CSaveGdiObj & operator= (CSaveGdiObj const &);
};
