/*
CSaveGdiObj.cpp : Implementation for the CSaveGdiObj class.
	These functions are wrappers of the C functions.
*/
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <cassert>
#include "CSaveGdiObj.hpp"

//////////////////////////////////////////////////////////////////////////////
#pragma region Construction et destruction.

/* Constructeur  partir d'un type d'objet GDI
   ------------------------------------------- */
CSaveGdiObj::CSaveGdiObj(HDC hdc, DWORD objectType)
{
	SSaveGdiObj_ConstructFromType(this, hdc, objectType);
	m_bIsCppClass = TRUE;
}


/* Constructeur  partir d'un nouvel d'objet GDI
   --------------------------------------------- */
CSaveGdiObj::CSaveGdiObj(HDC hdc, HGDIOBJ hNewObj, bool bDeleteSelected)
{
	SSaveGdiObj_ConstructFromObj(this, hdc, hNewObj, (bDeleteSelected?TRUE:FALSE));
	m_bIsCppClass = TRUE;
}


/* Destructeur
   ----------- */
CSaveGdiObj::~CSaveGdiObj()
{
	assert(m_bIsCppClass);
	SSaveGdiObj_Destroy(this);
}

#pragma endregion

//////////////////////////////////////////////////////////////////////////////
#pragma region Fonctions membres

/* Fonction pour changer l'objet GDI en cours
   ------------------------------------------ */
bool CSaveGdiObj::Select(HGDIOBJ hNewObj, bool bDeleteSelected)
{
	BOOL ret = SSaveGdiObj_Select(this, hNewObj, (bDeleteSelected?TRUE:FALSE));
	return (ret!=0);
}

#pragma endregion
