#pragma once

#include <cassert>

/*
CCheckGdiObj :
	Classe RAII pour vrifier qu'un DC a le mme objet GDI au dbut et  la fin.
	L'objet est vide en mode Release.

Toutes les fonctions de cette classe sont inline, elle n'a donc pas de fichier source.
Cette classe est non-copiable, non-assignable, non-swappable.
*/
class CCheckGdiObj
{
public:
	#ifdef _DEBUG
	inline explicit CCheckGdiObj(HDC hdc, DWORD objectType)
	 : m_hdc(hdc), m_objectType(objectType), m_hFirstObject(GetCurrentObject(hdc, objectType))
	{
		//Nothing to do here.
	}
	#else
	inline explicit CCheckGdiObj(HDC hdc, DWORD objectType)
	{
		//Nothing to do here.
		(void)hdc;
		(void)objectType;
	}
	#endif
	inline ~CCheckGdiObj()
	{
		#ifdef _DEBUG
		HGDIOBJ const hLastObject = GetCurrentObject(m_hdc, m_objectType);
		assert(hLastObject == m_hFirstObject);
		#endif
	}
	
private:
	//Forbidden copy constructor: Not implemented.
	CCheckGdiObj(CCheckGdiObj const &);
	CCheckGdiObj & operator= (CCheckGdiObj const &);
protected:
	#ifdef _DEBUG
	HDC const m_hdc;
	DWORD const m_objectType;
	HGDIOBJ const m_hFirstObject;
	#endif
};
