#include "singleton.h"


#include <mutex>
#include <thread>
#include <vector>

class ressource
{
	std::mutex mutex;
	std::thread thread;

	void run()
	{
		std::lock_guard<std::mutex> lock(mutex);
		std::this_thread::sleep_for(std::chrono::seconds(15));

	};
public:
	void start()
	{
		thread = std::thread(&ressource::run, this);
	}

	~ressource()
	{
		if (thread.joinable())
			thread.join();
	}

};

singleton::~singleton()
{
	vressources.clear();
}

singleton& singleton::current()
{
	static singleton s;
	return s;
}

void singleton::createRessource()
{
	auto tmp = std::make_shared<ressource>();
	tmp->start();
	vressources.push_back(tmp);
}