package asynch;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.xml.namespace.QName;
import javax.xml.ws.Response;
import javax.xml.ws.Service;

import oca.MonPortType;
import oca.SayHelloResponse;


//Pour gnrer le package oca :
//cd C:\Program Files\Java\jdk1.6.0_05\bin>
//wsimport -s D:\eclipse\Test\TestJaxWSClientAsynch\src -b D:\eclipse\Test\TestJaxWSClientAsynch\src\asynch\bindings.xml http://localhost:9083/hello?wsdl



public class ASynchClient {

	public static void main(String args[]) throws Exception {

		URL wsdlLocation = null;
		try {
			wsdlLocation = new URL("http://localhost:9083/hello?wsdl");
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		QName serviceName = new QName("http://oca", "MonService");
		Service s = Service.create(wsdlLocation, serviceName);
		MonPortType port = s.getPort(MonPortType.class);
		

		// ===
		ExecutorService executor = Executors.newFixedThreadPool(5);
        s.setExecutor(executor);
        
        // polling 
        Response<SayHelloResponse> resp =  port.sayHelloAsync("Hi", "Oli");
        while(!resp.isDone()){
           System.out.println("waiting");
        } 
        SayHelloResponse sayRep = resp.get();
        System.out.println(sayRep.getReturn());
        
        
        // event 
        port.sayHelloAsync("Hello","Oli",new MyAsyncHandler());
		
		
		// ===
		System.out.println("=====================================");
		

		System.out.println("Completed");
		System.exit(0);
	}

}
